% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate}
\alias{evaluate}
\title{Evaluate input and return all details of evaluation}
\usage{
evaluate(
  input,
  envir = parent.frame(),
  enclos = NULL,
  debug = FALSE,
  stop_on_error = 0L,
  keep_warning = TRUE,
  keep_message = TRUE,
  log_echo = FALSE,
  log_warning = FALSE,
  new_device = TRUE,
  output_handler = NULL,
  filename = NULL,
  include_timing = FALSE
)
}
\arguments{
\item{input}{input object to be parsed and evaluated.  May be a string, file
connection or function.  Passed on to \code{\link[=parse_all]{parse_all()}}.}

\item{envir}{environment in which to evaluate expressions.}

\item{enclos}{when \code{envir} is a list or data frame, this is treated as
the parent environment to \code{envir}.}

\item{debug}{if \code{TRUE}, displays information useful for debugging,
including all output that evaluate captures.}

\item{stop_on_error}{A number between 0 and 2 that controls what happens
when the code errors:
\itemize{
\item If \code{0}, the default, will continue running all code, just as if you'd
pasted the code into the command line.
\item If \code{1}, evaluation will stop on first error without signaling the error,
and you will get back all results up to that point.
\item If \code{2}, evaluation will halt on first error and you will get back no
results.
}}

\item{keep_warning, keep_message}{A single logical value that controls what
happens to warnings and messages.
\itemize{
\item If \code{TRUE}, the default, warnings and messages will be captured in the
output.
\item If \code{NA}, warnings and messages will not be captured and bubble up to
the calling environment of \code{evaluate()}.
\item If \code{FALSE}, warnings and messages will be completed supressed and
not shown anywhere.
}

Note that setting the envvar \code{R_EVALUATE_BYPASS_MESSAGES} to \code{true} will
force these arguments to be set to \code{NA}.}

\item{log_echo, log_warning}{If \code{TRUE}, will immediately log code and
warnings (respectively) to \code{stderr}.

This will be force to \code{TRUE} if env var \code{ACTIONS_STEP_DEBUG} is
\code{true}, as when debugging a failing GitHub Actions workflow.}

\item{new_device}{if \code{TRUE}, will open a new graphics device and
automatically close it after completion. This prevents evaluation from
interfering with your existing graphics environment.}

\item{output_handler}{an instance of \code{\link[=output_handler]{output_handler()}} that
processes the output from the evaluation. The default simply prints the
visible return values.}

\item{filename}{string overrriding the \code{\link[base:srcfile]{base::srcfile()}} filename.}

\item{include_timing}{Deprecated.}
}
\description{
Compare to \code{\link[=eval]{eval()}}, \code{evaluate} captures all of the
information necessary to recreate the output as if you had copied and pasted
the code into a R terminal. It captures messages, warnings, errors and
output, all correctly interleaved in the order in which they occured. It
stores the final result, whether or not it should be visible, and the
contents of the current graphics device.
}
\examples{
evaluate(c(
  "1 + 1",
  "2 + 2"
))

# Not that's there's a difference in output between putting multiple
# expressions on one line vs spreading them across multiple lines
evaluate("1;2;3")
evaluate(c("1", "2", "3"))

# This also affects how errors propagate, matching the behaviour
# of the R console
evaluate("1;stop(2);3")
evaluate(c("1", "stop(2)", "3"))
}
