% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-select.R
\name{select.tbl_lazy}
\alias{select.tbl_lazy}
\alias{rename.tbl_lazy}
\alias{rename_with.tbl_lazy}
\alias{relocate.tbl_lazy}
\title{Subset, rename, and reorder columns using their names}
\usage{
\method{select}{tbl_lazy}(.data, ...)

\method{rename}{tbl_lazy}(.data, ...)

\method{rename_with}{tbl_lazy}(.data, .fn, .cols = everything(), ...)

\method{relocate}{tbl_lazy}(.data, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{A lazy data frame backed by a database query.}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Variables, or functions of
variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending order.}

\item{.fn}{A function used to transform the selected \code{.cols}. Should
return a character vector the same length as the input.}

\item{.cols}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Columns to rename;
defaults to all columns.}

\item{.before, .after}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Destination of
columns selected by \code{...}. Supplying neither will move columns to the
left-hand side; specifying both is an error.}
}
\description{
These are methods for the dplyr \code{\link[=select]{select()}}, \code{\link[=rename]{rename()}}, and \code{\link[=relocate]{relocate()}}
generics. They generate the \code{SELECT} clause of the SQL query.

These functions do not support predicate functions, i.e. you can
not use \code{where(is.numeric)} to select all numeric variables.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(x = 1, y = 2, z = 3)
db \%>\% select(-y) \%>\% show_query()
db \%>\% relocate(z) \%>\% show_query()
db \%>\% rename(first = x, last = z) \%>\% show_query()
}
