% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equiv.R
\name{equiv_mean_extremum}
\alias{equiv_mean_extremum}
\title{Test for decrease in mean or minimum individual}
\usage{
equiv_mean_extremum(
  df_qual = NULL,
  data_qual = NULL,
  mean_qual = NULL,
  sd_qual = NULL,
  data_sample = NULL,
  n_sample = NULL,
  alpha,
  modcv = FALSE
)
}
\arguments{
\item{df_qual}{(optional) a data.frame containing the qualification data.
Defaults to NULL.}

\item{data_qual}{(optional) a vector of observations from the
"qualification" data to which equivalency is being tested. Or the column of
\code{df_qual} that contains this data. Defaults to NULL}

\item{mean_qual}{(optional) the mean from the "qualification" data to which
equivalency is being tested. Defaults to NULL}

\item{sd_qual}{(optional) the standard deviation from the "qualification"
data to which equivalency is being tested. Defaults to NULL}

\item{data_sample}{(optional) a vector of observations from the sample for
which equivalency is being tested. Defaults to NULL}

\item{n_sample}{(optional) the number of observations in the sample for
which equivalency will be tested. Defaults to NULL}

\item{alpha}{the acceptable probability of a type I error}

\item{modcv}{(optional) a boolean value indicating whether a modified CV
should be used. Defaults to FALSE, in which case the standard deviation
supplied (or calculated from \code{data_qual}) will be used directly.}
}
\value{
Returns an object of class \code{equiv_mean_extremum}. This object is a list
with the following named elements:

\item{\code{call}}{the expression used to call this function}
\item{\code{alpha}}{the value of alpha passed to this function}
\item{\code{n_sample}}{the number of observations in the sample for which
  equivalency is being checked. This is either the value \code{n_sample}
  passed to this function or the length of the vector \code{data_sample}.}
\item{\code{k1}}{the factor used to calculate the minimum individual
  threshold. The minimum individual threshold is calculated as
  \eqn{W_{min} = qual\,mean - k_1 \cdot qual\,sd}{
  Wmin = qual_mean - k1 * qual_sd}}
\item{\code{k2}}{the factor used to calculate the threshold for mean. The
  threshold for mean is calculated as
  \eqn{W_{mean} = qual\,mean - k_2 \cdot qual\,sd}{
  Wmean = qual_mean - k2 * qual_sd}}
\item{\code{modcv}}{logical value indicating whether the acceptance
  thresholds are calculated using the modified CV approach}
\item{\code{cv}}{the coefficient of variation of the qualification data.
  This value is not modified, even if \code{modcv=TRUE}}
\item{\code{cv_star}}{The modified coefficient of variation. If
  \code{modcv=FALSE}, this will be \code{NULL}}
\item{\code{threshold_min_indiv}}{The calculated threshold value for
  minimum individual}
\item{\code{threshold_mean}}{The calculated threshold value for mean}
\item{\code{result_min_indiv}}{a character vector of either "PASS" or
  "FAIL" indicating whether the data from \code{data_sample} passes the
  test for minimum individual. If \code{data_sample} was not supplied,
  this value will be \code{NULL}}
\item{\code{result_mean}}{a character vector of either "PASS" or
  "FAIL" indicating whether the data from \code{data_sample} passes the
  test for mean. If \code{data_sample} was not supplied, this value will
  be  \code{NULL}}
\item{\code{min_sample}}{The minimum value from the vector
  \code{data_sample}. if \code{data_sample} was not supplied, this will
  have a value of \code{NULL}}
\item{\code{mean_sample}}{The mean value from the vector
  \code{data_sample}. If \code{data_sample} was not supplied, this will
  have a value of \code{NULL}}
}
\description{
This test is used when determining if a new process or
manufacturing location produces material properties that are
"equivalent" to an existing dataset, and hence the existing
basis values are applicable to the new dataset. This test is also
sometimes used for determining if a new batch of material is acceptable.
This function determines thresholds based on both minimum
individual and mean, and optionally evaluates a sample against those
thresholds. The joint distribution between the sample mean
and sample minimum is used to generate these thresholds.
When there is no true difference between the existing ("qualification")
and the new population from which the sample is obtained, there is a
probability of \eqn{\alpha} of falsely concluding that there is a
difference in mean or variance. It is assumed that both the original
and new populations are normally distributed.
According to Vangel (2002), this test provides improved power compared
with a test of mean and standard deviation.
}
\details{
This function is used to
determine acceptance limits for a sample mean and sample minimum.
These acceptance limits are often used to set acceptance limits for
material strength for each lot of material, or each new manufacturing
site. When a sample meets the criteria that its mean and its minimum are
both greater than these limits, then one may accept the lot of material
or the new manufacturing site.

This procedure is used to ensure that the strength of material processed
at a second site, or made with a new batch of material are not degraded
relative to the data originally used to determine basis values for the
material. For more information about the use of this procedure, see
CMH-17-1G or PS-ACE 100-2002-006.

There are several optional arguments to this function. However, you can't
omit all of the optional arguments. You must supply either
\code{data_sample} or \code{n_sample}, but not both. You must also supply
either \code{data_qual} (and \code{df_qual} if \code{data_qual} is a
variable name and not a vector) or both \code{mean_qual} and \code{sd_qual},
but if you supply \code{data_qual} (and possibly \code{df_qual}) you should
not supply either \code{mean_qual} or \code{sd_qual} (and visa-versa). This
function will issue a warning or error if you violate any of these rules.

If \code{modcv} is TRUE, the standard deviation used to calculate the
thresholds will be replaced with a standard deviation calculated
using the Modified Coefficient of Variation (CV) approach.
The Modified CV approach is a way of adding extra variance to the
qualification data in the case that the qualification data has less
variance than expected, which sometimes occurs when qualification testing
is performed in a short period of time.
Using the Modified CV approach, the standard deviation is calculated by
multiplying \code{CV_star * mean_qual} where \code{mean_qual} is either the
value supplied or the value calculated by \code{mean(data_qual)} and
\eqn{CV*} is the value computed by \code{\link{calc_cv_star}}.
}
\examples{
equiv_mean_extremum(alpha = 0.01, n_sample = 6,
                    mean_qual = 100, sd_qual = 5.5, modcv = TRUE)
##
## Call:
## equiv_mean_extremum(mean_qual = 100, sd_qual = 5.5, n_sample = 6,
##     alpha = 0.01, modcv = TRUE)
##
## Modified CV used: CV* = 0.0675 ( CV = 0.055 )
##
## For alpha = 0.01 and n = 6
## ( k1 = 3.128346 and k2 = 1.044342 )
##                   Min Individual   Sample Mean
##      Thresholds:    78.88367        92.95069

}
\references{
M. G. Vangel. Lot Acceptance and Compliance Testing Using the Sample Mean
and an Extremum, Technometrics, vol. 44, no. 3. pp. 242–249. 2002.

“Composite Materials Handbook, Volume 1. Polymer Matrix Composites
Guideline for Characterization of Structural Materials,” SAE International,
CMH-17-1G, Mar. 2012.

Federal Aviation Administration, “Material Qualification and Equivalency
for Polymer Matrix Composite Material Systems,” PS-ACE 100-2002-006,
Sep. 2003.
}
\seealso{
\code{\link{k_equiv}}

\code{\link{calc_cv_star}}
}
