% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{slice}
\alias{slice}
\title{Which time steps fall within extreme values}
\usage{
slice(x, extremes, rightmost.closed = FALSE)
}
\arguments{
\item{x}{The \code{CFTime} instance to operate on.}

\item{extremes}{Character vector of timestamps that represent the time period
of interest. The extreme values are selected. Badly formatted timestamps
are silently dropped.}

\item{rightmost.closed}{Is the right side closed, i.e. included in the
result? Default is \code{FALSE}. A specification of \verb{c("2022-01-01", "2023-01-01)} will thus include all time steps that fall in the year 2022
when \code{closed = FALSE} but include \code{2023-01-01} if that exact value is
present in the time series.}
}
\value{
A logical vector with a length equal to the number of time steps in
\code{x} with values \code{TRUE} for those time steps that fall between the extreme
values, \code{FALSE} otherwise.

An attribute 'CFTime' will have the same definition as \code{x} but with offsets
corresponding to the time steps falling between the two extremes. If there
are no values between the extremes, the attribute is \code{NULL}.
}
\description{
Given a vector of character timestamps, return a logical vector of a length
equal to the number of time steps in the time series with values \code{TRUE} for
those time steps that fall between the two extreme values of the vector
values, \code{FALSE} otherwise.
}
\details{
If bounds were set these will be preserved.
}
\examples{
t <- CFtime("hours since 2023-01-01 00:00:00", "standard", 0:23)
slice(t, c("2022-12-01", "2023-01-01 03:00"))
}
