% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-sp.R
\name{mi}
\alias{mi}
\title{Predictors with Missing Values in \pkg{brms} Models}
\usage{
mi(x, idx = NA)
}
\arguments{
\item{x}{The variable containing missing values.}

\item{idx}{An optional variable containing indices of observations in `x`
that are to be used in the model. This is mostly relevant in partially
subsetted models (via \code{resp_subset}) but may also have other
applications that I haven't thought of.}
}
\description{
Specify predictor term with missing values in \pkg{brms}. The function does
not evaluate its arguments -- it exists purely to help set up a model.
For documentation on how to specify missing values in response variables,
see \code{\link{resp_mi}}.
}
\details{
For detailed documentation see \code{help(brmsformula)}.
}
\examples{
\dontrun{
data("nhanes", package = "mice")
N <- nrow(nhanes)

# simple model with missing data
bform1 <- bf(bmi | mi() ~ age * mi(chl)) +
  bf(chl | mi() ~ age) +
  set_rescor(FALSE)

fit1 <- brm(bform1, data = nhanes)

summary(fit1)
plot(conditional_effects(fit1, resp = "bmi"), ask = FALSE)
loo(fit1, newdata = na.omit(fit1$data))

# simulate some measurement noise
nhanes$se <- rexp(N, 2)

# measurement noise can be handled within 'mi' terms
# with or without the presence of missing values
bform2 <- bf(bmi | mi() ~ age * mi(chl)) +
  bf(chl | mi(se) ~ age) +
  set_rescor(FALSE)

fit2 <- brm(bform2, data = nhanes)

summary(fit2)
plot(conditional_effects(fit2, resp = "bmi"), ask = FALSE)

# 'mi' terms can also be used when some responses are subsetted
nhanes$sub <- TRUE
nhanes$sub[1:2] <- FALSE
nhanes$id <- 1:N
nhanes$idx <- sample(3:N, N, TRUE)

# this requires the addition term 'index' being specified
# in the subsetted part of the model
bform3 <- bf(bmi | mi() ~ age * mi(chl, idx)) +
  bf(chl | mi(se) + subset(sub) + index(id) ~ age) +
  set_rescor(FALSE)

fit3 <- brm(bform3, data = nhanes)

summary(fit3)
plot(conditional_effects(fit3, resp = "bmi"), ask = FALSE)
}

}
\seealso{
\code{\link{brmsformula}}
}
