% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paired.control.R
\name{paired.control}
\alias{paired.control}
\title{Control settings for \code{paired} function}
\usage{
paired.control(
  diff = TRUE,
  numeric.test = "paired.t",
  cat.test = "mcnemar",
  ordered.test = "signed.rank",
  date.test = "paired.t",
  mcnemar.correct = TRUE,
  signed.rank.exact = NULL,
  signed.rank.correct = TRUE,
  ...
)
}
\arguments{
\item{diff}{logical, telling \code{paired} whether to calculate a column of differences between time points.}

\item{numeric.test}{name of test for numeric RHS variables in \code{paired}: paired.t, signed.rank, sign.test.}

\item{cat.test}{name of test for categorical variables: mcnemar}

\item{ordered.test}{name of test for ordered variables: signed.rank, sign.test}

\item{date.test}{name of test to perform for date variables: paired.t, signed.rank, sign.test}

\item{mcnemar.correct, signed.rank.exact, signed.rank.correct}{Options for statistical tests. See \code{\link{wilcox.test}}
and \code{\link{mcnemar.test}} for details.}

\item{...}{Arguments passed to \code{\link{tableby.control}}}
}
\value{
A list with settings to be used within the \code{\link{paired}} function.
}
\description{
Control test and summary settings for the \code{\link{paired}} function.
}
\details{
Note that (with the exception of \code{total}) all arguments to \code{\link{tableby.control}} are accepted in
  this function (in fact, this function passes everything through to \code{\link{tableby.control}}).
  However, there are different defaults for the statistical tests (shown here). For details on the other arguments,
  please see the help page for \code{\link{tableby.control}}.
}
\seealso{
\code{\link{paired}}, \code{\link{tableby}}, \code{\link{tableby.control}}, \code{\link{summary.tableby}}
}
\author{
Ethan Heinzen
}
