% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotColData.R
\name{plotColData}
\alias{plotColData}
\title{Plot column metadata}
\usage{
plotColData(
  object,
  y,
  x = NULL,
  colour_by = color_by,
  shape_by = NULL,
  size_by = NULL,
  order_by = NULL,
  by_exprs_values = "logcounts",
  other_fields = list(),
  swap_rownames = NULL,
  color_by = NULL,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{SingleCellExperiment} object containing expression values and experimental information.}

\item{y}{String specifying the column-level metadata field to show on the y-axis.
Alternatively, an \link{AsIs} vector or data.frame, see \code{?\link{retrieveCellInfo}}.}

\item{x}{String specifying the column-level metadata to show on the x-axis.
Alternatively, an \link{AsIs} vector or data.frame, see \code{?\link{retrieveCellInfo}}.
If \code{NULL}, nothing is shown on the x-axis.}

\item{colour_by}{Specification of a column metadata field or a feature to colour by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{shape_by}{Specification of a column metadata field or a feature to shape by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{size_by}{Specification of a column metadata field or a feature to size by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{order_by}{Specification of a column metadata field or a feature to order points by, see the \code{by} argument in \code{?\link{retrieveCellInfo}} for possible values.}

\item{by_exprs_values}{A string or integer scalar specifying which assay to obtain expression values from, 
for use in point aesthetics - see \code{?\link{retrieveCellInfo}} for details.}

\item{other_fields}{Additional cell-based fields to include in the data.frame, see \code{?"\link{scater-plot-args}"} for details.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to 
identify features instead of \code{rownames(object)} when labelling plot 
elements.}

\item{color_by}{Alias to \code{colour_by}.}

\item{...}{Additional arguments for visualization, see \code{?"\link{scater-plot-args}"} for details.}
}
\value{
A \link{ggplot} object.
}
\description{
Plot column-level (i.e., cell) metadata in an SingleCellExperiment object.
}
\details{
If \code{y} is continuous and \code{x=NULL}, a violin plot is generated.
If \code{x} is categorical, a grouped violin plot will be generated, with one violin for each level of \code{x}.
If \code{x} is continuous, a scatter plot will be generated.

If \code{y} is categorical and \code{x} is continuous, horizontal violin plots will be generated.
If \code{x} is missing or categorical, rectangule plots will be generated where the area of a rectangle is proportional to the number of points for a combination of factors.
}
\examples{
example_sce <- mockSCE()
example_sce <- logNormCounts(example_sce)
colData(example_sce) <- cbind(colData(example_sce), 
    perCellQCMetrics(example_sce))

plotColData(example_sce, y = "detected", x = "sum", 
   colour_by = "Mutation_Status") + scale_x_log10()

plotColData(example_sce, y = "detected", x = "sum", 
   colour_by = "Mutation_Status", size_by = "Gene_0001", 
   shape_by = "Treatment") + scale_x_log10()

plotColData(example_sce, y = "Treatment", x = "sum", 
   colour_by = "Mutation_Status") + scale_y_log10() # flipped violin.

plotColData(example_sce, y = "detected", 
   x = "Cell_Cycle", colour_by = "Mutation_Status")

}
\author{
Davis McCarthy, with modifications by Aaron Lun
}
