% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_known_signatures.R
\name{get_known_signatures}
\alias{get_known_signatures}
\title{Get known signatures}
\usage{
get_known_signatures(
  muttype = c("snv", "dbs", "indel", "tsb_snv"),
  source = c("COSMIC", "SIGNAL", "SPARSE", "COSMIC_v3.1", "COSMIC_v3.2"),
  sig_type = c("reference", "exposure", "tissue"),
  incl_poss_artifacts = FALSE,
  tissue_type = c(NA, "Biliary", "Bladder", "Bone", "Breast", "Cervix", "CNS",
    "Colorectal", "Esophagus", "Head", "Kidney", "Liver", "Lung", "Lymphoid", "Myeloid",
    "Ovary", "Pancreas", "Prostate", "Skin", "Stomach", "Thyroid", "Uterus"),
  genome = c("GRCh37", "GRCh38", "mm10")
)
}
\arguments{
\item{muttype}{The type of mutations. Possible values:
* 'snv' (default);
* 'dbs';
* 'indel';
* 'tsb_snv' transcription strand bias snv;}

\item{source}{The signature source. Possible values:
* 'COSMIC' (default. Currently v3.2);
* 'COSMIC_v3.1';
* 'COSMIC_v3.2';
* 'SIGNAL';
* 'SPARSE';}

\item{sig_type}{The type of signature. Possible values:
* 'reference' (default);
* 'exposure';
* 'tissue';}

\item{incl_poss_artifacts}{Whether to include possible
artifacts. (default: TRUE)}

\item{tissue_type}{The specific tissue to select signatures from.
Can only be used when looking at tissue specific signatures.
Keep this at NA to see tissue specific signatures for all tissues.}

\item{genome}{The genome version that is used. This only works for COSMIC signatures.
* 'GRCh37' (default);
* 'GRCh38';
* 'mm10';}
}
\value{
A signature matrix
}
\description{
This function loads a signature matrix of pre-defined signatures.
It can retrieve signatures for different types of mutations.
It can also retrieve signatures from different sources.
Additionally, different signature types can be retrieved.
(The possible types are: Reference, tissue specific or drug exposure signatures.)
For the COSMIC signatures both GRCh37, GRCh38 and mm10 versions of the signatures can be used.
Finally, the user can choose whether to include possible artifacts.
If no signatures have been defined for a specific combination of options,
then an error is given.
}
\details{
Possible combinations:
COSMIC:
- all muttypes. (tsb_snv is the same as in version 3.1)
- reference
- Can include possible artifacts for SNVs
- For the SNVs and DBSs both GRCh37 and GRCh38 versions are available

COSMIC_v3.1:
- all muttypes.
- reference
- Can include possible artifacts for SNVs

SIGNAL:
 - SNV. (+ DBS, when using exposure signatures.)
 - all signature types
 - Can include possible artifacts for reference SNVs

SPARSE:
 - SNV
 - reference

 Artifacts can be included when using reference signatures for
 SNVs with COSMIC and SIGNAL


The signatures bundled in this package came from several sources.
Please cite the associated papers if you use them.

The COSMIC signatures were downloaded from:
https://cancer.sanger.ac.uk/signatures
Currently, both version 3.2 and 3.1 are available.
Paper:  Alexandrov, L.B. et al., 2020, Nature

The SIGNAL signatures were downloaded from:
https://signal.mutationalsignatures.com/
They were downloaded on: 03 July 2020.
Paper: Andrea Degasperi et al., 2020, Nature Cancer
Exposure paper: Jill E Kucab et al., 2019, Cell

The SPARSE signatures were downloaded from:
https://www.biorxiv.org/content/10.1101/384834v2
They were downloaded on: 03 July 2020.
Paper: Daniele Ramazzotti et al., 2019, Bioarchive
}
\examples{

## Get reference snv signature from COSMIC
get_known_signatures()

## Get reference snv signature from COSMIC,
## including potential artifacts.
get_known_signatures(incl_poss_artifacts = TRUE)

## Get a GRCh38 version of the signatures
get_known_signatures(genome = "GRCh38")

## Get DBS signatures
get_known_signatures("dbs")

## Get indel signatures
get_known_signatures("indel")

## Get transcription strand bias snv signatures
get_known_signatures("tsb_snv")

## Get COSMIC version 3.1 of the signatures
get_known_signatures(source = "COSMIC_v3.1")

## Get reference signatures from SIGNAL
get_known_signatures(source = "SIGNAL")

## Get reference signatures from SIGNAL,
## including potential artifacts
get_known_signatures(source = "SIGNAL", incl_poss_artifacts = TRUE)

## Get exposure signatures from SIGNAL
get_known_signatures(source = "SIGNAL", sig_type = "exposure")

## Get DBS exposure signatures from SIGNAL
get_known_signatures("dbs", source = "SIGNAL", sig_type = "exposure")

## Get all tissue specific signatures from SIGNAL
get_known_signatures(source = "SIGNAL", sig_type = "tissue")

## Get Bladder specific signatures from SIGNAL
get_known_signatures(
  source = "SIGNAL",
  sig_type = "tissue",
  tissue_type = "Bladder"
)

## If you use an incorrect tissue_type an error is given.

## Get sparse signatures
get_known_signatures(source = "SPARSE")
}
