% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellDataSet.R
\docType{class}
\name{CellDataSet}
\alias{CellDataSet}
\alias{CellDataSet-class}
\title{The CellDataSet class}
\description{
The main class used by Monocle to hold single cell expression data. 
CellDataSet extends the basic Bioconductor ExpressionSet class.
}
\details{
This class is initialized from a matrix of expression values Methods that 
operate on CellDataSet objects constitute the basic Monocle workflow.
}
\section{Fields}{

\describe{
\item{\code{reducedDimS}}{Matrix of class numeric, containing the source values computed by Independent Components Analysis.}

\item{\code{reducedDimW}}{Matrix of class numeric, containing the whitened expression values computed during Independent Components Analysis.}

\item{\code{reducedDimA}}{Matrix of class numeric, containing the weight values computed by Independent Components Analysis.}

\item{\code{reducedDimK}}{A Matrix of class numeric, containing the pre-whitening matrix computed by Independent Components Analysis.}

\item{\code{minSpanningTree}}{An Object of class igraph, containing the minimum spanning tree used by Monocle to order cells according to progress through a biological process.}

\item{\code{cellPairwiseDistances}}{A Matrix of class numeric, containing the pairwise distances between cells in the reduced dimension space.}

\item{\code{expressionFamily}}{An Object of class vglmff, specifying the VGAM family function used for expression responses.}

\item{\code{lowerDetectionLimit}}{A numeric value specifying the minimum expression level considered to be true expression.}

\item{\code{dispFitInfo}}{An environment containing lists, one for each set of estimated dispersion values. See estimateDispersions.}

\item{\code{dim_reduce_type}}{A string encoding how this CellDataSet has been reduced in dimensionality}

\item{\code{auxOrderingData}}{An environment of auxilliary data structures used by various steps in Monocle. Not to be accessed by users directly.}
}}

