% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSEA.R
\name{plotEnrichmentDetailed}
\alias{plotEnrichmentDetailed}
\title{Plot detailed output of the Feature Set Enrichment Analysis}
\usage{
plotEnrichmentDetailed(object, factor, feature.sets, fsea.results,
  adjust = TRUE, alpha = 0.1, max.genes = 5, max.pathways = 10,
  text_size = 3)
}
\arguments{
\item{object}{\code{\link{MOFAmodel}} object on which FSEA was performed}

\item{factor}{string with factor name or numeric with factor index}

\item{feature.sets}{data structure that holds feature set membership information, as used in the \link{runEnrichmentAnalysis} function.}

\item{fsea.results}{output of \link{runEnrichmentAnalysis} function}

\item{adjust}{use adjusted p-values?}

\item{alpha}{p.value threshold to filter out feature sets}

\item{max.genes}{maximum number of genes to display, per pathway}

\item{max.pathways}{maximum number of enriched pathways to display}

\item{text_size}{size of the text to label the top genes}
}
\value{
a \code{ggplot2} object
}
\description{
Method to plot a detailed output of the Feature Set Enrichment Analyisis (FSEA). \cr
Each row corresponds to a significant pathway, sorted by statistical significance, and each dot corresponds to a gene. \cr
For each pathway, we display the top genes of the pathway sorted by the corresponding feature statistic (by default, the absolute value of the loading)
The top genes with the highest statistic (max.genes argument) are displayed and labeled in black. The remaining genes are colored in grey.
}
\examples{
# Example on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFAobject <- loadModel(filepath)

# perform Enrichment Analysis on mRNA data using pre-build Reactome gene sets
data("reactomeGS", package = "MOFAdata")
fsea.results <- runEnrichmentAnalysis(MOFAobject, view="mRNA", feature.sets=reactomeGS)

# Plot detailed output of the enrichment analysis results
plotEnrichmentDetailed(
object = MOFAobject, 
factor = 5,
feature.sets = reactomeGS,
fsea.results = fsea.results,

)
}
