% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmas.r
\name{find_sigmas}
\alias{find_sigmas}
\title{Calculate the average dimensionality for m different gaussian kernel widths (\eqn{\sigma}).}
\usage{
find_sigmas(
  data,
  step_size = 0.1,
  steps = 10L,
  start = NULL,
  sample_rows = 500L,
  early_exit = FALSE,
  ...,
  censor_val = NULL,
  censor_range = NULL,
  missing_range = NULL,
  vars = NULL,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data set with \eqn{n} observations. Can be a \link[base]{data.frame},
\link[base]{matrix}, \link[Biobase:class.ExpressionSet]{ExpressionSet}
or \link[SingleCellExperiment]{SingleCellExperiment}.}

\item{step_size}{Size of log-sigma steps}

\item{steps}{Number of steps/calculations}

\item{start}{Initial value to search from. (Optional. default: \eqn{\log_{10}(min(dist(data)))})}

\item{sample_rows}{Number of random rows to use for sigma estimation or vector of row indices/names to use.
In the first case, only used if actually smaller than the number of available rows (Optional. default: 500)}

\item{early_exit}{logical. If TRUE, return if the first local maximum is found, else keep running}

\item{...}{Unused. All parameters to the right of the \code{...} have to be specified by name (e.g. \code{find_sigmas(data, verbose = FALSE)})}

\item{censor_val}{Value regarded as uncertain. Either a single value or one for every dimension}

\item{censor_range}{Uncertainity range for censoring. A length-2-vector of certainty range start and end. TODO: also allow \eqn{2\times G} matrix}

\item{missing_range}{Whole data range for missing value model. Has to be specified if NAs are in the data}

\item{vars}{Variables (columns) of the data to use. Specifying TRUE will select all columns (default: All floating point value columns)}

\item{verbose}{logical. If TRUE, show a progress bar and plot the output}
}
\value{
Object of class \link{Sigmas}
}
\description{
The sigma with the maximum value in average dimensionality is close to the ideal one.
Increasing step number gets this nearer to the ideal one.
}
\examples{
data(guo)
sigs <- find_sigmas(guo, verbose = TRUE)
DiffusionMap(guo, sigs)

}
\seealso{
\code{\link{Sigmas}}, the class returned by this; \code{\link{DiffusionMap}}, the class this is used for
}
