% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.r
\name{dm_predict}
\alias{dm_predict}
\title{Predict new data points using an existing DiffusionMap. The resulting matrix can be used in \link[=plot.DiffusionMap]{the plot method for the DiffusionMap}}
\usage{
dm_predict(dm, new_data, ..., verbose = FALSE)
}
\arguments{
\item{dm}{A \code{\link{DiffusionMap}} object.}

\item{new_data}{New data points to project into the diffusion map.
Can be a \link[base]{matrix}, \link[base]{data.frame},
\link[Biobase:class.ExpressionSet]{ExpressionSet},
or \link[SingleCellExperiment]{SingleCellExperiment}.}

\item{...}{Passed to \code{\link[proxy:dist]{proxy::dist}(new_data, data, dm@distance, ...)}.}

\item{verbose}{Show progress messages?}
}
\value{
A \eqn{nrow(new\_data) \times ncol(eigenvectors(dif))} matrix of projected diffusion components for the new data.
}
\description{
Predict new data points using an existing DiffusionMap. The resulting matrix can be used in \link[=plot.DiffusionMap]{the plot method for the DiffusionMap}
}
\examples{
data(guo)
g1 <- guo[, guo$num_cells != 32L]
g2 <- guo[, guo$num_cells == 32L]
dm <- DiffusionMap(g1)
dc2 <- dm_predict(dm, g2)
plot(dm, new_dcs = dc2)

}
