% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{degSummary}
\alias{degSummary}
\title{Print Summary Statistics of Alpha Level Cutoffs}
\usage{
degSummary(
  object,
  alpha = c(0.1, 0.05, 0.01),
  contrast = NULL,
  caption = "",
  kable = FALSE
)
}
\arguments{
\item{object}{Can be \link{DEGSet} or \link{DESeqDataSet} or \link{DESeqResults}.}

\item{alpha}{Numeric vector of desired alpha cutoffs.}

\item{contrast}{Character vector to use with \code{\link[=results]{results()}} function.}

\item{caption}{Character vector to add as caption to the table.}

\item{kable}{Whether return a \code{\link[knitr:kable]{knitr::kable()}} output. Default is data.frame.}
}
\value{
\link{data.frame} or \code{\link[knitr:kable]{knitr::kable()}}.
}
\description{
Print Summary Statistics of Alpha Level Cutoffs
}
\examples{
library(DESeq2)
data(humanGender)
idx <- c(1:5, 75:80)
counts <- assays(humanGender)[[1]]
dse <- DESeqDataSetFromMatrix(counts[1:1000, idx],
                              colData(humanGender)[idx,],
                              design = ~group)
dse <- DESeq(dse)
res1 <- results(dse)
res2 <- degComps(dse, contrast = c("group_Male_vs_Female"))
degSummary(dse, contrast = "group_Male_vs_Female")
degSummary(res1)
degSummary(res1, kable = TRUE)
degSummary(res2[[1]])
}
\references{
\itemize{
\item original idea of multiple alpha values and code syntax
from  Michael Steinbaugh.
}
}
\author{
Lorena Pantano
}
