% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-omnipath.R
\name{get_dorothea}
\alias{get_dorothea}
\title{DoRothEA gene regulatory network.}
\usage{
get_dorothea(
  organism = "human",
  levels = c("A", "B", "C"),
  weight_dict = list(A = 1, B = 2, C = 3, D = 4)
)
}
\arguments{
\item{organism}{Which organism to use. Only human and mouse are available.}

\item{levels}{List of confidence levels to return. Goes from A to D, A
being the most confident and D being the less.}

\item{weight_dict}{Dictionary of values to divide the mode of regulation
(-1 or 1), one for each confidence level. Bigger values will generate
weights close to zero.}
}
\description{
Wrapper to access DoRothEA gene regulatory network. DoRothEA is a
comprehensive resource containing a curated collection of transcription
factors (TFs) and their target genes. Each interaction is weighted by its
mode of regulation (either positive or negative) and by its confidence level
}
\examples{
dorothea <- get_dorothea(organism='human', levels=c('A', 'B', 'C'))
}
