# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.sync.v1.service.sync_list.sync_list_item import SyncListItemList
from twilio.rest.sync.v1.service.sync_list.sync_list_permission import SyncListPermissionList


class SyncListList(ListResource):

    def __init__(self, version, service_sid):
        """
        Initialize the SyncListList

        :param Version version: Version that contains the resource
        :param service_sid: The SID of the Sync Service that the resource is associated with

        :returns: twilio.rest.sync.v1.service.sync_list.SyncListList
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListList
        """
        super(SyncListList, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, }
        self._uri = '/Services/{service_sid}/Lists'.format(**self._solution)

    def create(self, unique_name=values.unset, ttl=values.unset,
               collection_ttl=values.unset):
        """
        Create the SyncListInstance

        :param unicode unique_name: An application-defined string that uniquely identifies the resource
        :param unicode ttl: Alias for collection_ttl
        :param unicode collection_ttl: How long, in seconds, before the Sync List expires and is deleted

        :returns: The created SyncListInstance
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListInstance
        """
        data = values.of({'UniqueName': unique_name, 'Ttl': ttl, 'CollectionTtl': collection_ttl, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return SyncListInstance(self._version, payload, service_sid=self._solution['service_sid'], )

    def stream(self, limit=None, page_size=None):
        """
        Streams SyncListInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.sync.v1.service.sync_list.SyncListInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists SyncListInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.sync.v1.service.sync_list.SyncListInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of SyncListInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of SyncListInstance
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListPage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return SyncListPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of SyncListInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of SyncListInstance
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return SyncListPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a SyncListContext

        :param sid: The SID of the Sync List resource to fetch

        :returns: twilio.rest.sync.v1.service.sync_list.SyncListContext
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListContext
        """
        return SyncListContext(self._version, service_sid=self._solution['service_sid'], sid=sid, )

    def __call__(self, sid):
        """
        Constructs a SyncListContext

        :param sid: The SID of the Sync List resource to fetch

        :returns: twilio.rest.sync.v1.service.sync_list.SyncListContext
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListContext
        """
        return SyncListContext(self._version, service_sid=self._solution['service_sid'], sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Sync.V1.SyncListList>'


class SyncListPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the SyncListPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param service_sid: The SID of the Sync Service that the resource is associated with

        :returns: twilio.rest.sync.v1.service.sync_list.SyncListPage
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListPage
        """
        super(SyncListPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of SyncListInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.sync.v1.service.sync_list.SyncListInstance
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListInstance
        """
        return SyncListInstance(self._version, payload, service_sid=self._solution['service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Sync.V1.SyncListPage>'


class SyncListContext(InstanceContext):

    def __init__(self, version, service_sid, sid):
        """
        Initialize the SyncListContext

        :param Version version: Version that contains the resource
        :param service_sid: The SID of the Sync Service with the Sync List resource to fetch
        :param sid: The SID of the Sync List resource to fetch

        :returns: twilio.rest.sync.v1.service.sync_list.SyncListContext
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListContext
        """
        super(SyncListContext, self).__init__(version)

        # Path Solution
        self._solution = {'service_sid': service_sid, 'sid': sid, }
        self._uri = '/Services/{service_sid}/Lists/{sid}'.format(**self._solution)

        # Dependents
        self._sync_list_items = None
        self._sync_list_permissions = None

    def fetch(self):
        """
        Fetch the SyncListInstance

        :returns: The fetched SyncListInstance
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return SyncListInstance(
            self._version,
            payload,
            service_sid=self._solution['service_sid'],
            sid=self._solution['sid'],
        )

    def delete(self):
        """
        Deletes the SyncListInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def update(self, ttl=values.unset, collection_ttl=values.unset):
        """
        Update the SyncListInstance

        :param unicode ttl: An alias for collection_ttl
        :param unicode collection_ttl: How long, in seconds, before the Sync List expires and is deleted

        :returns: The updated SyncListInstance
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListInstance
        """
        data = values.of({'Ttl': ttl, 'CollectionTtl': collection_ttl, })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return SyncListInstance(
            self._version,
            payload,
            service_sid=self._solution['service_sid'],
            sid=self._solution['sid'],
        )

    @property
    def sync_list_items(self):
        """
        Access the sync_list_items

        :returns: twilio.rest.sync.v1.service.sync_list.sync_list_item.SyncListItemList
        :rtype: twilio.rest.sync.v1.service.sync_list.sync_list_item.SyncListItemList
        """
        if self._sync_list_items is None:
            self._sync_list_items = SyncListItemList(
                self._version,
                service_sid=self._solution['service_sid'],
                list_sid=self._solution['sid'],
            )
        return self._sync_list_items

    @property
    def sync_list_permissions(self):
        """
        Access the sync_list_permissions

        :returns: twilio.rest.sync.v1.service.sync_list.sync_list_permission.SyncListPermissionList
        :rtype: twilio.rest.sync.v1.service.sync_list.sync_list_permission.SyncListPermissionList
        """
        if self._sync_list_permissions is None:
            self._sync_list_permissions = SyncListPermissionList(
                self._version,
                service_sid=self._solution['service_sid'],
                list_sid=self._solution['sid'],
            )
        return self._sync_list_permissions

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Sync.V1.SyncListContext {}>'.format(context)


class SyncListInstance(InstanceResource):

    def __init__(self, version, payload, service_sid, sid=None):
        """
        Initialize the SyncListInstance

        :returns: twilio.rest.sync.v1.service.sync_list.SyncListInstance
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListInstance
        """
        super(SyncListInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'unique_name': payload.get('unique_name'),
            'account_sid': payload.get('account_sid'),
            'service_sid': payload.get('service_sid'),
            'url': payload.get('url'),
            'links': payload.get('links'),
            'revision': payload.get('revision'),
            'date_expires': deserialize.iso8601_datetime(payload.get('date_expires')),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'created_by': payload.get('created_by'),
        }

        # Context
        self._context = None
        self._solution = {'service_sid': service_sid, 'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: SyncListContext for this SyncListInstance
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListContext
        """
        if self._context is None:
            self._context = SyncListContext(
                self._version,
                service_sid=self._solution['service_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def unique_name(self):
        """
        :returns: An application-defined string that uniquely identifies the resource
        :rtype: unicode
        """
        return self._properties['unique_name']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def service_sid(self):
        """
        :returns: The SID of the Sync Service that the resource is associated with
        :rtype: unicode
        """
        return self._properties['service_sid']

    @property
    def url(self):
        """
        :returns: The absolute URL of the Sync List resource
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def links(self):
        """
        :returns: The URLs of the Sync List's nested resources
        :rtype: unicode
        """
        return self._properties['links']

    @property
    def revision(self):
        """
        :returns: The current revision of the Sync List, represented as a string
        :rtype: unicode
        """
        return self._properties['revision']

    @property
    def date_expires(self):
        """
        :returns: The ISO 8601 date and time in GMT when the Sync List expires
        :rtype: datetime
        """
        return self._properties['date_expires']

    @property
    def date_created(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was created
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The ISO 8601 date and time in GMT when the resource was last updated
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def created_by(self):
        """
        :returns: The identity of the Sync List's creator
        :rtype: unicode
        """
        return self._properties['created_by']

    def fetch(self):
        """
        Fetch the SyncListInstance

        :returns: The fetched SyncListInstance
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListInstance
        """
        return self._proxy.fetch()

    def delete(self):
        """
        Deletes the SyncListInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def update(self, ttl=values.unset, collection_ttl=values.unset):
        """
        Update the SyncListInstance

        :param unicode ttl: An alias for collection_ttl
        :param unicode collection_ttl: How long, in seconds, before the Sync List expires and is deleted

        :returns: The updated SyncListInstance
        :rtype: twilio.rest.sync.v1.service.sync_list.SyncListInstance
        """
        return self._proxy.update(ttl=ttl, collection_ttl=collection_ttl, )

    @property
    def sync_list_items(self):
        """
        Access the sync_list_items

        :returns: twilio.rest.sync.v1.service.sync_list.sync_list_item.SyncListItemList
        :rtype: twilio.rest.sync.v1.service.sync_list.sync_list_item.SyncListItemList
        """
        return self._proxy.sync_list_items

    @property
    def sync_list_permissions(self):
        """
        Access the sync_list_permissions

        :returns: twilio.rest.sync.v1.service.sync_list.sync_list_permission.SyncListPermissionList
        :rtype: twilio.rest.sync.v1.service.sync_list.sync_list_permission.SyncListPermissionList
        """
        return self._proxy.sync_list_permissions

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Sync.V1.SyncListInstance {}>'.format(context)
