Report
======
This document describes the Puppet master's report endpoint and the schema for
Report Format 12 in technical terms. Also see the
[documentation](https://puppet.com/docs/puppet/latest/format_report.html).

The `report` endpoint allows clients to send reports to the master via `http`
or `https`. Once received by the master they are processed by the *report
processors* configured to be triggered when a report is received. As an
example, storing reports in PuppetDB is handled by one such report processor.

Save
----
The http(s) endpoint for sending reports to the master is:

    PUT /puppet/v3/report/:nodename?environment=:environment

### Supported HTTP Methods

PUT

### Supported Format(s)

`application/json`

### Parameters

None

### Content

The content of a report is typically generated by the Puppet Runtime and consists of a JSON serialization of `Puppet::Transaction::Report` object which in turn contains a structure of objects with of the following runtime types:

* `Puppet::Util::Log`
* `Puppet::Util::Metric`
* `Puppet::Resource::Status`
* `Puppet::Transaction::Event`

This JSON serialization is compliant with the endpoint's report JSON schema.

Example
-------
Here is an example of a PUT request. (Note that the content-length is not correct as the
example is formatted for readability)

    PUT /puppet/v3/report/kermit.com?environment=production HTTP/1.0
    Content-Type: application/json
    Content-Length: 1428

    {"host"=>"kermit.com",
     "time"=>"2013-09-12T03:50:59.009301000+02:00",
     "configuration_version"=>1357986,
     "transaction_uuid"=>"df34516e-4050-402d-a166-05b03b940749",
     "code_id"=>null,
     "job_id"=>null,
     "catalog_uuid"=>"827a74c8-cf98-44da-9ff7-18c5e4bee41e",
     "catalog_format"=>1,
     "report_format"=>9,
     "puppet_version"=>"5.0.0",
     "status"=>"unchanged",
     "transaction_completed"=>true,
     "noop"=>false,
     "noop_pending"=>false,
     "environment"=>"test_environment",
     "logs"=>
      [{"level"=>"warning",
        "message"=>"log message",
        "source"=>"Puppet",
        "tags"=>["warning"],
        "time"=>"2013-09-12T03:50:59.009328000+02:00",
        "file"=>nil,
        "line"=>nil}],
     "metrics"=>
      {"resources"=>
        {"name"=>"resources",
         "label"=>"Resources",
         "values"=>
          [["total", "Total", 1],
           ["skipped", "Skipped", 0],
           ["failed", "Failed", 0],
           ["failed_to_restart", "Failed to restart", 0],
           ["restarted", "Restarted", 0],
           ["changed", "Changed", 1],
           ["out_of_sync", "Out of sync", 0],
           ["scheduled", "Scheduled", 0]]},
       "time"=>
        {"name"=>"time",
         "label"=>"Time",
         "values"=>[["timing", "Timing", 4], ["total", "Total", 4]]},
       "changes"=>
        {"name"=>"changes", "label"=>"Changes", "values"=>[["total", "Total", 0]]},
       "events"=>
        {"name"=>"events",
         "label"=>"Events",
         "values"=>
          [["total", "Total", 0],
           ["failure", "Failure", 0],
           ["success", "Success", 0]]}},
     "resource_statuses"=>
      {"Notify[a resource]"=>
        {"title"=>"a resource",
         "file"=>nil,
         "line"=>nil,
         "resource"=>"Notify[a resource]",
         "resource_type"=>"Notify",
         "provider_used"=>nil,
         "containment_path"=>["Notify[a resource]"],
         "evaluation_time"=>nil,
         "tags"=>["notify"],
         "time"=>"2013-09-12T03:50:59.009238000+02:00",
         "failed"=>false,
         "changed"=>true,
         "out_of_sync"=>false,
         "skipped"=>false,
         "change_count"=>0,
         "out_of_sync_count"=>0,
         "events"=>[]}},
      "cached_catalog_status"=> "not_used"}

Schema
------

The sent report objects must conform to
[the report schema.](../schemas/report.json)
