/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.AutoNumber;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Divider;
import net.sourceforge.plantuml.sequencediagram.DottedNumber;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import net.sourceforge.plantuml.sequencediagram.Grouping;
import net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import net.sourceforge.plantuml.sequencediagram.GroupingStart;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.HSpace;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.LinkAnchor;
import net.sourceforge.plantuml.sequencediagram.Newpage;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.Notes;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;
import net.sourceforge.plantuml.sequencediagram.Reference;
import net.sourceforge.plantuml.sequencediagram.graphic.FileMaker;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramFileMakerPuma2;
import net.sourceforge.plantuml.sequencediagram.graphic.SequenceDiagramTxtMaker;
import net.sourceforge.plantuml.sequencediagram.teoz.SequenceDiagramFileMakerTeoz;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class SequenceDiagram
extends UmlDiagram {
    private final List<Participant> participantsList = new ArrayList<Participant>();
    private final List<Event> events = new ArrayList<Event>();
    private final Map<Participant, ParticipantEnglober> participantEnglobers2 = new HashMap<Participant, ParticipantEnglober>();
    private final Rose skin2 = new Rose();
    private EventWithDeactivate lastEventWithDeactivate;
    private boolean ignoreNewpage = false;
    private int autonewpage = -1;
    private Delay lastDelay;
    private final Stack<AbstractMessage> activationState = new Stack();
    private LifeEvent pendingCreate = null;
    private final List<GroupingStart> openGroupings = new ArrayList<GroupingStart>();
    private final AutoNumber autoNumber = new AutoNumber();
    private boolean showFootbox = true;
    private ParticipantEnglober participantEnglober;
    private boolean autoactivate;
    private final Set<EntityPortion> hiddenPortions = EnumSet.noneOf(EntityPortion.class);
    private final List<LinkAnchor> linkAnchors = new ArrayList<LinkAnchor>();

    public SequenceDiagram(UmlSource source, ISkinSimple skinParam) {
        super(source, UmlDiagramType.SEQUENCE, skinParam);
    }

    @Deprecated
    public Participant getOrCreateParticipant(String code) {
        return this.getOrCreateParticipant(code, Display.getWithNewlines(code));
    }

    public Participant getOrCreateParticipant(String code, Display display) {
        Participant result = this.participantsget(code);
        if (result == null) {
            result = new Participant(ParticipantType.PARTICIPANT, code, display, this.hiddenPortions, 0, this.getSkinParam().getCurrentStyleBuilder());
            this.addWithOrder(result);
            this.participantEnglobers2.put(result, this.participantEnglober);
        }
        return result;
    }

    private Participant participantsget(String code) {
        for (Participant p : this.participantsList) {
            if (!p.getCode().equals(code)) continue;
            return p;
        }
        return null;
    }

    public EventWithDeactivate getLastEventWithDeactivate() {
        return this.lastEventWithDeactivate;
    }

    public Participant createNewParticipant(ParticipantType type, String code, Display display, int order) {
        if (this.participantsget(code) != null) {
            throw new IllegalArgumentException();
        }
        if (Display.isNull(display)) {
            display = Display.getWithNewlines(code);
        }
        Participant result = new Participant(type, code, display, this.hiddenPortions, order, this.getSkinParam().getCurrentStyleBuilder());
        this.addWithOrder(result);
        this.participantEnglobers2.put(result, this.participantEnglober);
        return result;
    }

    private void addWithOrder(Participant result) {
        for (int i = 0; i < this.participantsList.size(); ++i) {
            if (result.getOrder() >= this.participantsList.get(i).getOrder()) continue;
            this.participantsList.add(i, result);
            return;
        }
        this.participantsList.add(result);
    }

    public Collection<Participant> participants() {
        return Collections.unmodifiableCollection(this.participantsList);
    }

    public boolean participantsContainsKey(String code) {
        return this.participantsget(code) != null;
    }

    public String addMessage(AbstractMessage m) {
        this.lastEventWithDeactivate = m;
        this.lastDelay = null;
        this.events.add(m);
        if (this.pendingCreate != null) {
            if (!m.compatibleForCreate(this.pendingCreate.getParticipant())) {
                return "After create command, you have to send a message to \"" + this.pendingCreate.getParticipant() + "\"";
            }
            m.addLifeEvent(this.pendingCreate);
            this.pendingCreate = null;
        }
        return null;
    }

    public void addNote(Note n, boolean tryMerge) {
        if (tryMerge && this.events.size() > 0) {
            Event last = this.events.get(this.events.size() - 1);
            if (last instanceof Note) {
                Notes notes = new Notes((Note)last, n);
                this.events.set(this.events.size() - 1, notes);
                return;
            }
            if (last instanceof Notes) {
                ((Notes)last).add(n);
                return;
            }
        }
        this.events.add(n);
    }

    public void newpage(Display strings) {
        if (this.ignoreNewpage) {
            return;
        }
        this.events.add(new Newpage(strings));
    }

    public void ignoreNewpage() {
        this.ignoreNewpage = true;
    }

    public final int getAutonewpage() {
        return this.autonewpage;
    }

    public void setAutonewpage(int autonewpage) {
        this.autonewpage = autonewpage;
    }

    public void divider(Display strings) {
        this.events.add(new Divider(strings, this.getSkinParam().getCurrentStyleBuilder()));
    }

    public void hspace() {
        this.events.add(new HSpace());
    }

    public void hspace(int pixel) {
        this.events.add(new HSpace(pixel));
    }

    public void delay(Display strings) {
        Delay delay = new Delay(strings, this.getSkinParam().getCurrentStyleBuilder());
        this.events.add(delay);
        this.lastDelay = delay;
    }

    public List<Event> events() {
        return Collections.unmodifiableList(this.events);
    }

    private FileMaker getSequenceDiagramPngMaker(int index, FileFormatOption fileFormatOption) {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            return new SequenceDiagramTxtMaker(this, fileFormat);
        }
        if (this.modeTeoz()) {
            return new SequenceDiagramFileMakerTeoz(this, this.skin2, fileFormatOption, index);
        }
        return new SequenceDiagramFileMakerPuma2(this, this.skin2, fileFormatOption);
    }

    private boolean modeTeoz() {
        return this.getPragma().useTeozLayout();
    }

    @Override
    public ImageBuilder createImageBuilder(FileFormatOption fileFormatOption) throws IOException {
        return super.createImageBuilder(fileFormatOption).annotations(false);
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormat) throws IOException {
        FileMaker sequenceDiagramPngMaker = this.getSequenceDiagramPngMaker(index, fileFormat);
        return sequenceDiagramPngMaker.createOne(os, index, fileFormat.isWithMetadata());
    }

    public AbstractMessage getActivatingMessage() {
        if (this.activationState.empty()) {
            return null;
        }
        return this.activationState.peek();
    }

    public String activate(Participant p, LifeEventType lifeEventType, HColor backcolor) {
        return this.activate(p, lifeEventType, backcolor, null);
    }

    public String activate(Participant p, LifeEventType lifeEventType, HColor backcolor, HColor linecolor) {
        if (this.lastDelay != null) {
            return "You cannot Activate/Deactivate just after a ...";
        }
        LifeEvent lifeEvent = new LifeEvent(p, lifeEventType, new SymbolContext(backcolor, linecolor));
        this.events.add(lifeEvent);
        if (lifeEventType == LifeEventType.CREATE) {
            this.pendingCreate = lifeEvent;
            return null;
        }
        if (this.lastEventWithDeactivate == null) {
            if (lifeEventType == LifeEventType.ACTIVATE) {
                p.incInitialLife(new SymbolContext(backcolor, linecolor));
                return null;
            }
            if (p.getInitialLife() == 0) {
                return "You cannot deactivate here";
            }
            return null;
        }
        if (lifeEventType == LifeEventType.ACTIVATE && this.lastEventWithDeactivate instanceof AbstractMessage) {
            this.activationState.push((AbstractMessage)this.lastEventWithDeactivate);
        } else if (lifeEventType == LifeEventType.DEACTIVATE && !this.activationState.empty()) {
            this.activationState.pop();
        }
        boolean ok = this.lastEventWithDeactivate.addLifeEvent(lifeEvent);
        if (this.lastEventWithDeactivate instanceof AbstractMessage) {
            lifeEvent.setMessage((AbstractMessage)this.lastEventWithDeactivate);
        }
        if (ok) {
            return null;
        }
        return "Activate/Deactivate already done on " + p.getCode();
    }

    public boolean grouping(String title, String comment, GroupingType type, HColor backColorGeneral, HColor backColorElement, boolean parallel) {
        if (type != GroupingType.START && this.openGroupings.size() == 0) {
            return false;
        }
        if (backColorGeneral == null) {
            backColorGeneral = this.getSkinParam().getHtmlColor(ColorParam.sequenceGroupBodyBackground, null, false);
        }
        GroupingStart top = this.openGroupings.size() > 0 ? this.openGroupings.get(0) : null;
        Grouping g = type == GroupingType.START ? new GroupingStart(title, comment, backColorGeneral, backColorElement, top, this.getSkinParam().getCurrentStyleBuilder()) : new GroupingLeaf(title, comment, type, backColorGeneral, backColorElement, top, this.getSkinParam().getCurrentStyleBuilder());
        this.events.add(g);
        if (type == GroupingType.START) {
            if (parallel) {
                ((GroupingStart)g).goParallel();
            }
            this.openGroupings.add(0, (GroupingStart)g);
        } else if (type == GroupingType.END) {
            this.openGroupings.remove(0);
            this.lastEventWithDeactivate = (GroupingLeaf)g;
        }
        return true;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(" + this.participantsList.size() + " participants)");
    }

    public final void autonumberGo(DottedNumber startingNumber, int increment, DecimalFormat decimalFormat) {
        this.autoNumber.go(startingNumber, increment, decimalFormat);
    }

    public final void autonumberStop() {
        this.autoNumber.stop();
    }

    public final AutoNumber getAutoNumber() {
        return this.autoNumber;
    }

    public String getNextMessageNumber() {
        return this.autoNumber.getNextMessageNumber();
    }

    public boolean isShowFootbox() {
        if (this.getSkinParam().strictUmlStyle()) {
            return false;
        }
        String footbox = this.getSkinParam().getValue("footbox");
        if (footbox == null) {
            return this.showFootbox;
        }
        return !footbox.equalsIgnoreCase("hide");
    }

    public void setShowFootbox(boolean footbox) {
        this.showFootbox = footbox;
    }

    public void boxStart(Display comment, HColor color, Stereotype stereotype) {
        if (this.participantEnglober != null) {
            throw new IllegalStateException();
        }
        this.participantEnglober = new ParticipantEnglober(comment, color, stereotype);
    }

    public void endBox() {
        if (this.participantEnglober == null) {
            throw new IllegalStateException();
        }
        this.participantEnglober = null;
    }

    public boolean isBoxPending() {
        return this.participantEnglober != null;
    }

    @Override
    public int getNbImages() {
        try {
            return this.getSequenceDiagramPngMaker(1, new FileFormatOption(FileFormat.DEBUG)).getNbPages();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 1;
        }
    }

    public void removeHiddenParticipants() {
        for (Participant p : new ArrayList<Participant>(this.participantsList)) {
            if (!this.isAlone(p)) continue;
            this.remove(p);
        }
    }

    private void remove(Participant p) {
        boolean ok = this.participantsList.remove(p);
        if (!ok) {
            throw new IllegalArgumentException();
        }
        this.participantEnglobers2.remove(p);
    }

    private boolean isAlone(Participant p) {
        for (Event ev : this.events) {
            if (!ev.dealWith(p)) continue;
            return false;
        }
        return true;
    }

    public void putParticipantInLast(String code) {
        Participant p = Objects.requireNonNull(this.participantsget(code), code);
        boolean ok = this.participantsList.remove(p);
        assert (ok);
        this.addWithOrder(p);
        this.participantEnglobers2.put(p, this.participantEnglober);
    }

    public ParticipantEnglober getEnglober(Participant p) {
        return this.participantEnglobers2.get(p);
    }

    public final void setAutoactivate(boolean autoactivate) {
        this.autoactivate = autoactivate;
    }

    public final boolean isAutoactivate() {
        return this.autoactivate;
    }

    @Override
    public boolean hasUrl() {
        for (Participant p : this.participantsList) {
            if (p.getUrl() == null) continue;
            return true;
        }
        for (Event ev : this.events) {
            if (!ev.hasUrl()) continue;
            return true;
        }
        return !this.getLegend().isNull() && this.getLegend().hasUrl();
    }

    public void addReference(Reference ref) {
        this.events.add(ref);
    }

    @Override
    public boolean isOk() {
        return this.participantsList.size() != 0;
    }

    @Override
    public String checkFinalError() {
        if (this.isHideUnlinkedData()) {
            this.removeHiddenParticipants();
        }
        return super.checkFinalError();
    }

    public void hideOrShow(Set<EntityPortion> portions, boolean show) {
        if (show) {
            this.hiddenPortions.removeAll(portions);
        } else {
            this.hiddenPortions.addAll(portions);
        }
    }

    public Display manageVariable(Display labels) {
        return labels.replace("%autonumber%", this.autoNumber.getCurrentMessageNumber(false));
    }

    public CommandExecutionResult linkAnchor(String anchor1, String anchor2, String message) {
        this.linkAnchors.add(new LinkAnchor(anchor1, anchor2, message));
        return CommandExecutionResult.ok();
    }

    public List<LinkAnchor> getLinkAnchors() {
        return Collections.unmodifiableList(this.linkAnchors);
    }

    @Override
    public ClockwiseTopRightBottomLeft getDefaultMargins() {
        return this.modeTeoz() ? ClockwiseTopRightBottomLeft.same(5.0) : ClockwiseTopRightBottomLeft.topRightBottomLeft(5.0, 5.0, 5.0, 0.0);
    }
}

