/* pocl/_kernel_renames.h - Rename OpenCL builtin functions to avoid name
   clashes with libm functions which are called in implementation.

   Copyright (c) 2011-2013 Erik Schnetter <eschnetter@perimeterinstitute.ca>
                           Perimeter Institute for Theoretical Physics
   Copyright (c) 2011-2017 Pekka Jääskeläinen / TUT

   Permission is hereby granted, free of charge, to any person obtaining a copy
   of this software and associated documentation files (the "Software"), to deal
   in the Software without restriction, including without limitation the rights
   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   copies of the Software, and to permit persons to whom the Software is
   furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
   THE SOFTWARE.
*/

#ifndef _KERNEL_RENAMES_H
#define _KERNEL_RENAMES_H

/* Move built-in declarations and libm functions out of the way.
  (There should be a better way of doing so. These functions are
  built-in math functions for OpenCL (see Clang's "Builtins.def").

  Functions defined in libc or libm may also
  interfere with OpenCL's functions, since their prototypes will be
  wrong.

  We're not using libm anymore, but renames are still important
  for SPIR/SPIR-V support. SPIR mangling is different, but when
  ocassionally it's the same, it still has different calling
  convention; LLVM can replace illegal calls (with incorrect CC)
  with an illegal instruction.
*/

#define abs            _cl_abs
#define abs_diff       _cl_abs_diff
#define acos           _cl_acos
#define acosh          _cl_acosh
#define acospi         _cl_acospi
#define add_sat        _cl_add_sat
#define all            _cl_all
#define any            _cl_any
#define asin           _cl_asin
#define asinh          _cl_asinh
#define asinpi         _cl_asinpi
#define async_work_group_strided_copy   _cl_async_work_group_strided_copy
#define async_work_group_copy   _cl_async_work_group_copy
#define atan           _cl_atan
#define atan2          _cl_atan2
#define atan2pi        _cl_atan2pi
#define atanh          _cl_atanh
#define atanpi         _cl_atanpi
#define bitselect      _cl_bitselect
#define cbrt           _cl_cbrt
#define ceil           _cl_ceil
#define clamp          _cl_clamp
#define clz            _cl_clz
#define copysign       _cl_copysign
#define cos            _cl_cos
#define cosh           _cl_cosh
#define cospi          _cl_cospi
#define cross          _cl_cross
#define ctz            _cl_ctz
#define degrees        _cl_degrees
#define distance       _cl_distance
#define dot            _cl_dot
#define erf            _cl_erf
#define erfc           _cl_erfc
#define exp            _cl_exp
#define exp10          _cl_exp10
#define exp2           _cl_exp2
#define expm1          _cl_expm1
#define fabs           _cl_fabs
#define fast_distance  _cl_fast_distance
#define fast_length    _cl_fast_length
#define fast_normalize _cl_fast_normalize
#define fdim           _cl_fdim
#define floor          _cl_floor
#define fma            _cl_fma
#define fmax           _cl_fmax
#define fmin           _cl_fmin
#define fmod           _cl_fmod
#define fract          _cl_fract
#define frexp          _cl_frexp
#define hadd           _cl_hadd
#define half_cos       _cl_half_cos
#define half_divide    _cl_half_divide
#define half_exp       _cl_half_exp
#define half_exp10     _cl_half_exp10
#define half_exp2      _cl_half_exp2
#define half_log       _cl_half_log
#define half_log10     _cl_half_log10
#define half_log2      _cl_half_log2
#define half_powr      _cl_half_powr
#define half_recip     _cl_half_recip
#define half_rsqrt     _cl_half_rsqrt
#define half_sin       _cl_half_sin
#define half_sqrt      _cl_half_sqrt
#define half_tan       _cl_half_tan
#define hypot          _cl_hypot
#define ilogb          _cl_ilogb
#define isequal        _cl_isequal
#define isfinite       _cl_isfinite
#define isgreater      _cl_isgreater
#define isgreaterequal _cl_isgreaterequal
#define isinf          _cl_isinf
#define isless         _cl_isless
#define islessequal    _cl_islessequal
#define islessgreater  _cl_islessgreater
#define isnan          _cl_isnan
#define isnormal       _cl_isnormal
#define isnotequal     _cl_isnotequal
#define isordered      _cl_isordered
#define isunordered    _cl_isunordered
#define ldexp          _cl_ldexp
#define length         _cl_length
#define lgamma         _cl_lgamma
#define lgamma_r       _cl_lgamma_r
#define log            _cl_log
#define log10          _cl_log10
#define log1p          _cl_log1p
#define log2           _cl_log2
#define logb           _cl_logb
#define mad            _cl_mad
#define mad24          _cl_mad24
#define mad_hi         _cl_mad_hi
#define mad_sat        _cl_mad_sat
#define max            _cl_max
#define maxmag         _cl_maxmag
#define min            _cl_min
#define minmag         _cl_minmag
#define mix            _cl_mix
#define modf           _cl_modf
#define mul24          _cl_mul24
#define mul_hi         _cl_mul_hi
#define nan            _cl_nan
#define native_cos     _cl_native_cos
#define native_divide  _cl_native_divide
#define native_exp     _cl_native_exp
#define native_exp10   _cl_native_exp10
#define native_exp2    _cl_native_exp2
#define native_log     _cl_native_log
#define native_log10   _cl_native_log10
#define native_log2    _cl_native_log2
#define native_powr    _cl_native_powr
#define native_recip   _cl_native_recip
#define native_rsqrt   _cl_native_rsqrt
#define native_sin     _cl_native_sin
#define native_sqrt    _cl_native_sqrt
#define native_tan     _cl_native_tan
#define nextafter      _cl_nextafter
#define normalize      _cl_normalize
#define popcount       _cl_popcount
#define pow            _cl_pow
#define pown           _cl_pown
#define powr           _cl_powr
#define prefetch       _cl_prefetch
#define radians        _cl_radians
#define remainder      _cl_remainder
#define remquo         _cl_remquo
#define rhadd          _cl_rhadd
#define rint           _cl_rint
#define rootn          _cl_rootn
#define rotate         _cl_rotate
#define round          _cl_round
#define rsqrt          _cl_rsqrt
#define select         _cl_select
#define shuffle        _cl_shuffle
#define shuffle2        _cl_shuffle2
#define sign           _cl_sign
#define signbit        _cl_signbit
#define sin            _cl_sin
#define sincos         _cl_sincos
#define sinh           _cl_sinh
#define sinpi          _cl_sinpi
#define smoothstep     _cl_smoothstep
#define sqrt           _cl_sqrt
#define step           _cl_step
#define sub_sat        _cl_sub_sat
#define tan            _cl_tan
#define tanh           _cl_tanh
#define tanpi          _cl_tanpi
#define tgamma         _cl_tgamma
#define trunc          _cl_trunc
#define upsample       _cl_upsample

#define  vload   _cl_vload
#define  vstore  _cl_vstore
#define  vload_half   _cl_vload_half
#define  vstore_half  _cl_vstore_half
#define  vloada_half   _cl_vloada_half
#define  vstorea_half  _cl_vstorea_half
#define  vload_half_rte   _cl_vload_half_rte
#define  vstore_half_rte  _cl_vstore_half_rte
#define  vloada_half_rte   _cl_vloada_half_rte
#define  vstorea_half_rte  _cl_vstorea_half_rte
#define  vload_half_rtz   _cl_vload_half_rtz
#define  vstore_half_rtz  _cl_vstore_half_rtz
#define  vloada_half_rtz   _cl_vloada_half_rtz
#define  vstorea_half_rtz  _cl_vstorea_half_rtz
#define  vload_half_rtp   _cl_vload_half_rtp
#define  vstore_half_rtp  _cl_vstore_half_rtp
#define  vloada_half_rtp   _cl_vloada_half_rtp
#define  vstorea_half_rtp  _cl_vstorea_half_rtp
#define  vload_half_rtn   _cl_vload_half_rtn
#define  vstore_half_rtn  _cl_vstore_half_rtn
#define  vloada_half_rtn   _cl_vloada_half_rtn
#define  vstorea_half_rtn  _cl_vstorea_half_rtn
#define convert_char    _cl_convert_char
#define convert_uchar    _cl_convert_uchar
#define convert_short    _cl_convert_short
#define convert_ushort    _cl_convert_ushort
#define convert_int    _cl_convert_int
#define convert_uint    _cl_convert_uint
#define convert_long    _cl_convert_long
#define convert_ulong    _cl_convert_ulong
#define convert_float    _cl_convert_float
#define convert_double    _cl_convert_double
#define convert_char_rte    _cl_convert_char_rte
#define convert_uchar_rte    _cl_convert_uchar_rte
#define convert_short_rte    _cl_convert_short_rte
#define convert_ushort_rte    _cl_convert_ushort_rte
#define convert_int_rte    _cl_convert_int_rte
#define convert_uint_rte    _cl_convert_uint_rte
#define convert_long_rte    _cl_convert_long_rte
#define convert_ulong_rte    _cl_convert_ulong_rte
#define convert_float_rte    _cl_convert_float_rte
#define convert_double_rte    _cl_convert_double_rte
#define convert_char_rtz    _cl_convert_char_rtz
#define convert_uchar_rtz    _cl_convert_uchar_rtz
#define convert_short_rtz    _cl_convert_short_rtz
#define convert_ushort_rtz    _cl_convert_ushort_rtz
#define convert_int_rtz    _cl_convert_int_rtz
#define convert_uint_rtz    _cl_convert_uint_rtz
#define convert_long_rtz    _cl_convert_long_rtz
#define convert_ulong_rtz    _cl_convert_ulong_rtz
#define convert_float_rtz    _cl_convert_float_rtz
#define convert_double_rtz    _cl_convert_double_rtz
#define convert_char_rtp    _cl_convert_char_rtp
#define convert_uchar_rtp    _cl_convert_uchar_rtp
#define convert_short_rtp    _cl_convert_short_rtp
#define convert_ushort_rtp    _cl_convert_ushort_rtp
#define convert_int_rtp    _cl_convert_int_rtp
#define convert_uint_rtp    _cl_convert_uint_rtp
#define convert_long_rtp    _cl_convert_long_rtp
#define convert_ulong_rtp    _cl_convert_ulong_rtp
#define convert_float_rtp    _cl_convert_float_rtp
#define convert_double_rtp    _cl_convert_double_rtp
#define convert_char_rtn    _cl_convert_char_rtn
#define convert_uchar_rtn    _cl_convert_uchar_rtn
#define convert_short_rtn    _cl_convert_short_rtn
#define convert_ushort_rtn    _cl_convert_ushort_rtn
#define convert_int_rtn    _cl_convert_int_rtn
#define convert_uint_rtn    _cl_convert_uint_rtn
#define convert_long_rtn    _cl_convert_long_rtn
#define convert_ulong_rtn    _cl_convert_ulong_rtn
#define convert_float_rtn    _cl_convert_float_rtn
#define convert_double_rtn    _cl_convert_double_rtn
#define convert_char_sat    _cl_convert_char_sat
#define convert_uchar_sat    _cl_convert_uchar_sat
#define convert_short_sat    _cl_convert_short_sat
#define convert_ushort_sat    _cl_convert_ushort_sat
#define convert_int_sat    _cl_convert_int_sat
#define convert_uint_sat    _cl_convert_uint_sat
#define convert_long_sat    _cl_convert_long_sat
#define convert_ulong_sat    _cl_convert_ulong_sat
#define convert_float_sat    _cl_convert_float_sat
#define convert_double_sat    _cl_convert_double_sat
#define convert_char_sat_rte    _cl_convert_char_sat_rte
#define convert_uchar_sat_rte    _cl_convert_uchar_sat_rte
#define convert_short_sat_rte    _cl_convert_short_sat_rte
#define convert_ushort_sat_rte    _cl_convert_ushort_sat_rte
#define convert_int_sat_rte    _cl_convert_int_sat_rte
#define convert_uint_sat_rte    _cl_convert_uint_sat_rte
#define convert_long_sat_rte    _cl_convert_long_sat_rte
#define convert_ulong_sat_rte    _cl_convert_ulong_sat_rte
#define convert_float_sat_rte    _cl_convert_float_sat_rte
#define convert_double_sat_rte    _cl_convert_double_sat_rte
#define convert_char_sat_rtz    _cl_convert_char_sat_rtz
#define convert_uchar_sat_rtz    _cl_convert_uchar_sat_rtz
#define convert_short_sat_rtz    _cl_convert_short_sat_rtz
#define convert_ushort_sat_rtz    _cl_convert_ushort_sat_rtz
#define convert_int_sat_rtz    _cl_convert_int_sat_rtz
#define convert_uint_sat_rtz    _cl_convert_uint_sat_rtz
#define convert_long_sat_rtz    _cl_convert_long_sat_rtz
#define convert_ulong_sat_rtz    _cl_convert_ulong_sat_rtz
#define convert_float_sat_rtz    _cl_convert_float_sat_rtz
#define convert_double_sat_rtz    _cl_convert_double_sat_rtz
#define convert_char_sat_rtp    _cl_convert_char_sat_rtp
#define convert_uchar_sat_rtp    _cl_convert_uchar_sat_rtp
#define convert_short_sat_rtp    _cl_convert_short_sat_rtp
#define convert_ushort_sat_rtp    _cl_convert_ushort_sat_rtp
#define convert_int_sat_rtp    _cl_convert_int_sat_rtp
#define convert_uint_sat_rtp    _cl_convert_uint_sat_rtp
#define convert_long_sat_rtp    _cl_convert_long_sat_rtp
#define convert_ulong_sat_rtp    _cl_convert_ulong_sat_rtp
#define convert_float_sat_rtp    _cl_convert_float_sat_rtp
#define convert_double_sat_rtp    _cl_convert_double_sat_rtp
#define convert_char_sat_rtn    _cl_convert_char_sat_rtn
#define convert_uchar_sat_rtn    _cl_convert_uchar_sat_rtn
#define convert_short_sat_rtn    _cl_convert_short_sat_rtn
#define convert_ushort_sat_rtn    _cl_convert_ushort_sat_rtn
#define convert_int_sat_rtn    _cl_convert_int_sat_rtn
#define convert_uint_sat_rtn    _cl_convert_uint_sat_rtn
#define convert_long_sat_rtn    _cl_convert_long_sat_rtn
#define convert_ulong_sat_rtn    _cl_convert_ulong_sat_rtn
#define convert_float_sat_rtn    _cl_convert_float_sat_rtn
#define convert_double_sat_rtn    _cl_convert_double_sat_rtn

#define  vload2   _cl_vload2
#define  vstore2  _cl_vstore2
#define  vload_half2   _cl_vload_half2
#define  vstore_half2  _cl_vstore_half2
#define  vloada_half2   _cl_vloada_half2
#define  vstorea_half2  _cl_vstorea_half2
#define  vload_half2_rte   _cl_vload_half2_rte
#define  vstore_half2_rte  _cl_vstore_half2_rte
#define  vloada_half2_rte   _cl_vloada_half2_rte
#define  vstorea_half2_rte  _cl_vstorea_half2_rte
#define  vload_half2_rtz   _cl_vload_half2_rtz
#define  vstore_half2_rtz  _cl_vstore_half2_rtz
#define  vloada_half2_rtz   _cl_vloada_half2_rtz
#define  vstorea_half2_rtz  _cl_vstorea_half2_rtz
#define  vload_half2_rtp   _cl_vload_half2_rtp
#define  vstore_half2_rtp  _cl_vstore_half2_rtp
#define  vloada_half2_rtp   _cl_vloada_half2_rtp
#define  vstorea_half2_rtp  _cl_vstorea_half2_rtp
#define  vload_half2_rtn   _cl_vload_half2_rtn
#define  vstore_half2_rtn  _cl_vstore_half2_rtn
#define  vloada_half2_rtn   _cl_vloada_half2_rtn
#define  vstorea_half2_rtn  _cl_vstorea_half2_rtn
#define convert_char2    _cl_convert_char2
#define convert_uchar2    _cl_convert_uchar2
#define convert_short2    _cl_convert_short2
#define convert_ushort2    _cl_convert_ushort2
#define convert_int2    _cl_convert_int2
#define convert_uint2    _cl_convert_uint2
#define convert_long2    _cl_convert_long2
#define convert_ulong2    _cl_convert_ulong2
#define convert_float2    _cl_convert_float2
#define convert_double2    _cl_convert_double2
#define convert_char2_rte    _cl_convert_char2_rte
#define convert_uchar2_rte    _cl_convert_uchar2_rte
#define convert_short2_rte    _cl_convert_short2_rte
#define convert_ushort2_rte    _cl_convert_ushort2_rte
#define convert_int2_rte    _cl_convert_int2_rte
#define convert_uint2_rte    _cl_convert_uint2_rte
#define convert_long2_rte    _cl_convert_long2_rte
#define convert_ulong2_rte    _cl_convert_ulong2_rte
#define convert_float2_rte    _cl_convert_float2_rte
#define convert_double2_rte    _cl_convert_double2_rte
#define convert_char2_rtz    _cl_convert_char2_rtz
#define convert_uchar2_rtz    _cl_convert_uchar2_rtz
#define convert_short2_rtz    _cl_convert_short2_rtz
#define convert_ushort2_rtz    _cl_convert_ushort2_rtz
#define convert_int2_rtz    _cl_convert_int2_rtz
#define convert_uint2_rtz    _cl_convert_uint2_rtz
#define convert_long2_rtz    _cl_convert_long2_rtz
#define convert_ulong2_rtz    _cl_convert_ulong2_rtz
#define convert_float2_rtz    _cl_convert_float2_rtz
#define convert_double2_rtz    _cl_convert_double2_rtz
#define convert_char2_rtp    _cl_convert_char2_rtp
#define convert_uchar2_rtp    _cl_convert_uchar2_rtp
#define convert_short2_rtp    _cl_convert_short2_rtp
#define convert_ushort2_rtp    _cl_convert_ushort2_rtp
#define convert_int2_rtp    _cl_convert_int2_rtp
#define convert_uint2_rtp    _cl_convert_uint2_rtp
#define convert_long2_rtp    _cl_convert_long2_rtp
#define convert_ulong2_rtp    _cl_convert_ulong2_rtp
#define convert_float2_rtp    _cl_convert_float2_rtp
#define convert_double2_rtp    _cl_convert_double2_rtp
#define convert_char2_rtn    _cl_convert_char2_rtn
#define convert_uchar2_rtn    _cl_convert_uchar2_rtn
#define convert_short2_rtn    _cl_convert_short2_rtn
#define convert_ushort2_rtn    _cl_convert_ushort2_rtn
#define convert_int2_rtn    _cl_convert_int2_rtn
#define convert_uint2_rtn    _cl_convert_uint2_rtn
#define convert_long2_rtn    _cl_convert_long2_rtn
#define convert_ulong2_rtn    _cl_convert_ulong2_rtn
#define convert_float2_rtn    _cl_convert_float2_rtn
#define convert_double2_rtn    _cl_convert_double2_rtn
#define convert_char2_sat    _cl_convert_char2_sat
#define convert_uchar2_sat    _cl_convert_uchar2_sat
#define convert_short2_sat    _cl_convert_short2_sat
#define convert_ushort2_sat    _cl_convert_ushort2_sat
#define convert_int2_sat    _cl_convert_int2_sat
#define convert_uint2_sat    _cl_convert_uint2_sat
#define convert_long2_sat    _cl_convert_long2_sat
#define convert_ulong2_sat    _cl_convert_ulong2_sat
#define convert_float2_sat    _cl_convert_float2_sat
#define convert_double2_sat    _cl_convert_double2_sat
#define convert_char2_sat_rte    _cl_convert_char2_sat_rte
#define convert_uchar2_sat_rte    _cl_convert_uchar2_sat_rte
#define convert_short2_sat_rte    _cl_convert_short2_sat_rte
#define convert_ushort2_sat_rte    _cl_convert_ushort2_sat_rte
#define convert_int2_sat_rte    _cl_convert_int2_sat_rte
#define convert_uint2_sat_rte    _cl_convert_uint2_sat_rte
#define convert_long2_sat_rte    _cl_convert_long2_sat_rte
#define convert_ulong2_sat_rte    _cl_convert_ulong2_sat_rte
#define convert_float2_sat_rte    _cl_convert_float2_sat_rte
#define convert_double2_sat_rte    _cl_convert_double2_sat_rte
#define convert_char2_sat_rtz    _cl_convert_char2_sat_rtz
#define convert_uchar2_sat_rtz    _cl_convert_uchar2_sat_rtz
#define convert_short2_sat_rtz    _cl_convert_short2_sat_rtz
#define convert_ushort2_sat_rtz    _cl_convert_ushort2_sat_rtz
#define convert_int2_sat_rtz    _cl_convert_int2_sat_rtz
#define convert_uint2_sat_rtz    _cl_convert_uint2_sat_rtz
#define convert_long2_sat_rtz    _cl_convert_long2_sat_rtz
#define convert_ulong2_sat_rtz    _cl_convert_ulong2_sat_rtz
#define convert_float2_sat_rtz    _cl_convert_float2_sat_rtz
#define convert_double2_sat_rtz    _cl_convert_double2_sat_rtz
#define convert_char2_sat_rtp    _cl_convert_char2_sat_rtp
#define convert_uchar2_sat_rtp    _cl_convert_uchar2_sat_rtp
#define convert_short2_sat_rtp    _cl_convert_short2_sat_rtp
#define convert_ushort2_sat_rtp    _cl_convert_ushort2_sat_rtp
#define convert_int2_sat_rtp    _cl_convert_int2_sat_rtp
#define convert_uint2_sat_rtp    _cl_convert_uint2_sat_rtp
#define convert_long2_sat_rtp    _cl_convert_long2_sat_rtp
#define convert_ulong2_sat_rtp    _cl_convert_ulong2_sat_rtp
#define convert_float2_sat_rtp    _cl_convert_float2_sat_rtp
#define convert_double2_sat_rtp    _cl_convert_double2_sat_rtp
#define convert_char2_sat_rtn    _cl_convert_char2_sat_rtn
#define convert_uchar2_sat_rtn    _cl_convert_uchar2_sat_rtn
#define convert_short2_sat_rtn    _cl_convert_short2_sat_rtn
#define convert_ushort2_sat_rtn    _cl_convert_ushort2_sat_rtn
#define convert_int2_sat_rtn    _cl_convert_int2_sat_rtn
#define convert_uint2_sat_rtn    _cl_convert_uint2_sat_rtn
#define convert_long2_sat_rtn    _cl_convert_long2_sat_rtn
#define convert_ulong2_sat_rtn    _cl_convert_ulong2_sat_rtn
#define convert_float2_sat_rtn    _cl_convert_float2_sat_rtn
#define convert_double2_sat_rtn    _cl_convert_double2_sat_rtn

#define  vload3   _cl_vload3
#define  vstore3  _cl_vstore3
#define  vload_half3   _cl_vload_half3
#define  vstore_half3  _cl_vstore_half3
#define  vloada_half3   _cl_vloada_half3
#define  vstorea_half3  _cl_vstorea_half3
#define  vload_half3_rte   _cl_vload_half3_rte
#define  vstore_half3_rte  _cl_vstore_half3_rte
#define  vloada_half3_rte   _cl_vloada_half3_rte
#define  vstorea_half3_rte  _cl_vstorea_half3_rte
#define  vload_half3_rtz   _cl_vload_half3_rtz
#define  vstore_half3_rtz  _cl_vstore_half3_rtz
#define  vloada_half3_rtz   _cl_vloada_half3_rtz
#define  vstorea_half3_rtz  _cl_vstorea_half3_rtz
#define  vload_half3_rtp   _cl_vload_half3_rtp
#define  vstore_half3_rtp  _cl_vstore_half3_rtp
#define  vloada_half3_rtp   _cl_vloada_half3_rtp
#define  vstorea_half3_rtp  _cl_vstorea_half3_rtp
#define  vload_half3_rtn   _cl_vload_half3_rtn
#define  vstore_half3_rtn  _cl_vstore_half3_rtn
#define  vloada_half3_rtn   _cl_vloada_half3_rtn
#define  vstorea_half3_rtn  _cl_vstorea_half3_rtn
#define convert_char3    _cl_convert_char3
#define convert_uchar3    _cl_convert_uchar3
#define convert_short3    _cl_convert_short3
#define convert_ushort3    _cl_convert_ushort3
#define convert_int3    _cl_convert_int3
#define convert_uint3    _cl_convert_uint3
#define convert_long3    _cl_convert_long3
#define convert_ulong3    _cl_convert_ulong3
#define convert_float3    _cl_convert_float3
#define convert_double3    _cl_convert_double3
#define convert_char3_rte    _cl_convert_char3_rte
#define convert_uchar3_rte    _cl_convert_uchar3_rte
#define convert_short3_rte    _cl_convert_short3_rte
#define convert_ushort3_rte    _cl_convert_ushort3_rte
#define convert_int3_rte    _cl_convert_int3_rte
#define convert_uint3_rte    _cl_convert_uint3_rte
#define convert_long3_rte    _cl_convert_long3_rte
#define convert_ulong3_rte    _cl_convert_ulong3_rte
#define convert_float3_rte    _cl_convert_float3_rte
#define convert_double3_rte    _cl_convert_double3_rte
#define convert_char3_rtz    _cl_convert_char3_rtz
#define convert_uchar3_rtz    _cl_convert_uchar3_rtz
#define convert_short3_rtz    _cl_convert_short3_rtz
#define convert_ushort3_rtz    _cl_convert_ushort3_rtz
#define convert_int3_rtz    _cl_convert_int3_rtz
#define convert_uint3_rtz    _cl_convert_uint3_rtz
#define convert_long3_rtz    _cl_convert_long3_rtz
#define convert_ulong3_rtz    _cl_convert_ulong3_rtz
#define convert_float3_rtz    _cl_convert_float3_rtz
#define convert_double3_rtz    _cl_convert_double3_rtz
#define convert_char3_rtp    _cl_convert_char3_rtp
#define convert_uchar3_rtp    _cl_convert_uchar3_rtp
#define convert_short3_rtp    _cl_convert_short3_rtp
#define convert_ushort3_rtp    _cl_convert_ushort3_rtp
#define convert_int3_rtp    _cl_convert_int3_rtp
#define convert_uint3_rtp    _cl_convert_uint3_rtp
#define convert_long3_rtp    _cl_convert_long3_rtp
#define convert_ulong3_rtp    _cl_convert_ulong3_rtp
#define convert_float3_rtp    _cl_convert_float3_rtp
#define convert_double3_rtp    _cl_convert_double3_rtp
#define convert_char3_rtn    _cl_convert_char3_rtn
#define convert_uchar3_rtn    _cl_convert_uchar3_rtn
#define convert_short3_rtn    _cl_convert_short3_rtn
#define convert_ushort3_rtn    _cl_convert_ushort3_rtn
#define convert_int3_rtn    _cl_convert_int3_rtn
#define convert_uint3_rtn    _cl_convert_uint3_rtn
#define convert_long3_rtn    _cl_convert_long3_rtn
#define convert_ulong3_rtn    _cl_convert_ulong3_rtn
#define convert_float3_rtn    _cl_convert_float3_rtn
#define convert_double3_rtn    _cl_convert_double3_rtn
#define convert_char3_sat    _cl_convert_char3_sat
#define convert_uchar3_sat    _cl_convert_uchar3_sat
#define convert_short3_sat    _cl_convert_short3_sat
#define convert_ushort3_sat    _cl_convert_ushort3_sat
#define convert_int3_sat    _cl_convert_int3_sat
#define convert_uint3_sat    _cl_convert_uint3_sat
#define convert_long3_sat    _cl_convert_long3_sat
#define convert_ulong3_sat    _cl_convert_ulong3_sat
#define convert_float3_sat    _cl_convert_float3_sat
#define convert_double3_sat    _cl_convert_double3_sat
#define convert_char3_sat_rte    _cl_convert_char3_sat_rte
#define convert_uchar3_sat_rte    _cl_convert_uchar3_sat_rte
#define convert_short3_sat_rte    _cl_convert_short3_sat_rte
#define convert_ushort3_sat_rte    _cl_convert_ushort3_sat_rte
#define convert_int3_sat_rte    _cl_convert_int3_sat_rte
#define convert_uint3_sat_rte    _cl_convert_uint3_sat_rte
#define convert_long3_sat_rte    _cl_convert_long3_sat_rte
#define convert_ulong3_sat_rte    _cl_convert_ulong3_sat_rte
#define convert_float3_sat_rte    _cl_convert_float3_sat_rte
#define convert_double3_sat_rte    _cl_convert_double3_sat_rte
#define convert_char3_sat_rtz    _cl_convert_char3_sat_rtz
#define convert_uchar3_sat_rtz    _cl_convert_uchar3_sat_rtz
#define convert_short3_sat_rtz    _cl_convert_short3_sat_rtz
#define convert_ushort3_sat_rtz    _cl_convert_ushort3_sat_rtz
#define convert_int3_sat_rtz    _cl_convert_int3_sat_rtz
#define convert_uint3_sat_rtz    _cl_convert_uint3_sat_rtz
#define convert_long3_sat_rtz    _cl_convert_long3_sat_rtz
#define convert_ulong3_sat_rtz    _cl_convert_ulong3_sat_rtz
#define convert_float3_sat_rtz    _cl_convert_float3_sat_rtz
#define convert_double3_sat_rtz    _cl_convert_double3_sat_rtz
#define convert_char3_sat_rtp    _cl_convert_char3_sat_rtp
#define convert_uchar3_sat_rtp    _cl_convert_uchar3_sat_rtp
#define convert_short3_sat_rtp    _cl_convert_short3_sat_rtp
#define convert_ushort3_sat_rtp    _cl_convert_ushort3_sat_rtp
#define convert_int3_sat_rtp    _cl_convert_int3_sat_rtp
#define convert_uint3_sat_rtp    _cl_convert_uint3_sat_rtp
#define convert_long3_sat_rtp    _cl_convert_long3_sat_rtp
#define convert_ulong3_sat_rtp    _cl_convert_ulong3_sat_rtp
#define convert_float3_sat_rtp    _cl_convert_float3_sat_rtp
#define convert_double3_sat_rtp    _cl_convert_double3_sat_rtp
#define convert_char3_sat_rtn    _cl_convert_char3_sat_rtn
#define convert_uchar3_sat_rtn    _cl_convert_uchar3_sat_rtn
#define convert_short3_sat_rtn    _cl_convert_short3_sat_rtn
#define convert_ushort3_sat_rtn    _cl_convert_ushort3_sat_rtn
#define convert_int3_sat_rtn    _cl_convert_int3_sat_rtn
#define convert_uint3_sat_rtn    _cl_convert_uint3_sat_rtn
#define convert_long3_sat_rtn    _cl_convert_long3_sat_rtn
#define convert_ulong3_sat_rtn    _cl_convert_ulong3_sat_rtn
#define convert_float3_sat_rtn    _cl_convert_float3_sat_rtn
#define convert_double3_sat_rtn    _cl_convert_double3_sat_rtn

#define  vload4   _cl_vload4
#define  vstore4  _cl_vstore4
#define  vload_half4   _cl_vload_half4
#define  vstore_half4  _cl_vstore_half4
#define  vloada_half4   _cl_vloada_half4
#define  vstorea_half4  _cl_vstorea_half4
#define  vload_half4_rte   _cl_vload_half4_rte
#define  vstore_half4_rte  _cl_vstore_half4_rte
#define  vloada_half4_rte   _cl_vloada_half4_rte
#define  vstorea_half4_rte  _cl_vstorea_half4_rte
#define  vload_half4_rtz   _cl_vload_half4_rtz
#define  vstore_half4_rtz  _cl_vstore_half4_rtz
#define  vloada_half4_rtz   _cl_vloada_half4_rtz
#define  vstorea_half4_rtz  _cl_vstorea_half4_rtz
#define  vload_half4_rtp   _cl_vload_half4_rtp
#define  vstore_half4_rtp  _cl_vstore_half4_rtp
#define  vloada_half4_rtp   _cl_vloada_half4_rtp
#define  vstorea_half4_rtp  _cl_vstorea_half4_rtp
#define  vload_half4_rtn   _cl_vload_half4_rtn
#define  vstore_half4_rtn  _cl_vstore_half4_rtn
#define  vloada_half4_rtn   _cl_vloada_half4_rtn
#define  vstorea_half4_rtn  _cl_vstorea_half4_rtn
#define convert_char4    _cl_convert_char4
#define convert_uchar4    _cl_convert_uchar4
#define convert_short4    _cl_convert_short4
#define convert_ushort4    _cl_convert_ushort4
#define convert_int4    _cl_convert_int4
#define convert_uint4    _cl_convert_uint4
#define convert_long4    _cl_convert_long4
#define convert_ulong4    _cl_convert_ulong4
#define convert_float4    _cl_convert_float4
#define convert_double4    _cl_convert_double4
#define convert_char4_rte    _cl_convert_char4_rte
#define convert_uchar4_rte    _cl_convert_uchar4_rte
#define convert_short4_rte    _cl_convert_short4_rte
#define convert_ushort4_rte    _cl_convert_ushort4_rte
#define convert_int4_rte    _cl_convert_int4_rte
#define convert_uint4_rte    _cl_convert_uint4_rte
#define convert_long4_rte    _cl_convert_long4_rte
#define convert_ulong4_rte    _cl_convert_ulong4_rte
#define convert_float4_rte    _cl_convert_float4_rte
#define convert_double4_rte    _cl_convert_double4_rte
#define convert_char4_rtz    _cl_convert_char4_rtz
#define convert_uchar4_rtz    _cl_convert_uchar4_rtz
#define convert_short4_rtz    _cl_convert_short4_rtz
#define convert_ushort4_rtz    _cl_convert_ushort4_rtz
#define convert_int4_rtz    _cl_convert_int4_rtz
#define convert_uint4_rtz    _cl_convert_uint4_rtz
#define convert_long4_rtz    _cl_convert_long4_rtz
#define convert_ulong4_rtz    _cl_convert_ulong4_rtz
#define convert_float4_rtz    _cl_convert_float4_rtz
#define convert_double4_rtz    _cl_convert_double4_rtz
#define convert_char4_rtp    _cl_convert_char4_rtp
#define convert_uchar4_rtp    _cl_convert_uchar4_rtp
#define convert_short4_rtp    _cl_convert_short4_rtp
#define convert_ushort4_rtp    _cl_convert_ushort4_rtp
#define convert_int4_rtp    _cl_convert_int4_rtp
#define convert_uint4_rtp    _cl_convert_uint4_rtp
#define convert_long4_rtp    _cl_convert_long4_rtp
#define convert_ulong4_rtp    _cl_convert_ulong4_rtp
#define convert_float4_rtp    _cl_convert_float4_rtp
#define convert_double4_rtp    _cl_convert_double4_rtp
#define convert_char4_rtn    _cl_convert_char4_rtn
#define convert_uchar4_rtn    _cl_convert_uchar4_rtn
#define convert_short4_rtn    _cl_convert_short4_rtn
#define convert_ushort4_rtn    _cl_convert_ushort4_rtn
#define convert_int4_rtn    _cl_convert_int4_rtn
#define convert_uint4_rtn    _cl_convert_uint4_rtn
#define convert_long4_rtn    _cl_convert_long4_rtn
#define convert_ulong4_rtn    _cl_convert_ulong4_rtn
#define convert_float4_rtn    _cl_convert_float4_rtn
#define convert_double4_rtn    _cl_convert_double4_rtn
#define convert_char4_sat    _cl_convert_char4_sat
#define convert_uchar4_sat    _cl_convert_uchar4_sat
#define convert_short4_sat    _cl_convert_short4_sat
#define convert_ushort4_sat    _cl_convert_ushort4_sat
#define convert_int4_sat    _cl_convert_int4_sat
#define convert_uint4_sat    _cl_convert_uint4_sat
#define convert_long4_sat    _cl_convert_long4_sat
#define convert_ulong4_sat    _cl_convert_ulong4_sat
#define convert_float4_sat    _cl_convert_float4_sat
#define convert_double4_sat    _cl_convert_double4_sat
#define convert_char4_sat_rte    _cl_convert_char4_sat_rte
#define convert_uchar4_sat_rte    _cl_convert_uchar4_sat_rte
#define convert_short4_sat_rte    _cl_convert_short4_sat_rte
#define convert_ushort4_sat_rte    _cl_convert_ushort4_sat_rte
#define convert_int4_sat_rte    _cl_convert_int4_sat_rte
#define convert_uint4_sat_rte    _cl_convert_uint4_sat_rte
#define convert_long4_sat_rte    _cl_convert_long4_sat_rte
#define convert_ulong4_sat_rte    _cl_convert_ulong4_sat_rte
#define convert_float4_sat_rte    _cl_convert_float4_sat_rte
#define convert_double4_sat_rte    _cl_convert_double4_sat_rte
#define convert_char4_sat_rtz    _cl_convert_char4_sat_rtz
#define convert_uchar4_sat_rtz    _cl_convert_uchar4_sat_rtz
#define convert_short4_sat_rtz    _cl_convert_short4_sat_rtz
#define convert_ushort4_sat_rtz    _cl_convert_ushort4_sat_rtz
#define convert_int4_sat_rtz    _cl_convert_int4_sat_rtz
#define convert_uint4_sat_rtz    _cl_convert_uint4_sat_rtz
#define convert_long4_sat_rtz    _cl_convert_long4_sat_rtz
#define convert_ulong4_sat_rtz    _cl_convert_ulong4_sat_rtz
#define convert_float4_sat_rtz    _cl_convert_float4_sat_rtz
#define convert_double4_sat_rtz    _cl_convert_double4_sat_rtz
#define convert_char4_sat_rtp    _cl_convert_char4_sat_rtp
#define convert_uchar4_sat_rtp    _cl_convert_uchar4_sat_rtp
#define convert_short4_sat_rtp    _cl_convert_short4_sat_rtp
#define convert_ushort4_sat_rtp    _cl_convert_ushort4_sat_rtp
#define convert_int4_sat_rtp    _cl_convert_int4_sat_rtp
#define convert_uint4_sat_rtp    _cl_convert_uint4_sat_rtp
#define convert_long4_sat_rtp    _cl_convert_long4_sat_rtp
#define convert_ulong4_sat_rtp    _cl_convert_ulong4_sat_rtp
#define convert_float4_sat_rtp    _cl_convert_float4_sat_rtp
#define convert_double4_sat_rtp    _cl_convert_double4_sat_rtp
#define convert_char4_sat_rtn    _cl_convert_char4_sat_rtn
#define convert_uchar4_sat_rtn    _cl_convert_uchar4_sat_rtn
#define convert_short4_sat_rtn    _cl_convert_short4_sat_rtn
#define convert_ushort4_sat_rtn    _cl_convert_ushort4_sat_rtn
#define convert_int4_sat_rtn    _cl_convert_int4_sat_rtn
#define convert_uint4_sat_rtn    _cl_convert_uint4_sat_rtn
#define convert_long4_sat_rtn    _cl_convert_long4_sat_rtn
#define convert_ulong4_sat_rtn    _cl_convert_ulong4_sat_rtn
#define convert_float4_sat_rtn    _cl_convert_float4_sat_rtn
#define convert_double4_sat_rtn    _cl_convert_double4_sat_rtn

#define  vload8   _cl_vload8
#define  vstore8  _cl_vstore8
#define  vload_half8   _cl_vload_half8
#define  vstore_half8  _cl_vstore_half8
#define  vloada_half8   _cl_vloada_half8
#define  vstorea_half8  _cl_vstorea_half8
#define  vload_half8_rte   _cl_vload_half8_rte
#define  vstore_half8_rte  _cl_vstore_half8_rte
#define  vloada_half8_rte   _cl_vloada_half8_rte
#define  vstorea_half8_rte  _cl_vstorea_half8_rte
#define  vload_half8_rtz   _cl_vload_half8_rtz
#define  vstore_half8_rtz  _cl_vstore_half8_rtz
#define  vloada_half8_rtz   _cl_vloada_half8_rtz
#define  vstorea_half8_rtz  _cl_vstorea_half8_rtz
#define  vload_half8_rtp   _cl_vload_half8_rtp
#define  vstore_half8_rtp  _cl_vstore_half8_rtp
#define  vloada_half8_rtp   _cl_vloada_half8_rtp
#define  vstorea_half8_rtp  _cl_vstorea_half8_rtp
#define  vload_half8_rtn   _cl_vload_half8_rtn
#define  vstore_half8_rtn  _cl_vstore_half8_rtn
#define  vloada_half8_rtn   _cl_vloada_half8_rtn
#define  vstorea_half8_rtn  _cl_vstorea_half8_rtn
#define convert_char8    _cl_convert_char8
#define convert_uchar8    _cl_convert_uchar8
#define convert_short8    _cl_convert_short8
#define convert_ushort8    _cl_convert_ushort8
#define convert_int8    _cl_convert_int8
#define convert_uint8    _cl_convert_uint8
#define convert_long8    _cl_convert_long8
#define convert_ulong8    _cl_convert_ulong8
#define convert_float8    _cl_convert_float8
#define convert_double8    _cl_convert_double8
#define convert_char8_rte    _cl_convert_char8_rte
#define convert_uchar8_rte    _cl_convert_uchar8_rte
#define convert_short8_rte    _cl_convert_short8_rte
#define convert_ushort8_rte    _cl_convert_ushort8_rte
#define convert_int8_rte    _cl_convert_int8_rte
#define convert_uint8_rte    _cl_convert_uint8_rte
#define convert_long8_rte    _cl_convert_long8_rte
#define convert_ulong8_rte    _cl_convert_ulong8_rte
#define convert_float8_rte    _cl_convert_float8_rte
#define convert_double8_rte    _cl_convert_double8_rte
#define convert_char8_rtz    _cl_convert_char8_rtz
#define convert_uchar8_rtz    _cl_convert_uchar8_rtz
#define convert_short8_rtz    _cl_convert_short8_rtz
#define convert_ushort8_rtz    _cl_convert_ushort8_rtz
#define convert_int8_rtz    _cl_convert_int8_rtz
#define convert_uint8_rtz    _cl_convert_uint8_rtz
#define convert_long8_rtz    _cl_convert_long8_rtz
#define convert_ulong8_rtz    _cl_convert_ulong8_rtz
#define convert_float8_rtz    _cl_convert_float8_rtz
#define convert_double8_rtz    _cl_convert_double8_rtz
#define convert_char8_rtp    _cl_convert_char8_rtp
#define convert_uchar8_rtp    _cl_convert_uchar8_rtp
#define convert_short8_rtp    _cl_convert_short8_rtp
#define convert_ushort8_rtp    _cl_convert_ushort8_rtp
#define convert_int8_rtp    _cl_convert_int8_rtp
#define convert_uint8_rtp    _cl_convert_uint8_rtp
#define convert_long8_rtp    _cl_convert_long8_rtp
#define convert_ulong8_rtp    _cl_convert_ulong8_rtp
#define convert_float8_rtp    _cl_convert_float8_rtp
#define convert_double8_rtp    _cl_convert_double8_rtp
#define convert_char8_rtn    _cl_convert_char8_rtn
#define convert_uchar8_rtn    _cl_convert_uchar8_rtn
#define convert_short8_rtn    _cl_convert_short8_rtn
#define convert_ushort8_rtn    _cl_convert_ushort8_rtn
#define convert_int8_rtn    _cl_convert_int8_rtn
#define convert_uint8_rtn    _cl_convert_uint8_rtn
#define convert_long8_rtn    _cl_convert_long8_rtn
#define convert_ulong8_rtn    _cl_convert_ulong8_rtn
#define convert_float8_rtn    _cl_convert_float8_rtn
#define convert_double8_rtn    _cl_convert_double8_rtn
#define convert_char8_sat    _cl_convert_char8_sat
#define convert_uchar8_sat    _cl_convert_uchar8_sat
#define convert_short8_sat    _cl_convert_short8_sat
#define convert_ushort8_sat    _cl_convert_ushort8_sat
#define convert_int8_sat    _cl_convert_int8_sat
#define convert_uint8_sat    _cl_convert_uint8_sat
#define convert_long8_sat    _cl_convert_long8_sat
#define convert_ulong8_sat    _cl_convert_ulong8_sat
#define convert_float8_sat    _cl_convert_float8_sat
#define convert_double8_sat    _cl_convert_double8_sat
#define convert_char8_sat_rte    _cl_convert_char8_sat_rte
#define convert_uchar8_sat_rte    _cl_convert_uchar8_sat_rte
#define convert_short8_sat_rte    _cl_convert_short8_sat_rte
#define convert_ushort8_sat_rte    _cl_convert_ushort8_sat_rte
#define convert_int8_sat_rte    _cl_convert_int8_sat_rte
#define convert_uint8_sat_rte    _cl_convert_uint8_sat_rte
#define convert_long8_sat_rte    _cl_convert_long8_sat_rte
#define convert_ulong8_sat_rte    _cl_convert_ulong8_sat_rte
#define convert_float8_sat_rte    _cl_convert_float8_sat_rte
#define convert_double8_sat_rte    _cl_convert_double8_sat_rte
#define convert_char8_sat_rtz    _cl_convert_char8_sat_rtz
#define convert_uchar8_sat_rtz    _cl_convert_uchar8_sat_rtz
#define convert_short8_sat_rtz    _cl_convert_short8_sat_rtz
#define convert_ushort8_sat_rtz    _cl_convert_ushort8_sat_rtz
#define convert_int8_sat_rtz    _cl_convert_int8_sat_rtz
#define convert_uint8_sat_rtz    _cl_convert_uint8_sat_rtz
#define convert_long8_sat_rtz    _cl_convert_long8_sat_rtz
#define convert_ulong8_sat_rtz    _cl_convert_ulong8_sat_rtz
#define convert_float8_sat_rtz    _cl_convert_float8_sat_rtz
#define convert_double8_sat_rtz    _cl_convert_double8_sat_rtz
#define convert_char8_sat_rtp    _cl_convert_char8_sat_rtp
#define convert_uchar8_sat_rtp    _cl_convert_uchar8_sat_rtp
#define convert_short8_sat_rtp    _cl_convert_short8_sat_rtp
#define convert_ushort8_sat_rtp    _cl_convert_ushort8_sat_rtp
#define convert_int8_sat_rtp    _cl_convert_int8_sat_rtp
#define convert_uint8_sat_rtp    _cl_convert_uint8_sat_rtp
#define convert_long8_sat_rtp    _cl_convert_long8_sat_rtp
#define convert_ulong8_sat_rtp    _cl_convert_ulong8_sat_rtp
#define convert_float8_sat_rtp    _cl_convert_float8_sat_rtp
#define convert_double8_sat_rtp    _cl_convert_double8_sat_rtp
#define convert_char8_sat_rtn    _cl_convert_char8_sat_rtn
#define convert_uchar8_sat_rtn    _cl_convert_uchar8_sat_rtn
#define convert_short8_sat_rtn    _cl_convert_short8_sat_rtn
#define convert_ushort8_sat_rtn    _cl_convert_ushort8_sat_rtn
#define convert_int8_sat_rtn    _cl_convert_int8_sat_rtn
#define convert_uint8_sat_rtn    _cl_convert_uint8_sat_rtn
#define convert_long8_sat_rtn    _cl_convert_long8_sat_rtn
#define convert_ulong8_sat_rtn    _cl_convert_ulong8_sat_rtn
#define convert_float8_sat_rtn    _cl_convert_float8_sat_rtn
#define convert_double8_sat_rtn    _cl_convert_double8_sat_rtn

#define  vload16   _cl_vload16
#define  vstore16  _cl_vstore16
#define  vload_half16   _cl_vload_half16
#define  vstore_half16  _cl_vstore_half16
#define  vloada_half16   _cl_vloada_half16
#define  vstorea_half16  _cl_vstorea_half16
#define  vload_half16_rte   _cl_vload_half16_rte
#define  vstore_half16_rte  _cl_vstore_half16_rte
#define  vloada_half16_rte   _cl_vloada_half16_rte
#define  vstorea_half16_rte  _cl_vstorea_half16_rte
#define  vload_half16_rtz   _cl_vload_half16_rtz
#define  vstore_half16_rtz  _cl_vstore_half16_rtz
#define  vloada_half16_rtz   _cl_vloada_half16_rtz
#define  vstorea_half16_rtz  _cl_vstorea_half16_rtz
#define  vload_half16_rtp   _cl_vload_half16_rtp
#define  vstore_half16_rtp  _cl_vstore_half16_rtp
#define  vloada_half16_rtp   _cl_vloada_half16_rtp
#define  vstorea_half16_rtp  _cl_vstorea_half16_rtp
#define  vload_half16_rtn   _cl_vload_half16_rtn
#define  vstore_half16_rtn  _cl_vstore_half16_rtn
#define  vloada_half16_rtn   _cl_vloada_half16_rtn
#define  vstorea_half16_rtn  _cl_vstorea_half16_rtn
#define convert_char16    _cl_convert_char16
#define convert_uchar16    _cl_convert_uchar16
#define convert_short16    _cl_convert_short16
#define convert_ushort16    _cl_convert_ushort16
#define convert_int16    _cl_convert_int16
#define convert_uint16    _cl_convert_uint16
#define convert_long16    _cl_convert_long16
#define convert_ulong16    _cl_convert_ulong16
#define convert_float16    _cl_convert_float16
#define convert_double16    _cl_convert_double16
#define convert_char16_rte    _cl_convert_char16_rte
#define convert_uchar16_rte    _cl_convert_uchar16_rte
#define convert_short16_rte    _cl_convert_short16_rte
#define convert_ushort16_rte    _cl_convert_ushort16_rte
#define convert_int16_rte    _cl_convert_int16_rte
#define convert_uint16_rte    _cl_convert_uint16_rte
#define convert_long16_rte    _cl_convert_long16_rte
#define convert_ulong16_rte    _cl_convert_ulong16_rte
#define convert_float16_rte    _cl_convert_float16_rte
#define convert_double16_rte    _cl_convert_double16_rte
#define convert_char16_rtz    _cl_convert_char16_rtz
#define convert_uchar16_rtz    _cl_convert_uchar16_rtz
#define convert_short16_rtz    _cl_convert_short16_rtz
#define convert_ushort16_rtz    _cl_convert_ushort16_rtz
#define convert_int16_rtz    _cl_convert_int16_rtz
#define convert_uint16_rtz    _cl_convert_uint16_rtz
#define convert_long16_rtz    _cl_convert_long16_rtz
#define convert_ulong16_rtz    _cl_convert_ulong16_rtz
#define convert_float16_rtz    _cl_convert_float16_rtz
#define convert_double16_rtz    _cl_convert_double16_rtz
#define convert_char16_rtp    _cl_convert_char16_rtp
#define convert_uchar16_rtp    _cl_convert_uchar16_rtp
#define convert_short16_rtp    _cl_convert_short16_rtp
#define convert_ushort16_rtp    _cl_convert_ushort16_rtp
#define convert_int16_rtp    _cl_convert_int16_rtp
#define convert_uint16_rtp    _cl_convert_uint16_rtp
#define convert_long16_rtp    _cl_convert_long16_rtp
#define convert_ulong16_rtp    _cl_convert_ulong16_rtp
#define convert_float16_rtp    _cl_convert_float16_rtp
#define convert_double16_rtp    _cl_convert_double16_rtp
#define convert_char16_rtn    _cl_convert_char16_rtn
#define convert_uchar16_rtn    _cl_convert_uchar16_rtn
#define convert_short16_rtn    _cl_convert_short16_rtn
#define convert_ushort16_rtn    _cl_convert_ushort16_rtn
#define convert_int16_rtn    _cl_convert_int16_rtn
#define convert_uint16_rtn    _cl_convert_uint16_rtn
#define convert_long16_rtn    _cl_convert_long16_rtn
#define convert_ulong16_rtn    _cl_convert_ulong16_rtn
#define convert_float16_rtn    _cl_convert_float16_rtn
#define convert_double16_rtn    _cl_convert_double16_rtn
#define convert_char16_sat    _cl_convert_char16_sat
#define convert_uchar16_sat    _cl_convert_uchar16_sat
#define convert_short16_sat    _cl_convert_short16_sat
#define convert_ushort16_sat    _cl_convert_ushort16_sat
#define convert_int16_sat    _cl_convert_int16_sat
#define convert_uint16_sat    _cl_convert_uint16_sat
#define convert_long16_sat    _cl_convert_long16_sat
#define convert_ulong16_sat    _cl_convert_ulong16_sat
#define convert_float16_sat    _cl_convert_float16_sat
#define convert_double16_sat    _cl_convert_double16_sat
#define convert_char16_sat_rte    _cl_convert_char16_sat_rte
#define convert_uchar16_sat_rte    _cl_convert_uchar16_sat_rte
#define convert_short16_sat_rte    _cl_convert_short16_sat_rte
#define convert_ushort16_sat_rte    _cl_convert_ushort16_sat_rte
#define convert_int16_sat_rte    _cl_convert_int16_sat_rte
#define convert_uint16_sat_rte    _cl_convert_uint16_sat_rte
#define convert_long16_sat_rte    _cl_convert_long16_sat_rte
#define convert_ulong16_sat_rte    _cl_convert_ulong16_sat_rte
#define convert_float16_sat_rte    _cl_convert_float16_sat_rte
#define convert_double16_sat_rte    _cl_convert_double16_sat_rte
#define convert_char16_sat_rtz    _cl_convert_char16_sat_rtz
#define convert_uchar16_sat_rtz    _cl_convert_uchar16_sat_rtz
#define convert_short16_sat_rtz    _cl_convert_short16_sat_rtz
#define convert_ushort16_sat_rtz    _cl_convert_ushort16_sat_rtz
#define convert_int16_sat_rtz    _cl_convert_int16_sat_rtz
#define convert_uint16_sat_rtz    _cl_convert_uint16_sat_rtz
#define convert_long16_sat_rtz    _cl_convert_long16_sat_rtz
#define convert_ulong16_sat_rtz    _cl_convert_ulong16_sat_rtz
#define convert_float16_sat_rtz    _cl_convert_float16_sat_rtz
#define convert_double16_sat_rtz    _cl_convert_double16_sat_rtz
#define convert_char16_sat_rtp    _cl_convert_char16_sat_rtp
#define convert_uchar16_sat_rtp    _cl_convert_uchar16_sat_rtp
#define convert_short16_sat_rtp    _cl_convert_short16_sat_rtp
#define convert_ushort16_sat_rtp    _cl_convert_ushort16_sat_rtp
#define convert_int16_sat_rtp    _cl_convert_int16_sat_rtp
#define convert_uint16_sat_rtp    _cl_convert_uint16_sat_rtp
#define convert_long16_sat_rtp    _cl_convert_long16_sat_rtp
#define convert_ulong16_sat_rtp    _cl_convert_ulong16_sat_rtp
#define convert_float16_sat_rtp    _cl_convert_float16_sat_rtp
#define convert_double16_sat_rtp    _cl_convert_double16_sat_rtp
#define convert_char16_sat_rtn    _cl_convert_char16_sat_rtn
#define convert_uchar16_sat_rtn    _cl_convert_uchar16_sat_rtn
#define convert_short16_sat_rtn    _cl_convert_short16_sat_rtn
#define convert_ushort16_sat_rtn    _cl_convert_ushort16_sat_rtn
#define convert_int16_sat_rtn    _cl_convert_int16_sat_rtn
#define convert_uint16_sat_rtn    _cl_convert_uint16_sat_rtn
#define convert_long16_sat_rtn    _cl_convert_long16_sat_rtn
#define convert_ulong16_sat_rtn    _cl_convert_ulong16_sat_rtn
#define convert_float16_sat_rtn    _cl_convert_float16_sat_rtn
#define convert_double16_sat_rtn    _cl_convert_double16_sat_rtn


#define atomic_add     _cl_atomic_add
#define atomic_sub     _cl_atomic_sub
#define atomic_xchg    _cl_atomic_xchg
#define atomic_inc     _cl_atomic_inc
#define atomic_dec     _cl_atomic_dec
#define atomic_cmpxchg _cl_atomic_cmpxchg
#define atomic_min     _cl_atomic_min
#define atomic_max     _cl_atomic_max
#define atomic_and     _cl_atomic_and
#define atomic_or      _cl_atomic_or
#define atomic_xor     _cl_atomic_xor

#define atom_add     _cl_atom_add
#define atom_sub     _cl_atom_sub
#define atom_xchg    _cl_atom_xchg
#define atom_inc     _cl_atom_inc
#define atom_dec     _cl_atom_dec
#define atom_cmpxchg _cl_atom_cmpxchg
#define atom_min     _cl_atom_min
#define atom_max     _cl_atom_max
#define atom_and     _cl_atom_and
#define atom_or      _cl_atom_or
#define atom_xor     _cl_atom_xor

#define  atomic_init    _cl_atomic_init
#define  atomic_flag_test_and_set_explicit    _cl_atomic_flag_test_and_set_explicit
#define  atomic_flag_test_and_set    _cl_atomic_flag_test_and_set
#define  atomic_flag_clear_explicit    _cl_atomic_flag_clear_explicit
#define  atomic_flag_clear    _cl_atomic_flag_clear
#define  atomic_store_explicit    _cl_atomic_store_explicit
#define  atomic_store    _cl_atomic_store
#define  atomic_load_explicit    _cl_atomic_load_explicit
#define  atomic_load    _cl_atomic_load
#define  atomic_exchange_explicit    _cl_atomic_exchange_explicit
#define  atomic_exchange    _cl_atomic_exchange
#define  atomic_compare_exchange_strong_explicit    _cl_atomic_compare_exchange_strong_explicit
#define  atomic_compare_exchange_strong    _cl_atomic_compare_exchange_strong
#define  atomic_compare_exchange_weak_explicit    _cl_atomic_compare_exchange_weak_explicit
#define  atomic_compare_exchange_weak    _cl_atomic_compare_exchange_weak
#define  atomic_fetch_add_explicit    _cl_atomic_fetch_add_explicit
#define  atomic_fetch_add    _cl_atomic_fetch_add
#define  atomic_fetch_sub_explicit    _cl_atomic_fetch_sub_explicit
#define  atomic_fetch_sub    _cl_atomic_fetch_sub
#define  atomic_fetch_or_explicit    _cl_atomic_fetch_or_explicit
#define  atomic_fetch_or    _cl_atomic_fetch_or
#define  atomic_fetch_xor_explicit    _cl_atomic_fetch_xor_explicit
#define  atomic_fetch_xor    _cl_atomic_fetch_xor
#define  atomic_fetch_and_explicit    _cl_atomic_fetch_and_explicit
#define  atomic_fetch_and    _cl_atomic_fetch_and
#define  atomic_fetch_min_explicit    _cl_atomic_fetch_min_explicit
#define  atomic_fetch_min    _cl_atomic_fetch_min
#define  atomic_fetch_max_explicit    _cl_atomic_fetch_max_explicit
#define  atomic_fetch_max    _cl_atomic_fetch_max

#define read_mem_fence     _cl_read_mem_fence
#define write_mem_fence    _cl_write_mem_fence
#define mem_fence          _cl_mem_fence
#define work_group_barrier _cl_work_group_barrier
#define atomic_work_item_fence _cl_atomic_work_item_fence
#define wait_group_events  _cl_wait_group_events

#define get_image_array_size _cl_get_image_array_size
#define get_image_channel_data_type _cl_get_image_channel_data_type
#define get_image_channel_order _cl_get_image_channel_order
#define get_image_dim _cl_get_image_dim
#define get_image_depth _cl_get_image_depth
#define get_image_height _cl_get_image_height
#define get_image_width _cl_get_image_width
#define read_imageui _cl_read_imageui
#define read_imagei _cl_read_imagei
#define read_imagef _cl_read_imagef
#define write_imageui _cl_write_imageui
#define write_imagei _cl_write_imagei
#define write_imagef _cl_write_imagef

#endif
