; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  < %s -mtriple=mipsel-elf -mcpu=mips32   -relocation-model=pic | FileCheck %s -check-prefixes=MIPS32-EL
; RUN: llc  < %s -mtriple=mips-elf   -mcpu=mips32   -relocation-model=pic | FileCheck %s -check-prefixes=MIPS32-EB
; RUN: llc  < %s -mtriple=mipsel-elf -mcpu=mips32r2 -relocation-model=pic | FileCheck %s -check-prefixes=MIPS32-EL
; RUN: llc  < %s -mtriple=mips-elf   -mcpu=mips32r2 -relocation-model=pic | FileCheck %s -check-prefixes=MIPS32-EB
; RUN: llc  < %s -mtriple=mipsel-elf -mcpu=mips32r6 -relocation-model=pic | FileCheck %s -check-prefixes=MIPS32R6-EL
; RUN: llc  < %s -mtriple=mips-elf   -mcpu=mips32r6 -relocation-model=pic | FileCheck %s -check-prefixes=MIPS32R6-EB

%struct.S2 = type { %struct.S1, %struct.S1 }
%struct.S1 = type { i8, i8 }
%struct.S4 = type { [7 x i8] }

@s2 = common global %struct.S2 zeroinitializer, align 1
@s4 = common global %struct.S4 zeroinitializer, align 1

define void @bar1() nounwind {
; MIPS32-EL-LABEL: bar1:
; MIPS32-EL:       # %bb.0: # %entry
; MIPS32-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EL-NEXT:    addiu $sp, $sp, -24
; MIPS32-EL-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-EL-NEXT:    addu $gp, $2, $25
; MIPS32-EL-NEXT:    lw $1, %got(s2)($gp)
; MIPS32-EL-NEXT:    lbu $2, 2($1)
; MIPS32-EL-NEXT:    lbu $1, 3($1)
; MIPS32-EL-NEXT:    sll $1, $1, 8
; MIPS32-EL-NEXT:    lw $25, %call16(foo2)($gp)
; MIPS32-EL-NEXT:    .reloc $tmp0, R_MIPS_JALR, foo2
; MIPS32-EL-NEXT:  $tmp0:
; MIPS32-EL-NEXT:    jalr $25
; MIPS32-EL-NEXT:    or $4, $1, $2
; MIPS32-EL-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-EL-NEXT:    jr $ra
; MIPS32-EL-NEXT:    addiu $sp, $sp, 24
;
; MIPS32-EB-LABEL: bar1:
; MIPS32-EB:       # %bb.0: # %entry
; MIPS32-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EB-NEXT:    addiu $sp, $sp, -24
; MIPS32-EB-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-EB-NEXT:    addu $gp, $2, $25
; MIPS32-EB-NEXT:    lw $1, %got(s2)($gp)
; MIPS32-EB-NEXT:    lbu $2, 3($1)
; MIPS32-EB-NEXT:    sll $2, $2, 16
; MIPS32-EB-NEXT:    lbu $1, 2($1)
; MIPS32-EB-NEXT:    sll $1, $1, 24
; MIPS32-EB-NEXT:    lw $25, %call16(foo2)($gp)
; MIPS32-EB-NEXT:    .reloc $tmp0, R_MIPS_JALR, foo2
; MIPS32-EB-NEXT:  $tmp0:
; MIPS32-EB-NEXT:    jalr $25
; MIPS32-EB-NEXT:    or $4, $1, $2
; MIPS32-EB-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-EB-NEXT:    jr $ra
; MIPS32-EB-NEXT:    addiu $sp, $sp, 24
;
; MIPS32R6-EL-LABEL: bar1:
; MIPS32R6-EL:       # %bb.0: # %entry
; MIPS32R6-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-EL-NEXT:    addiu $sp, $sp, -24
; MIPS32R6-EL-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32R6-EL-NEXT:    addu $gp, $2, $25
; MIPS32R6-EL-NEXT:    lw $1, %got(s2)($gp)
; MIPS32R6-EL-NEXT:    lhu $4, 2($1)
; MIPS32R6-EL-NEXT:    lw $25, %call16(foo2)($gp)
; MIPS32R6-EL-NEXT:    .reloc $tmp0, R_MIPS_JALR, foo2
; MIPS32R6-EL-NEXT:  $tmp0:
; MIPS32R6-EL-NEXT:    jalrc $25
; MIPS32R6-EL-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32R6-EL-NEXT:    jr $ra
; MIPS32R6-EL-NEXT:    addiu $sp, $sp, 24
;
; MIPS32R6-EB-LABEL: bar1:
; MIPS32R6-EB:       # %bb.0: # %entry
; MIPS32R6-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-EB-NEXT:    addiu $sp, $sp, -24
; MIPS32R6-EB-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32R6-EB-NEXT:    addu $gp, $2, $25
; MIPS32R6-EB-NEXT:    lw $1, %got(s2)($gp)
; MIPS32R6-EB-NEXT:    lhu $1, 2($1)
; MIPS32R6-EB-NEXT:    lw $25, %call16(foo2)($gp)
; MIPS32R6-EB-NEXT:    .reloc $tmp0, R_MIPS_JALR, foo2
; MIPS32R6-EB-NEXT:  $tmp0:
; MIPS32R6-EB-NEXT:    jalr $25
; MIPS32R6-EB-NEXT:    sll $4, $1, 16
; MIPS32R6-EB-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32R6-EB-NEXT:    jr $ra
; MIPS32R6-EB-NEXT:    addiu $sp, $sp, 24
entry:
  tail call void @foo2(ptr byval(%struct.S1) getelementptr inbounds (%struct.S2, ptr @s2, i32 0, i32 1)) nounwind
  ret void
}

; FIXME: We should be able to do better than this using lhu
define void @bar2() nounwind {
; MIPS32-EL-LABEL: bar2:
; MIPS32-EL:       # %bb.0: # %entry
; MIPS32-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EL-NEXT:    addiu $sp, $sp, -24
; MIPS32-EL-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-EL-NEXT:    addu $gp, $2, $25
; MIPS32-EL-NEXT:    lw $1, %got(s4)($gp)
; MIPS32-EL-NEXT:    lwl $4, 3($1)
; MIPS32-EL-NEXT:    lwr $4, 0($1)
; MIPS32-EL-NEXT:    lbu $2, 4($1)
; MIPS32-EL-NEXT:    lbu $3, 5($1)
; MIPS32-EL-NEXT:    sll $3, $3, 8
; MIPS32-EL-NEXT:    or $2, $3, $2
; MIPS32-EL-NEXT:    lbu $1, 6($1)
; MIPS32-EL-NEXT:    sll $1, $1, 16
; MIPS32-EL-NEXT:    lw $25, %call16(foo4)($gp)
; MIPS32-EL-NEXT:    .reloc $tmp1, R_MIPS_JALR, foo4
; MIPS32-EL-NEXT:  $tmp1:
; MIPS32-EL-NEXT:    jalr $25
; MIPS32-EL-NEXT:    or $5, $2, $1
; MIPS32-EL-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-EL-NEXT:    jr $ra
; MIPS32-EL-NEXT:    addiu $sp, $sp, 24
;
; MIPS32-EB-LABEL: bar2:
; MIPS32-EB:       # %bb.0: # %entry
; MIPS32-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32-EB-NEXT:    addiu $sp, $sp, -24
; MIPS32-EB-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32-EB-NEXT:    addu $gp, $2, $25
; MIPS32-EB-NEXT:    lw $1, %got(s4)($gp)
; MIPS32-EB-NEXT:    lwl $4, 0($1)
; MIPS32-EB-NEXT:    lbu $2, 5($1)
; MIPS32-EB-NEXT:    lwr $4, 3($1)
; MIPS32-EB-NEXT:    sll $2, $2, 16
; MIPS32-EB-NEXT:    lbu $3, 4($1)
; MIPS32-EB-NEXT:    sll $3, $3, 24
; MIPS32-EB-NEXT:    or $2, $3, $2
; MIPS32-EB-NEXT:    lbu $1, 6($1)
; MIPS32-EB-NEXT:    sll $1, $1, 8
; MIPS32-EB-NEXT:    lw $25, %call16(foo4)($gp)
; MIPS32-EB-NEXT:    .reloc $tmp1, R_MIPS_JALR, foo4
; MIPS32-EB-NEXT:  $tmp1:
; MIPS32-EB-NEXT:    jalr $25
; MIPS32-EB-NEXT:    or $5, $2, $1
; MIPS32-EB-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32-EB-NEXT:    jr $ra
; MIPS32-EB-NEXT:    addiu $sp, $sp, 24
;
; MIPS32R6-EL-LABEL: bar2:
; MIPS32R6-EL:       # %bb.0: # %entry
; MIPS32R6-EL-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-EL-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-EL-NEXT:    addiu $sp, $sp, -24
; MIPS32R6-EL-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32R6-EL-NEXT:    addu $gp, $2, $25
; MIPS32R6-EL-NEXT:    lw $1, %got(s4)($gp)
; MIPS32R6-EL-NEXT:    lhu $2, 4($1)
; MIPS32R6-EL-NEXT:    lbu $3, 6($1)
; MIPS32R6-EL-NEXT:    sll $3, $3, 16
; MIPS32R6-EL-NEXT:    lw $4, 0($1)
; MIPS32R6-EL-NEXT:    lw $25, %call16(foo4)($gp)
; MIPS32R6-EL-NEXT:    .reloc $tmp1, R_MIPS_JALR, foo4
; MIPS32R6-EL-NEXT:  $tmp1:
; MIPS32R6-EL-NEXT:    jalr $25
; MIPS32R6-EL-NEXT:    or $5, $2, $3
; MIPS32R6-EL-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32R6-EL-NEXT:    jr $ra
; MIPS32R6-EL-NEXT:    addiu $sp, $sp, 24
;
; MIPS32R6-EB-LABEL: bar2:
; MIPS32R6-EB:       # %bb.0: # %entry
; MIPS32R6-EB-NEXT:    lui $2, %hi(_gp_disp)
; MIPS32R6-EB-NEXT:    addiu $2, $2, %lo(_gp_disp)
; MIPS32R6-EB-NEXT:    addiu $sp, $sp, -24
; MIPS32R6-EB-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; MIPS32R6-EB-NEXT:    addu $gp, $2, $25
; MIPS32R6-EB-NEXT:    lw $1, %got(s4)($gp)
; MIPS32R6-EB-NEXT:    lbu $2, 6($1)
; MIPS32R6-EB-NEXT:    sll $2, $2, 8
; MIPS32R6-EB-NEXT:    lhu $3, 4($1)
; MIPS32R6-EB-NEXT:    sll $3, $3, 16
; MIPS32R6-EB-NEXT:    lw $4, 0($1)
; MIPS32R6-EB-NEXT:    lw $25, %call16(foo4)($gp)
; MIPS32R6-EB-NEXT:    .reloc $tmp1, R_MIPS_JALR, foo4
; MIPS32R6-EB-NEXT:  $tmp1:
; MIPS32R6-EB-NEXT:    jalr $25
; MIPS32R6-EB-NEXT:    or $5, $3, $2
; MIPS32R6-EB-NEXT:    lw $ra, 20($sp) # 4-byte Folded Reload
; MIPS32R6-EB-NEXT:    jr $ra
; MIPS32R6-EB-NEXT:    addiu $sp, $sp, 24
entry:
  tail call void @foo4(ptr byval(%struct.S4) @s4) nounwind
  ret void
}

declare void @foo2(ptr byval(%struct.S1))
declare void @foo4(ptr byval(%struct.S4))
