"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OtGeometryUtil = void 0;
const count_point_1 = require("./count-point");
const flattener_1 = require("./flattener");
const get_bound_1 = require("./get-bound");
const point_lister_1 = require("./point-lister");
const shared_1 = require("./shared");
var OtGeometryUtil;
(function (OtGeometryUtil) {
    OtGeometryUtil.Flattener = flattener_1.OtGhFlattener;
    OtGeometryUtil.ListPoint = point_lister_1.OtGhPointLister;
    OtGeometryUtil.GetBound = get_bound_1.OtGhGetBound;
    OtGeometryUtil.CountPoint = count_point_1.OtGhCountPoint;
    function apply(cls, ...gs) {
        const sink = new cls();
        const traverse = new shared_1.OtGeometryTraverse(sink);
        for (const geom of gs)
            if (geom)
                traverse.process(geom);
        return sink.getResult();
    }
    OtGeometryUtil.apply = apply;
})(OtGeometryUtil = exports.OtGeometryUtil || (exports.OtGeometryUtil = {}));
//# sourceMappingURL=index.js.map