# Building Iosevka from Source
### Cloning
Note that this repo has a 30+ GB commit history. If you only want the current files and future changes, you can avoid downloading so much by cloning the repo with a [`--depth`](https://git-scm.com/docs/git-clone#Documentation/git-clone.txt---depthltdepthgt) limit. Example:
```
git clone --depth 1 https://github.com/be5invis/Iosevka.git 
```

### Building
To build Iosevka you should:

1. Ensure that [`nodejs`](http://nodejs.org) (≥ 14.0.0) and [`ttfautohint`](http://www.freetype.org/ttfautohint/) are present, and accessible from `PATH`.
2. Run `npm install`. This command will install **all** the NPM dependencies, and will also validate whether external dependencies are present.
3. `npm run build -- contents::iosevka`.

You will find TTFs, as well as WOFF(2) web fonts and one Webfont CSS in the `dist/` directory.

### Using a Docker container

A Docker container handling the build environment for you can be found [here](https://github.com/avivace/fonts-iosevka).

To pull it from Docker Hub and start a standard build of the latest released version, run

```
docker run -it -v $(pwd):/build avivace/iosevka-build
```

If you are using Powershell, run

```
docker run -it -v ${pwd}:/build avivace/iosevka-build
```

Fonts files will be placed in the `dist` folder.

You can provide `private-build.plans.toml` for a customized build and/or specify the desired release appending `-e FONT_VERSION=X.X.X`. to the Docker command.

## Customized Build

To create a custom build, you need:

1. Create `private-build-plans.toml` file if absent.

2. Add a build plan into `private-build-plans.toml`. The configurable properties are described in the following sections.
   
3. Run `npm run build -- contents::<your plan name>` and the built fonts would be available in `dist/`. Aside from `contents::<plan>`, other options are:

   1. `contents::<plan>` : Everything (TTF + webfont, hinted + unhinted);
   2. `ttf::<plan>` : TTF only;
   3. `ttf-unhinted::<plan>` : Unhinted TTF only;
   4. `webfont::<plan>` : Web fonts only (CSS + WOFF2);
   4. `webfont-unhinted::<plan>` : Unhinted web fonts only (CSS + WOFF2);
   5. `woff2::<plan>` : WOFF2 only.
   5. `woff2-unhinted::<plan>` : Unhinted WOFF2 only.

⚠️ **Important**: By default, the build system will schedule a number of concurrently running jobs equal to the number of threads available on the CPU, which *will* push CPU usage and also likely RAM usage, if you do not have very much to work with, to the ceiling (each job consumes more than 1 GB of RAM at its peak). If this is an issue for you, pass an additional argument `--jCmd=<number of concurrent jobs>`.

### Configuring Custom Build

Configuration of build plans are organized under `[buildPlans.<plan name>]` sections in the `private-build-plans.toml`. You can use [the Customizer](https://be5invis.github.io/Iosevka/customizer) to create the build plan, and/or manually edit them, following the instructions below.

Inside the plan, top-level properties include:

* `family`: String, defines the family name of your custom variant.
* `spacing`: Optional, String, denotes the spacing of the custom variant. Valid values include:
  - `normal`: The normal monospace font.
  - `quasi-proportional`: The font will become quasi-proportional.
  - `quasi-proportional-extension-only`: The font will become quasi-proportional, but will not shrink narrow letters (like `i`). Only wide letters (like `M`) will get expanded.
  - `term`: Make the symbols' width suitable for terminal emulators. Arrows and geometric symbols will become narrower.
  - `fontconfig-mono`: Apply `term` spacing changes and further apply changes to be compatible with FontConfig's Mono spacing, which recognizes a font as monospace if and only if its every non-combining characters having the same width. The changes include:
    - Completely remove wide glyphs. All non-combining glyphs will be exactly the same width.
      - As a consequence, the following characters will be **removed**:
        - `U+27F5` LONG LEFTWARDS ARROW
        - `U+27F6` LONG RIGHTWARDS ARROW
        - `U+27FB` LONG LEFTWARDS ARROW FROM BAR
        - `U+27FC` LONG RIGHTWARDS ARROW FROM BAR
    - Remove `NWID` and `WWID` features typographic features
  - `fixed`: Apply `fontconfig-mono` changes and further remove ligations.
* `serifs`: Optional, String, configures style of serifs.
  - When set to `slab`, the font will be converted into slab-serif.
  - Otherwise the font will be sans-serif.
* `no-cv-ss`: Optional, Boolean, disables `cv##` and `ss##` OpenType features.
* `no-ligation`: Optional, Boolean, disables ligations.
* `export-glyph-names`: Optional, Boolean, whether to export glyph names into the fonts. Setting this to `true` will increase file footprint, however this is necessary for ligature support in [Kitty](https://sw.kovidgoyal.net/kitty/).
* `webfont-formats`: Optional, Array of String. Controls the formats needed to be exported into the webfont CSS. Valid options are `'ttf'` and `'woff2'`, or including both.

Build plan could have 5 optional subsections: `ligations`, `variants`, `weights`, `widths` and `slopes`.

#### Configuring Ligations

Subsection `ligations` is used to customize the ligation set assigned to `calt` OpenType feature. Properties include:

<!-- BEGIN Section-Predefined-Ligation-Sets -->
<!-- THIS SECTION IS AUTOMATICALLY GENERATED. DO NOT EDIT. -->

* `inherits`: Optional, String, defines the inherited ligation set. When absent, the ligation set will not inherit any other sets. Valid values are:

  - `--default-center-ops--`: Default ligation set would be assigned to undefined.
  - `--c-center-ops--`: Default ligation set would be assigned to undefined.
  - `--default-equality-inequality--`: Default ligation set would be assigned to undefined.
  - `--c-equality-inequality--`: Default ligation set would be assigned to undefined.
  - `--raku-equality-inequality--`: Default ligation set would be assigned to undefined.
  - `--ml-equality-inequality--`: Default ligation set would be assigned to undefined.
  - `--fstar-equality-inequality--`: Default ligation set would be assigned to undefined.
  - `--haskell-equality-inequality--`: Default ligation set would be assigned to undefined.
  - `--matlab-equality-inequality--`: Default ligation set would be assigned to undefined.
  - `--verilog-equality-inequality--`: Default ligation set would be assigned to undefined.
  - `--wolfram-equality-inequality--`: Default ligation set would be assigned to undefined.
  - `--erlang-equality-inequality--`: Default ligation set would be assigned to undefined.
  - `--default-kern--`: Default ligation set would be assigned to undefined.
  - `default-calt`: Inherit default ligation set.
  - `dlig`: Default ligation set would be assigned to Discretionary ligatures.
  - `clike`: Default ligation set would be assigned to C-Like.
  - `javascript`: Default ligation set would be assigned to JavaScript.
  - `php`: Default ligation set would be assigned to PHP.
  - `julia`: Default ligation set would be assigned to Julia.
  - `raku`: Default ligation set would be assigned to Raku.
  - `ml`: Default ligation set would be assigned to ML.
  - `fsharp`: Default ligation set would be assigned to F#.
  - `fstar`: Default ligation set would be assigned to F*.
  - `haskell`: Default ligation set would be assigned to Haskell.
  - `idris`: Default ligation set would be assigned to Idris.
  - `elm`: Default ligation set would be assigned to Elm.
  - `purescript`: Default ligation set would be assigned to PureScript.
  - `swift`: Default ligation set would be assigned to Swift.
  - `dafny`: Default ligation set would be assigned to Dafny.
  - `coq`: Default ligation set would be assigned to Coq.
  - `matlab`: Default ligation set would be assigned to Matlab.
  - `verilog`: Default ligation set would be assigned to Verilog.
  - `wolfram`: Default ligation set would be assigned to Wolfram Language (Mathematica).
  - `erlang`: Default ligation set would be assigned to Erlang Language.

<!-- END Section-Predefined-Ligation-Sets -->

<!-- BEGIN Section-Cherry-Picking-Ligation-Sets -->
<!-- THIS SECTION IS AUTOMATICALLY GENERATED. DO NOT EDIT. -->

* `disables` and `enables`: Optional, String Array, Cherry-picking ligation groups to be disabled or enabled. Valid values include:

  - `center-ops`: Vertically align some of the operators (like `*`) to the center position it is before or after a "center" operator (like `+`).
  - `center-op-trigger-plus-minus-l`: Plus (`+`) and Minus (`-`) will trigger other operator characters at left to be centered.
  - `center-op-trigger-plus-minus-r`: Plus (`+`) and Minus (`-`) will trigger other operator characters at right to be centered.
  - `center-op-trigger-equal-l`: Equal (`=`) will trigger other operator characters at left to be centered.
  - `center-op-trigger-equal-r`: Equal (`=`) will trigger other operator characters at right to be centered.
  - `center-op-trigger-bar-l`: Bars (`|`) will trigger other operator characters at left to be centered.
  - `center-op-trigger-bar-r`: Bars (`|`) will trigger other operator characters at right to be centered.
  - `center-op-trigger-angle-inside`: Less (`<`) and Greater (`>`) will trigger other operator characters at inside to be centered.
  - `center-op-trigger-angle-outside`: Less (`<`) and Greater (`>`) will trigger other operator characters at outside to be centered.
  - `center-op-influence-dot`: Treat dot (`.`) as operator and perform chained centering.
  - `center-op-influence-colon`: undefined.
  - `arrow-l`: Enable ligation set that forms left-pointing arrows.
  - `arrow-r`: Enable ligation set that forms right-pointing arrows.
  - `counter-arrow-l`: Enable ligation that produces left-pointing counter-arrows.
  - `counter-arrow-r`: Enable ligation that produces right-pointing counter-arrows.
  - `trig`: Enable ligation for `<|`, `|>` , `<||`, and other bar-and-angle-bracket symbols.
  - `eqeqeq`: Enable special ligation for `===` with triple lines.
  - `eqeq`: Enable ligation for `==` and `===`.
  - `lteq`: Enable ligation for `<=` as less-than-or-equal sign.
  - `eqlt`: Enable ligation for `=<` as less-than-or-equal sign.
  - `gteq`: Enable ligation for `>=` as greater-than-or-equal sign.
  - `exeqeqeq`: Enable special ligation for `!===` with triple lines.
  - `exeqeq`: Enable special ligation for `!==` with triple lines.
  - `eqexeq`: Enable special ligation for `=!=` with triple lines.
  - `eqexeq-dl`: Enable special ligation for `=!=` with double lines.
  - `exeq`: Enable ligation for `!=` and `!==`.
  - `tildeeq`: Enable ligation for `~=` as inequality.
  - `eqslasheq`: Enable special triple-line ligation for `=/=` as inequality.
  - `slasheq`: Enable ligation for `/=` and `=/=` as inequality.
  - `ltgt-ne`: Enable ligation for `<>` as inequality.
  - `ltgt-diamond`: Enable ligation for `<>` as diamond.
  - `ltgt-diamond-tag`: Enable ligation for `<>` as diamond-shaped empty HTML/XML tag.
  - `ltgt-slash-tag`: Enable ligation for `</`, `/>` and `</>`.
  - `brst`: Center asterisk in `(*` and `*)`.
  - `slash-asterisk`: Shift asterisk in `/*` and `*/`.
  - `plusplus`: Enable ligation for `++` and further plus-chaining.
  - `kern-dotty`: Move connecting dotty punctuations closer, like for `::`, `:::` and `...`.
  - `kern-bars`: Move consecutive bars closer, like for `||`, `|||` and `//`.
  - `logic`: Enable ligation for `/\` and `\/`.
  - `llgg`: Enable ligation for `<<`, `>>` and other angle-bracket chaining.
  - `llggeq`: Enable ligation for `<<=`, `>>=` as shift operator.
  - `html-comment`: Enable ligation for `<!--` and `<!---`.
  - `colon-greater-as-colon-arrow`: Transform `:>` into `:` and a narrow arrow.
  - `brace-bar`: Enable ligation for `{|` and `|}`.
  - `brack-bar`: Enable ligation for `[|` and `|]`.
  - `connected-underscore`: Make contiguous underscores (like `__`) connected.
  - `connected-number-sign`: Make contiguous number signs (like `##`) connected.
  - `connected-tilde-as-wave`: Make contiguous ASCII tildes (like `~~`) connected as a wave line.
  - `connected-hyphen`: Make contiguous hyphen-minuses (like `--`) connected as a straight solid line.

<!-- END Section-Cherry-Picking-Ligation-Sets -->

#### Configuring Character Variants

Subsection `variants` is used to configure character variants in the font. Properties include:

<!-- BEGIN Section-Stylistic-Sets -->
<!-- THIS SECTION IS AUTOMATICALLY GENERATED. DO NOT EDIT. -->

* `inherits`: Optional, String, defines the inherited stylistic set. Valid options include:

  - `ss01`: Set character variant to “Andale Mono Style”.
  - `ss02`: Set character variant to “Anonymous Pro Style”.
  - `ss03`: Set character variant to “Consolas Style”.
  - `ss04`: Set character variant to “Menlo Style”.
  - `ss05`: Set character variant to “Fira Mono Style”.
  - `ss06`: Set character variant to “Liberation Mono Style”.
  - `ss07`: Set character variant to “Monaco Style”.
  - `ss08`: Set character variant to “Pragmata Pro Style”.
  - `ss09`: Set character variant to “Source Code Pro Style”.
  - `ss10`: Set character variant to “Envy Code R Style”.
  - `ss11`: Set character variant to “X Window Style”.
  - `ss12`: Set character variant to “Ubuntu Mono Style”.
  - `ss13`: Set character variant to “Lucida Style”.
  - `ss14`: Set character variant to “JetBrains Mono Style”.
  - `ss15`: Set character variant to “IBM Plex Mono Style”.
  - `ss16`: Set character variant to “PT Mono Style”.
  - `ss17`: Set character variant to “Recursive Mono Style”.
  - `ss18`: Set character variant to “Input Mono Style”.
  - `ss20`: Set character variant to “Curly Style”.

<!-- END Section-Stylistic-Sets -->

<!-- BEGIN Section-Cherry-Picking-Styles -->
<!-- THIS SECTION IS AUTOMATICALLY GENERATED. DO NOT EDIT. -->

* `design`, `upright`, `italic`, and `oblique`: Optional, Dictionary, defines styles for individual characters. The choices are organized in key-value pairs, assigning a variant to a character group. Alternatively, you could assign numbers to `cv##` tags, like what you did when using OpenType in CSS. Assignments under `design` will be applied to all the slopes, and `upright`, `italic`, and `oblique` will apply to corresponded slopes. 

  In addition, style selector for default digit form also uses these dictionaries.
  
  The valid combinations include:

  - Default digit form:
     <table><tr><td rowspan="2" width="348"><img src="../images/cv-digit-form-lining.light.svg#gh-light-mode-only" width=320/><img src="../images/cv-digit-form-lining.dark.svg#gh-dark-mode-only" width=320/></td><td><code>digit-form = 'lining'</code></td></tr><tr><td>Lining (default)</td></tr><tr><td rowspan="2" width="348"><img src="../images/cv-digit-form-old-style.light.svg#gh-light-mode-only" width=320/><img src="../images/cv-digit-form-old-style.dark.svg#gh-dark-mode-only" width=320/></td><td><code>digit-form = 'old-style'</code></td></tr><tr><td>Old-style</td></tr></table>
  - APL form:
     <table><tr><td rowspan="2" width="252"><img src="../images/cv-apl-form-none.light.svg#gh-light-mode-only" width=224/><img src="../images/cv-apl-form-none.dark.svg#gh-dark-mode-only" width=224/></td><td><code>apl-form = 'none'</code></td></tr><tr><td>Disable APL-specific forms (default)</td></tr><tr><td rowspan="2" width="252"><img src="../images/cv-apl-form-enable.light.svg#gh-light-mode-only" width=224/><img src="../images/cv-apl-form-enable.dark.svg#gh-dark-mode-only" width=224/></td><td><code>apl-form = 'enable'</code></td></tr><tr><td>Enable harmonized alternate forms APL operators</td></tr></table>
  - Styles for `A`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-a-straight-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-a-straight-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-a = 'straight-serifless'</code>, <code>cv01 = 1</code></td></tr><tr><td>Standard, straight <code>A</code>, without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-a-straight-top-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-a-straight-top-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-a = 'straight-top-serifed'</code>, <code>cv01 = 2</code></td></tr><tr><td>Straight <code>A</code> with serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-a-straight-base-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-a-straight-base-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-a = 'straight-base-serifed'</code>, <code>cv01 = 3</code></td></tr><tr><td>Straight <code>A</code> with serif at both top and bottom (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-a-straight-tri-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-a-straight-tri-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-a = 'straight-tri-serifed'</code>, <code>cv01 = 4</code></td></tr><tr><td>Straight <code>A</code> with serif at both top and bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-a-curly-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-a-curly-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-a = 'curly-serifless'</code>, <code>cv01 = 5</code></td></tr><tr><td>Slightly curly <code>A</code>, like Iosevka 2.x, without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-a-curly-top-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-a-curly-top-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-a = 'curly-top-serifed'</code>, <code>cv01 = 6</code></td></tr><tr><td>Slightly curly <code>A</code>, like Iosevka 2.x, with serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-a-curly-base-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-a-curly-base-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-a = 'curly-base-serifed'</code>, <code>cv01 = 7</code></td></tr><tr><td>Slightly curly <code>A</code>, like Iosevka 2.x, with serif at both top and bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-a-curly-tri-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-a-curly-tri-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-a = 'curly-tri-serifed'</code>, <code>cv01 = 8</code></td></tr><tr><td>Slightly curly <code>A</code>, like Iosevka 2.x, with serif at both top and bottom</td></tr></table>
  - Styles for `B`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-b-standard-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-b-standard-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-b = 'standard-serifless'</code>, <code>cv02 = 1</code></td></tr><tr><td><code>B</code> in near-symmetric proportion, without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-b-standard-unilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-b-standard-unilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-b = 'standard-unilateral-serifed'</code>, <code>cv02 = 2</code></td></tr><tr><td><code>B</code> in near-symmetric proportion with motion serifs at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-b-standard-bilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-b-standard-bilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-b = 'standard-bilateral-serifed'</code>, <code>cv02 = 3</code></td></tr><tr><td><code>B</code> in near-symmetric proportion with motion serifs at both top and bottom (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-b-more-asymmetric-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-b-more-asymmetric-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-b = 'more-asymmetric-serifless'</code>, <code>cv02 = 4</code></td></tr><tr><td><code>B</code> in more asymmetric proportion to differentiate with <code>8</code>, without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-b-more-asymmetric-unilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-b-more-asymmetric-unilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-b = 'more-asymmetric-unilateral-serifed'</code>, <code>cv02 = 5</code></td></tr><tr><td><code>B</code> in more asymmetric proportion with motion serifs at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-b-more-asymmetric-bilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-b-more-asymmetric-bilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-b = 'more-asymmetric-bilateral-serifed'</code>, <code>cv02 = 6</code></td></tr><tr><td><code>B</code> in more asymmetric proportion with motion serifs at both top and bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-b-standard-interrupted-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-b-standard-interrupted-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-b = 'standard-interrupted-serifless'</code>, <code>cv02 = 7</code></td></tr><tr><td><code>B</code> in near-symmetric proportion with interrupted middle bar, without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-b-standard-interrupted-unilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-b-standard-interrupted-unilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-b = 'standard-interrupted-unilateral-serifed'</code>, <code>cv02 = 8</code></td></tr><tr><td><code>B</code> in near-symmetric proportion with interrupted middle bar and motion serifs at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-b-standard-interrupted-bilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-b-standard-interrupted-bilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-b = 'standard-interrupted-bilateral-serifed'</code>, <code>cv02 = 9</code></td></tr><tr><td><code>B</code> in near-symmetric proportion with interrupted middle bar and motion serifs at both top and bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-b-more-asymmetric-interrupted-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-b-more-asymmetric-interrupted-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-b = 'more-asymmetric-interrupted-serifless'</code>, <code>cv02 = 10</code></td></tr><tr><td><code>B</code> in more asymmetric proportion to differentiate with <code>8</code>, with interrupted middle bar, without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-b-more-asymmetric-interrupted-unilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-b-more-asymmetric-interrupted-unilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-b = 'more-asymmetric-interrupted-unilateral-serifed'</code>, <code>cv02 = 11</code></td></tr><tr><td><code>B</code> in more asymmetric proportion with interrupted middle bar and <code>8</code> with motion serifs at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-b-more-asymmetric-interrupted-bilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-b-more-asymmetric-interrupted-bilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-b = 'more-asymmetric-interrupted-bilateral-serifed'</code>, <code>cv02 = 12</code></td></tr><tr><td><code>B</code> in more asymmetric proportion with interrupted middle bar and <code>8</code> with motion serifs at both top and bottom</td></tr></table>
  - Styles for `C`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-c-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-c-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-c = 'serifless'</code>, <code>cv03 = 1</code></td></tr><tr><td>Serifless <code>C</code> (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-c-unilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-c-unilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-c = 'unilateral-serifed'</code>, <code>cv03 = 2</code></td></tr><tr><td><code>C</code> with serif at top (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-c-bilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-c-bilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-c = 'bilateral-serifed'</code>, <code>cv03 = 3</code></td></tr><tr><td><code>C</code> with serifs at both top and bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-c-unilateral-inward-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-c-unilateral-inward-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-c = 'unilateral-inward-serifed'</code>, <code>cv03 = 4</code></td></tr><tr><td><code>C</code> with inward serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-c-bilateral-inward-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-c-bilateral-inward-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-c = 'bilateral-inward-serifed'</code>, <code>cv03 = 5</code></td></tr><tr><td><code>C</code> with inward serif at both top and bottom</td></tr></table>
  - Styles for `D`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-d-standard-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-d-standard-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-d = 'standard-serifless'</code>, <code>cv04 = 1</code></td></tr><tr><td>Standard <code>D</code> without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-d-standard-unilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-d-standard-unilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-d = 'standard-unilateral-serifed'</code>, <code>cv04 = 2</code></td></tr><tr><td>Standard <code>D</code> with serifs at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-d-standard-bilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-d-standard-bilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-d = 'standard-bilateral-serifed'</code>, <code>cv04 = 3</code></td></tr><tr><td>Standard <code>D</code> with serifs at both top and bottom (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-d-more-rounded-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-d-more-rounded-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-d = 'more-rounded-serifless'</code>, <code>cv04 = 4</code></td></tr><tr><td>More rounded <code>D</code> to differentiate with <code>O</code>, without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-d-more-rounded-unilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-d-more-rounded-unilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-d = 'more-rounded-unilateral-serifed'</code>, <code>cv04 = 5</code></td></tr><tr><td>More rounded <code>D</code> to differentiate with <code>O</code> with motion serifs at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-d-more-rounded-bilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-d-more-rounded-bilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-d = 'more-rounded-bilateral-serifed'</code>, <code>cv04 = 6</code></td></tr><tr><td>More rounded <code>D</code> to differentiate with <code>O</code> with serifs at both top and bottom</td></tr></table>
  - Styles for `E`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-e-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-e-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-e = 'serifless'</code>, <code>cv05 = 1</code></td></tr><tr><td>E without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-e-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-e-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-e = 'top-left-serifed'</code>, <code>cv05 = 2</code></td></tr><tr><td>E with serif only at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-e-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-e-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-e = 'serifed'</code>, <code>cv05 = 3</code></td></tr><tr><td>E with serifs (default for Slab)</td></tr></table>
  - Styles for `F`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-f-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-f-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-f = 'serifless'</code>, <code>cv06 = 1</code></td></tr><tr><td>F without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-f-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-f-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-f = 'top-left-serifed'</code>, <code>cv06 = 2</code></td></tr><tr><td>F with serif only at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-f-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-f-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-f = 'serifed'</code>, <code>cv06 = 3</code></td></tr><tr><td>F with serifs (default for Slab)</td></tr></table>
  - Styles for `G`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothed-serifless-hookless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothed-serifless-hookless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothed-serifless-hookless'</code>, <code>cv07 = 1</code></td></tr><tr><td>Toothed G</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothed-serifless-hooked.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothed-serifless-hooked.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothed-serifless-hooked'</code>, <code>cv07 = 2</code></td></tr><tr><td>Toothed G with inward hook at terminal (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothed-serifless-capped.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothed-serifless-capped.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothed-serifless-capped'</code>, <code>cv07 = 3</code></td></tr><tr><td>Toothed G with a cap terminal</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothed-serifed-hookless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothed-serifed-hookless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothed-serifed-hookless'</code>, <code>cv07 = 4</code></td></tr><tr><td>Toothed G with top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothed-serifed-hooked.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothed-serifed-hooked.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothed-serifed-hooked'</code>, <code>cv07 = 5</code></td></tr><tr><td>Toothed G with inward hook at terminal and top serif (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothed-serifed-capped.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothed-serifed-capped.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothed-serifed-capped'</code>, <code>cv07 = 6</code></td></tr><tr><td>Toothed G with a cap terminal and top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothed-inward-serifed-hookless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothed-inward-serifed-hookless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothed-inward-serifed-hookless'</code>, <code>cv07 = 7</code></td></tr><tr><td>Toothed G with inward top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothed-inward-serifed-hooked.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothed-inward-serifed-hooked.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothed-inward-serifed-hooked'</code>, <code>cv07 = 8</code></td></tr><tr><td>Toothed G with inward hook at terminal and inward top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothed-inward-serifed-capped.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothed-inward-serifed-capped.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothed-inward-serifed-capped'</code>, <code>cv07 = 9</code></td></tr><tr><td>Toothed G with a cap terminal and inward top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-corner-serifless-hookless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-corner-serifless-hookless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-corner-serifless-hookless'</code>, <code>cv07 = 10</code></td></tr><tr><td>Corner toothless G</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-corner-serifless-hooked.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-corner-serifless-hooked.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-corner-serifless-hooked'</code>, <code>cv07 = 11</code></td></tr><tr><td>Corner toothless G with inward hook at terminal</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-corner-serifless-capped.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-corner-serifless-capped.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-corner-serifless-capped'</code>, <code>cv07 = 12</code></td></tr><tr><td>Corner toothless G with a cap terminal</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-corner-serifed-hookless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-corner-serifed-hookless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-corner-serifed-hookless'</code>, <code>cv07 = 13</code></td></tr><tr><td>Corner toothless G with top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-corner-serifed-hooked.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-corner-serifed-hooked.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-corner-serifed-hooked'</code>, <code>cv07 = 14</code></td></tr><tr><td>Corner toothless G with inward hook at terminal and top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-corner-serifed-capped.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-corner-serifed-capped.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-corner-serifed-capped'</code>, <code>cv07 = 15</code></td></tr><tr><td>Corner toothless G with a cap terminal and top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-corner-inward-serifed-hookless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-corner-inward-serifed-hookless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-corner-inward-serifed-hookless'</code>, <code>cv07 = 16</code></td></tr><tr><td>Corner toothless G with inward top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-corner-inward-serifed-hooked.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-corner-inward-serifed-hooked.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-corner-inward-serifed-hooked'</code>, <code>cv07 = 17</code></td></tr><tr><td>Corner toothless G with inward hook at terminal and inward top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-corner-inward-serifed-capped.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-corner-inward-serifed-capped.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-corner-inward-serifed-capped'</code>, <code>cv07 = 18</code></td></tr><tr><td>Corner toothless G with a cap terminal and inward top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-rounded-serifless-hookless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-rounded-serifless-hookless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-rounded-serifless-hookless'</code>, <code>cv07 = 19</code></td></tr><tr><td>Round toothless G</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-rounded-serifless-hooked.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-rounded-serifless-hooked.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-rounded-serifless-hooked'</code>, <code>cv07 = 20</code></td></tr><tr><td>Round toothless G with inward hook at terminal</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-rounded-serifless-capped.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-rounded-serifless-capped.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-rounded-serifless-capped'</code>, <code>cv07 = 21</code></td></tr><tr><td>Round toothless G with a cap terminal</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-rounded-serifed-hookless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-rounded-serifed-hookless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-rounded-serifed-hookless'</code>, <code>cv07 = 22</code></td></tr><tr><td>Round toothless G with top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-rounded-serifed-hooked.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-rounded-serifed-hooked.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-rounded-serifed-hooked'</code>, <code>cv07 = 23</code></td></tr><tr><td>Round toothless G with inward hook at terminal and top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-rounded-serifed-capped.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-rounded-serifed-capped.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-rounded-serifed-capped'</code>, <code>cv07 = 24</code></td></tr><tr><td>Round toothless G with a cap terminal and top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-rounded-inward-serifed-hookless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-rounded-inward-serifed-hookless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-rounded-inward-serifed-hookless'</code>, <code>cv07 = 25</code></td></tr><tr><td>Round toothless G with inward top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-rounded-inward-serifed-hooked.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-rounded-inward-serifed-hooked.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-rounded-inward-serifed-hooked'</code>, <code>cv07 = 26</code></td></tr><tr><td>Round toothless G with inward hook at terminal and inward top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-g-toothless-rounded-inward-serifed-capped.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-g-toothless-rounded-inward-serifed-capped.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-g = 'toothless-rounded-inward-serifed-capped'</code>, <code>cv07 = 27</code></td></tr><tr><td>Round toothless G with a cap terminal and inward top serif</td></tr></table>
  - Styles for `H`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-h-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-h-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-h = 'serifless'</code>, <code>cv08 = 1</code></td></tr><tr><td>H without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-h-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-h-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-h = 'top-left-serifed'</code>, <code>cv08 = 2</code></td></tr><tr><td>H with serif only at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-h-top-left-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-h-top-left-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-h = 'top-left-bottom-right-serifed'</code>, <code>cv08 = 3</code></td></tr><tr><td>H with serif only at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-h-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-h-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-h = 'serifed'</code>, <code>cv08 = 4</code></td></tr><tr><td>H with serifs (default for Slab)</td></tr></table>
  - Styles for `I`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-i-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-i-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-i = 'serifed'</code>, <code>cv09 = 1</code></td></tr><tr><td>I with standard (long) serifs (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-i-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-i-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-i = 'serifless'</code>, <code>cv09 = 2</code></td></tr><tr><td>I without serifs, like a straight bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-i-short-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-i-short-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-i = 'short-serifed'</code>, <code>cv09 = 3</code></td></tr><tr><td>I with short serifs</td></tr></table>
  - Styles for `J`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'serifless'</code>, <code>cv10 = 1</code></td></tr><tr><td>J without top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'serifed'</code>, <code>cv10 = 2</code></td></tr><tr><td>J with top serif at left side (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-serifed-both-sides.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-serifed-both-sides.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'serifed-both-sides'</code>, <code>cv10 = 3</code></td></tr><tr><td>J with top serif at both sides (asymmetric)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-serifed-symmetric.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-serifed-symmetric.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'serifed-symmetric'</code>, <code>cv10 = 4</code></td></tr><tr><td>J with top serif at both sides (symmetric)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-flat-hook-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-flat-hook-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'flat-hook-serifless'</code>, <code>cv10 = 5</code></td></tr><tr><td>J with flat hook and without top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-flat-hook-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-flat-hook-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'flat-hook-serifed'</code>, <code>cv10 = 6</code></td></tr><tr><td>J with flat hook and top serif at left side</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-flat-hook-serifed-both-sides.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-flat-hook-serifed-both-sides.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'flat-hook-serifed-both-sides'</code>, <code>cv10 = 7</code></td></tr><tr><td>J with flat hook and top serif at both sides (asymmetric)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-flat-hook-serifed-symmetric.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-flat-hook-serifed-symmetric.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'flat-hook-serifed-symmetric'</code>, <code>cv10 = 8</code></td></tr><tr><td>J with flat hook and top serif at both sides (symmetric)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-descending-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-descending-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'descending-serifless'</code>, <code>cv10 = 9</code></td></tr><tr><td>J with hook goes below descender and without serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-descending-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-descending-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'descending-serifed'</code>, <code>cv10 = 10</code></td></tr><tr><td>J with hook goes below descender and top serif at left side</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-descending-serifed-both-sides.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-descending-serifed-both-sides.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'descending-serifed-both-sides'</code>, <code>cv10 = 11</code></td></tr><tr><td>J with hook goes below descender and top serif at both sides (asymmetric)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-descending-serifed-symmetric.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-descending-serifed-symmetric.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'descending-serifed-symmetric'</code>, <code>cv10 = 12</code></td></tr><tr><td>J with hook goes below descender and top serif at both sides (symmetric)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-descending-flat-hook-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-descending-flat-hook-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'descending-flat-hook-serifless'</code>, <code>cv10 = 13</code></td></tr><tr><td>J with flat hook goes below descender and without serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-j-descending-flat-hook-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-j-descending-flat-hook-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-j = 'descending-flat-hook-serifed'</code>, <code>cv10 = 14</code></td></tr><tr><td>J with flat hook goes below descender and top serif at left side</td></tr></table>
  - Styles for `K`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-straight-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-straight-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'straight-serifless'</code>, <code>cv11 = 1</code></td></tr><tr><td><code>K</code> with standard shape, without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-straight-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-straight-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'straight-top-left-serifed'</code>, <code>cv11 = 2</code></td></tr><tr><td><code>K</code> with standard shape and serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-straight-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-straight-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'straight-bottom-right-serifed'</code>, <code>cv11 = 3</code></td></tr><tr><td><code>K</code> with standard shape and serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-straight-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-straight-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'straight-serifed'</code>, <code>cv11 = 4</code></td></tr><tr><td><code>K</code> with standard shape, and serifs (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-straight-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-straight-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'straight-top-left-and-bottom-right-serifed'</code>, <code>cv11 = 5</code></td></tr><tr><td><code>K</code> with standard shape and serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-curly-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-curly-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'curly-serifless'</code>, <code>cv11 = 6</code></td></tr><tr><td>Slightly curly <code>K</code>, like Iosevka 2.x, without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-curly-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-curly-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'curly-top-left-serifed'</code>, <code>cv11 = 7</code></td></tr><tr><td>Slightly curly <code>K</code>, like Iosevka 2.x, with serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-curly-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-curly-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'curly-bottom-right-serifed'</code>, <code>cv11 = 8</code></td></tr><tr><td>Slightly curly <code>K</code>, like Iosevka 2.x, with serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-curly-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-curly-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'curly-serifed'</code>, <code>cv11 = 9</code></td></tr><tr><td>Slightly curly <code>K</code>, like Iosevka 2.x, and with serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-curly-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-curly-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'curly-top-left-and-bottom-right-serifed'</code>, <code>cv11 = 10</code></td></tr><tr><td>Slightly curly <code>K</code>, like Iosevka 2.x, with serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-symmetric-touching-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-symmetric-touching-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'symmetric-touching-serifless'</code>, <code>cv11 = 11</code></td></tr><tr><td><code>K</code> with symmetric legs touching the vertical bar, without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-symmetric-touching-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-symmetric-touching-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'symmetric-touching-top-left-serifed'</code>, <code>cv11 = 12</code></td></tr><tr><td><code>K</code> with symmetric legs touching the vertical bar, and serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-symmetric-touching-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-symmetric-touching-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'symmetric-touching-bottom-right-serifed'</code>, <code>cv11 = 13</code></td></tr><tr><td><code>K</code> with symmetric legs touching the vertical bar, and serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-symmetric-touching-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-symmetric-touching-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'symmetric-touching-serifed'</code>, <code>cv11 = 14</code></td></tr><tr><td><code>K</code> with symmetric legs touching the vertical bar, and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-symmetric-touching-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-symmetric-touching-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'symmetric-touching-top-left-and-bottom-right-serifed'</code>, <code>cv11 = 15</code></td></tr><tr><td><code>K</code> with symmetric legs touching the vertical bar, and serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-symmetric-connected-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-symmetric-connected-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'symmetric-connected-serifless'</code>, <code>cv11 = 16</code></td></tr><tr><td><code>K</code> with symmetric legs connected to the vertical bar, without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-symmetric-connected-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-symmetric-connected-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'symmetric-connected-top-left-serifed'</code>, <code>cv11 = 17</code></td></tr><tr><td><code>K</code> with symmetric legs connected to the vertical bar, and serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-symmetric-connected-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-symmetric-connected-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'symmetric-connected-bottom-right-serifed'</code>, <code>cv11 = 18</code></td></tr><tr><td><code>K</code> with symmetric legs connected to the vertical bar, and serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-symmetric-connected-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-symmetric-connected-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'symmetric-connected-serifed'</code>, <code>cv11 = 19</code></td></tr><tr><td><code>K</code> with symmetric legs connected to the vertical bar, and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-k-symmetric-connected-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-k-symmetric-connected-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-k = 'symmetric-connected-top-left-and-bottom-right-serifed'</code>, <code>cv11 = 20</code></td></tr><tr><td><code>K</code> with symmetric legs connected to the vertical bar, and serifs at top left and bottom right</td></tr></table>
  - Styles for `L`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-l-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-l-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-l = 'serifless'</code>, <code>cv12 = 1</code></td></tr><tr><td>Serifless <code>L</code> (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-l-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-l-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-l = 'motion-serifed'</code>, <code>cv12 = 2</code></td></tr><tr><td>Standard <code>L</code> with motion serif at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-l-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-l-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-l = 'serifed'</code>, <code>cv12 = 3</code></td></tr><tr><td><code>L</code> with serifs (default for Slab)</td></tr></table>
  - Styles for `M`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-m-hanging.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-m-hanging.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-m = 'hanging'</code>, <code>cv13 = 1</code></td></tr><tr><td><code>M</code> with middle being hanging off baseline (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-m-hanging-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-m-hanging-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-m = 'hanging-motion-serifed'</code>, <code>cv13 = 2</code></td></tr><tr><td><code>M</code> with middle being hanging off baseline and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-m-slanted-sides-hanging.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-m-slanted-sides-hanging.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-m = 'slanted-sides-hanging'</code>, <code>cv13 = 3</code></td></tr><tr><td><code>M</code> with slanted sides and middle being hanging off baseline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-m-slanted-sides-hanging-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-m-slanted-sides-hanging-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-m = 'slanted-sides-hanging-motion-serifed'</code>, <code>cv13 = 4</code></td></tr><tr><td><code>M</code> with slanted sides, middle being hanging off baseline, and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-m-flat-bottom.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-m-flat-bottom.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-m = 'flat-bottom'</code>, <code>cv13 = 5</code></td></tr><tr><td><code>M</code> with middle aligned to baseline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-m-flat-bottom-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-m-flat-bottom-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-m = 'flat-bottom-motion-serifed'</code>, <code>cv13 = 6</code></td></tr><tr><td><code>M</code> with middle aligned to baseline and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-m-slanted-sides-flat-bottom.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-m-slanted-sides-flat-bottom.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-m = 'slanted-sides-flat-bottom'</code>, <code>cv13 = 7</code></td></tr><tr><td><code>M</code> with slanted sides and middle aligned to baseline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-m-slanted-sides-flat-bottom-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-m-slanted-sides-flat-bottom-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-m = 'slanted-sides-flat-bottom-motion-serifed'</code>, <code>cv13 = 8</code></td></tr><tr><td><code>M</code> with slanted sides, middle aligned to baseline, and motion serifs</td></tr></table>
  - Styles for `N`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-n-standard.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-n-standard.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-n = 'standard'</code>, <code>cv14 = 1</code></td></tr><tr><td>Standard N (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-n-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-n-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-n = 'motion-serifed'</code>, <code>cv14 = 2</code></td></tr><tr><td>Standard N with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-n-asymmetric.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-n-asymmetric.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-n = 'asymmetric'</code>, <code>cv14 = 3</code></td></tr><tr><td>More asymmetric N, with the diagonal bar stops at middle of right stem</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-n-asymmetric-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-n-asymmetric-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-n = 'asymmetric-motion-serifed'</code>, <code>cv14 = 4</code></td></tr><tr><td>More asymmetric N, with the diagonal bar stops at middle of right stem and motion serifs</td></tr></table>
  - Styles for `P`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-p-closed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-p-closed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-p = 'closed'</code>, <code>cv15 = 1</code></td></tr><tr><td>Closed <code>P</code> (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-p-closed-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-p-closed-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-p = 'closed-motion-serifed'</code>, <code>cv15 = 2</code></td></tr><tr><td>Closed <code>P</code> with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-p-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-p-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-p = 'open'</code>, <code>cv15 = 3</code></td></tr><tr><td>P with open contour at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-p-open-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-p-open-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-p = 'open-motion-serifed'</code>, <code>cv15 = 4</code></td></tr><tr><td>P with open contour at bottom and motion serifs</td></tr></table>
  - Styles for `Q`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-q-curly-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-q-curly-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-q = 'curly-tailed'</code>, <code>cv16 = 1</code></td></tr><tr><td><code>Q</code> with a curly tail (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-q-crossing-curly-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-q-crossing-curly-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-q = 'crossing-curly-tailed'</code>, <code>cv16 = 2</code></td></tr><tr><td><code>Q</code> with a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-q-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-q-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-q = 'straight'</code>, <code>cv16 = 3</code></td></tr><tr><td><code>Q</code> with a straight tail like in the old versions</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-q-crossing.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-q-crossing.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-q = 'crossing'</code>, <code>cv16 = 4</code></td></tr><tr><td><code>Q</code> with a tail crossing the ring</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-q-vertical-crossing.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-q-vertical-crossing.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-q = 'vertical-crossing'</code>, <code>cv16 = 5</code></td></tr><tr><td><code>Q</code> with a vertical tail crossing the ring</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-q-horizontal-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-q-horizontal-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-q = 'horizontal-tailed'</code>, <code>cv16 = 6</code></td></tr><tr><td><code>Q</code> with a horizontal tail, like Univers</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-q-detached-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-q-detached-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-q = 'detached-tailed'</code>, <code>cv16 = 7</code></td></tr><tr><td><code>Q</code> with a oblique tail detached</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-q-detached-bend-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-q-detached-bend-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-q = 'detached-bend-tailed'</code>, <code>cv16 = 8</code></td></tr><tr><td><code>Q</code> with a bend tail detached</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-q-open-swash.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-q-open-swash.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-q = 'open-swash'</code>, <code>cv16 = 9</code></td></tr><tr><td><code>Q</code> with open contour and swash-y shape</td></tr></table>
  - Styles for `R`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-r-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-r-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-r = 'straight'</code>, <code>cv17 = 1</code></td></tr><tr><td>Standard, straight-leg <code>R</code> (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-r-straight-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-r-straight-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-r = 'straight-motion-serifed'</code>, <code>cv17 = 2</code></td></tr><tr><td>Standard, straight-leg <code>R</code>, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-r-curly.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-r-curly.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-r = 'curly'</code>, <code>cv17 = 3</code></td></tr><tr><td> Slightly curly-legged <code>R</code>, like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-r-curly-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-r-curly-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-r = 'curly-motion-serifed'</code>, <code>cv17 = 4</code></td></tr><tr><td> Slightly curly-legged <code>R</code>, like Iosevka 2.x, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-r-standing.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-r-standing.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-r = 'standing'</code>, <code>cv17 = 5</code></td></tr><tr><td><code>R</code> with near-vertical standing leg</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-r-standing-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-r-standing-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-r = 'standing-motion-serifed'</code>, <code>cv17 = 6</code></td></tr><tr><td><code>R</code> with near-vertical standing leg</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-r-straight-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-r-straight-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-r = 'straight-open'</code>, <code>cv17 = 7</code></td></tr><tr><td>Standard, straight-leg <code>R</code>, with open contour at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-r-straight-open-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-r-straight-open-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-r = 'straight-open-motion-serifed'</code>, <code>cv17 = 8</code></td></tr><tr><td>Standard, straight-leg <code>R</code>, with open contour at bottom and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-r-curly-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-r-curly-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-r = 'curly-open'</code>, <code>cv17 = 9</code></td></tr><tr><td> Slightly curly-legged <code>R</code>, like Iosevka 2.x, with open contour at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-r-curly-open-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-r-curly-open-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-r = 'curly-open-motion-serifed'</code>, <code>cv17 = 10</code></td></tr><tr><td> Slightly curly-legged <code>R</code>, like Iosevka 2.x, with open contour at bottom and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-r-standing-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-r-standing-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-r = 'standing-open'</code>, <code>cv17 = 11</code></td></tr><tr><td><code>R</code> with near-vertical standing leg, with open contour at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-r-standing-open-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-r-standing-open-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-r = 'standing-open-motion-serifed'</code>, <code>cv17 = 12</code></td></tr><tr><td><code>R</code> with near-vertical standing leg, with open contour at bottom and motion serifs</td></tr></table>
  - Styles for `S`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-s-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-s-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-s = 'serifless'</code>, <code>cv18 = 1</code></td></tr><tr><td>Serifless <code>S</code> (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-s-unilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-s-unilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-s = 'unilateral-serifed'</code>, <code>cv18 = 2</code></td></tr><tr><td><code>S</code> with single serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-s-bilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-s-bilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-s = 'bilateral-serifed'</code>, <code>cv18 = 3</code></td></tr><tr><td><code>S</code> with serifs at both end (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-s-unilateral-inward-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-s-unilateral-inward-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-s = 'unilateral-inward-serifed'</code>, <code>cv18 = 4</code></td></tr><tr><td><code>S</code> with single inward serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-s-bilateral-inward-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-s-bilateral-inward-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-s = 'bilateral-inward-serifed'</code>, <code>cv18 = 5</code></td></tr><tr><td><code>S</code> with inward serifs at both end</td></tr></table>
  - Styles for `T`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-t-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-t-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-t = 'serifless'</code>, <code>cv19 = 1</code></td></tr><tr><td>Serifless T (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-t-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-t-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-t = 'motion-serifed'</code>, <code>cv19 = 2</code></td></tr><tr><td>Motion-Serifed T</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-t-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-t-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-t = 'serifed'</code>, <code>cv19 = 3</code></td></tr><tr><td>Serifed T (default for Slab)</td></tr></table>
  - Styles for `U`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-u-toothed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-u-toothed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-u = 'toothed'</code>, <code>cv20 = 1</code></td></tr><tr><td><code>U</code> with bottom-right tooth</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-u-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-u-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-u = 'motion-serifed'</code>, <code>cv20 = 2</code></td></tr><tr><td>Normal <code>U</code> with right bar and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-u-toothless-corner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-u-toothless-corner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-u = 'toothless-corner'</code>, <code>cv20 = 3</code></td></tr><tr><td>Toothless (corner bottom-right) <code>U</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-u-toothless-corner-unilateral-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-u-toothless-corner-unilateral-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-u = 'toothless-corner-unilateral-motion-serifed'</code>, <code>cv20 = 4</code></td></tr><tr><td>Toothless (corner bottom-right) <code>U</code> with motion serifs, like Museo</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-u-toothless-corner-bilateral-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-u-toothless-corner-bilateral-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-u = 'toothless-corner-bilateral-motion-serifed'</code>, <code>cv20 = 5</code></td></tr><tr><td>Toothless (corner bottom-right) <code>U</code> with motion serifs, like Museo</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-u-toothless-rounded.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-u-toothless-rounded.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-u = 'toothless-rounded'</code>, <code>cv20 = 6</code></td></tr><tr><td>Toothless (rounded) <code>U</code> (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-u-toothless-rounded-unilateral-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-u-toothless-rounded-unilateral-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-u = 'toothless-rounded-unilateral-motion-serifed'</code>, <code>cv20 = 7</code></td></tr><tr><td>Toothless (rounded) <code>U</code> with motion serifs, like Museo</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-u-toothless-rounded-bilateral-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-u-toothless-rounded-bilateral-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-u = 'toothless-rounded-bilateral-motion-serifed'</code>, <code>cv20 = 8</code></td></tr><tr><td>Toothless (rounded) <code>U</code> with motion serifs, like Museo</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-u-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-u-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-u = 'tailed'</code>, <code>cv20 = 9</code></td></tr><tr><td><code>U</code> with right bar and a slightly curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-u-tailed-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-u-tailed-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-u = 'tailed-motion-serifed'</code>, <code>cv20 = 10</code></td></tr><tr><td><code>U</code> with right bar, motion serifs and a slightly curly tail</td></tr></table>
  - Styles for `V`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-v-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-v-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-v = 'straight'</code>, <code>cv21 = 1</code></td></tr><tr><td>Standard, straight <code>V</code> (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-v-straight-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-v-straight-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-v = 'straight-motion-serifed'</code>, <code>cv21 = 2</code></td></tr><tr><td>Standard, straight <code>V</code>, and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-v-curly.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-v-curly.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-v = 'curly'</code>, <code>cv21 = 3</code></td></tr><tr><td> Slightly curly <code>V</code>, like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-v-curly-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-v-curly-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-v = 'curly-motion-serifed'</code>, <code>cv21 = 4</code></td></tr><tr><td> Slightly curly <code>V</code>, like Iosevka 2.x, and motion serifs</td></tr></table>
  - Styles for `W`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-w-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-w-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-w = 'straight'</code>, <code>cv22 = 1</code></td></tr><tr><td>Standard, straight <code>W</code> (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-w-straight-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-w-straight-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-w = 'straight-motion-serifed'</code>, <code>cv22 = 2</code></td></tr><tr><td>Standard, straight <code>W</code>, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-w-curly.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-w-curly.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-w = 'curly'</code>, <code>cv22 = 3</code></td></tr><tr><td>Slightly curly <code>W</code>, like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-w-curly-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-w-curly-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-w = 'curly-motion-serifed'</code>, <code>cv22 = 4</code></td></tr><tr><td>Slightly curly <code>W</code>, like Iosevka 2.x, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-w-straight-flat-top.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-w-straight-flat-top.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-w = 'straight-flat-top'</code>, <code>cv22 = 5</code></td></tr><tr><td>Standard, straight <code>W</code>, and the middle is forced to be aligned the top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-w-straight-flat-top-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-w-straight-flat-top-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-w = 'straight-flat-top-motion-serifed'</code>, <code>cv22 = 6</code></td></tr><tr><td>Standard, straight <code>W</code>, and the middle is forced to be aligned the top, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-w-straight-double-v.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-w-straight-double-v.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-w = 'straight-double-v'</code>, <code>cv22 = 7</code></td></tr><tr><td>Straight <code>W</code> looks like double V</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-w-straight-double-v-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-w-straight-double-v-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-w = 'straight-double-v-motion-serifed'</code>, <code>cv22 = 8</code></td></tr><tr><td>Straight <code>W</code> looks like double V, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-w-straight-asymmetric.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-w-straight-asymmetric.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-w = 'straight-asymmetric'</code>, <code>cv22 = 9</code></td></tr><tr><td>Straight <code>W</code> looks asymmetric</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-w-straight-asymmetric-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-w-straight-asymmetric-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-w = 'straight-asymmetric-motion-serifed'</code>, <code>cv22 = 10</code></td></tr><tr><td>Straight <code>W</code> looks asymmetric, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-w-straight-vertical-sides.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-w-straight-vertical-sides.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-w = 'straight-vertical-sides'</code>, <code>cv22 = 11</code></td></tr><tr><td>Straight <code>W</code> with vertical sides</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-w-straight-vertical-sides-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-w-straight-vertical-sides-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-w = 'straight-vertical-sides-motion-serifed'</code>, <code>cv22 = 12</code></td></tr><tr><td>Straight <code>W</code> with vertical sides and motion serifs</td></tr></table>
  - Styles for `X`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-x-straight-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-x-straight-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-x = 'straight-serifless'</code>, <code>cv23 = 1</code></td></tr><tr><td>Serifless, straight <code>X</code> (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-x-straight-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-x-straight-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-x = 'straight-motion-serifed'</code>, <code>cv23 = 2</code></td></tr><tr><td>Straight <code>X</code> with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-x-straight-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-x-straight-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-x = 'straight-serifed'</code>, <code>cv23 = 3</code></td></tr><tr><td>Straight <code>X</code> with full serifs (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-x-curly-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-x-curly-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-x = 'curly-serifless'</code>, <code>cv23 = 4</code></td></tr><tr><td>Serifless, slightly curly <code>X</code>, like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-x-curly-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-x-curly-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-x = 'curly-motion-serifed'</code>, <code>cv23 = 5</code></td></tr><tr><td>Slightly curly <code>X</code>, like Iosevka 2.x, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-x-curly-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-x-curly-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-x = 'curly-serifed'</code>, <code>cv23 = 6</code></td></tr><tr><td>Slightly curly <code>X</code>, like Iosevka 2.x, with full serifs</td></tr></table>
  - Styles for `Y`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-y-straight-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-y-straight-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-y = 'straight-serifless'</code>, <code>cv24 = 1</code></td></tr><tr><td>Straight <code>Y</code> without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-y-straight-base-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-y-straight-base-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-y = 'straight-base-serifed'</code>, <code>cv24 = 2</code></td></tr><tr><td>Standard, straight <code>Y</code>, with serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-y-straight-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-y-straight-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-y = 'straight-motion-serifed'</code>, <code>cv24 = 3</code></td></tr><tr><td>Standard, straight <code>Y</code>, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-y-straight-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-y-straight-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-y = 'straight-serifed'</code>, <code>cv24 = 4</code></td></tr><tr><td>Standard, straight <code>Y</code>, with serifs (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-y-curly-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-y-curly-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-y = 'curly-serifless'</code>, <code>cv24 = 5</code></td></tr><tr><td>Slightly curly <code>Y</code>, like Iosevka 2.x, without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-y-curly-base-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-y-curly-base-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-y = 'curly-base-serifed'</code>, <code>cv24 = 6</code></td></tr><tr><td>Slightly curly <code>Y</code>, like Iosevka 2.x, with serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-y-curly-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-y-curly-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-y = 'curly-motion-serifed'</code>, <code>cv24 = 7</code></td></tr><tr><td>Slightly curly <code>Y</code>, like Iosevka 2.x, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-y-curly-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-y-curly-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-y = 'curly-serifed'</code>, <code>cv24 = 8</code></td></tr><tr><td>Slightly curly <code>Y</code>, like Iosevka 2.x, with serifs</td></tr></table>
  - Styles for `Z`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-straight-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-straight-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'straight-serifless'</code>, <code>cv25 = 1</code></td></tr><tr><td>Straight <code>Z</code> without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-straight-serifless-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-straight-serifless-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'straight-serifless-with-crossbar'</code>, <code>cv25 = 2</code></td></tr><tr><td>Straight <code>Z</code> with a diagonal crossbar, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-straight-serifless-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-straight-serifless-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'straight-serifless-with-horizontal-crossbar'</code>, <code>cv25 = 3</code></td></tr><tr><td>Straight <code>Z</code> with a horizontal crossbar, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-straight-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-straight-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'straight-serifed'</code>, <code>cv25 = 4</code></td></tr><tr><td>Straight <code>Z</code> with top and bottom serifs (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-straight-serifed-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-straight-serifed-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'straight-serifed-with-crossbar'</code>, <code>cv25 = 5</code></td></tr><tr><td>Straight <code>Z</code> with a diagonal crossbar and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-straight-serifed-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-straight-serifed-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'straight-serifed-with-horizontal-crossbar'</code>, <code>cv25 = 6</code></td></tr><tr><td>Straight <code>Z</code> with a horizontal crossbar and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-straight-bottom-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-straight-bottom-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'straight-bottom-serifed'</code>, <code>cv25 = 7</code></td></tr><tr><td>Standard <code>Z</code> with serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-straight-bottom-serifed-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-straight-bottom-serifed-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'straight-bottom-serifed-with-crossbar'</code>, <code>cv25 = 8</code></td></tr><tr><td>Standard <code>Z</code> with a diagonal crossbar and serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-straight-bottom-serifed-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-straight-bottom-serifed-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'straight-bottom-serifed-with-horizontal-crossbar'</code>, <code>cv25 = 9</code></td></tr><tr><td>Standard <code>Z</code> with a horizontal crossbar and serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-straight-top-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-straight-top-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'straight-top-serifed'</code>, <code>cv25 = 10</code></td></tr><tr><td>Standard <code>Z</code> with serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-straight-top-serifed-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-straight-top-serifed-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'straight-top-serifed-with-crossbar'</code>, <code>cv25 = 11</code></td></tr><tr><td>Standard <code>Z</code> with a diagonal crossbar and serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-straight-top-serifed-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-straight-top-serifed-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'straight-top-serifed-with-horizontal-crossbar'</code>, <code>cv25 = 12</code></td></tr><tr><td>Standard <code>Z</code> with a horizontal crossbar and serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-curly-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-curly-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'curly-serifless'</code>, <code>cv25 = 13</code></td></tr><tr><td>Curly <code>Z</code> without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-curly-serifless-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-curly-serifless-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'curly-serifless-with-crossbar'</code>, <code>cv25 = 14</code></td></tr><tr><td>Curly <code>Z</code> with a diagonal crossbar, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-curly-serifless-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-curly-serifless-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'curly-serifless-with-horizontal-crossbar'</code>, <code>cv25 = 15</code></td></tr><tr><td>Curly <code>Z</code> with a horizontal crossbar, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-curly-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-curly-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'curly-serifed'</code>, <code>cv25 = 16</code></td></tr><tr><td>Curly <code>Z</code> with top and bottom serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-curly-serifed-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-curly-serifed-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'curly-serifed-with-crossbar'</code>, <code>cv25 = 17</code></td></tr><tr><td>Curly <code>Z</code> with a diagonal crossbar and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-curly-serifed-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-curly-serifed-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'curly-serifed-with-horizontal-crossbar'</code>, <code>cv25 = 18</code></td></tr><tr><td>Curly <code>Z</code> with a horizontal crossbar and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-curly-bottom-serifed-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-curly-bottom-serifed-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'curly-bottom-serifed-with-crossbar'</code>, <code>cv25 = 19</code></td></tr><tr><td>Curly <code>Z</code> with serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-curly-bottom-serifed-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-curly-bottom-serifed-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'curly-bottom-serifed-with-horizontal-crossbar'</code>, <code>cv25 = 20</code></td></tr><tr><td>Curly <code>Z</code> with a diagonal crossbar and serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-curly-bottom-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-curly-bottom-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'curly-bottom-serifed'</code>, <code>cv25 = 21</code></td></tr><tr><td>Curly <code>Z</code> with a horizontal crossbar and serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-curly-top-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-curly-top-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'curly-top-serifed'</code>, <code>cv25 = 22</code></td></tr><tr><td>Curly <code>Z</code> with serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-curly-top-serifed-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-curly-top-serifed-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'curly-top-serifed-with-crossbar'</code>, <code>cv25 = 23</code></td></tr><tr><td>Curly <code>Z</code> with a diagonal crossbar and serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-curly-top-serifed-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-curly-top-serifed-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'curly-top-serifed-with-horizontal-crossbar'</code>, <code>cv25 = 24</code></td></tr><tr><td>Curly <code>Z</code> with a horizontal crossbar and serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-cursive.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-cursive.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'cursive'</code>, <code>cv25 = 25</code></td></tr><tr><td>Cursive <code>Z</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-cursive-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-cursive-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'cursive-with-crossbar'</code>, <code>cv25 = 26</code></td></tr><tr><td>Cursive <code>Z</code> with a diagonal cross bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-z-cursive-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-z-cursive-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-z = 'cursive-with-horizontal-crossbar'</code>, <code>cv25 = 27</code></td></tr><tr><td>Cursive <code>Z</code> with a horizontal cross bar</td></tr></table>
  - Styles for `a`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-a-double-storey-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-double-storey-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'double-storey-serifless'</code>, <code>cv26 = 1</code></td></tr><tr><td>Double-storey <code>a</code> without serifs (default for Sans Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-double-storey-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-double-storey-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'double-storey-tailed'</code>, <code>cv26 = 2</code></td></tr><tr><td>Double-storey <code>a</code> with curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-double-storey-toothless-corner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-double-storey-toothless-corner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'double-storey-toothless-corner'</code>, <code>cv26 = 3</code></td></tr><tr><td>Toothless (cornered bottom-right) double-storey <code>a</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-double-storey-toothless-rounded.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-double-storey-toothless-rounded.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'double-storey-toothless-rounded'</code>, <code>cv26 = 4</code></td></tr><tr><td>Toothless (rounded bottom-right) double-storey <code>a</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-double-storey-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-double-storey-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'double-storey-serifed'</code>, <code>cv26 = 5</code></td></tr><tr><td>Double-storey <code>a</code> with serif at bottom right (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-single-storey-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-single-storey-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'single-storey-serifless'</code>, <code>cv26 = 6</code></td></tr><tr><td>Single-storey <code>a</code> without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-single-storey-earless-corner-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-single-storey-earless-corner-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'single-storey-earless-corner-serifless'</code>, <code>cv26 = 7</code></td></tr><tr><td>Earless (cornered top-right) single-storey <code>a</code> without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-single-storey-earless-rounded-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-single-storey-earless-rounded-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'single-storey-earless-rounded-serifless'</code>, <code>cv26 = 8</code></td></tr><tr><td>Earless (rounded top-right) single-storey <code>a</code> without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-single-storey-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-single-storey-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'single-storey-tailed'</code>, <code>cv26 = 9</code></td></tr><tr><td>Single-storey <code>a</code> with curly tail (default for Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-single-storey-earless-corner-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-single-storey-earless-corner-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'single-storey-earless-corner-tailed'</code>, <code>cv26 = 10</code></td></tr><tr><td>Earless (cornered top-right) single-storey <code>a</code> with curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-single-storey-earless-rounded-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-single-storey-earless-rounded-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'single-storey-earless-rounded-tailed'</code>, <code>cv26 = 11</code></td></tr><tr><td>Earless (rounded top-right) single-storey <code>a</code> with curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-single-storey-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-single-storey-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'single-storey-serifed'</code>, <code>cv26 = 12</code></td></tr><tr><td>Single-storey <code>a</code> with serif at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-single-storey-earless-corner-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-single-storey-earless-corner-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'single-storey-earless-corner-serifed'</code>, <code>cv26 = 13</code></td></tr><tr><td>Earless (cornered top-right) single-storey <code>a</code> with serif at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-a-single-storey-earless-rounded-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-a-single-storey-earless-rounded-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>a = 'single-storey-earless-rounded-serifed'</code>, <code>cv26 = 14</code></td></tr><tr><td>Earless (rounded top-right) single-storey <code>a</code> with serif at bottom right</td></tr></table>
  - Styles for `b`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-b-toothed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-b-toothed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>b = 'toothed'</code>, <code>cv27 = 1</code></td></tr><tr><td><code>b</code> with bottom-left tooth (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-b-toothed-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-b-toothed-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>b = 'toothed-motion-serifed'</code>, <code>cv27 = 2</code></td></tr><tr><td><code>b</code> with motion serif, and with bottom-left tooth</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-b-toothless-corner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-b-toothless-corner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>b = 'toothless-corner'</code>, <code>cv27 = 3</code></td></tr><tr><td><code>b</code> without bottom-left tooth, with a corner transition</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-b-toothless-corner-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-b-toothless-corner-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>b = 'toothless-corner-motion-serifed'</code>, <code>cv27 = 4</code></td></tr><tr><td><code>b</code> with motion serif, and without bottom-left tooth, with a corner transition</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-b-toothless-rounded.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-b-toothless-rounded.dark.svg#gh-dark-mode-only" width=32/></td><td><code>b = 'toothless-rounded'</code>, <code>cv27 = 5</code></td></tr><tr><td><code>b</code> without bottom-left tooth, with a rounded transition</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-b-toothless-rounded-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-b-toothless-rounded-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>b = 'toothless-rounded-motion-serifed'</code>, <code>cv27 = 6</code></td></tr><tr><td><code>b</code> with motion serif, and without bottom-left tooth, with a rounded transition</td></tr></table>
  - Styles for `c`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-c-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-c-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>c = 'serifless'</code>, <code>cv28 = 1</code></td></tr><tr><td>Serifless <code>c</code> (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-c-unilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-c-unilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>c = 'unilateral-serifed'</code>, <code>cv28 = 2</code></td></tr><tr><td><code>c</code> with serif at top (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-c-bilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-c-bilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>c = 'bilateral-serifed'</code>, <code>cv28 = 3</code></td></tr><tr><td><code>c</code> with serifs at both top and bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-c-unilateral-inward-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-c-unilateral-inward-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>c = 'unilateral-inward-serifed'</code>, <code>cv28 = 4</code></td></tr><tr><td><code>c</code> with inward serif at top (default for Slab Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-c-bilateral-inward-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-c-bilateral-inward-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>c = 'bilateral-inward-serifed'</code>, <code>cv28 = 5</code></td></tr><tr><td><code>c</code> with inward serif at both top and bottom</td></tr></table>
  - Styles for `d`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-d-toothed-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-d-toothed-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>d = 'toothed-serifless'</code>, <code>cv29 = 1</code></td></tr><tr><td><code>d</code> with bottom-right tooth, and without serifs (default for Sans Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-d-toothed-top-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-d-toothed-top-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>d = 'toothed-top-serifed'</code>, <code>cv29 = 2</code></td></tr><tr><td><code>d</code> with bottom-right tooth and top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-d-toothed-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-d-toothed-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>d = 'toothed-serifed'</code>, <code>cv29 = 3</code></td></tr><tr><td><code>d</code> with serifs (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-d-toothless-corner-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-d-toothless-corner-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>d = 'toothless-corner-serifless'</code>, <code>cv29 = 4</code></td></tr><tr><td><code>d</code> without bottom-right tooth, with a corner transition, and without serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-d-toothless-corner-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-d-toothless-corner-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>d = 'toothless-corner-serifed'</code>, <code>cv29 = 5</code></td></tr><tr><td><code>d</code> without bottom-right tooth, with a corner transition and top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-d-toothless-rounded-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-d-toothless-rounded-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>d = 'toothless-rounded-serifless'</code>, <code>cv29 = 6</code></td></tr><tr><td><code>d</code> without bottom-right tooth, with a rounded transition, and without serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-d-toothless-rounded-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-d-toothless-rounded-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>d = 'toothless-rounded-serifed'</code>, <code>cv29 = 7</code></td></tr><tr><td><code>d</code> without bottom-right tooth, with a rounded transition and top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-d-tailed-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-d-tailed-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>d = 'tailed-serifless'</code>, <code>cv29 = 8</code></td></tr><tr><td><code>d</code> with a bottom-right tail, and without serif (default for Sans Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-d-tailed-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-d-tailed-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>d = 'tailed-serifed'</code>, <code>cv29 = 9</code></td></tr><tr><td><code>d</code> with a bottom-right tail and top serif (default for Slab Italic)</td></tr></table>
  - Styles for `e`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-e-flat-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-e-flat-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>e = 'flat-crossbar'</code>, <code>cv30 = 1</code></td></tr><tr><td><code>e</code> with flat crossbar (default for Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-e-rounded.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-e-rounded.dark.svg#gh-dark-mode-only" width=32/></td><td><code>e = 'rounded'</code>, <code>cv30 = 2</code></td></tr><tr><td><code>e</code> with more rounded shape (default for Italic)</td></tr></table>
  - Styles for `f`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-f-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'serifless'</code>, <code>cv31 = 1</code></td></tr><tr><td><code>f</code> without bottom serif, hook or extension (default for Sans Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'serifed'</code>, <code>cv31 = 2</code></td></tr><tr><td><code>f</code> with bottom serif (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'tailed'</code>, <code>cv31 = 3</code></td></tr><tr><td><code>f</code> with bottom hook</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-extended.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-extended.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'extended'</code>, <code>cv31 = 4</code></td></tr><tr><td><code>f</code> with bar extended to descender</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-diagonal-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-diagonal-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'diagonal-tailed'</code>, <code>cv31 = 5</code></td></tr><tr><td><code>f</code> with bottom diagonal tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-serifless-crossbar-at-x-height.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-serifless-crossbar-at-x-height.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'serifless-crossbar-at-x-height'</code>, <code>cv31 = 6</code></td></tr><tr><td><code>f</code> without bottom serif, hook or extension; crossbar is placed right at X-height</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-serifed-crossbar-at-x-height.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-serifed-crossbar-at-x-height.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'serifed-crossbar-at-x-height'</code>, <code>cv31 = 7</code></td></tr><tr><td><code>f</code> with bottom serif; crossbar is placed right at X-height</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-tailed-crossbar-at-x-height.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-tailed-crossbar-at-x-height.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'tailed-crossbar-at-x-height'</code>, <code>cv31 = 8</code></td></tr><tr><td><code>f</code> with bottom hook; crossbar is placed right at X-height</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-extended-crossbar-at-x-height.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-extended-crossbar-at-x-height.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'extended-crossbar-at-x-height'</code>, <code>cv31 = 9</code></td></tr><tr><td><code>f</code> with bar extended to descender; crossbar is placed right at X-height</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-diagonal-tailed-crossbar-at-x-height.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-diagonal-tailed-crossbar-at-x-height.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'diagonal-tailed-crossbar-at-x-height'</code>, <code>cv31 = 10</code></td></tr><tr><td><code>f</code> with bottom diagonal tail; crossbar is placed right at X-height</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-flat-hook.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-flat-hook.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'flat-hook'</code>, <code>cv31 = 11</code></td></tr><tr><td><code>f</code> with flat top hook, without bottom serif, hook or extension</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-flat-hook-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-flat-hook-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'flat-hook-serifed'</code>, <code>cv31 = 12</code></td></tr><tr><td><code>f</code> with flat top hook and bottom serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-flat-hook-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-flat-hook-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'flat-hook-tailed'</code>, <code>cv31 = 13</code></td></tr><tr><td><code>f</code> with flat top hook and bottom hook (default for Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-flat-hook-extended.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-flat-hook-extended.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'flat-hook-extended'</code>, <code>cv31 = 14</code></td></tr><tr><td><code>f</code> with flat top hook and bar extended to descender</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-flat-hook-diagonal-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-flat-hook-diagonal-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'flat-hook-diagonal-tailed'</code>, <code>cv31 = 15</code></td></tr><tr><td><code>f</code> with flat hook and bottom diagonal tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-flat-hook-crossbar-at-x-height.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-flat-hook-crossbar-at-x-height.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'flat-hook-crossbar-at-x-height'</code>, <code>cv31 = 16</code></td></tr><tr><td><code>f</code> with flat top hook, without bottom serif, hook or extension; crossbar is placed right at X-height</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-flat-hook-serifed-crossbar-at-x-height.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-flat-hook-serifed-crossbar-at-x-height.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'flat-hook-serifed-crossbar-at-x-height'</code>, <code>cv31 = 17</code></td></tr><tr><td><code>f</code> with flat top hook, bottom serif; crossbar is placed right at X-height</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-flat-hook-tailed-crossbar-at-x-height.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-flat-hook-tailed-crossbar-at-x-height.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'flat-hook-tailed-crossbar-at-x-height'</code>, <code>cv31 = 18</code></td></tr><tr><td><code>f</code> with flat top hook, bottom hook; crossbar is placed right at X-height</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-flat-hook-extended-crossbar-at-x-height.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-flat-hook-extended-crossbar-at-x-height.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'flat-hook-extended-crossbar-at-x-height'</code>, <code>cv31 = 19</code></td></tr><tr><td><code>f</code> with flat top hook, bar extended to descender; crossbar is placed right at X-height</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-f-flat-hook-diagonal-tailed-crossbar-at-x-height.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-f-flat-hook-diagonal-tailed-crossbar-at-x-height.dark.svg#gh-dark-mode-only" width=32/></td><td><code>f = 'flat-hook-diagonal-tailed-crossbar-at-x-height'</code>, <code>cv31 = 20</code></td></tr><tr><td><code>f</code> with flat hook and bottom diagonal tail; crossbar is placed right at X-height</td></tr></table>
  - Styles for `g`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-g-double-storey.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-g-double-storey.dark.svg#gh-dark-mode-only" width=32/></td><td><code>g = 'double-storey'</code>, <code>cv32 = 1</code></td></tr><tr><td>Double-storey <code>g</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-g-double-storey-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-g-double-storey-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>g = 'double-storey-open'</code>, <code>cv32 = 2</code></td></tr><tr><td>Open Double-storey <code>g</code>, like Trebuchet MS or Fira Code</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-g-single-storey-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-g-single-storey-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>g = 'single-storey-serifless'</code>, <code>cv32 = 3</code></td></tr><tr><td>Single-storey <code>g</code> without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-g-single-storey-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-g-single-storey-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>g = 'single-storey-serifed'</code>, <code>cv32 = 4</code></td></tr><tr><td>Single-storey <code>g</code> with serif at top right (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-g-earless-corner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-g-earless-corner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>g = 'earless-corner'</code>, <code>cv32 = 5</code></td></tr><tr><td>Earless (cornered top-right) single-storey <code>g</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-g-earless-rounded.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-g-earless-rounded.dark.svg#gh-dark-mode-only" width=32/></td><td><code>g = 'earless-rounded'</code>, <code>cv32 = 6</code></td></tr><tr><td>Earless (rounded top-right) single-storey <code>g</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-g-single-storey-flat-hook-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-g-single-storey-flat-hook-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>g = 'single-storey-flat-hook-serifless'</code>, <code>cv32 = 7</code></td></tr><tr><td>Single-storey <code>g</code> with flat terminal hook and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-g-single-storey-flat-hook-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-g-single-storey-flat-hook-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>g = 'single-storey-flat-hook-serifed'</code>, <code>cv32 = 8</code></td></tr><tr><td>Single-storey <code>g</code> with top-right serif and flat terminal hook</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-g-single-storey-earless-corner-flat-hook.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-g-single-storey-earless-corner-flat-hook.dark.svg#gh-dark-mode-only" width=32/></td><td><code>g = 'single-storey-earless-corner-flat-hook'</code>, <code>cv32 = 9</code></td></tr><tr><td>Earless (cornered top-right) single-storey <code>g</code> with flat terminal hook</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-g-single-storey-earless-rounded-flat-hook.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-g-single-storey-earless-rounded-flat-hook.dark.svg#gh-dark-mode-only" width=32/></td><td><code>g = 'single-storey-earless-rounded-flat-hook'</code>, <code>cv32 = 10</code></td></tr><tr><td>Earless (rounded top-right) single-storey <code>g</code> with flat terminal hook</td></tr></table>
  - Styles for `h`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-h-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-h-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>h = 'straight'</code>, <code>cv33 = 1</code></td></tr><tr><td><code>h</code> with straight ending (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-h-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-h-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>h = 'tailed'</code>, <code>cv33 = 2</code></td></tr><tr><td><code>h</code> with curly tailed ending</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-h-straight-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-h-straight-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>h = 'straight-motion-serifed'</code>, <code>cv33 = 3</code></td></tr><tr><td><code>h</code> with straight ending and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-h-tailed-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-h-tailed-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>h = 'tailed-motion-serifed'</code>, <code>cv33 = 4</code></td></tr><tr><td><code>h</code> with curly tailed ending and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-h-straight-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-h-straight-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>h = 'straight-top-left-serifed'</code>, <code>cv33 = 5</code></td></tr><tr><td><code>h</code> with straight ending and serif at top left</td></tr></table>
  - Styles for `i`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-i-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-i-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>i = 'serifed'</code>, <code>cv34 = 1</code></td></tr><tr><td>Serifed <code>i</code> (default for Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-i-zshaped.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-i-zshaped.dark.svg#gh-dark-mode-only" width=32/></td><td><code>i = 'zshaped'</code>, <code>cv34 = 2</code></td></tr><tr><td>Z-shaped <code>i</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-i-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-i-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>i = 'serifless'</code>, <code>cv34 = 3</code></td></tr><tr><td><code>i</code> like a straight line</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-i-hooky.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-i-hooky.dark.svg#gh-dark-mode-only" width=32/></td><td><code>i = 'hooky'</code>, <code>cv34 = 4</code></td></tr><tr><td>Hooky <code>i</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-i-hooky-bottom.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-i-hooky-bottom.dark.svg#gh-dark-mode-only" width=32/></td><td><code>i = 'hooky-bottom'</code>, <code>cv34 = 5</code></td></tr><tr><td><code>i</code> with a sharp-turning horizontal tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-i-serifed-asymmetric.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-i-serifed-asymmetric.dark.svg#gh-dark-mode-only" width=32/></td><td><code>i = 'serifed-asymmetric'</code>, <code>cv34 = 6</code></td></tr><tr><td><code>i</code> with shorter top serif and full bottom serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-i-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-i-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>i = 'tailed'</code>, <code>cv34 = 7</code></td></tr><tr><td><code>i</code> with curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-i-tailed-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-i-tailed-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>i = 'tailed-serifed'</code>, <code>cv34 = 8</code></td></tr><tr><td><code>i</code> with top serif and curly tail (default for Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-i-flat-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-i-flat-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>i = 'flat-tailed'</code>, <code>cv34 = 9</code></td></tr><tr><td><code>i</code> with curly-then-flat tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-i-serifed-flat-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-i-serifed-flat-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>i = 'serifed-flat-tailed'</code>, <code>cv34 = 10</code></td></tr><tr><td><code>i</code> with top serif and curly-then-flat tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-i-diagonal-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-i-diagonal-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>i = 'diagonal-tailed'</code>, <code>cv34 = 11</code></td></tr><tr><td><code>i</code> with diagonal tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-i-serifed-diagonal-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-i-serifed-diagonal-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>i = 'serifed-diagonal-tailed'</code>, <code>cv34 = 12</code></td></tr><tr><td><code>i</code> with top serif and diagonal tail</td></tr></table>
  - Styles for `j`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-j-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-j-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>j = 'serifless'</code>, <code>cv35 = 1</code></td></tr><tr><td><code>j</code> without serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-j-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-j-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>j = 'serifed'</code>, <code>cv35 = 2</code></td></tr><tr><td><code>j</code> with top serif (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-j-straight-line.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-j-straight-line.dark.svg#gh-dark-mode-only" width=32/></td><td><code>j = 'straight-line'</code>, <code>cv35 = 3</code></td></tr><tr><td><code>j</code> like a straight line</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-j-hooky.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-j-hooky.dark.svg#gh-dark-mode-only" width=32/></td><td><code>j = 'hooky'</code>, <code>cv35 = 4</code></td></tr><tr><td><code>j</code> like a straight line with top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-j-flat-hook-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-j-flat-hook-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>j = 'flat-hook-serifless'</code>, <code>cv35 = 5</code></td></tr><tr><td><code>j</code> with flat terminal hook</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-j-flat-hook-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-j-flat-hook-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>j = 'flat-hook-serifed'</code>, <code>cv35 = 6</code></td></tr><tr><td><code>j</code> with flat terminal hook and top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-j-diagonal-tailed-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-j-diagonal-tailed-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>j = 'diagonal-tailed-serifless'</code>, <code>cv35 = 7</code></td></tr><tr><td><code>j</code> with diagonal tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-j-diagonal-tailed-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-j-diagonal-tailed-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>j = 'diagonal-tailed-serifed'</code>, <code>cv35 = 8</code></td></tr><tr><td><code>j</code> with top serif and diagonal tail</td></tr></table>
  - Styles for `k`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-k-straight-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-straight-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'straight-serifless'</code>, <code>cv36 = 1</code></td></tr><tr><td><code>k</code> with standard shape, and without serifs (default for Sans Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-straight-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-straight-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'straight-top-left-serifed'</code>, <code>cv36 = 2</code></td></tr><tr><td><code>k</code> with serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-straight-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-straight-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'straight-bottom-right-serifed'</code>, <code>cv36 = 3</code></td></tr><tr><td><code>k</code> with serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-straight-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-straight-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'straight-top-left-and-bottom-right-serifed'</code>, <code>cv36 = 4</code></td></tr><tr><td><code>k</code> with serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-straight-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-straight-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'straight-serifed'</code>, <code>cv36 = 5</code></td></tr><tr><td><code>k</code> with serifs (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-curly-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-curly-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'curly-serifless'</code>, <code>cv36 = 6</code></td></tr><tr><td>Slightly curly <code>k</code>, like Iosevka 2.x, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-curly-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-curly-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'curly-top-left-serifed'</code>, <code>cv36 = 7</code></td></tr><tr><td>Slightly curly <code>k</code>, like Iosevka 2.x, with serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-curly-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-curly-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'curly-bottom-right-serifed'</code>, <code>cv36 = 8</code></td></tr><tr><td>Slightly curly <code>k</code>, like Iosevka 2.x, with serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-curly-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-curly-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'curly-top-left-and-bottom-right-serifed'</code>, <code>cv36 = 9</code></td></tr><tr><td>Slightly curly <code>k</code>, like Iosevka 2.x, with serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-curly-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-curly-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'curly-serifed'</code>, <code>cv36 = 10</code></td></tr><tr><td>Slightly curly <code>k</code>, like Iosevka 2.x, with serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-symmetric-touching-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-symmetric-touching-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'symmetric-touching-serifless'</code>, <code>cv36 = 11</code></td></tr><tr><td><code>k</code> with symmetric legs touching the vertical bar, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-symmetric-touching-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-symmetric-touching-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'symmetric-touching-top-left-serifed'</code>, <code>cv36 = 12</code></td></tr><tr><td><code>k</code> with symmetric legs touching the vertical bar and serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-symmetric-touching-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-symmetric-touching-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'symmetric-touching-bottom-right-serifed'</code>, <code>cv36 = 13</code></td></tr><tr><td><code>k</code> with symmetric legs touching the vertical bar and serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-symmetric-touching-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-symmetric-touching-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'symmetric-touching-top-left-and-bottom-right-serifed'</code>, <code>cv36 = 14</code></td></tr><tr><td><code>k</code> with symmetric legs touching the vertical bar and serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-symmetric-touching-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-symmetric-touching-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'symmetric-touching-serifed'</code>, <code>cv36 = 15</code></td></tr><tr><td><code>k</code> with symmetric legs touching the vertical bar and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-symmetric-connected-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-symmetric-connected-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'symmetric-connected-serifless'</code>, <code>cv36 = 16</code></td></tr><tr><td><code>k</code> with symmetric legs connected to the vertical bar, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-symmetric-connected-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-symmetric-connected-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'symmetric-connected-bottom-right-serifed'</code>, <code>cv36 = 17</code></td></tr><tr><td><code>k</code> with symmetric legs connected to the vertical bar and serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-symmetric-connected-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-symmetric-connected-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'symmetric-connected-top-left-serifed'</code>, <code>cv36 = 18</code></td></tr><tr><td><code>k</code> with symmetric legs connected to the vertical bar and serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-symmetric-connected-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-symmetric-connected-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'symmetric-connected-top-left-and-bottom-right-serifed'</code>, <code>cv36 = 19</code></td></tr><tr><td><code>k</code> with symmetric legs connected to the vertical bar and serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-symmetric-connected-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-symmetric-connected-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'symmetric-connected-serifed'</code>, <code>cv36 = 20</code></td></tr><tr><td><code>k</code> with symmetric legs connected to the vertical bar and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-cursive-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-cursive-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'cursive-serifless'</code>, <code>cv36 = 21</code></td></tr><tr><td><code>k</code> with a cursive loop, and without serifs (default for Sans Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-cursive-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-cursive-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'cursive-top-left-serifed'</code>, <code>cv36 = 22</code></td></tr><tr><td><code>k</code> with a cursive loop and serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-cursive-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-cursive-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'cursive-bottom-right-serifed'</code>, <code>cv36 = 23</code></td></tr><tr><td><code>k</code> with a cursive loop and serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-cursive-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-cursive-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'cursive-top-left-and-bottom-right-serifed'</code>, <code>cv36 = 24</code></td></tr><tr><td><code>k</code> with a cursive loop and serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-cursive-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-cursive-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'cursive-serifed'</code>, <code>cv36 = 25</code></td></tr><tr><td><code>k</code> with a cursive loop and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-diagonal-tailed-cursive-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-diagonal-tailed-cursive-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'diagonal-tailed-cursive-serifless'</code>, <code>cv36 = 26</code></td></tr><tr><td><code>k</code> with a cursive loop and diagonal tail, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-k-diagonal-tailed-cursive-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-k-diagonal-tailed-cursive-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>k = 'diagonal-tailed-cursive-top-left-serifed'</code>, <code>cv36 = 27</code></td></tr><tr><td><code>k</code> with a cursive loop, diagonal tail and serifs at top left (default for Slab Italic)</td></tr></table>
  - Styles for `l`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-l-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-l-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>l = 'serifed'</code>, <code>cv37 = 1</code></td></tr><tr><td>Serifed <code>l</code> (default for Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-l-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-l-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>l = 'serifless'</code>, <code>cv37 = 2</code></td></tr><tr><td><code>l</code> like a straight line</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-l-hooky.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-l-hooky.dark.svg#gh-dark-mode-only" width=32/></td><td><code>l = 'hooky'</code>, <code>cv37 = 3</code></td></tr><tr><td>Hooky <code>l</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-l-zshaped.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-l-zshaped.dark.svg#gh-dark-mode-only" width=32/></td><td><code>l = 'zshaped'</code>, <code>cv37 = 4</code></td></tr><tr><td>Z-shaped <code>l</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-l-hooky-bottom.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-l-hooky-bottom.dark.svg#gh-dark-mode-only" width=32/></td><td><code>l = 'hooky-bottom'</code>, <code>cv37 = 5</code></td></tr><tr><td><code>l</code> with a straight sharp-turning horizontal tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-l-serifed-asymmetric.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-l-serifed-asymmetric.dark.svg#gh-dark-mode-only" width=32/></td><td><code>l = 'serifed-asymmetric'</code>, <code>cv37 = 6</code></td></tr><tr><td><code>l</code> with shorter top serif and full bottom serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-l-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-l-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>l = 'tailed'</code>, <code>cv37 = 7</code></td></tr><tr><td><code>l</code> with curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-l-tailed-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-l-tailed-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>l = 'tailed-serifed'</code>, <code>cv37 = 8</code></td></tr><tr><td><code>l</code> with top serif and curly tail (default for Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-l-flat-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-l-flat-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>l = 'flat-tailed'</code>, <code>cv37 = 9</code></td></tr><tr><td><code>l</code> with curly-then-flat tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-l-serifed-flat-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-l-serifed-flat-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>l = 'serifed-flat-tailed'</code>, <code>cv37 = 10</code></td></tr><tr><td><code>l</code> with top serif and curly-then-flat tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-l-diagonal-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-l-diagonal-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>l = 'diagonal-tailed'</code>, <code>cv37 = 11</code></td></tr><tr><td><code>l</code> with diagonal tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-l-serifed-diagonal-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-l-serifed-diagonal-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>l = 'serifed-diagonal-tailed'</code>, <code>cv37 = 12</code></td></tr><tr><td><code>l</code> with top serif and diagonal tail</td></tr></table>
  - Styles for `m`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-m-normal.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-normal.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'normal'</code>, <code>cv38 = 1</code></td></tr><tr><td><code>m</code> with normal middle leg, touching the baseline (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'top-left-serifed'</code>, <code>cv38 = 2</code></td></tr><tr><td><code>m</code> with serif at top left, normal middle leg touching baseline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'top-left-and-bottom-right-serifed'</code>, <code>cv38 = 3</code></td></tr><tr><td><code>m</code> with serifs at top left and bottom right, normal middle leg touching baseline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'tailed'</code>, <code>cv38 = 4</code></td></tr><tr><td><code>m</code> with normal middle leg, touching the baseline, and a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-tailed-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-tailed-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'tailed-top-left-serifed'</code>, <code>cv38 = 5</code></td></tr><tr><td><code>m</code> with serif at top left, normal middle leg touching baseline, and a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-earless-corner-double-arch.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-earless-corner-double-arch.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'earless-corner-double-arch'</code>, <code>cv38 = 6</code></td></tr><tr><td>Earless (corner top-left) <code>m</code> with normal middle leg touching baseline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-earless-corner-double-arch-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-earless-corner-double-arch-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'earless-corner-double-arch-tailed'</code>, <code>cv38 = 7</code></td></tr><tr><td>Earless (corner top-left) <code>m</code> with normal middle leg touching baseline, and a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-earless-rounded-double-arch.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-earless-rounded-double-arch.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'earless-rounded-double-arch'</code>, <code>cv38 = 8</code></td></tr><tr><td>Earless (rounded top-left) <code>m</code> with normal middle leg touching baseline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-earless-rounded-double-arch-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-earless-rounded-double-arch-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'earless-rounded-double-arch-tailed'</code>, <code>cv38 = 9</code></td></tr><tr><td>Earless (rounded top-left) <code>m</code> with normal middle leg touching baseline, and a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-earless-single-arch.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-earless-single-arch.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'earless-single-arch'</code>, <code>cv38 = 10</code></td></tr><tr><td>Earless (single-arch) <code>m</code> with normal middle leg touching baseline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-earless-single-arch-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-earless-single-arch-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'earless-single-arch-tailed'</code>, <code>cv38 = 11</code></td></tr><tr><td>Earless (single-arch) <code>m</code> with normal middle leg touching baseline, and a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-short-leg.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-short-leg.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'short-leg'</code>, <code>cv38 = 12</code></td></tr><tr><td><code>m</code> with shorter middle leg, like Ubuntu Mono</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-short-leg-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-short-leg-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'short-leg-top-left-serifed'</code>, <code>cv38 = 13</code></td></tr><tr><td><code>m</code> with serif at top left, a shorter middle leg like Ubuntu Mono</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-short-leg-tailed-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-short-leg-tailed-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'short-leg-tailed-top-left-serifed'</code>, <code>cv38 = 14</code></td></tr><tr><td><code>m</code> with serif at top left, a shorter middle leg like Ubuntu Mono, and a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-short-leg-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-short-leg-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'short-leg-tailed'</code>, <code>cv38 = 15</code></td></tr><tr><td><code>m</code> with shorter middle leg, like Ubuntu Mono, and a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-short-leg-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-short-leg-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'short-leg-top-left-and-bottom-right-serifed'</code>, <code>cv38 = 16</code></td></tr><tr><td><code>m</code> with serifs at top left and bottom right, a shorter middle leg like Ubuntu Mono</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-earless-corner-double-arch-short-leg.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-earless-corner-double-arch-short-leg.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'earless-corner-double-arch-short-leg'</code>, <code>cv38 = 17</code></td></tr><tr><td>Earless (corner top-left) <code>m</code> with a shorter middle leg like Ubuntu Mono</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-earless-corner-double-arch-short-leg-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-earless-corner-double-arch-short-leg-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'earless-corner-double-arch-short-leg-tailed'</code>, <code>cv38 = 18</code></td></tr><tr><td>Earless (corner top-left) <code>m</code> with a shorter middle leg like Ubuntu Mono, and a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-earless-rounded-double-arch-short-leg.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-earless-rounded-double-arch-short-leg.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'earless-rounded-double-arch-short-leg'</code>, <code>cv38 = 19</code></td></tr><tr><td>Earless (rounded top-left) <code>m</code> with a shorter middle leg like Ubuntu Mono</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-earless-rounded-double-arch-short-leg-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-earless-rounded-double-arch-short-leg-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'earless-rounded-double-arch-short-leg-tailed'</code>, <code>cv38 = 20</code></td></tr><tr><td>Earless (rounded top-left) <code>m</code> with a shorter middle leg like Ubuntu Mono, and a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-earless-single-arch-short-leg.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-earless-single-arch-short-leg.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'earless-single-arch-short-leg'</code>, <code>cv38 = 21</code></td></tr><tr><td>Earless (single-arch) <code>m</code> with a shorter middle leg like Ubuntu Mono</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-m-earless-single-arch-short-leg-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-m-earless-single-arch-short-leg-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>m = 'earless-single-arch-short-leg-tailed'</code>, <code>cv38 = 22</code></td></tr><tr><td>Earless (single-arch) <code>m</code> with a shorter middle leg like Ubuntu Mono, and a curly tail</td></tr></table>
  - Styles for `n`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-n-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-n-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>n = 'straight'</code>, <code>cv39 = 1</code></td></tr><tr><td><code>n</code> with straight ending (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-n-straight-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-n-straight-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>n = 'straight-motion-serifed'</code>, <code>cv39 = 2</code></td></tr><tr><td><code>n</code> with motion serifs and straight ending</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-n-straight-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-n-straight-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>n = 'straight-top-left-serifed'</code>, <code>cv39 = 3</code></td></tr><tr><td><code>n</code> with motion serifs at top left and straight ending</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-n-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-n-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>n = 'tailed'</code>, <code>cv39 = 4</code></td></tr><tr><td><code>n</code> with a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-n-tailed-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-n-tailed-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>n = 'tailed-motion-serifed'</code>, <code>cv39 = 5</code></td></tr><tr><td><code>n</code> with motion serifs and a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-n-earless-corner-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-n-earless-corner-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>n = 'earless-corner-straight'</code>, <code>cv39 = 6</code></td></tr><tr><td>Earless (corner top-left) <code>n</code> with straight ending</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-n-earless-corner-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-n-earless-corner-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>n = 'earless-corner-tailed'</code>, <code>cv39 = 7</code></td></tr><tr><td>Earless (corner top-left) <code>n</code> with a curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-n-earless-rounded-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-n-earless-rounded-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>n = 'earless-rounded-straight'</code>, <code>cv39 = 8</code></td></tr><tr><td>Earless (rounded top-left) <code>n</code> with straight ending</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-n-earless-rounded-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-n-earless-rounded-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>n = 'earless-rounded-tailed'</code>, <code>cv39 = 9</code></td></tr><tr><td>Earless (rounded top-left) <code>n</code> with a curly tail</td></tr></table>
  - Styles for `p`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-p-eared.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-p-eared.dark.svg#gh-dark-mode-only" width=32/></td><td><code>p = 'eared'</code>, <code>cv40 = 1</code></td></tr><tr><td><code>p</code> with top-left ear (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-p-earless-corner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-p-earless-corner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>p = 'earless-corner'</code>, <code>cv40 = 2</code></td></tr><tr><td><code>p</code> without top-left ear (corner)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-p-earless-rounded.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-p-earless-rounded.dark.svg#gh-dark-mode-only" width=32/></td><td><code>p = 'earless-rounded'</code>, <code>cv40 = 3</code></td></tr><tr><td><code>p</code> without top-left ear (rounded)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-p-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-p-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>p = 'motion-serifed'</code>, <code>cv40 = 4</code></td></tr><tr><td><code>p</code> with motion serifs</td></tr></table>
  - Styles for `q`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-q-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-q-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>q = 'straight'</code>, <code>cv41 = 1</code></td></tr><tr><td><code>q</code> with straight bar (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-q-straight-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-q-straight-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>q = 'straight-motion-serifed'</code>, <code>cv41 = 2</code></td></tr><tr><td><code>q</code> with straight bar and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-q-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-q-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>q = 'tailed'</code>, <code>cv41 = 3</code></td></tr><tr><td><code>q</code> with tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-q-tailed-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-q-tailed-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>q = 'tailed-motion-serifed'</code>, <code>cv41 = 4</code></td></tr><tr><td><code>q</code> with tail and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-q-diagonal-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-q-diagonal-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>q = 'diagonal-tailed'</code>, <code>cv41 = 5</code></td></tr><tr><td><code>q</code> with diagonal tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-q-diagonal-tailed-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-q-diagonal-tailed-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>q = 'diagonal-tailed-motion-serifed'</code>, <code>cv41 = 6</code></td></tr><tr><td><code>q</code> with diagonal tail and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-q-earless-corner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-q-earless-corner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>q = 'earless-corner'</code>, <code>cv41 = 7</code></td></tr><tr><td>Earless (cornered top-left) single-storey <code>q</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-q-earless-corner-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-q-earless-corner-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>q = 'earless-corner-tailed'</code>, <code>cv41 = 8</code></td></tr><tr><td>Earless (cornered top-left) single-storey <code>q</code> with curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-q-earless-corner-diagonal-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-q-earless-corner-diagonal-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>q = 'earless-corner-diagonal-tailed'</code>, <code>cv41 = 9</code></td></tr><tr><td>Earless (cornered top-left) single-storey <code>q</code> with curly diagonal tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-q-earless-rounded.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-q-earless-rounded.dark.svg#gh-dark-mode-only" width=32/></td><td><code>q = 'earless-rounded'</code>, <code>cv41 = 10</code></td></tr><tr><td>Earless (rounded top-left) single-storey <code>q</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-q-earless-rounded-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-q-earless-rounded-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>q = 'earless-rounded-tailed'</code>, <code>cv41 = 11</code></td></tr><tr><td>Earless (rounded top-left) single-storey <code>q</code> with curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-q-earless-rounded-diagonal-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-q-earless-rounded-diagonal-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>q = 'earless-rounded-diagonal-tailed'</code>, <code>cv41 = 12</code></td></tr><tr><td>Earless (rounded top-left) single-storey <code>q</code> with curly diagonal tail</td></tr></table>
  - Styles for `r`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-r-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'serifless'</code>, <code>cv42 = 1</code></td></tr><tr><td>Straight, serif-less <code>r</code> (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'serifed'</code>, <code>cv42 = 2</code></td></tr><tr><td><code>r</code> with serif at both top and bottom (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-top-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-top-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'top-serifed'</code>, <code>cv42 = 3</code></td></tr><tr><td><code>r</code> with serifs at top-left only (default for Slab Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-base-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-base-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'base-serifed'</code>, <code>cv42 = 4</code></td></tr><tr><td><code>r</code> with serifs at top-left only</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-earless-corner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-earless-corner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'earless-corner'</code>, <code>cv42 = 5</code></td></tr><tr><td>Earless (corner top-left), serif-less <code>r</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-earless-corner-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-earless-corner-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'earless-corner-serifed'</code>, <code>cv42 = 6</code></td></tr><tr><td>Earless (corner top-left), serifed <code>r</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-earless-rounded.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-earless-rounded.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'earless-rounded'</code>, <code>cv42 = 7</code></td></tr><tr><td>Earless (rounded top-left), serif-less <code>r</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-earless-rounded-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-earless-rounded-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'earless-rounded-serifed'</code>, <code>cv42 = 8</code></td></tr><tr><td>Earless (rounded top-left), serifed <code>r</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-hookless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-hookless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'hookless'</code>, <code>cv42 = 9</code></td></tr><tr><td>Hookless, serifless <code>r</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-hookless-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-hookless-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'hookless-serifed'</code>, <code>cv42 = 10</code></td></tr><tr><td>Hookless <code>r</code> with top and bottom serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-hookless-top-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-hookless-top-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'hookless-top-serifed'</code>, <code>cv42 = 11</code></td></tr><tr><td>Hookless <code>r</code> with top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-hookless-base-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-hookless-base-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'hookless-base-serifed'</code>, <code>cv42 = 12</code></td></tr><tr><td>Hookless <code>r</code> with bottom serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-corner-hooked.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-corner-hooked.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'corner-hooked'</code>, <code>cv42 = 13</code></td></tr><tr><td><code>r</code> with vertical corner hook downwards</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-corner-hooked-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-corner-hooked-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'corner-hooked-serifed'</code>, <code>cv42 = 14</code></td></tr><tr><td><code>r</code> with vertical corner hook downwards, top and bottom serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-corner-hooked-top-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-corner-hooked-top-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'corner-hooked-top-serifed'</code>, <code>cv42 = 15</code></td></tr><tr><td><code>r</code> with vertical corner hook downwards and top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-corner-hooked-base-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-corner-hooked-base-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'corner-hooked-base-serifed'</code>, <code>cv42 = 16</code></td></tr><tr><td><code>r</code> with vertical corner hook downwards and bottom serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-compact.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-compact.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'compact'</code>, <code>cv42 = 17</code></td></tr><tr><td>Hookless and compact, serifless <code>r</code>. Identical to <code>compact</code> for monospace fonts</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-compact-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-compact-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'compact-serifed'</code>, <code>cv42 = 18</code></td></tr><tr><td>Hookless and compact <code>r</code> with top and bottom serifs. Identical to <code>compact-serifed</code> for monospace fonts</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-compact-top-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-compact-top-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'compact-top-serifed'</code>, <code>cv42 = 19</code></td></tr><tr><td>Hookless and compact <code>r</code> with top serif. Identical to <code>compact-top-serifed</code> for monospace fonts</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-r-compact-base-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-r-compact-base-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>r = 'compact-base-serifed'</code>, <code>cv42 = 20</code></td></tr><tr><td>Hookless and compact <code>r</code> with bottom serif. Identical to <code>compact-base-serifed</code> for monospace fonts</td></tr></table>
  - Styles for `s`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-s-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-s-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>s = 'serifless'</code>, <code>cv43 = 1</code></td></tr><tr><td>Serifless <code>s</code> (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-s-unilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-s-unilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>s = 'unilateral-serifed'</code>, <code>cv43 = 2</code></td></tr><tr><td><code>s</code> with single serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-s-bilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-s-bilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>s = 'bilateral-serifed'</code>, <code>cv43 = 3</code></td></tr><tr><td><code>s</code> with serifs at both end (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-s-unilateral-inward-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-s-unilateral-inward-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>s = 'unilateral-inward-serifed'</code>, <code>cv43 = 4</code></td></tr><tr><td><code>s</code> with single inward serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-s-bilateral-inward-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-s-bilateral-inward-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>s = 'bilateral-inward-serifed'</code>, <code>cv43 = 5</code></td></tr><tr><td><code>s</code> with inward serifs at both end (default for Slab Italic)</td></tr></table>
  - Styles for `t`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-t-standard.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-standard.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'standard'</code>, <code>cv44 = 1</code></td></tr><tr><td>Standard <code>t</code> shape (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-flat-hook.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-flat-hook.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'flat-hook'</code>, <code>cv44 = 2</code></td></tr><tr><td><code>t</code> with flat hook</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-diagonal-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-diagonal-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'diagonal-tailed'</code>, <code>cv44 = 3</code></td></tr><tr><td><code>t</code> with diagonal tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-cross.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-cross.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'cross'</code>, <code>cv44 = 4</code></td></tr><tr><td>Futura-like <code>t</code> shape</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-hookless-asymmetric.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-hookless-asymmetric.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'hookless-asymmetric'</code>, <code>cv44 = 5</code></td></tr><tr><td><code>t</code> without hook and with ony half the cross bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-standard-short-neck.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-standard-short-neck.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'standard-short-neck'</code>, <code>cv44 = 6</code></td></tr><tr><td>Standard <code>t</code> shape with a shorter neck</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-flat-hook-short-neck.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-flat-hook-short-neck.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'flat-hook-short-neck'</code>, <code>cv44 = 7</code></td></tr><tr><td><code>t</code> with flat hook and a slightly shorter neck</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-diagonal-tailed-short-neck.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-diagonal-tailed-short-neck.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'diagonal-tailed-short-neck'</code>, <code>cv44 = 8</code></td></tr><tr><td><code>t</code> with diagonal tail and a shorter neck</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-cross-short-neck.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-cross-short-neck.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'cross-short-neck'</code>, <code>cv44 = 9</code></td></tr><tr><td>Futura-like <code>t</code> shape with a shorter neck</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-hookless-asymmetric-short-neck.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-hookless-asymmetric-short-neck.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'hookless-asymmetric-short-neck'</code>, <code>cv44 = 10</code></td></tr><tr><td><code>t</code> without hook, with ony half the cross bar and a shorter neck</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-standard-short-neck2.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-standard-short-neck2.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'standard-short-neck2'</code>, <code>cv44 = 11</code></td></tr><tr><td>Standard <code>t</code> shape with a more shorter neck</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-flat-hook-short-neck2.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-flat-hook-short-neck2.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'flat-hook-short-neck2'</code>, <code>cv44 = 12</code></td></tr><tr><td><code>t</code> with flat hook and a more shorter neck</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-diagonal-tailed-short-neck2.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-diagonal-tailed-short-neck2.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'diagonal-tailed-short-neck2'</code>, <code>cv44 = 13</code></td></tr><tr><td><code>t</code> with diagonal tail and a more shorter neck</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-cross-short-neck2.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-cross-short-neck2.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'cross-short-neck2'</code>, <code>cv44 = 14</code></td></tr><tr><td>Futura-like <code>t</code> shape with a more shorter neck</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-t-hookless-asymmetric-short-neck2.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-t-hookless-asymmetric-short-neck2.dark.svg#gh-dark-mode-only" width=32/></td><td><code>t = 'hookless-asymmetric-short-neck2'</code>, <code>cv44 = 15</code></td></tr><tr><td><code>t</code> without hook, with ony half the cross bar and a more shorter neck</td></tr></table>
  - Styles for `u`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-u-toothed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-u-toothed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>u = 'toothed'</code>, <code>cv45 = 1</code></td></tr><tr><td>Normal <code>u</code> with bottom-right tooth (default for Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-u-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-u-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>u = 'motion-serifed'</code>, <code>cv45 = 2</code></td></tr><tr><td>Normal <code>u</code> with right bar and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-u-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-u-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>u = 'bottom-right-serifed'</code>, <code>cv45 = 3</code></td></tr><tr><td><code>u</code> with right bar and a slightly curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-u-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-u-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>u = 'tailed'</code>, <code>cv45 = 4</code></td></tr><tr><td><code>u</code> with right bar and a slightly curly tail (default for Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-u-tailed-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-u-tailed-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>u = 'tailed-motion-serifed'</code>, <code>cv45 = 5</code></td></tr><tr><td><code>u</code> with right bar, motion serifs and a slightly curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-u-toothless-corner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-u-toothless-corner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>u = 'toothless-corner'</code>, <code>cv45 = 6</code></td></tr><tr><td>Toothless (corner bottom-right) <code>u</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-u-toothless-corner-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-u-toothless-corner-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>u = 'toothless-corner-motion-serifed'</code>, <code>cv45 = 7</code></td></tr><tr><td>Toothless (corner bottom-right) <code>u</code> with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-u-toothless-rounded.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-u-toothless-rounded.dark.svg#gh-dark-mode-only" width=32/></td><td><code>u = 'toothless-rounded'</code>, <code>cv45 = 8</code></td></tr><tr><td>Toothless (rounded) <code>u</code>, like a smaller uppercase <code>U</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-u-toothless-rounded-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-u-toothless-rounded-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>u = 'toothless-rounded-motion-serifed'</code>, <code>cv45 = 9</code></td></tr><tr><td>Toothless (rounded) <code>u</code> with motion serifs</td></tr></table>
  - Styles for `v`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-v-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-v-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>v = 'straight'</code>, <code>cv46 = 1</code></td></tr><tr><td>Standard, straight <code>v</code> (default for Sans Upright, Sans Italic, Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-v-straight-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-v-straight-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>v = 'straight-motion-serifed'</code>, <code>cv46 = 2</code></td></tr><tr><td>Standard, straight <code>v</code>, with motion serifs (default for Slab Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-v-curly.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-v-curly.dark.svg#gh-dark-mode-only" width=32/></td><td><code>v = 'curly'</code>, <code>cv46 = 3</code></td></tr><tr><td>Slightly curly <code>v</code>, like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-v-curly-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-v-curly-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>v = 'curly-motion-serifed'</code>, <code>cv46 = 4</code></td></tr><tr><td>Slightly curly <code>v</code>, like Iosevka 2.x, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-v-cursive.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-v-cursive.dark.svg#gh-dark-mode-only" width=32/></td><td><code>v = 'cursive'</code>, <code>cv46 = 5</code></td></tr><tr><td>Cursive <code>v</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-v-cursive-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-v-cursive-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>v = 'cursive-serifed'</code>, <code>cv46 = 6</code></td></tr><tr><td>Cursive <code>v</code> with motion serifs</td></tr></table>
  - Styles for `w`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-w-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'straight'</code>, <code>cv47 = 1</code></td></tr><tr><td>Standard, straight <code>w</code> (default for Sans Upright, Sans Italic, Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-straight-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-straight-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'straight-motion-serifed'</code>, <code>cv47 = 2</code></td></tr><tr><td>Standard, straight <code>w</code>, with motion serifs (default for Slab Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-curly.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-curly.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'curly'</code>, <code>cv47 = 3</code></td></tr><tr><td>Slightly curly <code>w</code>, like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-curly-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-curly-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'curly-motion-serifed'</code>, <code>cv47 = 4</code></td></tr><tr><td>Slightly curly <code>w</code>, like Iosevka 2.x, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-straight-flat-top.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-straight-flat-top.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'straight-flat-top'</code>, <code>cv47 = 5</code></td></tr><tr><td>Standard, straight <code>w</code>, and the middle is forced to be aligned the top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-straight-flat-top-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-straight-flat-top-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'straight-flat-top-motion-serifed'</code>, <code>cv47 = 6</code></td></tr><tr><td>Standard, straight <code>w</code>, and the middle is forced to be aligned the top, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-straight-double-v.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-straight-double-v.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'straight-double-v'</code>, <code>cv47 = 7</code></td></tr><tr><td>Straight <code>w</code> looks like double V</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-straight-double-v-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-straight-double-v-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'straight-double-v-motion-serifed'</code>, <code>cv47 = 8</code></td></tr><tr><td>Straight <code>w</code> looks like double V, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-straight-asymmetric.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-straight-asymmetric.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'straight-asymmetric'</code>, <code>cv47 = 9</code></td></tr><tr><td>Straight <code>w</code> looks asymmetric</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-straight-asymmetric-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-straight-asymmetric-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'straight-asymmetric-motion-serifed'</code>, <code>cv47 = 10</code></td></tr><tr><td>Straight <code>w</code> looks asymmetric, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-straight-vertical-sides.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-straight-vertical-sides.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'straight-vertical-sides'</code>, <code>cv47 = 11</code></td></tr><tr><td>Straight <code>w</code> with vertical sides</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-straight-vertical-sides-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-straight-vertical-sides-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'straight-vertical-sides-motion-serifed'</code>, <code>cv47 = 12</code></td></tr><tr><td>Straight <code>w</code> with vertical sides and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-cursive.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-cursive.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'cursive'</code>, <code>cv47 = 13</code></td></tr><tr><td>Cursive <code>w</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-w-cursive-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-w-cursive-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>w = 'cursive-motion-serifed'</code>, <code>cv47 = 14</code></td></tr><tr><td>Cursive <code>w</code> with motion serifs</td></tr></table>
  - Styles for `x`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-x-straight-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-x-straight-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>x = 'straight-serifless'</code>, <code>cv48 = 1</code></td></tr><tr><td>Serifless, straight <code>x</code> (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-x-curly-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-x-curly-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>x = 'curly-motion-serifed'</code>, <code>cv48 = 2</code></td></tr><tr><td>Slightly curly <code>x</code>, like Iosevka 2.x, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-x-straight-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-x-straight-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>x = 'straight-serifed'</code>, <code>cv48 = 3</code></td></tr><tr><td>Straight <code>x</code> with full serifs (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-x-curly-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-x-curly-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>x = 'curly-serifless'</code>, <code>cv48 = 4</code></td></tr><tr><td>Serifless, slightly curly <code>x</code>, like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-x-straight-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-x-straight-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>x = 'straight-motion-serifed'</code>, <code>cv48 = 5</code></td></tr><tr><td>Straight <code>x</code> with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-x-curly-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-x-curly-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>x = 'curly-serifed'</code>, <code>cv48 = 6</code></td></tr><tr><td>Slightly curly <code>x</code>, like Iosevka 2.x, with full serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-x-cursive.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-x-cursive.dark.svg#gh-dark-mode-only" width=32/></td><td><code>x = 'cursive'</code>, <code>cv48 = 7</code></td></tr><tr><td>Cursive <code>x</code> (default for Slab Italic)</td></tr></table>
  - Styles for `y`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-y-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-y-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>y = 'straight'</code>, <code>cv49 = 1</code></td></tr><tr><td>Letter <code>y</code> that is fully straight (default for Sans Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-y-straight-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-y-straight-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>y = 'straight-motion-serifed'</code>, <code>cv49 = 2</code></td></tr><tr><td>Letter <code>y</code> that is fully straight, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-y-straight-turn.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-y-straight-turn.dark.svg#gh-dark-mode-only" width=32/></td><td><code>y = 'straight-turn'</code>, <code>cv49 = 3</code></td></tr><tr><td>Letter <code>y</code> with straight upper and a tail turns leftward (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-y-straight-turn-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-y-straight-turn-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>y = 'straight-turn-motion-serifed'</code>, <code>cv49 = 4</code></td></tr><tr><td>Letter <code>y</code> with straight upper and a tail turns leftward, and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-y-curly.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-y-curly.dark.svg#gh-dark-mode-only" width=32/></td><td><code>y = 'curly'</code>, <code>cv49 = 5</code></td></tr><tr><td>More curly letter <code>y</code>, like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-y-curly-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-y-curly-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>y = 'curly-motion-serifed'</code>, <code>cv49 = 6</code></td></tr><tr><td>More curly letter <code>y</code>, like Iosevka 2.x, with motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-y-curly-turn.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-y-curly-turn.dark.svg#gh-dark-mode-only" width=32/></td><td><code>y = 'curly-turn'</code>, <code>cv49 = 7</code></td></tr><tr><td>More curly letter <code>y</code>, like Iosevka 2.x, with a tail turns leftward</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-y-curly-turn-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-y-curly-turn-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>y = 'curly-turn-motion-serifed'</code>, <code>cv49 = 8</code></td></tr><tr><td>More curly letter <code>y</code>, like Iosevka 2.x, with a tail turns leftward and motion serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-y-cursive.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-y-cursive.dark.svg#gh-dark-mode-only" width=32/></td><td><code>y = 'cursive'</code>, <code>cv49 = 9</code></td></tr><tr><td>Cursive-like <code>y</code> (default for Sans Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-y-cursive-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-y-cursive-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>y = 'cursive-motion-serifed'</code>, <code>cv49 = 10</code></td></tr><tr><td>Cursive-like <code>y</code>, with motion serifs (default for Slab Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-y-cursive-flat-hook.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-y-cursive-flat-hook.dark.svg#gh-dark-mode-only" width=32/></td><td><code>y = 'cursive-flat-hook'</code>, <code>cv49 = 11</code></td></tr><tr><td>Cursive-like <code>y</code> with flat terminal hook</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-y-cursive-flat-hook-motion-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-y-cursive-flat-hook-motion-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>y = 'cursive-flat-hook-motion-serifed'</code>, <code>cv49 = 12</code></td></tr><tr><td>Cursive-like <code>y</code> with flat terminal hook, and motion serifs</td></tr></table>
  - Styles for `z`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-z-straight-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-straight-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'straight-serifless'</code>, <code>cv50 = 1</code></td></tr><tr><td>Straight <code>z</code> without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-straight-serifless-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-straight-serifless-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'straight-serifless-with-crossbar'</code>, <code>cv50 = 2</code></td></tr><tr><td>Straight <code>z</code> with a diagonal crossbar, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-straight-serifless-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-straight-serifless-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'straight-serifless-with-horizontal-crossbar'</code>, <code>cv50 = 3</code></td></tr><tr><td>Straight <code>z</code> with a horizontal crossbar, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-straight-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-straight-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'straight-serifed'</code>, <code>cv50 = 4</code></td></tr><tr><td>Straight <code>z</code> with top and bottom serifs (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-straight-serifed-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-straight-serifed-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'straight-serifed-with-crossbar'</code>, <code>cv50 = 5</code></td></tr><tr><td>Straight <code>z</code> with a diagonal crossbar and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-straight-serifed-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-straight-serifed-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'straight-serifed-with-horizontal-crossbar'</code>, <code>cv50 = 6</code></td></tr><tr><td>Straight <code>z</code> with a horizontal crossbar and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-straight-bottom-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-straight-bottom-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'straight-bottom-serifed'</code>, <code>cv50 = 7</code></td></tr><tr><td>Standard <code>z</code> with serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-straight-bottom-serifed-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-straight-bottom-serifed-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'straight-bottom-serifed-with-crossbar'</code>, <code>cv50 = 8</code></td></tr><tr><td>Standard <code>z</code> with a diagonal crossbar and serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-straight-bottom-serifed-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-straight-bottom-serifed-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'straight-bottom-serifed-with-horizontal-crossbar'</code>, <code>cv50 = 9</code></td></tr><tr><td>Standard <code>z</code> with a horizontal crossbar and serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-straight-top-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-straight-top-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'straight-top-serifed'</code>, <code>cv50 = 10</code></td></tr><tr><td>Standard <code>z</code> with serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-straight-top-serifed-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-straight-top-serifed-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'straight-top-serifed-with-crossbar'</code>, <code>cv50 = 11</code></td></tr><tr><td>Standard <code>z</code> with a diagonal crossbar and serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-straight-top-serifed-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-straight-top-serifed-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'straight-top-serifed-with-horizontal-crossbar'</code>, <code>cv50 = 12</code></td></tr><tr><td>Standard <code>z</code> with a horizontal crossbar and serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-curly-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-curly-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'curly-serifless'</code>, <code>cv50 = 13</code></td></tr><tr><td>Curly <code>z</code> without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-curly-serifless-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-curly-serifless-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'curly-serifless-with-crossbar'</code>, <code>cv50 = 14</code></td></tr><tr><td>Curly <code>z</code> with a diagonal crossbar, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-curly-serifless-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-curly-serifless-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'curly-serifless-with-horizontal-crossbar'</code>, <code>cv50 = 15</code></td></tr><tr><td>Curly <code>z</code> with a horizontal crossbar, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-curly-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-curly-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'curly-serifed'</code>, <code>cv50 = 16</code></td></tr><tr><td>Curly <code>z</code> with top and bottom serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-curly-serifed-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-curly-serifed-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'curly-serifed-with-crossbar'</code>, <code>cv50 = 17</code></td></tr><tr><td>Curly <code>z</code> with a diagonal crossbar and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-curly-serifed-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-curly-serifed-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'curly-serifed-with-horizontal-crossbar'</code>, <code>cv50 = 18</code></td></tr><tr><td>Curly <code>z</code> with a horizontal crossbar and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-curly-bottom-serifed-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-curly-bottom-serifed-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'curly-bottom-serifed-with-crossbar'</code>, <code>cv50 = 19</code></td></tr><tr><td>Curly <code>z</code> with serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-curly-bottom-serifed-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-curly-bottom-serifed-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'curly-bottom-serifed-with-horizontal-crossbar'</code>, <code>cv50 = 20</code></td></tr><tr><td>Curly <code>z</code> with a diagonal crossbar and serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-curly-bottom-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-curly-bottom-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'curly-bottom-serifed'</code>, <code>cv50 = 21</code></td></tr><tr><td>Curly <code>z</code> with a horizontal crossbar and serif at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-curly-top-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-curly-top-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'curly-top-serifed'</code>, <code>cv50 = 22</code></td></tr><tr><td>Curly <code>z</code> with serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-curly-top-serifed-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-curly-top-serifed-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'curly-top-serifed-with-crossbar'</code>, <code>cv50 = 23</code></td></tr><tr><td>Curly <code>z</code> with a diagonal crossbar and serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-curly-top-serifed-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-curly-top-serifed-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'curly-top-serifed-with-horizontal-crossbar'</code>, <code>cv50 = 24</code></td></tr><tr><td>Curly <code>z</code> with a horizontal crossbar and serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-cursive.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-cursive.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'cursive'</code>, <code>cv50 = 25</code></td></tr><tr><td>Cursive <code>z</code> (default for Slab Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-cursive-with-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-cursive-with-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'cursive-with-crossbar'</code>, <code>cv50 = 26</code></td></tr><tr><td>Cursive <code>z</code> with a diagonal cross bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-z-cursive-with-horizontal-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-z-cursive-with-horizontal-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>z = 'cursive-with-horizontal-crossbar'</code>, <code>cv50 = 27</code></td></tr><tr><td>Cursive <code>z</code> with a horizontal cross bar</td></tr></table>
  - Styles for `ſ` (Long-S):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-long-s-bent-hook.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-long-s-bent-hook.dark.svg#gh-dark-mode-only" width=32/></td><td><code>long-s = 'bent-hook'</code>, <code>cv51 = 1</code></td></tr><tr><td>Long-S with standard bending hook (default for Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-long-s-flat-hook.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-long-s-flat-hook.dark.svg#gh-dark-mode-only" width=32/></td><td><code>long-s = 'flat-hook'</code>, <code>cv51 = 2</code></td></tr><tr><td>Long-S with flat hook</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-long-s-bent-hook-descending.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-long-s-bent-hook-descending.dark.svg#gh-dark-mode-only" width=32/></td><td><code>long-s = 'bent-hook-descending'</code>, <code>cv51 = 3</code></td></tr><tr><td>Long-S with standard bending hook and descends baseline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-long-s-flat-hook-descending.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-long-s-flat-hook-descending.dark.svg#gh-dark-mode-only" width=32/></td><td><code>long-s = 'flat-hook-descending'</code>, <code>cv51 = 4</code></td></tr><tr><td>Long-S with flat hook and descends baseline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-long-s-bent-hook-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-long-s-bent-hook-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>long-s = 'bent-hook-tailed'</code>, <code>cv51 = 5</code></td></tr><tr><td>Long-S with standard bending hook and tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-long-s-flat-hook-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-long-s-flat-hook-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>long-s = 'flat-hook-tailed'</code>, <code>cv51 = 6</code></td></tr><tr><td>Long-S with flat hook and tail (default for Italic)</td></tr></table>
  - Styles for `ß` (Eszet):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-eszet-traditional.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eszet-traditional.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eszet = 'traditional'</code>, <code>cv52 = 1</code></td></tr><tr><td>Traditional, Fraktur-like Eszet (<code>ß</code>)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eszet-traditional-descending.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eszet-traditional-descending.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eszet = 'traditional-descending'</code>, <code>cv52 = 2</code></td></tr><tr><td>Traditional, Fraktur-like Eszet (<code>ß</code>) with descending bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eszet-traditional-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eszet-traditional-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eszet = 'traditional-tailed'</code>, <code>cv52 = 3</code></td></tr><tr><td>Traditional, Fraktur-like Eszet (<code>ß</code>) with descending tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eszet-traditional-flat-hook.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eszet-traditional-flat-hook.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eszet = 'traditional-flat-hook'</code>, <code>cv52 = 4</code></td></tr><tr><td>Traditional, Fraktur-like Eszet (<code>ß</code>) with flat hook</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eszet-traditional-flat-hook-descending.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eszet-traditional-flat-hook-descending.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eszet = 'traditional-flat-hook-descending'</code>, <code>cv52 = 5</code></td></tr><tr><td>Traditional, Fraktur-like Eszet (<code>ß</code>) with flat hook and descending bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eszet-traditional-flat-hook-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eszet-traditional-flat-hook-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eszet = 'traditional-flat-hook-tailed'</code>, <code>cv52 = 6</code></td></tr><tr><td>Traditional, Fraktur-like Eszet (<code>ß</code>) with flat hook and descending tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eszet-sulzbacher.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eszet-sulzbacher.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eszet = 'sulzbacher'</code>, <code>cv52 = 7</code></td></tr><tr><td>More modern, beta-like Eszet (<code>ß</code>) (default for Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eszet-sulzbacher-descending.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eszet-sulzbacher-descending.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eszet = 'sulzbacher-descending'</code>, <code>cv52 = 8</code></td></tr><tr><td>More modern, beta-like Eszet (<code>ß</code>) with descending bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eszet-sulzbacher-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eszet-sulzbacher-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eszet = 'sulzbacher-tailed'</code>, <code>cv52 = 9</code></td></tr><tr><td>More modern, beta-like Eszet (<code>ß</code>) with descending tail (default for Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eszet-longs-s-lig.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eszet-longs-s-lig.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eszet = 'longs-s-lig'</code>, <code>cv52 = 10</code></td></tr><tr><td>Eszet (<code>ß</code>) shown as a ligature of long-S (<code>ſ</code>) and <code>s</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eszet-longs-s-lig-descending.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eszet-longs-s-lig-descending.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eszet = 'longs-s-lig-descending'</code>, <code>cv52 = 11</code></td></tr><tr><td>Eszet (<code>ß</code>) shown as a ligature of long-S (<code>ſ</code>) and <code>s</code>, with descending bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eszet-longs-s-lig-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eszet-longs-s-lig-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eszet = 'longs-s-lig-tailed'</code>, <code>cv52 = 12</code></td></tr><tr><td>Eszet (<code>ß</code>) shown as a ligature of long-S (<code>ſ</code>) and <code>s</code>, with descending tail</td></tr></table>
  - Styles for `Λ`, `Δ` (Greek capital Lambda (`Λ`) and Greek capital Delta (`Δ`)):
     <table><tr><td rowspan="2" width="92"><img src="../images/cv-turn-v-straight.light.svg#gh-light-mode-only" width=64/><img src="../images/cv-turn-v-straight.dark.svg#gh-dark-mode-only" width=64/></td><td><code>turn-v = 'straight'</code>, <code>cv53 = 1</code></td></tr><tr><td>Standard, straight Greek capital Lambda (<code>Λ</code>) and Greek capital Delta (<code>Δ</code>) (default)</td></tr><tr><td rowspan="2" width="92"><img src="../images/cv-turn-v-curly.light.svg#gh-light-mode-only" width=64/><img src="../images/cv-turn-v-curly.dark.svg#gh-dark-mode-only" width=64/></td><td><code>turn-v = 'curly'</code>, <code>cv53 = 2</code></td></tr><tr><td>Slightly curly Greek capital Lambda (<code>Λ</code>) and Greek capital Delta (<code>Δ</code>), like Iosevka 2.x</td></tr></table>
  - Styles for `α` (Greek lower Alpha):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-lower-alpha-crossing.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-alpha-crossing.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-alpha = 'crossing'</code>, <code>cv54 = 1</code></td></tr><tr><td>Greek lower Alpha (<code>α</code>) with a cross-like shape at right (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lower-alpha-tailed-barred.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-alpha-tailed-barred.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-alpha = 'tailed-barred'</code>, <code>cv54 = 2</code></td></tr><tr><td>Greek lower Alpha (<code>α</code>) with a straight right bar and tail</td></tr></table>
  - Styles for `δ` (Greek lower Delta):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-lower-delta-rounded.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-delta-rounded.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-delta = 'rounded'</code>, <code>cv55 = 1</code></td></tr><tr><td>Greek lower Delta (<code>δ</code>) with rounded top (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lower-delta-flat-top.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-delta-flat-top.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-delta = 'flat-top'</code>, <code>cv55 = 2</code></td></tr><tr><td>Greek lower Delta (<code>δ</code>) with flat top</td></tr></table>
  - Styles for `Γ` (Greek capital Gamma):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-capital-gamma-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-gamma-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-gamma = 'serifless'</code>, <code>cv56 = 1</code></td></tr><tr><td>Standard capital Gamma (<code>Γ</code>) without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-gamma-top-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-gamma-top-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-gamma = 'top-right-serifed'</code>, <code>cv56 = 2</code></td></tr><tr><td>Standard capital Gamma (<code>Γ</code>) with serifs at top right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-capital-gamma-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-capital-gamma-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>capital-gamma = 'serifed'</code>, <code>cv56 = 3</code></td></tr><tr><td>Standard capital Gamma (<code>Γ</code>) with motion serifs at top and bottom (default for Slab)</td></tr></table>
  - Styles for `ι` (Greek lower Iota):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-lower-iota-zshaped.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-iota-zshaped.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-iota = 'zshaped'</code>, <code>cv57 = 1</code></td></tr><tr><td>Z-shaped Greek lower Iota (<code>ι</code>)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lower-iota-hooky-bottom.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-iota-hooky-bottom.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-iota = 'hooky-bottom'</code>, <code>cv57 = 2</code></td></tr><tr><td>Greek lower Iota (<code>ι</code>) with a sharp-turning horizontal tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lower-iota-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-iota-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-iota = 'tailed'</code>, <code>cv57 = 3</code></td></tr><tr><td>Greek lower Iota (<code>ι</code>) with curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lower-iota-tailed-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-iota-tailed-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-iota = 'tailed-serifed'</code>, <code>cv57 = 4</code></td></tr><tr><td>Greek lower Iota (<code>ι</code>) with top serif and curly tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lower-iota-flat-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-iota-flat-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-iota = 'flat-tailed'</code>, <code>cv57 = 5</code></td></tr><tr><td>Greek lower Iota (<code>ι</code>) with a curly-then-flat tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lower-iota-serifed-flat-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-iota-serifed-flat-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-iota = 'serifed-flat-tailed'</code>, <code>cv57 = 6</code></td></tr><tr><td>Greek lower Iota (<code>ι</code>) with top serif and a curly-then-flat tail (default)</td></tr></table>
  - Styles for `λ` (Greek small Lambda):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-lower-lambda-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-lambda-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-lambda = 'straight'</code>, <code>cv58 = 1</code></td></tr><tr><td>More-straight Greek small Lambda (<code>λ</code>) (default for Sans Upright, Sans Italic, Slab Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lower-lambda-straight-turn.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-lambda-straight-turn.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-lambda = 'straight-turn'</code>, <code>cv58 = 2</code></td></tr><tr><td>Greek small Lambda (<code>λ</code>) with straight upper and a tail turns leftward (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lower-lambda-curly.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-lambda-curly.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-lambda = 'curly'</code>, <code>cv58 = 3</code></td></tr><tr><td>More curly Greek small Lambda (<code>λ</code>), like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lower-lambda-curly-turn.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-lambda-curly-turn.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-lambda = 'curly-turn'</code>, <code>cv58 = 4</code></td></tr><tr><td>More curly Greek small Lambda (<code>λ</code>), like Iosevka 2.x, with a tail turns leftward</td></tr></table>
  - Styles for `μ` (Greek small Mu):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-lower-mu-tailless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-mu-tailless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-mu = 'tailless'</code>, <code>cv59 = 1</code></td></tr><tr><td>Tailless Greek small Mu (<code>μ</code>)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lower-mu-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-mu-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-mu = 'tailed'</code>, <code>cv59 = 2</code></td></tr><tr><td>Tailed Greek small Mu (<code>μ</code>) (default)</td></tr></table>
  - Styles for `ξ` (Greek lower Xi):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-lower-xi-rounded.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-xi-rounded.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-xi = 'rounded'</code>, <code>cv60 = 1</code></td></tr><tr><td>Greek lower Xi (<code>ξ</code>) with rounded top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lower-xi-flat-top.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lower-xi-flat-top.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lower-xi = 'flat-top'</code>, <code>cv60 = 2</code></td></tr><tr><td>Greek lower Xi (<code>ξ</code>) with flat top (default)</td></tr></table>
  - Styles for `Ж` (Cyrillic Capital Zhe):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-zhe-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-zhe-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-zhe = 'straight'</code>, <code>cv61 = 1</code></td></tr><tr><td>Cyrillic Capital Lower Zhe (<code>Ж</code>) with straight legs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-zhe-curly.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-zhe-curly.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-zhe = 'curly'</code>, <code>cv61 = 2</code></td></tr><tr><td>Cyrillic Capital Lower Zhe (<code>Ж</code>) with curly legs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-zhe-symmetric-touching.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-zhe-symmetric-touching.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-zhe = 'symmetric-touching'</code>, <code>cv61 = 3</code></td></tr><tr><td>Cyrillic Capital Lower Zhe (<code>Ж</code>) with symmetric legs touching the vertical bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-zhe-symmetric-connected.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-zhe-symmetric-connected.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-zhe = 'symmetric-connected'</code>, <code>cv61 = 4</code></td></tr><tr><td>Cyrillic Capital Lower Zhe (<code>Ж</code>) with symmetric legs connected to the vertical bar (default)</td></tr></table>
  - Styles for `ж` (Cyrillic Zhe):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-zhe-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-zhe-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-zhe = 'straight'</code>, <code>cv62 = 1</code></td></tr><tr><td>Cyrillic Lower Zhe (<code>ж</code>) with straight legs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-zhe-curly.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-zhe-curly.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-zhe = 'curly'</code>, <code>cv62 = 2</code></td></tr><tr><td>Cyrillic Lower Zhe (<code>ж</code>) with curly legs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-zhe-symmetric-touching.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-zhe-symmetric-touching.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-zhe = 'symmetric-touching'</code>, <code>cv62 = 3</code></td></tr><tr><td>Cyrillic Lower Zhe (<code>ж</code>) with symmetric legs touching the vertical bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-zhe-symmetric-connected.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-zhe-symmetric-connected.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-zhe = 'symmetric-connected'</code>, <code>cv62 = 4</code></td></tr><tr><td>Cyrillic Lower Zhe (<code>ж</code>) with symmetric legs connected to the vertical bar (default)</td></tr></table>
  - Styles for `З` (Cyrillic Capital Ze):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ze-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ze-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ze = 'serifless'</code>, <code>cv63 = 1</code></td></tr><tr><td>Serifless Cyrillic Capital Ze (<code>З</code>) (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ze-unilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ze-unilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ze = 'unilateral-serifed'</code>, <code>cv63 = 2</code></td></tr><tr><td>Cyrillic Capital Ze (<code>З</code>) with serif (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ze-bilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ze-bilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ze = 'bilateral-serifed'</code>, <code>cv63 = 3</code></td></tr><tr><td>Cyrillic Capital Ze (<code>З</code>) with serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ze-unilateral-inward-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ze-unilateral-inward-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ze = 'unilateral-inward-serifed'</code>, <code>cv63 = 4</code></td></tr><tr><td>Cyrillic Capital Ze (<code>З</code>) with inward serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ze-bilateral-inward-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ze-bilateral-inward-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ze = 'bilateral-inward-serifed'</code>, <code>cv63 = 5</code></td></tr><tr><td>Cyrillic Capital Ze (<code>З</code>) with inward serif</td></tr></table>
  - Styles for `з` (Cyrillic Lower Ze):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ze-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ze-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ze = 'serifless'</code>, <code>cv64 = 1</code></td></tr><tr><td>Serifless Cyrillic Lower Ze (<code>з</code>) (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ze-unilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ze-unilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ze = 'unilateral-serifed'</code>, <code>cv64 = 2</code></td></tr><tr><td>Cyrillic Lower Ze (<code>з</code>) with serif (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ze-bilateral-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ze-bilateral-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ze = 'bilateral-serifed'</code>, <code>cv64 = 3</code></td></tr><tr><td>Cyrillic Lower Ze (<code>з</code>) with serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ze-unilateral-inward-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ze-unilateral-inward-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ze = 'unilateral-inward-serifed'</code>, <code>cv64 = 4</code></td></tr><tr><td>Cyrillic Lower Ze (<code>з</code>) with inward serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ze-bilateral-inward-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ze-bilateral-inward-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ze = 'bilateral-inward-serifed'</code>, <code>cv64 = 5</code></td></tr><tr><td>Cyrillic Lower Ze (<code>з</code>) with inward serif</td></tr></table>
  - Styles for `К` (Cyrillic Capital Ka):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-straight-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-straight-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'straight-serifless'</code>, <code>cv65 = 1</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with standard shape</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-straight-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-straight-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'straight-top-left-serifed'</code>, <code>cv65 = 2</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with standard shape and serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-straight-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-straight-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'straight-bottom-right-serifed'</code>, <code>cv65 = 3</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with standard shape and serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-straight-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-straight-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'straight-serifed'</code>, <code>cv65 = 4</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with standard shape and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-straight-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-straight-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'straight-top-left-and-bottom-right-serifed'</code>, <code>cv65 = 5</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with standard shape and serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-curly-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-curly-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'curly-serifless'</code>, <code>cv65 = 6</code></td></tr><tr><td>Slightly curly Cyrillic Capital Ka (<code>К</code>) , like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-curly-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-curly-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'curly-top-left-serifed'</code>, <code>cv65 = 7</code></td></tr><tr><td>Slightly curly Cyrillic Capital Ka (<code>К</code>) , like Iosevka 2.x, with serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-curly-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-curly-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'curly-bottom-right-serifed'</code>, <code>cv65 = 8</code></td></tr><tr><td>Slightly curly Cyrillic Capital Ka (<code>К</code>) , like Iosevka 2.x, with serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-curly-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-curly-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'curly-serifed'</code>, <code>cv65 = 9</code></td></tr><tr><td>Slightly curly Cyrillic Capital Ka (<code>К</code>) , like Iosevka 2.x, with serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-curly-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-curly-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'curly-top-left-and-bottom-right-serifed'</code>, <code>cv65 = 10</code></td></tr><tr><td>Slightly curly Cyrillic Capital Ka (<code>К</code>) , like Iosevka 2.x, with serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-symmetric-touching-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-symmetric-touching-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'symmetric-touching-serifless'</code>, <code>cv65 = 11</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with symmetric legs touching the vertical bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-symmetric-touching-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-symmetric-touching-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'symmetric-touching-top-left-serifed'</code>, <code>cv65 = 12</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with symmetric legs touching the vertical bar, and serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-symmetric-touching-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-symmetric-touching-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'symmetric-touching-bottom-right-serifed'</code>, <code>cv65 = 13</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with symmetric legs touching the vertical bar, and serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-symmetric-touching-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-symmetric-touching-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'symmetric-touching-serifed'</code>, <code>cv65 = 14</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with symmetric legs touching the vertical bar, and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-symmetric-touching-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-symmetric-touching-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'symmetric-touching-top-left-and-bottom-right-serifed'</code>, <code>cv65 = 15</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with symmetric legs touching the vertical bar, and serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-symmetric-connected-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-symmetric-connected-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'symmetric-connected-serifless'</code>, <code>cv65 = 16</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with symmetric legs connected to the vertical bar (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-symmetric-connected-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-symmetric-connected-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'symmetric-connected-top-left-serifed'</code>, <code>cv65 = 17</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with symmetric legs connected to the vertical bar, and serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-symmetric-connected-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-symmetric-connected-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'symmetric-connected-bottom-right-serifed'</code>, <code>cv65 = 18</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with symmetric legs connected to the vertical bar, and serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-symmetric-connected-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-symmetric-connected-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'symmetric-connected-serifed'</code>, <code>cv65 = 19</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with symmetric legs connected to the vertical bar, and serifs (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ka-symmetric-connected-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ka-symmetric-connected-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ka = 'symmetric-connected-top-left-and-bottom-right-serifed'</code>, <code>cv65 = 20</code></td></tr><tr><td>Cyrillic Capital Ka (<code>К</code>) with symmetric legs connected to the vertical bar, and serifs at top left and bottom right</td></tr></table>
  - Styles for `к` (Cyrillic Ka):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-straight-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-straight-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'straight-serifless'</code>, <code>cv66 = 1</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with standard shape, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-straight-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-straight-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'straight-top-left-serifed'</code>, <code>cv66 = 2</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with standard shape and serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-straight-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-straight-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'straight-bottom-right-serifed'</code>, <code>cv66 = 3</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with standard shape and serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-straight-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-straight-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'straight-serifed'</code>, <code>cv66 = 4</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with standard shape and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-straight-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-straight-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'straight-top-left-and-bottom-right-serifed'</code>, <code>cv66 = 5</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with standard shape and serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-curly-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-curly-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'curly-serifless'</code>, <code>cv66 = 6</code></td></tr><tr><td>Slightly curly Cyrillic Lower Ka (<code>к</code>) , like Iosevka 2.x, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-curly-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-curly-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'curly-top-left-serifed'</code>, <code>cv66 = 7</code></td></tr><tr><td>Slightly curly Cyrillic Lower Ka (<code>к</code>) , like Iosevka 2.x, with serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-curly-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-curly-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'curly-bottom-right-serifed'</code>, <code>cv66 = 8</code></td></tr><tr><td>Slightly curly Cyrillic Lower Ka (<code>к</code>) , like Iosevka 2.x, with serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-curly-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-curly-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'curly-serifed'</code>, <code>cv66 = 9</code></td></tr><tr><td>Slightly curly Cyrillic Lower Ka (<code>к</code>) , like Iosevka 2.x, with serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-curly-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-curly-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'curly-top-left-and-bottom-right-serifed'</code>, <code>cv66 = 10</code></td></tr><tr><td>Slightly curly Cyrillic Lower Ka (<code>к</code>) , like Iosevka 2.x, with serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-symmetric-touching-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-symmetric-touching-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'symmetric-touching-serifless'</code>, <code>cv66 = 11</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with symmetric legs touching the vertical bar, and without serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-symmetric-touching-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-symmetric-touching-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'symmetric-touching-top-left-serifed'</code>, <code>cv66 = 12</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with symmetric legs touching the vertical bar, and serifs at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-symmetric-touching-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-symmetric-touching-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'symmetric-touching-bottom-right-serifed'</code>, <code>cv66 = 13</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with symmetric legs touching the vertical bar, and serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-symmetric-touching-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-symmetric-touching-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'symmetric-touching-serifed'</code>, <code>cv66 = 14</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with symmetric legs touching the vertical bar, and serifs</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-symmetric-touching-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-symmetric-touching-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'symmetric-touching-top-left-and-bottom-right-serifed'</code>, <code>cv66 = 15</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with symmetric legs touching the vertical bar, and serifs at top left and bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-symmetric-connected-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-symmetric-connected-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'symmetric-connected-serifless'</code>, <code>cv66 = 16</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with symmetric legs connected to the vertical bar, and without serifs (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-symmetric-connected-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-symmetric-connected-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'symmetric-connected-top-left-serifed'</code>, <code>cv66 = 17</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with symmetric legs connected to the vertical bar, and serifs at top left (default for Slab Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-symmetric-connected-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-symmetric-connected-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'symmetric-connected-bottom-right-serifed'</code>, <code>cv66 = 18</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with symmetric legs connected to the vertical bar, and serifs at bottom right</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-symmetric-connected-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-symmetric-connected-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'symmetric-connected-serifed'</code>, <code>cv66 = 19</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with symmetric legs connected to the vertical bar, and serifs (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ka-symmetric-connected-top-left-and-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ka-symmetric-connected-top-left-and-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ka = 'symmetric-connected-top-left-and-bottom-right-serifed'</code>, <code>cv66 = 20</code></td></tr><tr><td>Cyrillic Lower Ka (<code>к</code>) with symmetric legs connected to the vertical bar, and serifs at top left and bottom right</td></tr></table>
  - Styles for `л` (Cyrillic Lower El):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-el-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-el-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-el = 'straight'</code>, <code>cv67 = 1</code></td></tr><tr><td>Cyrillic Lower El (<code>л</code>) with standard shape (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-el-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-el-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-el = 'tailed'</code>, <code>cv67 = 2</code></td></tr><tr><td>Cyrillic Lower El (<code>л</code>) with tail shape</td></tr></table>
  - Styles for `н` (Cyrillic Lower En):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-en-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-en-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-en = 'serifless'</code>, <code>cv68 = 1</code></td></tr><tr><td>Cyrillic Lower En (<code>н</code>) with standard shape (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-en-tailed-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-en-tailed-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-en = 'tailed-serifless'</code>, <code>cv68 = 2</code></td></tr><tr><td>Cyrillic Lower En (<code>н</code>) with tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-en-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-en-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-en = 'top-left-serifed'</code>, <code>cv68 = 3</code></td></tr><tr><td>Cyrillic Lower En (<code>н</code>) with outward serifs only at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-en-tailed-top-left-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-en-tailed-top-left-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-en = 'tailed-top-left-serifed'</code>, <code>cv68 = 4</code></td></tr><tr><td>Cyrillic Lower En (<code>н</code>) with tail and outward serifs only at top left</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-en-top-left-bottom-right-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-en-top-left-bottom-right-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-en = 'top-left-bottom-right-serifed'</code>, <code>cv68 = 5</code></td></tr><tr><td>Cyrillic Lower En (<code>н</code>) with outward serifs only at top left and bottom right (default for Slab Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-en-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-en-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-en = 'serifed'</code>, <code>cv68 = 6</code></td></tr><tr><td>Cyrillic Lower En (<code>н</code>) with full serifs (default for Slab Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-en-tailed-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-en-tailed-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-en = 'tailed-serifed'</code>, <code>cv68 = 7</code></td></tr><tr><td>Cyrillic Lower En (<code>н</code>) with tail and full serifs</td></tr></table>
  - Styles for `ф` (Cyrillic Lower Ef):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ef-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ef-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ef = 'serifless'</code>, <code>cv69 = 1</code></td></tr><tr><td>Cyrillic Lower Ef (<code>ф</code>) with standard shape and without serifs (default for Sans Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ef-cursive.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ef-cursive.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ef = 'cursive'</code>, <code>cv69 = 2</code></td></tr><tr><td>Cyrillic Lower Ef (<code>ф</code>) with cursive shape (default for Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ef-top-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ef-top-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ef = 'top-serifed'</code>, <code>cv69 = 3</code></td></tr><tr><td>Cyrillic Lower Ef (<code>ф</code>) with standard shape and serif at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ef-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ef-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ef = 'serifed'</code>, <code>cv69 = 4</code></td></tr><tr><td>Cyrillic Lower Ef (<code>ф</code>) with standard shape and serifs at top and bottom (default for Slab Upright)</td></tr></table>
  - Styles for `ч` (Cyrillic Lower Che):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-che-standard.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-che-standard.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-che = 'standard'</code>, <code>cv70 = 1</code></td></tr><tr><td>Cyrillic Lower Che (<code>ч</code>) with standard shape (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-che-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-che-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-che = 'tailed'</code>, <code>cv70 = 2</code></td></tr><tr><td>Cyrillic Lower Che (<code>ч</code>) with tail</td></tr></table>
  - Styles for `У` (Cyrillic Capital U):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-u-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-u-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-u = 'straight'</code>, <code>cv71 = 1</code></td></tr><tr><td>Cyrillic capital U (<code>У</code>) that is fully straight (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-u-straight-turn.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-u-straight-turn.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-u = 'straight-turn'</code>, <code>cv71 = 2</code></td></tr><tr><td>Cyrillic capital U (<code>У</code>) with straight upper and a tail turns leftward (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-u-curly.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-u-curly.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-u = 'curly'</code>, <code>cv71 = 3</code></td></tr><tr><td>More curly Cyrillic capital U (<code>У</code>), like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-u-curly-turn.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-u-curly-turn.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-u = 'curly-turn'</code>, <code>cv71 = 4</code></td></tr><tr><td>More curly Cyrillic capital U (<code>У</code>), like Iosevka 2.x, with a tail turns leftward</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-u-cursive.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-u-cursive.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-u = 'cursive'</code>, <code>cv71 = 5</code></td></tr><tr><td>Cursive-like Cyrillic capital U (<code>У</code>)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-u-cursive-flat-hook.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-u-cursive-flat-hook.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-u = 'cursive-flat-hook'</code>, <code>cv71 = 6</code></td></tr><tr><td>Cursive-like Cyrillic capital U (<code>У</code>) with flat terminal hook</td></tr></table>
  - Styles for `Я` (Cyrillic Capital Ya):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ya-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ya-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ya = 'straight'</code>, <code>cv72 = 1</code></td></tr><tr><td>Standard, straight-leg Cyrillic Capital Ya (<code>Я</code>) (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ya-curly.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ya-curly.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ya = 'curly'</code>, <code>cv72 = 2</code></td></tr><tr><td>Slightly curly-legged Cyrillic Capital Ya (<code>Я</code>), like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ya-standing.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ya-standing.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ya = 'standing'</code>, <code>cv72 = 3</code></td></tr><tr><td>Cyrillic Capital Ya (<code>Я</code>) with near-vertical standing leg</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ya-straight-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ya-straight-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ya = 'straight-open'</code>, <code>cv72 = 4</code></td></tr><tr><td>Standard, straight-leg Cyrillic Capital Ya (<code>Я</code>), with open contour at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ya-curly-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ya-curly-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ya = 'curly-open'</code>, <code>cv72 = 5</code></td></tr><tr><td> Slightly curly-legged Cyrillic Capital Ya (<code>Я</code>), like Iosevka 2.x, with open contour at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-capital-ya-standing-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-capital-ya-standing-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-capital-ya = 'standing-open'</code>, <code>cv72 = 6</code></td></tr><tr><td>Cyrillic Capital Ya (<code>Я</code>) with near-vertical standing leg, with open contour at bottom</td></tr></table>
  - Styles for `я` (Cyrillic Lower Ya):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ya-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ya-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ya = 'straight'</code>, <code>cv73 = 1</code></td></tr><tr><td>Standard, straight-leg Cyrillic Lower Ya (<code>я</code>) (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ya-straight-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ya-straight-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ya = 'straight-tailed'</code>, <code>cv73 = 2</code></td></tr><tr><td>Standard, straight-leg Cyrillic Lower Ya (<code>я</code>), with tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ya-curly.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ya-curly.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ya = 'curly'</code>, <code>cv73 = 3</code></td></tr><tr><td>Slightly curly-legged Cyrillic Lower Ya (<code>я</code>), like Iosevka 2.x</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ya-curly-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ya-curly-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ya = 'curly-tailed'</code>, <code>cv73 = 4</code></td></tr><tr><td> Slightly curly-legged Cyrillic Lower Ya (<code>я</code>), like Iosevka 2.x, with tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ya-standing.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ya-standing.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ya = 'standing'</code>, <code>cv73 = 5</code></td></tr><tr><td>Cyrillic Lower Ya (<code>я</code>) with near-vertical standing leg</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ya-standing-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ya-standing-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ya = 'standing-tailed'</code>, <code>cv73 = 6</code></td></tr><tr><td>Cyrillic Lower Ya (<code>я</code>) with near-vertical standing leg</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ya-straight-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ya-straight-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ya = 'straight-open'</code>, <code>cv73 = 7</code></td></tr><tr><td>Standard, straight-leg Cyrillic Lower Ya (<code>я</code>), with open contour at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ya-straight-open-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ya-straight-open-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ya = 'straight-open-tailed'</code>, <code>cv73 = 8</code></td></tr><tr><td>Standard, straight-leg Cyrillic Lower Ya (<code>я</code>), with open contour at bottom and tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ya-curly-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ya-curly-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ya = 'curly-open'</code>, <code>cv73 = 9</code></td></tr><tr><td> Slightly curly-legged Cyrillic Lower Ya (<code>я</code>), like Iosevka 2.x, with open contour at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ya-curly-open-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ya-curly-open-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ya = 'curly-open-tailed'</code>, <code>cv73 = 10</code></td></tr><tr><td> Slightly curly-legged Cyrillic Lower Ya (<code>я</code>), like Iosevka 2.x, with open contour at bottom and tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ya-standing-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ya-standing-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ya = 'standing-open'</code>, <code>cv73 = 11</code></td></tr><tr><td>Cyrillic Lower Ya (<code>я</code>) with near-vertical standing leg, with open contour at bottom</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-ya-standing-open-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-ya-standing-open-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-ya = 'standing-open-tailed'</code>, <code>cv73 = 12</code></td></tr><tr><td>Cyrillic Lower Ya (<code>я</code>) with near-vertical standing leg, with open contour at bottom and tail</td></tr></table>
  - Styles for `ь` (Cyrillic Lower Yeri and related letters):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-yeri-corner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-yeri-corner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-yeri = 'corner'</code>, <code>cv74 = 1</code></td></tr><tr><td>Cyrillic Lower Yeri (<code>ь</code>) with corner at bottom left (default for Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-yeri-round.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-yeri-round.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-yeri = 'round'</code>, <code>cv74 = 2</code></td></tr><tr><td>Cyrillic Lower Yeri (<code>ь</code>) with rounded shape (default for Sans Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-yeri-cursive.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-yeri-cursive.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-yeri = 'cursive'</code>, <code>cv74 = 3</code></td></tr><tr><td>Cyrillic Lower Yeri (<code>ь</code>) with cursive shape (default for Slab Italic)</td></tr></table>
  - Styles for `ы` (Cyrillic Lower Yery):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-yery-corner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-yery-corner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-yery = 'corner'</code>, <code>cv75 = 1</code></td></tr><tr><td>Cyrillic Lower Yery (<code>ы</code>) with corner at bottom left (default for Upright)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-yery-corner-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-yery-corner-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-yery = 'corner-tailed'</code>, <code>cv75 = 2</code></td></tr><tr><td>Cyrillic Lower Yery (<code>ы</code>) with corner at bottom left and tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-yery-round.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-yery-round.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-yery = 'round'</code>, <code>cv75 = 3</code></td></tr><tr><td>Cyrillic Lower Yery (<code>ы</code>) with rounded shape (default for Sans Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-yery-round-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-yery-round-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-yery = 'round-tailed'</code>, <code>cv75 = 4</code></td></tr><tr><td>Cyrillic Lower Yery (<code>ы</code>) with rounded shape and tail</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-yery-cursive.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-yery-cursive.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-yery = 'cursive'</code>, <code>cv75 = 5</code></td></tr><tr><td>Cyrillic Lower Yery (<code>ы</code>) with cursive shape (default for Slab Italic)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cyrl-yery-cursive-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cyrl-yery-cursive-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cyrl-yery = 'cursive-tailed'</code>, <code>cv75 = 6</code></td></tr><tr><td>Cyrillic Lower Yery (<code>ы</code>) with cursive shape and tail</td></tr></table>
  - Styles for `0`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-zero-unslashed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-unslashed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'unslashed'</code>, <code>cv76 = 1</code></td></tr><tr><td>O-like Zero (<code>0</code>)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-slashed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-slashed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'slashed'</code>, <code>cv76 = 2</code></td></tr><tr><td>Slashed Zero (<code>0</code>) (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-reverse-slashed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-reverse-slashed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'reverse-slashed'</code>, <code>cv76 = 3</code></td></tr><tr><td>Reverse-slashed Zero (<code>0</code>)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-dotted.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-dotted.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'dotted'</code>, <code>cv76 = 4</code></td></tr><tr><td>Dotted Zero (<code>0</code>)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-long-dotted.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-long-dotted.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'long-dotted'</code>, <code>cv76 = 5</code></td></tr><tr><td>Long-dotted Zero (<code>0</code>) like Hack</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-slashed-split.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-slashed-split.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'slashed-split'</code>, <code>cv76 = 6</code></td></tr><tr><td>Slashed Zero (<code>0</code>) with slash separated from the outline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-reverse-slashed-split.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-reverse-slashed-split.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'reverse-slashed-split'</code>, <code>cv76 = 7</code></td></tr><tr><td>Reverse-slashed Zero (<code>0</code>) with slash separated from the outline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-unslashed-oval.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-unslashed-oval.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'unslashed-oval'</code>, <code>cv76 = 8</code></td></tr><tr><td>O-like Zero (<code>0</code>) but more round</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-slashed-oval.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-slashed-oval.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'slashed-oval'</code>, <code>cv76 = 9</code></td></tr><tr><td>Slashed Zero (<code>0</code>) but more round</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-reverse-slashed-oval.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-reverse-slashed-oval.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'reverse-slashed-oval'</code>, <code>cv76 = 10</code></td></tr><tr><td>Reverse-slashed Zero (<code>0</code>) but more round</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-dotted-oval.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-dotted-oval.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'dotted-oval'</code>, <code>cv76 = 11</code></td></tr><tr><td>Dotted Zero (<code>0</code>) but more round</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-long-dotted-oval.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-long-dotted-oval.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'long-dotted-oval'</code>, <code>cv76 = 12</code></td></tr><tr><td>Long-dotted Zero (<code>0</code>) like Hack but more round</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-slashed-split-oval.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-slashed-split-oval.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'slashed-split-oval'</code>, <code>cv76 = 13</code></td></tr><tr><td>Slashed Zero (<code>0</code>) with slash separated from the outline and more round</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-zero-reverse-slashed-split-oval.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-zero-reverse-slashed-split-oval.dark.svg#gh-dark-mode-only" width=32/></td><td><code>zero = 'reverse-slashed-split-oval'</code>, <code>cv76 = 14</code></td></tr><tr><td>Reverse-slashed Zero (<code>0</code>) with slash separated from the outline and more round</td></tr></table>
  - Styles for `1`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-one-line.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-one-line.dark.svg#gh-dark-mode-only" width=32/></td><td><code>one = 'line'</code>, <code>cv77 = 1</code></td></tr><tr><td><code>1</code> drawn just like a straight line</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-one-no-base.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-one-no-base.dark.svg#gh-dark-mode-only" width=32/></td><td><code>one = 'no-base'</code>, <code>cv77 = 2</code></td></tr><tr><td><code>1</code> without bottom serif (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-one-base.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-one-base.dark.svg#gh-dark-mode-only" width=32/></td><td><code>one = 'base'</code>, <code>cv77 = 3</code></td></tr><tr><td><code>1</code> with bottom serif (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-one-no-base-long-top-serif.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-one-no-base-long-top-serif.dark.svg#gh-dark-mode-only" width=32/></td><td><code>one = 'no-base-long-top-serif'</code>, <code>cv77 = 4</code></td></tr><tr><td><code>1</code> without bottom serif and with a long top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-one-base-long-top-serif.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-one-base-long-top-serif.dark.svg#gh-dark-mode-only" width=32/></td><td><code>one = 'base-long-top-serif'</code>, <code>cv77 = 5</code></td></tr><tr><td><code>1</code> with bottom serif and a long top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-one-no-base-flat-top-serif.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-one-no-base-flat-top-serif.dark.svg#gh-dark-mode-only" width=32/></td><td><code>one = 'no-base-flat-top-serif'</code>, <code>cv77 = 6</code></td></tr><tr><td><code>1</code> without bottom serif and with a flat top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-one-base-flat-top-serif.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-one-base-flat-top-serif.dark.svg#gh-dark-mode-only" width=32/></td><td><code>one = 'base-flat-top-serif'</code>, <code>cv77 = 7</code></td></tr><tr><td><code>1</code> with bottom serif and a flat top serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-one-no-base-top-cut.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-one-no-base-top-cut.dark.svg#gh-dark-mode-only" width=32/></td><td><code>one = 'no-base-top-cut'</code>, <code>cv77 = 8</code></td></tr><tr><td><code>1</code> without bottom serif and with a diagonal cut at top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-one-base-top-cut.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-one-base-top-cut.dark.svg#gh-dark-mode-only" width=32/></td><td><code>one = 'base-top-cut'</code>, <code>cv77 = 9</code></td></tr><tr><td><code>1</code> with bottom serif and a diagonal cut at top</td></tr></table>
  - Styles for `2`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-two-straight-neck.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-two-straight-neck.dark.svg#gh-dark-mode-only" width=32/></td><td><code>two = 'straight-neck'</code>, <code>cv78 = 1</code></td></tr><tr><td><code>2</code> with straight neck</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-two-curly-neck.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-two-curly-neck.dark.svg#gh-dark-mode-only" width=32/></td><td><code>two = 'curly-neck'</code>, <code>cv78 = 2</code></td></tr><tr><td><code>2</code> with curly neck (default)</td></tr></table>
  - Styles for `3`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-three-flat-top.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-three-flat-top.dark.svg#gh-dark-mode-only" width=32/></td><td><code>three = 'flat-top'</code>, <code>cv79 = 1</code></td></tr><tr><td>Flat top <code>3</code> (Like Museo Sans / Montserrat)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-three-two-arcs.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-three-two-arcs.dark.svg#gh-dark-mode-only" width=32/></td><td><code>three = 'two-arcs'</code>, <code>cv79 = 2</code></td></tr><tr><td>Arched top <code>3</code> (default)</td></tr></table>
  - Styles for `4`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-four-closed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-four-closed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>four = 'closed'</code>, <code>cv80 = 1</code></td></tr><tr><td><code>4</code> with closed contour</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-four-closed-non-crossing.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-four-closed-non-crossing.dark.svg#gh-dark-mode-only" width=32/></td><td><code>four = 'closed-non-crossing'</code>, <code>cv80 = 2</code></td></tr><tr><td><code>4</code> with closed contour but the horizontal bar does not overflow the vertical bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-four-semi-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-four-semi-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>four = 'semi-open'</code>, <code>cv80 = 3</code></td></tr><tr><td><code>4</code> with semi-open contour (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-four-semi-open-non-crossing.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-four-semi-open-non-crossing.dark.svg#gh-dark-mode-only" width=32/></td><td><code>four = 'semi-open-non-crossing'</code>, <code>cv80 = 4</code></td></tr><tr><td><code>4</code> with semi-open contour but the horizontal bar does not overflow the vertical bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-four-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-four-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>four = 'open'</code>, <code>cv80 = 5</code></td></tr><tr><td><code>4</code> with open contour</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-four-open-non-crossing.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-four-open-non-crossing.dark.svg#gh-dark-mode-only" width=32/></td><td><code>four = 'open-non-crossing'</code>, <code>cv80 = 6</code></td></tr><tr><td><code>4</code> with open contour but the horizontal bar does not overflow the vertical bar</td></tr></table>
  - Styles for `5`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-five-vertical-upper-left-bar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-five-vertical-upper-left-bar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>five = 'vertical-upper-left-bar'</code>, <code>cv81 = 1</code></td></tr><tr><td><code>5</code> with a vertical upper-left bar (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-five-oblique-upper-left-bar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-five-oblique-upper-left-bar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>five = 'oblique-upper-left-bar'</code>, <code>cv81 = 2</code></td></tr><tr><td><code>5</code> with an oblique upper-left bar</td></tr></table>
  - Styles for `6`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-six-closed-contour.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-six-closed-contour.dark.svg#gh-dark-mode-only" width=32/></td><td><code>six = 'closed-contour'</code>, <code>cv82 = 1</code></td></tr><tr><td><code>6</code> with a more closed contour</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-six-open-contour.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-six-open-contour.dark.svg#gh-dark-mode-only" width=32/></td><td><code>six = 'open-contour'</code>, <code>cv82 = 2</code></td></tr><tr><td><code>6</code> with a more open contour</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-six-straight-bar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-six-straight-bar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>six = 'straight-bar'</code>, <code>cv82 = 3</code></td></tr><tr><td><code>6</code> with a straight bar (default)</td></tr></table>
  - Styles for `7`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-seven-straight-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-seven-straight-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>seven = 'straight-serifless'</code>, <code>cv83 = 1</code></td></tr><tr><td><code>7</code> with straight stem and without serif (default for Sans)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-seven-straight-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-seven-straight-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>seven = 'straight-serifed'</code>, <code>cv83 = 2</code></td></tr><tr><td><code>7</code> with straight stem and initial serif (default for Slab)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-seven-bend-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-seven-bend-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>seven = 'bend-serifless'</code>, <code>cv83 = 3</code></td></tr><tr><td><code>7</code> with bend stem and without serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-seven-bend-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-seven-bend-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>seven = 'bend-serifed'</code>, <code>cv83 = 4</code></td></tr><tr><td><code>7</code> with bend stem and initial serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-seven-curly-serifless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-seven-curly-serifless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>seven = 'curly-serifless'</code>, <code>cv83 = 5</code></td></tr><tr><td><code>7</code> with curly stem and without serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-seven-curly-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-seven-curly-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>seven = 'curly-serifed'</code>, <code>cv83 = 6</code></td></tr><tr><td><code>7</code> with curly stem and initial serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-seven-straight-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-seven-straight-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>seven = 'straight-crossbar'</code>, <code>cv83 = 7</code></td></tr><tr><td><code>7</code> with straight stem and crossbar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-seven-straight-crossbar-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-seven-straight-crossbar-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>seven = 'straight-crossbar-serifed'</code>, <code>cv83 = 8</code></td></tr><tr><td><code>7</code> with straight stem, crossbar and initial serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-seven-bend-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-seven-bend-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>seven = 'bend-crossbar'</code>, <code>cv83 = 9</code></td></tr><tr><td><code>7</code> with bend stem and crossbar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-seven-bend-crossbar-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-seven-bend-crossbar-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>seven = 'bend-crossbar-serifed'</code>, <code>cv83 = 10</code></td></tr><tr><td><code>7</code> with bend stem, crossbar and initial serif</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-seven-curly-crossbar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-seven-curly-crossbar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>seven = 'curly-crossbar'</code>, <code>cv83 = 11</code></td></tr><tr><td><code>7</code> with curly stem and crossbar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-seven-curly-crossbar-serifed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-seven-curly-crossbar-serifed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>seven = 'curly-crossbar-serifed'</code>, <code>cv83 = 12</code></td></tr><tr><td><code>7</code> with curly stem, crossbar and initial serif</td></tr></table>
  - Styles for `8`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-eight-crossing.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eight-crossing.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eight = 'crossing'</code>, <code>cv84 = 1</code></td></tr><tr><td><code>8</code> with crossing middle part (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eight-two-circles.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eight-two-circles.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eight = 'two-circles'</code>, <code>cv84 = 2</code></td></tr><tr><td><code>8</code> looks like two circles joined together</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-eight-crossing-asymmetric.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-eight-crossing-asymmetric.dark.svg#gh-dark-mode-only" width=32/></td><td><code>eight = 'crossing-asymmetric'</code>, <code>cv84 = 3</code></td></tr><tr><td><code>8</code> looks asymmetric crossing middle part</td></tr></table>
  - Styles for `9`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-nine-closed-contour.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-nine-closed-contour.dark.svg#gh-dark-mode-only" width=32/></td><td><code>nine = 'closed-contour'</code>, <code>cv85 = 1</code></td></tr><tr><td><code>9</code> with a more closed contour</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-nine-open-contour.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-nine-open-contour.dark.svg#gh-dark-mode-only" width=32/></td><td><code>nine = 'open-contour'</code>, <code>cv85 = 2</code></td></tr><tr><td><code>9</code> with a more open contour</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-nine-straight-bar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-nine-straight-bar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>nine = 'straight-bar'</code>, <code>cv85 = 3</code></td></tr><tr><td><code>9</code> with a straight bar (default)</td></tr></table>
  - Styles for `öẋ`, `ij` (Dot and Comma shape in diacritics):
     <table><tr><td rowspan="2" width="188"><img src="../images/cv-diacritic-dot-round.light.svg#gh-light-mode-only" width=160/><img src="../images/cv-diacritic-dot-round.dark.svg#gh-dark-mode-only" width=160/></td><td><code>diacritic-dot = 'round'</code>, <code>cv86 = 1</code></td></tr><tr><td>Dots and Commas in diacritics are round (default)</td></tr><tr><td rowspan="2" width="188"><img src="../images/cv-diacritic-dot-square.light.svg#gh-light-mode-only" width=160/><img src="../images/cv-diacritic-dot-square.dark.svg#gh-dark-mode-only" width=160/></td><td><code>diacritic-dot = 'square'</code>, <code>cv86 = 2</code></td></tr><tr><td>Dots and Commas in diacritics are square</td></tr></table>
  - Styles for `.,`, `:;` (Dot and Comma shape in punctuations and symbols):
     <table><tr><td rowspan="2" width="220"><img src="../images/cv-punctuation-dot-round.light.svg#gh-light-mode-only" width=192/><img src="../images/cv-punctuation-dot-round.dark.svg#gh-dark-mode-only" width=192/></td><td><code>punctuation-dot = 'round'</code>, <code>cv87 = 1</code></td></tr><tr><td>Small punctuations (like <code>.</code>, <code>,</code>) use round dots (default)</td></tr><tr><td rowspan="2" width="220"><img src="../images/cv-punctuation-dot-square.light.svg#gh-light-mode-only" width=192/><img src="../images/cv-punctuation-dot-square.dark.svg#gh-dark-mode-only" width=192/></td><td><code>punctuation-dot = 'square'</code>, <code>cv87 = 2</code></td></tr><tr><td>Small punctuations (like <code>.</code>, <code>,</code>) use square dots</td></tr></table>
  - Styles for `~`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-tilde-high.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-tilde-high.dark.svg#gh-dark-mode-only" width=32/></td><td><code>tilde = 'high'</code>, <code>cv88 = 1</code></td></tr><tr><td>Higher tilde <code>~</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-tilde-low.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-tilde-low.dark.svg#gh-dark-mode-only" width=32/></td><td><code>tilde = 'low'</code>, <code>cv88 = 2</code></td></tr><tr><td>Lower tilde <code>~</code> (default)</td></tr></table>
  - Styles for `*`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-asterisk-penta-high.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-asterisk-penta-high.dark.svg#gh-dark-mode-only" width=32/></td><td><code>asterisk = 'penta-high'</code>, <code>cv89 = 1</code></td></tr><tr><td>High five-pointed asterisk <code>*</code> (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-asterisk-penta-mid.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-asterisk-penta-mid.dark.svg#gh-dark-mode-only" width=32/></td><td><code>asterisk = 'penta-mid'</code>, <code>cv89 = 2</code></td></tr><tr><td>Medium-height five-pointed asterisk <code>*</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-asterisk-penta-low.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-asterisk-penta-low.dark.svg#gh-dark-mode-only" width=32/></td><td><code>asterisk = 'penta-low'</code>, <code>cv89 = 3</code></td></tr><tr><td>Low five-pointed asterisk <code>*</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-asterisk-flip-penta-high.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-asterisk-flip-penta-high.dark.svg#gh-dark-mode-only" width=32/></td><td><code>asterisk = 'flip-penta-high'</code>, <code>cv89 = 4</code></td></tr><tr><td>High five-pointed and turned asterisk <code>*</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-asterisk-flip-penta-mid.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-asterisk-flip-penta-mid.dark.svg#gh-dark-mode-only" width=32/></td><td><code>asterisk = 'flip-penta-mid'</code>, <code>cv89 = 5</code></td></tr><tr><td>Medium-height five-pointed and turned asterisk <code>*</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-asterisk-flip-penta-low.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-asterisk-flip-penta-low.dark.svg#gh-dark-mode-only" width=32/></td><td><code>asterisk = 'flip-penta-low'</code>, <code>cv89 = 6</code></td></tr><tr><td>Low five-pointed and turned asterisk <code>*</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-asterisk-hex-high.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-asterisk-hex-high.dark.svg#gh-dark-mode-only" width=32/></td><td><code>asterisk = 'hex-high'</code>, <code>cv89 = 7</code></td></tr><tr><td>High six-pointed asterisk <code>*</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-asterisk-hex-mid.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-asterisk-hex-mid.dark.svg#gh-dark-mode-only" width=32/></td><td><code>asterisk = 'hex-mid'</code>, <code>cv89 = 8</code></td></tr><tr><td>Medium-height six-pointed asterisk <code>*</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-asterisk-hex-low.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-asterisk-hex-low.dark.svg#gh-dark-mode-only" width=32/></td><td><code>asterisk = 'hex-low'</code>, <code>cv89 = 9</code></td></tr><tr><td>Low six-pointed asterisk <code>*</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-asterisk-turn-hex-high.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-asterisk-turn-hex-high.dark.svg#gh-dark-mode-only" width=32/></td><td><code>asterisk = 'turn-hex-high'</code>, <code>cv89 = 10</code></td></tr><tr><td>High turned six-pointed asterisk <code>*</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-asterisk-turn-hex-mid.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-asterisk-turn-hex-mid.dark.svg#gh-dark-mode-only" width=32/></td><td><code>asterisk = 'turn-hex-mid'</code>, <code>cv89 = 11</code></td></tr><tr><td>Medium-height turned six-pointed asterisk <code>*</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-asterisk-turn-hex-low.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-asterisk-turn-hex-low.dark.svg#gh-dark-mode-only" width=32/></td><td><code>asterisk = 'turn-hex-low'</code>, <code>cv89 = 12</code></td></tr><tr><td>Low turned six-pointed asterisk <code>*</code></td></tr></table>
  - Styles for `_`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-underscore-above-baseline.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-underscore-above-baseline.dark.svg#gh-dark-mode-only" width=32/></td><td><code>underscore = 'above-baseline'</code>, <code>cv90 = 1</code></td></tr><tr><td>Extra-high <code>_</code>, placed right below baseline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-underscore-high.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-underscore-high.dark.svg#gh-dark-mode-only" width=32/></td><td><code>underscore = 'high'</code>, <code>cv90 = 2</code></td></tr><tr><td>Higher underscore <code>_</code>, placed right below baseline (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-underscore-low.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-underscore-low.dark.svg#gh-dark-mode-only" width=32/></td><td><code>underscore = 'low'</code>, <code>cv90 = 3</code></td></tr><tr><td>Lower underscore <code>_</code>, placed right above descender line</td></tr></table>
  - Styles for `^`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-caret-high.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-caret-high.dark.svg#gh-dark-mode-only" width=32/></td><td><code>caret = 'high'</code>, <code>cv91 = 1</code></td></tr><tr><td>Higher circumflex <code>^</code></td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-caret-medium.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-caret-medium.dark.svg#gh-dark-mode-only" width=32/></td><td><code>caret = 'medium'</code>, <code>cv91 = 2</code></td></tr><tr><td>Lower circumflex <code>^</code> (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-caret-low.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-caret-low.dark.svg#gh-dark-mode-only" width=32/></td><td><code>caret = 'low'</code>, <code>cv91 = 3</code></td></tr><tr><td>Lower circumflex <code>^</code></td></tr></table>
  - Styles for `(`, `)`:
     <table><tr><td rowspan="2" width="92"><img src="../images/cv-paren-normal.light.svg#gh-light-mode-only" width=64/><img src="../images/cv-paren-normal.dark.svg#gh-dark-mode-only" width=64/></td><td><code>paren = 'normal'</code>, <code>cv92 = 1</code></td></tr><tr><td>Parenthesis with normal contour (default)</td></tr><tr><td rowspan="2" width="92"><img src="../images/cv-paren-large-contour.light.svg#gh-light-mode-only" width=64/><img src="../images/cv-paren-large-contour.dark.svg#gh-dark-mode-only" width=64/></td><td><code>paren = 'large-contour'</code>, <code>cv92 = 2</code></td></tr><tr><td>Parenthesis with larger contour, like that in Monaco</td></tr><tr><td rowspan="2" width="92"><img src="../images/cv-paren-flat-arc.light.svg#gh-light-mode-only" width=64/><img src="../images/cv-paren-flat-arc.dark.svg#gh-dark-mode-only" width=64/></td><td><code>paren = 'flat-arc'</code>, <code>cv92 = 3</code></td></tr><tr><td>Parenthesis with flat arc, like that in JetBrains Mono</td></tr></table>
  - Styles for `{`, `}`:
     <table><tr><td rowspan="2" width="92"><img src="../images/cv-brace-straight.light.svg#gh-light-mode-only" width=64/><img src="../images/cv-brace-straight.dark.svg#gh-dark-mode-only" width=64/></td><td><code>brace = 'straight'</code>, <code>cv93 = 1</code></td></tr><tr><td>More straight braces</td></tr><tr><td rowspan="2" width="92"><img src="../images/cv-brace-curly.light.svg#gh-light-mode-only" width=64/><img src="../images/cv-brace-curly.dark.svg#gh-dark-mode-only" width=64/></td><td><code>brace = 'curly'</code>, <code>cv93 = 2</code></td></tr><tr><td>More curly braces (default)</td></tr><tr><td rowspan="2" width="92"><img src="../images/cv-brace-curly-flat-boundary.light.svg#gh-light-mode-only" width=64/><img src="../images/cv-brace-curly-flat-boundary.dark.svg#gh-dark-mode-only" width=64/></td><td><code>brace = 'curly-flat-boundary'</code>, <code>cv93 = 3</code></td></tr><tr><td>Curly braces with flat boundary shape</td></tr></table>
  - Styles for `#`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-number-sign-upright.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-number-sign-upright.dark.svg#gh-dark-mode-only" width=32/></td><td><code>number-sign = 'upright'</code>, <code>cv94 = 1</code></td></tr><tr><td>Number sign with vertical bars (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-number-sign-slanted.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-number-sign-slanted.dark.svg#gh-dark-mode-only" width=32/></td><td><code>number-sign = 'slanted'</code>, <code>cv94 = 2</code></td></tr><tr><td>Number sign with slanted bars</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-number-sign-upright-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-number-sign-upright-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>number-sign = 'upright-open'</code>, <code>cv94 = 3</code></td></tr><tr><td>Number sign with vertical bars and open inner</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-number-sign-slanted-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-number-sign-slanted-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>number-sign = 'slanted-open'</code>, <code>cv94 = 4</code></td></tr><tr><td>Number sign with slanted bars and open inner</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-number-sign-upright-tall.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-number-sign-upright-tall.dark.svg#gh-dark-mode-only" width=32/></td><td><code>number-sign = 'upright-tall'</code>, <code>cv94 = 5</code></td></tr><tr><td>Number sign with vertical bars and taller than digits</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-number-sign-slanted-tall.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-number-sign-slanted-tall.dark.svg#gh-dark-mode-only" width=32/></td><td><code>number-sign = 'slanted-tall'</code>, <code>cv94 = 6</code></td></tr><tr><td>Number sign with slanted bars and taller than digits</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-number-sign-upright-open-tall.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-number-sign-upright-open-tall.dark.svg#gh-dark-mode-only" width=32/></td><td><code>number-sign = 'upright-open-tall'</code>, <code>cv94 = 7</code></td></tr><tr><td>Number sign with vertical bars, open inner, and taller than digits</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-number-sign-slanted-open-tall.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-number-sign-slanted-open-tall.dark.svg#gh-dark-mode-only" width=32/></td><td><code>number-sign = 'slanted-open-tall'</code>, <code>cv94 = 8</code></td></tr><tr><td>Number sign with slanted bars, open inner, and taller than digits</td></tr></table>
  - Styles for `&`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-ampersand-closed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ampersand-closed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ampersand = 'closed'</code>, <code>cv95 = 1</code></td></tr><tr><td>Ampersand (<code>&amp;</code>) with a closed contour (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-ampersand-upper-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ampersand-upper-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ampersand = 'upper-open'</code>, <code>cv95 = 2</code></td></tr><tr><td>Ampersand (<code>&amp;</code>) with an open contour at upper half</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-ampersand-lower-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ampersand-lower-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ampersand = 'lower-open'</code>, <code>cv95 = 3</code></td></tr><tr><td>Ampersand (<code>&amp;</code>) with an open contour at lower half</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-ampersand-flat-top.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ampersand-flat-top.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ampersand = 'flat-top'</code>, <code>cv95 = 4</code></td></tr><tr><td>Ampersand (<code>&amp;</code>) drawn with a flat top</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-ampersand-et-toothed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ampersand-et-toothed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ampersand = 'et-toothed'</code>, <code>cv95 = 5</code></td></tr><tr><td>Ampersand (<code>&amp;</code>) drawn like a ligature of Ɛ and t with tooth</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-ampersand-et-toothless-corner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ampersand-et-toothless-corner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ampersand = 'et-toothless-corner'</code>, <code>cv95 = 6</code></td></tr><tr><td>Ampersand (<code>&amp;</code>) drawn like a ligature of Ɛ and t without tooth (corner)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-ampersand-et-toothless-rounded.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ampersand-et-toothless-rounded.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ampersand = 'et-toothless-rounded'</code>, <code>cv95 = 7</code></td></tr><tr><td>Ampersand (<code>&amp;</code>) drawn like a ligature of Ɛ and t without tooth (rounded)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-ampersand-et-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ampersand-et-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ampersand = 'et-tailed'</code>, <code>cv95 = 8</code></td></tr><tr><td>Ampersand (<code>&amp;</code>) drawn like a ligature of Ɛ and t with tail</td></tr></table>
  - Styles for `@`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-at-threefold.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-at-threefold.dark.svg#gh-dark-mode-only" width=32/></td><td><code>at = 'threefold'</code>, <code>cv96 = 1</code></td></tr><tr><td>The three-fold At symbol (<code>@</code>) (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-at-fourfold.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-at-fourfold.dark.svg#gh-dark-mode-only" width=32/></td><td><code>at = 'fourfold'</code>, <code>cv96 = 2</code></td></tr><tr><td>The traditional, four-fold At symbol (<code>@</code>)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-at-fourfold-solid-inner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-at-fourfold-solid-inner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>at = 'fourfold-solid-inner'</code>, <code>cv96 = 3</code></td></tr><tr><td>The four-fold At symbol (<code>@</code>) with inner loop being solid</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-at-threefold-tall.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-at-threefold-tall.dark.svg#gh-dark-mode-only" width=32/></td><td><code>at = 'threefold-tall'</code>, <code>cv96 = 4</code></td></tr><tr><td>The three-fold At symbol (<code>@</code>) with taller outline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-at-fourfold-tall.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-at-fourfold-tall.dark.svg#gh-dark-mode-only" width=32/></td><td><code>at = 'fourfold-tall'</code>, <code>cv96 = 5</code></td></tr><tr><td>The traditional, four-fold At symbol (<code>@</code>) with taller outline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-at-fourfold-solid-inner-tall.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-at-fourfold-solid-inner-tall.dark.svg#gh-dark-mode-only" width=32/></td><td><code>at = 'fourfold-solid-inner-tall'</code>, <code>cv96 = 6</code></td></tr><tr><td>The four-fold At symbol (<code>@</code>) with inner loop being solid and taller outline</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-at-short.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-at-short.dark.svg#gh-dark-mode-only" width=32/></td><td><code>at = 'short'</code>, <code>cv96 = 7</code></td></tr><tr><td>The shorter, Fira-like At symbol (<code>@</code>)</td></tr></table>
  - Styles for `$`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-dollar-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-dollar-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>dollar = 'open'</code>, <code>cv97 = 1</code></td></tr><tr><td>Dollar symbol with open contour</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-dollar-through.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-dollar-through.dark.svg#gh-dark-mode-only" width=32/></td><td><code>dollar = 'through'</code>, <code>cv97 = 2</code></td></tr><tr><td>Dollar symbol with strike-through vertical bar (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-dollar-interrupted.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-dollar-interrupted.dark.svg#gh-dark-mode-only" width=32/></td><td><code>dollar = 'interrupted'</code>, <code>cv97 = 3</code></td></tr><tr><td>Dollar symbol with strike-through vertical bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-dollar-open-cap.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-dollar-open-cap.dark.svg#gh-dark-mode-only" width=32/></td><td><code>dollar = 'open-cap'</code>, <code>cv97 = 4</code></td></tr><tr><td>Dollar symbol with open contour, not exceeding baseline and ascender</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-dollar-through-cap.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-dollar-through-cap.dark.svg#gh-dark-mode-only" width=32/></td><td><code>dollar = 'through-cap'</code>, <code>cv97 = 5</code></td></tr><tr><td>Dollar symbol with strike-through vertical bar, not exceeding baseline and ascender</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-dollar-interrupted-cap.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-dollar-interrupted-cap.dark.svg#gh-dark-mode-only" width=32/></td><td><code>dollar = 'interrupted-cap'</code>, <code>cv97 = 6</code></td></tr><tr><td>Dollar symbol with strike-through vertical bar, not exceeding baseline and ascender</td></tr></table>
  - Styles for `%`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-percent-dots.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-percent-dots.dark.svg#gh-dark-mode-only" width=32/></td><td><code>percent = 'dots'</code>, <code>cv98 = 1</code></td></tr><tr><td>Percent <code>%</code> with rectangular dots</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-percent-rings-segmented-slash.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-percent-rings-segmented-slash.dark.svg#gh-dark-mode-only" width=32/></td><td><code>percent = 'rings-segmented-slash'</code>, <code>cv98 = 2</code></td></tr><tr><td>Percent <code>%</code> with rings and segmented slash (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-percent-rings-continuous-slash.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-percent-rings-continuous-slash.dark.svg#gh-dark-mode-only" width=32/></td><td><code>percent = 'rings-continuous-slash'</code>, <code>cv98 = 3</code></td></tr><tr><td>Percent <code>%</code> with rings and continuous bar</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-percent-rings-continuous-slash-also-connected.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-percent-rings-continuous-slash-also-connected.dark.svg#gh-dark-mode-only" width=32/></td><td><code>percent = 'rings-continuous-slash-also-connected'</code>, <code>cv98 = 4</code></td></tr><tr><td>Percent <code>%</code> with rings and continuous bar and the slash in <code>%</code> is also connected to the top-left ring</td></tr></table>
  - Styles for `|`:
     <table><tr><td rowspan="2" width="92"><img src="../images/cv-bar-natural-slope.light.svg#gh-light-mode-only" width=64/><img src="../images/cv-bar-natural-slope.dark.svg#gh-dark-mode-only" width=64/></td><td><code>bar = 'natural-slope'</code>, <code>cv99 = 1</code></td></tr><tr><td>Bar punctuations (<code>|</code>) has a natural slope under italics and oblique (default)</td></tr><tr><td rowspan="2" width="92"><img src="../images/cv-bar-force-upright.light.svg#gh-light-mode-only" width=64/><img src="../images/cv-bar-force-upright.dark.svg#gh-dark-mode-only" width=64/></td><td><code>bar = 'force-upright'</code>, <code>cv99 = 2</code></td></tr><tr><td>Bar punctuations (<code>|</code>) is forced upright under italics and oblique</td></tr></table>
  - Styles for `'`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-ascii-single-quote-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ascii-single-quote-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ascii-single-quote = 'straight'</code>, <code>VXSA = 1</code></td></tr><tr><td>Show ASCII quote (<code>"</code>) as short vertical straight bar. (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-ascii-single-quote-raised-comma.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ascii-single-quote-raised-comma.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ascii-single-quote = 'raised-comma'</code>, <code>VXSA = 2</code></td></tr><tr><td>Show ASCII quote (<code>"</code>) as raised comma.</td></tr></table>
  - Styles for `` ` ``:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-ascii-grave-straight.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ascii-grave-straight.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ascii-grave = 'straight'</code>, <code>VXSB = 1</code></td></tr><tr><td>Show ASCII grave (<code>`</code>) as short diagonal straight bar. (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-ascii-grave-raised-inverse-comma.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ascii-grave-raised-inverse-comma.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ascii-grave = 'raised-inverse-comma'</code>, <code>VXSB = 2</code></td></tr><tr><td>Show ASCII grave (<code>`</code>) as raised comma.</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-ascii-grave-raised-turn-comma.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-ascii-grave-raised-turn-comma.dark.svg#gh-dark-mode-only" width=32/></td><td><code>ascii-grave = 'raised-turn-comma'</code>, <code>VXSB = 3</code></td></tr><tr><td>Show ASCII grave (<code>`</code>) as raised turned comma, identical to curly open single quote symbols (U+2018).</td></tr></table>
  - Styles for `?`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-question-smooth.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-question-smooth.dark.svg#gh-dark-mode-only" width=32/></td><td><code>question = 'smooth'</code>, <code>VXSC = 1</code></td></tr><tr><td>Smooth question mark (<code>?</code>) (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-question-corner.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-question-corner.dark.svg#gh-dark-mode-only" width=32/></td><td><code>question = 'corner'</code>, <code>VXSC = 2</code></td></tr><tr><td>Question mark (<code>?</code>) with a corner at middle</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-question-corner-flat-hooked.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-question-corner-flat-hooked.dark.svg#gh-dark-mode-only" width=32/></td><td><code>question = 'corner-flat-hooked'</code>, <code>VXSC = 3</code></td></tr><tr><td>Question mark (<code>?</code>) with a corner at middle and flat hook</td></tr></table>
  - Styles for `¶`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-pilcrow-high.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-pilcrow-high.dark.svg#gh-dark-mode-only" width=32/></td><td><code>pilcrow = 'high'</code>, <code>VXSD = 1</code></td></tr><tr><td>Higher pilcrow sign <code>¶</code> (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-pilcrow-low.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-pilcrow-low.dark.svg#gh-dark-mode-only" width=32/></td><td><code>pilcrow = 'low'</code>, <code>VXSD = 2</code></td></tr><tr><td>Lower pilcrow sign <code>¶</code></td></tr></table>
  - Styles for `¢`:
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-cent-open.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cent-open.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cent = 'open'</code>, <code>VXSE = 1</code></td></tr><tr><td>Cent sign (<code>¢</code>) with open contour</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cent-through.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cent-through.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cent = 'through'</code>, <code>VXSE = 2</code></td></tr><tr><td>Cent sign (<code>¢</code>) with vertical bar all through the <code>c</code> part (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-cent-bar-interrupted.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-cent-bar-interrupted.dark.svg#gh-dark-mode-only" width=32/></td><td><code>cent = 'bar-interrupted'</code>, <code>VXSE = 3</code></td></tr><tr><td>Cent sign (<code>¢</code>) with vertical bar breaks at center</td></tr></table>
  - Styles for `∂` (Partial derivative symbol):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-partial-derivative-straight-bar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-partial-derivative-straight-bar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>partial-derivative = 'straight-bar'</code>, <code>VXSF = 1</code></td></tr><tr><td>The upper bar of the partial derivative symbol is straight (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-partial-derivative-curly-bar.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-partial-derivative-curly-bar.dark.svg#gh-dark-mode-only" width=32/></td><td><code>partial-derivative = 'curly-bar'</code>, <code>VXSF = 2</code></td></tr><tr><td>The upper bar of the partial derivative symbol is curly</td></tr></table>
  - Styles for `μ` (Greek small Mu):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-micro-sign-tailless.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-micro-sign-tailless.dark.svg#gh-dark-mode-only" width=32/></td><td><code>micro-sign = 'tailless'</code>, <code>VXSG = 1</code></td></tr><tr><td>Tailless Greek small Mu (<code>μ</code>) (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-micro-sign-tailed.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-micro-sign-tailed.dark.svg#gh-dark-mode-only" width=32/></td><td><code>micro-sign = 'tailed'</code>, <code>VXSG = 2</code></td></tr><tr><td>Tailed Greek small Mu (<code>μ</code>)</td></tr></table>
  - Styles for `<=`, `>=` (Less-equal and Greater-equal ligations):
     <table><tr><td rowspan="2" width="92"><img src="../images/cv-lig-ltgteq-flat.light.svg#gh-light-mode-only" width=64/><img src="../images/cv-lig-ltgteq-flat.dark.svg#gh-dark-mode-only" width=64/></td><td><code>lig-ltgteq = 'flat'</code>, <code>VXLA = 1</code></td></tr><tr><td>The lower bar of <code>&lt;=</code> and <code>&gt;=</code> ligation is flat (default)</td></tr><tr><td rowspan="2" width="92"><img src="../images/cv-lig-ltgteq-slanted.light.svg#gh-light-mode-only" width=64/><img src="../images/cv-lig-ltgteq-slanted.dark.svg#gh-dark-mode-only" width=64/></td><td><code>lig-ltgteq = 'slanted'</code>, <code>VXLA = 2</code></td></tr><tr><td>The lower bar of <code>&lt;=</code> and <code>&gt;=</code> ligation is slanted</td></tr></table>
  - Styles for `!=` (Not-equal ligations):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-lig-neq-vertical.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-neq-vertical.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-neq = 'vertical'</code>, <code>VXLB = 1</code></td></tr><tr><td>The bar in inequality (<code>!=</code>, etc.) ligation is vertical</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lig-neq-slightly-slanted.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-neq-slightly-slanted.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-neq = 'slightly-slanted'</code>, <code>VXLB = 2</code></td></tr><tr><td>The bar in inequality (<code>!=</code>, etc.) ligation is slightly slanted (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lig-neq-more-slanted.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-neq-more-slanted.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-neq = 'more-slanted'</code>, <code>VXLB = 3</code></td></tr><tr><td>The bar in inequality (<code>!=</code>, etc.) ligation is more slanted</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lig-neq-vertical-dotted.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-neq-vertical-dotted.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-neq = 'vertical-dotted'</code>, <code>VXLB = 4</code></td></tr><tr><td>The bar in inequality (<code>!=</code>, etc.) ligation is vertical, and with a dot at bottom for ligations built from exclamation sign (<code>!</code>)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lig-neq-slightly-slanted-dotted.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-neq-slightly-slanted-dotted.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-neq = 'slightly-slanted-dotted'</code>, <code>VXLB = 5</code></td></tr><tr><td>The bar in inequality (<code>!=</code>, etc.) ligation is slightly slanted, and with a dot at bottom for ligations built from exclamation sign (<code>!</code>)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lig-neq-more-slanted-dotted.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-neq-more-slanted-dotted.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-neq = 'more-slanted-dotted'</code>, <code>VXLB = 6</code></td></tr><tr><td>The bar in inequality (<code>!=</code>, etc.) ligation is more slanted, and with a dot at bottom for ligations built from exclamation sign (<code>!</code>)</td></tr></table>
  - Styles for `==` (Equality ligations):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-lig-equal-chain-with-notch.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-equal-chain-with-notch.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-equal-chain = 'with-notch'</code>, <code>VXLC = 1</code></td></tr><tr><td>The bars in equality (<code>==</code>, etc.) ligation have notches in the middle (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lig-equal-chain-without-notch.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-equal-chain-without-notch.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-equal-chain = 'without-notch'</code>, <code>VXLC = 2</code></td></tr><tr><td>The bars in equality (<code>==</code>, etc.) ligation do not have notches in the middle</td></tr></table>
  - Styles for `--` (Hyphen-minus ligations):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-lig-hyphen-chain-with-notch.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-hyphen-chain-with-notch.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-hyphen-chain = 'with-notch'</code>, <code>VXLD = 1</code></td></tr><tr><td>The bars in connected hyphen-minus (<code>--</code>, etc.) ligation have notches in the middle (default)</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lig-hyphen-chain-without-notch.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-hyphen-chain-without-notch.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-hyphen-chain = 'without-notch'</code>, <code>VXLD = 2</code></td></tr><tr><td>The bars in connected hyphen-minus (<code>--</code>, etc.) ligation do not have notches in the middle</td></tr></table>
  - Styles for `=>` (Double arrow ligation):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-lig-double-arrow-bar-with-notch.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-double-arrow-bar-with-notch.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-double-arrow-bar = 'with-notch'</code>, <code>VXLE = 1</code></td></tr><tr><td>The bars in double arrow (<code>=&gt;</code>, etc.) ligation have notches in the middle</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lig-double-arrow-bar-without-notch.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-double-arrow-bar-without-notch.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-double-arrow-bar = 'without-notch'</code>, <code>VXLE = 2</code></td></tr><tr><td>The bars in double arrow (<code>=&gt;</code>, etc.) ligation do not have notches in the middle (default)</td></tr></table>
  - Styles for `->` (Single arrow ligation):
     <table><tr><td rowspan="2" width="60"><img src="../images/cv-lig-single-arrow-bar-with-notch.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-single-arrow-bar-with-notch.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-single-arrow-bar = 'with-notch'</code>, <code>VXLF = 1</code></td></tr><tr><td>The bars in single arrow (<code>=&gt;</code>, etc.) ligation have notches in the middle</td></tr><tr><td rowspan="2" width="60"><img src="../images/cv-lig-single-arrow-bar-without-notch.light.svg#gh-light-mode-only" width=32/><img src="../images/cv-lig-single-arrow-bar-without-notch.dark.svg#gh-dark-mode-only" width=32/></td><td><code>lig-single-arrow-bar = 'without-notch'</code>, <code>VXLF = 2</code></td></tr><tr><td>The bars in single arrow (<code>=&gt;</code>, etc.) ligation do not have notches in the middle (default)</td></tr></table>

<!-- END Section-Cherry-Picking-Styles -->

#### Configuring Weights, Widths and Slopes

Subsection `weights` is used to change the weight grades that the custom family needs. It is a dictionary of either strings formatted in `default.<weight>` format, meaning reusing a default weight grade, or sub-objects with properties:

* `shape`: Number, configures the weight grade of the glyphs' shapes.
* `menu`: Integer, configures the weight grade used when naming fonts.
* `css`: Integer, configures the weight grade used in web font CSS.

Subsection `widths` is used to change the width grades that the custom family needs. It is a dictionary of either strings formatted in `default.<width>` format, meaning reusing a default width grade, or sub-objects with properties:

* `shape`: Number, configures the width of the glyphs' shapes, measured in 1/1000 em.
* `menu`: Integer, configures the width grade used when naming fonts. The valid values are `1` to `9`, inclusive.
* `css`: String, configures the [font-stretch](https://developer.mozilla.org/en-US/docs/Web/CSS/font-stretch) value used in web font CSS.

Subsection `slopes` is used to change the slope angles and grades that the custom family needs. It is a dictionary of either strings formatted in `default.<slope>` format, meaning reusing a default slope grade, or sub-objects with properties:

* `angle`: Number, configures the slope angle in degrees. The valid vales are `0` to `15`, inclusive.
* `shape`: String from `upright`, `italic` or `oblique`. Configures the slope used for variant selection. 
* `menu`: String from `upright`, `italic` or `oblique`. Configures the slope grade used when naming fonts.
* `css`: String from `normal`, `italic` or `oblique`. Configures the [CSS font-style](https://developer.mozilla.org/zh-CN/docs/Web/CSS/font-style) value.

Subsection `slopes` is a simple string-to-string dictionary maps slopes (`upright`, `italic` or `oblique`) to [CSS font-style](https://developer.mozilla.org/zh-CN/docs/Web/CSS/font-style) values, represented in string.

#### Compatibility Ligatures

Certain software, notably Emacs, relies on pre-encoded ligatures instead of OpenType to provide ligations. Iosevka could be configured with additional subsection `compatibility-ligatures`, being an array of records with following fields:

* `unicode`: The PUA code point being assigned to.
* `featureTag`: The feature tag to compute ligations.
* `sequence`: The source character sequence.

A sample of compatibility ligature config is:

```toml
[[buildPlans.iosevka-custom.compatibility-ligatures]]
unicode = 57600 # 0xE100
featureTag = 'calt'
sequence = '<*>'
```

#### Metric Override

Subsection `metric-override` provides ability to override certain metric values, if you *reallly* want to. Adding this section is **strongly discouraged** as it may introduce broken geometry or broken shapes.

| Property | Unit | Default Value | Meaning |
|----------|------|---------|----------|
| `cap` | emu | 735 | Height of `H`. |
| `ascender` | emu | 735 | Height of `b`. |
| `xHeight` | emu | 520 | Height of `x`. |
| `sb` | emu | (*varies, 60 for Regular*) | Width of common side-bearings. |
| `accentWidth` | emu | 200 | Width of accent marks. |
| `accentClearance` | emu | 72 | Vertical clearance of accent marks to the base. |
| `accentHeight` | emu | 176 | Height of accent marks. |
| `accentStackOffset` | emu | 220 | Offset height of accent mark stack. |
| `dotSize` | emu | (*varies, 125 for regular*) | Size of dots in diacritic marks. |
| `periodSize` | emu | (*varies, 140 for regular*) | Size of dots in period. |
| `leading` | emu | 1250 | Built-in line height. |
| `symbolMid` | emu | 340 | Height of the center of hyphen (`-`). |
| `parenSize` | emu | 966 | Height of Parentheses. |
| `winMetricAscenderPad` | emu | 0 | Additional pad for Win metrics’ ascender to avoid clipping in legacy Windows applications. |
| `winMetricDescenderPad` | emu | 0 | Additional pad for Win metrics’ descender to avoid clipping in legacy Windows applications. |
| `powerlineScaleX`, `powerlineScaleY` | (*ratio*) | 1 | X and Y scale of Powerline glyphs. |
| `powerlineShiftX`, `powerlineShiftY` | emu | 0 | X and Y shift of Powerline glyphs. |
| `onumZeroHeightRatio` | (*ratio*) | 1.145 | Ratio of height of `0` under `onum` feature, to the height of `x`. |
| `essRatio` | (*ratio*) | (*varies, 1.12 for Regular*) | Ratio of the thickness of the neck of `S`/`s`/`?`, to the normal stroke width. `essRatioUpper`, `essRatioLower` and `rssRatioQuestion` will override this value for corresponded glyph categories when set. |
| `essRatioUpper` | (*ratio*) | (*varies, 1.12 for Regular*) | Ratio of the thickness of the neck of `S`, to the normal stroke width. |
| `essRatioLower` | (*ratio*) | (*varies, 1.12 for Regular*) | Ratio of the thickness of the neck of `s`, to the normal stroke width. |
| `essRatioQuestion` | (*ratio*) | (*varies, 1.12 for Regular*) | Ratio of the thickness of the neck of `?`, to the normal stroke width. |
| `archDepth` | emu | (*varies, 195 for Regular*) | Depth of the curve segment of arches / O rings in capital letters. |
| `smallArchDepth` | emu | (*varies, 200 for Regular*) | Depth of the curve segment of arches / O rings in small letters. |

The values of each item could be either a number, or a string representing an expression so that it could be different for different instance fonts, or depending on default values. The syntax of valid expressions are:

```
Expression -> Term (('+' | '-') Term)*
Term       -> Factor (('*' | '/') Factor)*
Factor     -> ('+' | '-')* Primitive
Primitive  -> Literal
            | Call
            | Binding
            | Group
            | List
Literal    -> ['0'..'9']+ ('.' ['0'..'9']+)?
Identifier -> ['A'..'Z', 'a'..'z', '_']+
Call       -> Identifier '(' Expression (',' Expression)* ')'
List       -> Identifier '[' Expression (',' Expression)* ']'
Binding    -> Identifier
```

Valid identifiers include:
 * `weight`: being the weight grade;
 * `width`: being the characters' unit width, measured in em-units;
 * `slopeAngle`: being the slope angle in degrees;
 * Default value of all overridable metrics, prefixed with `default_`, i.e., default `cap` value will be accessable thorugh `default_cap`.

Valid functions include:
 * `blend`(_x_, \[_x1_, _y1_\], \[_x2_, _y2_\], ...): Perform a smooth interpolation through data pairs \[_x1_, _y1_\], \[_x2_, _y2_\], ..., against parameter _x_.

For example, the following configuration:

```toml
[buildPlans.iosevka-custom.metric-override]
leading = 1500
sb = 'default_sb * 1.0625 + 15'
dotSize = 'blend(weight, [100, 50], [400, 125], [900, 180])'
```

will:

 * Override line height to `1500` em-unit;
 * Override the sidebearing value by its value multiplied by `1.0625` then added with `15`.
 * Override the dot size by a interpolation against weight: at thin (`100`) being `50`, at regular (`400`) being `125`, and at heavy (`900`) being `180`.

#### Sample Configuration

A sample configuration could be found at [private-build-plans.sample.toml](https://github.com/be5invis/Iosevka/blob/master/private-build-plans.sample.toml).

### TTC Building

It is possible to create a customized TTC build by using the following method:

 1. Add a collect plan into `private-build-plans.toml`, with a `from` field containing all the TTF groups it needs:
   ```toml
   [collectPlans.iosevka-custom]
   from = ["iosevka-custom1", "iosevka-custom-2"]
   ```
 2. Run build with the following command:
  - `npm run build -- ttc::iosevka-custom`: Create TTCs from collection `iosevka-custom`; The file will be saved into `dist/.ttc`.
  - `npm run build -- super-ttc::iosevka-custom`: Create a single-file TTC from collection `iosevka-custom`; The file will be saved into `dist/.super-ttc`.
