#include <cctbx/sgtbx/reference_settings.h>

namespace cctbx { namespace sgtbx { namespace reference_settings {

namespace wyckoff {

namespace {

  // Based on ~rwgk/spgr/altwyk/altwyk-9706061705:
  //   python reference-altwyk.py > reference-only-altwyk-9706061705
  //   cform-std-only.pl reference-only-altwyk-9706061705
  // Manually modified for C++.
  // Reprocessed with sgtbx to obtain special position operators
  // that correctly average. The special position operators
  // are chosen such that special_op * x = x when all elements
  // of x are in the interval )-0.5,0.5].

// BEGIN_COMPILED_IN_REFERENCE_DATA
  static const raw_position w2[] = {
  { 1, "1/2,1/2,1/2"},
  { 1, "0,1/2,1/2"},
  { 1, "1/2,0,1/2"},
  { 1, "1/2,1/2,0"},
  { 1, "1/2,0,0"},
  { 1, "0,1/2,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w3[] = {
  { 1, "1/2,y,1/2"},
  { 1, "1/2,y,0"},
  { 1, "0,y,1/2"},
  { 1, "0,y,0"}
  };
  static const raw_position w5[] = {
  { 2, "0,y,1/2"},
  { 2, "0,y,0"}
  };
  static const raw_position w6[] = {
  { 1, "x,1/2,z"},
  { 1, "x,0,z"}
  };
  static const raw_position w8[] = {
  { 2, "x,0,z"}
  };
  static const raw_position w10[] = {
  { 2, "x,1/2,z"},
  { 2, "x,0,z"},
  { 2, "1/2,y,1/2"},
  { 2, "0,y,1/2"},
  { 2, "1/2,y,0"},
  { 2, "0,y,0"},
  { 1, "1/2,1/2,1/2"},
  { 1, "1/2,0,1/2"},
  { 1, "0,1/2,1/2"},
  { 1, "1/2,1/2,0"},
  { 1, "1/2,0,0"},
  { 1, "0,0,1/2"},
  { 1, "0,1/2,0"},
  { 1, "0,0,0"}
  };
  static const raw_position w11[] = {
  { 2, "x,1/4,z"},
  { 2, "1/2,0,1/2"},
  { 2, "0,0,1/2"},
  { 2, "1/2,0,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w12[] = {
  { 4, "x,0,z"},
  { 4, "0,y,1/2"},
  { 4, "0,y,0"},
  { 4, "1/4,1/4,1/2"},
  { 4, "1/4,1/4,0"},
  { 2, "0,1/2,1/2"},
  { 2, "0,0,1/2"},
  { 2, "0,1/2,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w13[] = {
  { 2, "1/2,y,1/4"},
  { 2, "0,y,1/4"},
  { 2, "1/2,0,0"},
  { 2, "0,1/2,0"},
  { 2, "1/2,1/2,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w14[] = {
  { 2, "1/2,0,1/2"},
  { 2, "0,0,1/2"},
  { 2, "1/2,0,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w15[] = {
  { 4, "0,y,1/4"},
  { 4, "1/4,1/4,1/2"},
  { 4, "1/4,1/4,0"},
  { 4, "0,1/2,0"},
  { 4, "0,0,0"}
  };
  static const raw_position w16[] = {
  { 2, "1/2,1/2,z"},
  { 2, "0,1/2,z"},
  { 2, "1/2,0,z"},
  { 2, "0,0,z"},
  { 2, "1/2,y,1/2"},
  { 2, "1/2,y,0"},
  { 2, "0,y,1/2"},
  { 2, "0,y,0"},
  { 2, "x,1/2,1/2"},
  { 2, "x,1/2,0"},
  { 2, "x,0,1/2"},
  { 2, "x,0,0"},
  { 1, "1/2,1/2,1/2"},
  { 1, "0,1/2,1/2"},
  { 1, "1/2,0,1/2"},
  { 1, "1/2,1/2,0"},
  { 1, "0,0,1/2"},
  { 1, "0,1/2,0"},
  { 1, "1/2,0,0"},
  { 1, "0,0,0"}
  };
  static const raw_position w17[] = {
  { 2, "1/2,y,1/4"},
  { 2, "0,y,1/4"},
  { 2, "x,1/2,0"},
  { 2, "x,0,0"}
  };
  static const raw_position w18[] = {
  { 2, "0,1/2,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w20[] = {
  { 4, "0,y,1/4"},
  { 4, "x,0,0"}
  };
  static const raw_position w21[] = {
  { 4, "1/4,1/4,z"},
  { 4, "0,1/2,z"},
  { 4, "0,0,z"},
  { 4, "0,y,1/2"},
  { 4, "0,y,0"},
  { 4, "x,0,1/2"},
  { 4, "x,0,0"},
  { 2, "0,0,1/2"},
  { 2, "1/2,0,1/2"},
  { 2, "0,1/2,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w22[] = {
  { 8, "x,1/4,1/4"},
  { 8, "1/4,y,1/4"},
  { 8, "1/4,1/4,z"},
  { 8, "0,0,z"},
  { 8, "0,y,0"},
  { 8, "x,0,0"},
  { 4, "1/4,1/4,-1/4"},
  { 4, "1/4,1/4,1/4"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w23[] = {
  { 4, "0,1/2,z"},
  { 4, "0,0,z"},
  { 4, "1/2,y,0"},
  { 4, "0,y,0"},
  { 4, "x,0,1/2"},
  { 4, "x,0,0"},
  { 2, "0,1/2,0"},
  { 2, "0,0,1/2"},
  { 2, "1/2,0,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w24[] = {
  { 4, "0,1/4,z"},
  { 4, "1/4,y,0"},
  { 4, "x,0,1/4"}
  };
  static const raw_position w25[] = {
  { 2, "1/2,y,z"},
  { 2, "0,y,z"},
  { 2, "x,1/2,z"},
  { 2, "x,0,z"},
  { 1, "1/2,1/2,z"},
  { 1, "1/2,0,z"},
  { 1, "0,1/2,z"},
  { 1, "0,0,z"}
  };
  static const raw_position w26[] = {
  { 2, "1/2,y,z"},
  { 2, "0,y,z"}
  };
  static const raw_position w27[] = {
  { 2, "1/2,1/2,z"},
  { 2, "1/2,0,z"},
  { 2, "0,1/2,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w28[] = {
  { 2, "1/4,y,z"},
  { 2, "0,1/2,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w30[] = {
  { 2, "1/2,0,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w31[] = {
  { 2, "0,y,z"}
  };
  static const raw_position w35[] = {
  { 4, "0,y,z"},
  { 4, "x,0,z"},
  { 4, "1/4,1/4,z"},
  { 2, "0,1/2,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w36[] = {
  { 4, "0,y,z"}
  };
  static const raw_position w37[] = {
  { 4, "1/4,1/4,z"},
  { 4, "0,1/2,z"},
  { 4, "0,0,z"}
  };
  static const raw_position w38[] = {
  { 4, "1/2,y,z"},
  { 4, "0,y,z"},
  { 4, "x,0,z"},
  { 2, "1/2,0,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w39[] = {
  { 4, "x,1/4,z"},
  { 4, "1/2,0,z"},
  { 4, "0,0,z"}
  };
  static const raw_position w40[] = {
  { 4, "1/4,y,z"},
  { 4, "0,0,z"}
  };
  static const raw_position w41[] = {
  { 4, "0,0,z"}
  };
  static const raw_position w42[] = {
  { 8, "x,0,z"},
  { 8, "0,y,z"},
  { 8, "1/4,1/4,z"},
  { 4, "0,0,z"}
  };
  static const raw_position w43[] = {
  { 8, "0,0,z"}
  };
  static const raw_position w44[] = {
  { 4, "0,y,z"},
  { 4, "x,0,z"},
  { 2, "0,1/2,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w45[] = {
  { 4, "0,1/2,z"},
  { 4, "0,0,z"}
  };
  static const raw_position w47[] = {
  { 4, "x,y,1/2"},
  { 4, "x,y,0"},
  { 4, "x,1/2,z"},
  { 4, "x,0,z"},
  { 4, "1/2,y,z"},
  { 4, "0,y,z"},
  { 2, "1/2,1/2,z"},
  { 2, "1/2,0,z"},
  { 2, "0,1/2,z"},
  { 2, "0,0,z"},
  { 2, "1/2,y,1/2"},
  { 2, "1/2,y,0"},
  { 2, "0,y,1/2"},
  { 2, "0,y,0"},
  { 2, "x,1/2,1/2"},
  { 2, "x,1/2,0"},
  { 2, "x,0,1/2"},
  { 2, "x,0,0"},
  { 1, "1/2,1/2,1/2"},
  { 1, "0,1/2,1/2"},
  { 1, "1/2,1/2,0"},
  { 1, "0,1/2,0"},
  { 1, "1/2,0,1/2"},
  { 1, "0,0,1/2"},
  { 1, "1/2,0,0"},
  { 1, "0,0,0"}
  };
  static const raw_position w48[] = {
  { 4, "1/4,-1/4,z"},
  { 4, "1/4,1/4,z"},
  { 4, "-1/4,y,1/4"},
  { 4, "1/4,y,1/4"},
  { 4, "x,1/4,-1/4"},
  { 4, "x,1/4,1/4"},
  { 4, "0,0,0"},
  { 4, "1/2,1/2,1/2"},
  { 2, "1/4,-1/4,1/4"},
  { 2, "1/4,1/4,-1/4"},
  { 2, "-1/4,1/4,1/4"},
  { 2, "1/4,1/4,1/4"}
  };
  static const raw_position w49[] = {
  { 4, "x,y,0"},
  { 4, "1/2,0,z"},
  { 4, "0,1/2,z"},
  { 4, "1/2,1/2,z"},
  { 4, "0,0,z"},
  { 4, "1/2,y,1/4"},
  { 4, "0,y,1/4"},
  { 4, "x,1/2,1/4"},
  { 4, "x,0,1/4"},
  { 2, "1/2,1/2,1/4"},
  { 2, "0,1/2,1/4"},
  { 2, "1/2,0,1/4"},
  { 2, "0,0,1/4"},
  { 2, "1/2,0,0"},
  { 2, "0,1/2,0"},
  { 2, "1/2,1/2,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w50[] = {
  { 4, "1/4,-1/4,z"},
  { 4, "1/4,1/4,z"},
  { 4, "1/4,y,1/2"},
  { 4, "1/4,y,0"},
  { 4, "x,1/4,1/2"},
  { 4, "x,1/4,0"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"},
  { 2, "1/4,1/4,1/2"},
  { 2, "-1/4,1/4,1/2"},
  { 2, "-1/4,1/4,0"},
  { 2, "1/4,1/4,0"}
  };
  static const raw_position w51[] = {
  { 4, "1/4,y,z"},
  { 4, "x,1/2,z"},
  { 4, "x,0,z"},
  { 4, "0,y,1/2"},
  { 4, "0,y,0"},
  { 2, "1/4,1/2,z"},
  { 2, "1/4,0,z"},
  { 2, "0,1/2,1/2"},
  { 2, "0,0,1/2"},
  { 2, "0,1/2,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w52[] = {
  { 4, "x,1/4,1/4"},
  { 4, "1/4,0,z"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w53[] = {
  { 4, "0,y,z"},
  { 4, "1/4,y,1/4"},
  { 4, "x,1/2,0"},
  { 4, "x,0,0"},
  { 2, "0,1/2,0"},
  { 2, "1/2,1/2,0"},
  { 2, "1/2,0,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w54[] = {
  { 4, "1/4,1/2,z"},
  { 4, "1/4,0,z"},
  { 4, "0,y,1/4"},
  { 4, "0,1/2,0"},
  { 4, "0,0,0"}
  };
  static const raw_position w55[] = {
  { 4, "x,y,1/2"},
  { 4, "x,y,0"},
  { 4, "0,1/2,z"},
  { 4, "0,0,z"},
  { 2, "0,1/2,1/2"},
  { 2, "0,1/2,0"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w56[] = {
  { 4, "1/4,-1/4,z"},
  { 4, "1/4,1/4,z"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w57[] = {
  { 4, "x,y,1/4"},
  { 4, "x,1/4,0"},
  { 4, "1/2,0,0"},
  { 4, "0,0,0"}
  };
  static const raw_position w58[] = {
  { 4, "x,y,0"},
  { 4, "0,1/2,z"},
  { 4, "0,0,z"},
  { 2, "0,1/2,1/2"},
  { 2, "0,1/2,0"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w59[] = {
  { 4, "x,1/4,z"},
  { 4, "1/4,y,z"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"},
  { 2, "1/4,-1/4,z"},
  { 2, "1/4,1/4,z"}
  };
  static const raw_position w60[] = {
  { 4, "0,y,1/4"},
  { 4, "0,1/2,0"},
  { 4, "0,0,0"}
  };
  static const raw_position w61[] = {
  { 4, "0,0,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w62[] = {
  { 4, "x,1/4,z"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w63[] = {
  { 8, "x,y,1/4"},
  { 8, "0,y,z"},
  { 8, "x,0,0"},
  { 8, "1/4,1/4,0"},
  { 4, "0,y,1/4"},
  { 4, "0,1/2,0"},
  { 4, "0,0,0"}
  };
  static const raw_position w64[] = {
  { 8, "0,y,z"},
  { 8, "1/4,y,1/4"},
  { 8, "x,0,0"},
  { 8, "1/4,1/4,0"},
  { 4, "1/2,0,0"},
  { 4, "0,0,0"}
  };
  static const raw_position w65[] = {
  { 8, "x,y,1/2"},
  { 8, "x,y,0"},
  { 8, "x,0,z"},
  { 8, "0,y,z"},
  { 8, "1/4,1/4,z"},
  { 4, "0,1/2,z"},
  { 4, "0,0,z"},
  { 4, "0,y,1/2"},
  { 4, "0,y,0"},
  { 4, "x,0,1/2"},
  { 4, "x,0,0"},
  { 4, "1/4,1/4,1/2"},
  { 4, "1/4,1/4,0"},
  { 2, "0,0,1/2"},
  { 2, "1/2,0,1/2"},
  { 2, "1/2,0,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w66[] = {
  { 8, "x,y,0"},
  { 8, "1/4,1/4,z"},
  { 8, "0,1/2,z"},
  { 8, "0,0,z"},
  { 8, "0,y,1/4"},
  { 8, "x,0,1/4"},
  { 4, "1/4,-1/4,0"},
  { 4, "1/4,1/4,0"},
  { 4, "0,1/2,0"},
  { 4, "0,0,0"},
  { 4, "0,1/2,1/4"},
  { 4, "0,0,1/4"}
  };
  static const raw_position w67[] = {
  { 8, "x,1/4,z"},
  { 8, "0,y,z"},
  { 8, "1/4,0,z"},
  { 8, "1/4,y,1/2"},
  { 8, "1/4,y,0"},
  { 8, "x,0,1/2"},
  { 8, "x,0,0"},
  { 4, "0,1/4,z"},
  { 4, "1/4,1/4,1/2"},
  { 4, "1/4,1/4,0"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"},
  { 4, "1/4,0,1/2"},
  { 4, "1/4,0,0"}
  };
  static const raw_position w68[] = {
  { 8, "1/4,0,z"},
  { 8, "0,1/4,z"},
  { 8, "0,y,1/4"},
  { 8, "x,1/4,1/4"},
  { 8, "0,0,0"},
  { 8, "1/4,-1/4,0"},
  { 4, "0,1/4,-1/4"},
  { 4, "0,1/4,1/4"}
  };
  static const raw_position w69[] = {
  {16, "x,y,0"},
  {16, "x,0,z"},
  {16, "0,y,z"},
  {16, "x,1/4,1/4"},
  {16, "1/4,y,1/4"},
  {16, "1/4,1/4,z"},
  { 8, "0,0,z"},
  { 8, "0,y,0"},
  { 8, "x,0,0"},
  { 8, "1/4,1/4,1/4"},
  { 8, "1/4,1/4,0"},
  { 8, "1/4,0,1/4"},
  { 8, "0,1/4,1/4"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w70[] = {
  {16, "1/8,1/8,z"},
  {16, "1/8,y,1/8"},
  {16, "x,1/8,1/8"},
  {16, "1/2,1/2,1/2"},
  {16, "0,0,0"},
  { 8, "1/8,1/8,-3/8"},
  { 8, "1/8,1/8,1/8"}
  };
  static const raw_position w71[] = {
  { 8, "x,y,0"},
  { 8, "x,0,z"},
  { 8, "0,y,z"},
  { 8, "1/4,1/4,1/4"},
  { 4, "1/2,0,z"},
  { 4, "0,0,z"},
  { 4, "0,y,1/2"},
  { 4, "0,y,0"},
  { 4, "x,1/2,0"},
  { 4, "x,0,0"},
  { 2, "1/2,0,1/2"},
  { 2, "1/2,1/2,0"},
  { 2, "0,1/2,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w72[] = {
  { 8, "x,y,0"},
  { 8, "0,1/2,z"},
  { 8, "0,0,z"},
  { 8, "0,y,1/4"},
  { 8, "x,0,1/4"},
  { 8, "1/4,1/4,1/4"},
  { 4, "1/2,0,0"},
  { 4, "0,0,0"},
  { 4, "1/2,0,1/4"},
  { 4, "0,0,1/4"}
  };
  static const raw_position w73[] = {
  { 8, "0,1/4,z"},
  { 8, "1/4,y,0"},
  { 8, "x,0,1/4"},
  { 8, "1/4,1/4,1/4"},
  { 8, "0,0,0"}
  };
  static const raw_position w74[] = {
  { 8, "x,1/4,z"},
  { 8, "0,y,z"},
  { 8, "1/4,y,1/4"},
  { 8, "x,0,0"},
  { 4, "0,1/4,z"},
  { 4, "1/4,1/4,-1/4"},
  { 4, "1/4,1/4,1/4"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w75[] = {
  { 2, "0,1/2,z"},
  { 1, "1/2,1/2,z"},
  { 1, "0,0,z"}
  };
  static const raw_position w77[] = {
  { 2, "0,1/2,z"},
  { 2, "1/2,1/2,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w79[] = {
  { 4, "0,1/2,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w81[] = {
  { 2, "0,1/2,z"},
  { 2, "1/2,1/2,z"},
  { 2, "0,0,z"},
  { 1, "1/2,1/2,1/2"},
  { 1, "1/2,1/2,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w82[] = {
  { 4, "0,1/2,z"},
  { 4, "0,0,z"},
  { 2, "0,1/2,-1/4"},
  { 2, "0,1/2,1/4"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w83[] = {
  { 4, "x,y,1/2"},
  { 4, "x,y,0"},
  { 4, "0,1/2,z"},
  { 2, "1/2,1/2,z"},
  { 2, "0,0,z"},
  { 2, "0,1/2,1/2"},
  { 2, "0,1/2,0"},
  { 1, "1/2,1/2,1/2"},
  { 1, "1/2,1/2,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w84[] = {
  { 4, "x,y,0"},
  { 4, "0,1/2,z"},
  { 4, "1/2,1/2,z"},
  { 4, "0,0,z"},
  { 2, "1/2,1/2,1/4"},
  { 2, "0,0,1/4"},
  { 2, "0,1/2,1/2"},
  { 2, "0,1/2,0"},
  { 2, "1/2,1/2,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w85[] = {
  { 4, "1/4,-1/4,z"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"},
  { 2, "1/4,1/4,z"},
  { 2, "1/4,-1/4,1/2"},
  { 2, "1/4,-1/4,0"}
  };
  static const raw_position w86[] = {
  { 4, "1/4,1/4,z"},
  { 4, "-1/4,1/4,z"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"},
  { 2, "1/4,1/4,-1/4"},
  { 2, "1/4,1/4,1/4"}
  };
  static const raw_position w87[] = {
  { 8, "x,y,0"},
  { 8, "0,1/2,z"},
  { 8, "1/4,1/4,1/4"},
  { 4, "0,0,z"},
  { 4, "0,1/2,1/4"},
  { 4, "0,1/2,0"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w88[] = {
  { 8, "0,1/4,z"},
  { 8, "0,0,1/2"},
  { 8, "0,0,0"},
  { 4, "0,1/4,-3/8"},
  { 4, "0,1/4,1/8"}
  };
  static const raw_position w89[] = {
  { 4, "x,1/2,0"},
  { 4, "x,0,1/2"},
  { 4, "x,1/2,1/2"},
  { 4, "x,0,0"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,1/2"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 4, "0,1/2,z"},
  { 2, "1/2,1/2,z"},
  { 2, "0,0,z"},
  { 2, "1/2,0,1/2"},
  { 2, "1/2,0,0"},
  { 1, "1/2,1/2,1/2"},
  { 1, "1/2,1/2,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w90[] = {
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,1/2"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 4, "0,0,z"},
  { 2, "0,1/2,z"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w91[] = {
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,3/8"},
  { 4, "1/2,y,0"},
  { 4, "0,y,0"}
  };
  static const raw_position w92[] = {
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,0"}
  };
  static const raw_position w93[] = {
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,-1/4"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,1/4"},
  { 4, "x,1/2,0"},
  { 4, "x,0,1/2"},
  { 4, "x,1/2,1/2"},
  { 4, "x,0,0"},
  { 4, "0,1/2,z"},
  { 4, "1/2,1/2,z"},
  { 4, "0,0,z"},
  { 2, "1/2,1/2,1/4"},
  { 2, "0,0,1/4"},
  { 2, "0,1/2,1/2"},
  { 2, "0,1/2,0"},
  { 2, "1/2,1/2,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w94[] = {
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,1/2"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 4, "0,1/2,z"},
  { 4, "0,0,z"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w95[] = {
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,-3/8"},
  { 4, "1/2,y,0"},
  { 4, "0,y,0"}
  };
  static const raw_position w97[] = {
  { 8, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,1/4"},
  { 8, "x,0,1/2"},
  { 8, "x,0,0"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 8, "0,1/2,z"},
  { 4, "0,0,z"},
  { 4, "0,1/2,1/4"},
  { 4, "0,1/2,0"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w98[] = {
  { 8, "x,1/4,1/8"},
  { 8, "1/2*x-1/2*y,-1/2*x+1/2*y,0"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 8, "0,0,z"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w99[] = {
  { 4, "x,1/2,z"},
  { 4, "x,0,z"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  { 2, "1/2,0,z"},
  { 1, "1/2,1/2,z"},
  { 1, "0,0,z"}
  };
  static const raw_position w100[] = {
  { 4, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,z"},
  { 2, "1/2,0,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w101[] = {
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  { 4, "0,1/2,z"},
  { 2, "1/2,1/2,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w102[] = {
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  { 4, "0,1/2,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w103[] = {
  { 4, "0,1/2,z"},
  { 2, "1/2,1/2,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w105[] = {
  { 4, "x,1/2,z"},
  { 4, "x,0,z"},
  { 2, "0,1/2,z"},
  { 2, "1/2,1/2,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w107[] = {
  { 8, "x,0,z"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  { 4, "0,1/2,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w108[] = {
  { 8, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,z"},
  { 4, "1/2,0,z"},
  { 4, "0,0,z"}
  };
  static const raw_position w109[] = {
  { 8, "0,y,z"},
  { 4, "0,0,z"}
  };
  static const raw_position w111[] = {
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  { 4, "0,1/2,z"},
  { 4, "x,1/2,0"},
  { 4, "x,0,1/2"},
  { 4, "x,1/2,1/2"},
  { 4, "x,0,0"},
  { 2, "1/2,1/2,z"},
  { 2, "0,0,z"},
  { 2, "1/2,0,1/2"},
  { 2, "1/2,0,0"},
  { 1, "1/2,1/2,0"},
  { 1, "0,0,1/2"},
  { 1, "1/2,1/2,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w112[] = {
  { 4, "0,1/2,z"},
  { 4, "1/2,1/2,z"},
  { 4, "0,0,z"},
  { 4, "0,y,1/4"},
  { 4, "x,1/2,1/4"},
  { 4, "1/2,y,1/4"},
  { 4, "x,0,1/4"},
  { 2, "1/2,1/2,0"},
  { 2, "0,0,0"},
  { 2, "0,1/2,1/4"},
  { 2, "1/2,1/2,1/4"},
  { 2, "1/2,0,1/4"},
  { 2, "0,0,1/4"}
  };
  static const raw_position w113[] = {
  { 4, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,z"},
  { 4, "0,0,z"},
  { 2, "0,1/2,z"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w114[] = {
  { 4, "0,1/2,z"},
  { 4, "0,0,z"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w115[] = {
  { 4, "x,1/2,z"},
  { 4, "x,0,z"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,1/2"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 2, "0,1/2,z"},
  { 2, "1/2,1/2,z"},
  { 2, "0,0,z"},
  { 1, "0,0,1/2"},
  { 1, "1/2,1/2,1/2"},
  { 1, "1/2,1/2,0"},
  { 1, "0,0,0"}
  };
  static const raw_position w116[] = {
  { 4, "0,1/2,z"},
  { 4, "1/2,1/2,z"},
  { 4, "0,0,z"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,-1/4"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,1/4"},
  { 2, "1/2,1/2,0"},
  { 2, "0,0,0"},
  { 2, "1/2,1/2,1/4"},
  { 2, "0,0,1/4"}
  };
  static const raw_position w117[] = {
  { 4, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,1/2"},
  { 4, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,0"},
  { 4, "0,1/2,z"},
  { 4, "0,0,z"},
  { 2, "0,1/2,1/2"},
  { 2, "0,1/2,0"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w118[] = {
  { 4, "0,1/2,z"},
  { 4, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,1/4"},
  { 4, "1/2*x-1/2*y+1/4,-1/2*x+1/2*y+1/4,1/4"},
  { 4, "0,0,z"},
  { 2, "0,1/2,-1/4"},
  { 2, "0,1/2,1/4"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w119[] = {
  { 8, "x,0,z"},
  { 8, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,1/4"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 4, "0,1/2,z"},
  { 4, "0,0,z"},
  { 2, "0,1/2,-1/4"},
  { 2, "0,1/2,1/4"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w120[] = {
  { 8, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,0"},
  { 8, "0,1/2,z"},
  { 8, "0,0,z"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,1/4"},
  { 4, "0,1/2,0"},
  { 4, "0,1/2,1/4"},
  { 4, "0,0,0"},
  { 4, "0,0,1/4"}
  };
  static const raw_position w121[] = {
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  { 8, "0,1/2,z"},
  { 8, "x,0,1/2"},
  { 8, "x,0,0"},
  { 4, "0,0,z"},
  { 4, "0,1/2,1/4"},
  { 4, "0,1/2,0"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w122[] = {
  { 8, "x,1/4,1/8"},
  { 8, "0,0,z"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w123[] = {
  { 8, "x,1/2,z"},
  { 8, "x,0,z"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  { 8, "x,y,1/2"},
  { 8, "x,y,0"},
  { 4, "x,1/2,1/2"},
  { 4, "x,1/2,0"},
  { 4, "x,0,1/2"},
  { 4, "x,0,0"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,1/2"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 4, "0,1/2,z"},
  { 2, "1/2,1/2,z"},
  { 2, "0,0,z"},
  { 2, "0,1/2,0"},
  { 2, "0,1/2,1/2"},
  { 1, "1/2,1/2,1/2"},
  { 1, "1/2,1/2,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w124[] = {
  { 8, "x,y,0"},
  { 8, "x,1/2,1/4"},
  { 8, "x,0,1/4"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,1/4"},
  { 8, "0,1/2,z"},
  { 4, "1/2,1/2,z"},
  { 4, "0,0,z"},
  { 4, "0,1/2,1/4"},
  { 4, "0,1/2,0"},
  { 2, "1/2,1/2,0"},
  { 2, "1/2,1/2,1/4"},
  { 2, "0,0,0"},
  { 2, "0,0,1/4"}
  };
  static const raw_position w125[] = {
  { 8, "1/2*x-1/2*y,-1/2*x+1/2*y,z"},
  { 8, "x,1/4,1/2"},
  { 8, "x,1/4,0"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,1/2"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 4, "-1/4,1/4,z"},
  { 4, "1/4,1/4,z"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"},
  { 2, "-1/4,1/4,1/2"},
  { 2, "-1/4,1/4,0"},
  { 2, "1/4,1/4,1/2"},
  { 2, "1/4,1/4,0"}
  };
  static const raw_position w126[] = {
  { 8, "x,-1/4,1/4"},
  { 8, "x,1/4,1/4"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,1/4"},
  { 8, "1/4,-1/4,z"},
  { 8, "0,0,0"},
  { 4, "1/4,1/4,z"},
  { 4, "1/4,-1/4,0"},
  { 4, "1/4,-1/4,-1/4"},
  { 2, "1/4,1/4,-1/4"},
  { 2, "1/4,1/4,1/4"}
  };
  static const raw_position w127[] = {
  { 8, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,z"},
  { 8, "x,y,1/2"},
  { 8, "x,y,0"},
  { 4, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,1/2"},
  { 4, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,0"},
  { 4, "0,1/2,z"},
  { 4, "0,0,z"},
  { 2, "0,1/2,0"},
  { 2, "0,1/2,1/2"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w128[] = {
  { 8, "x,y,0"},
  { 8, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,1/4"},
  { 8, "0,1/2,z"},
  { 4, "0,0,z"},
  { 4, "0,1/2,1/4"},
  { 4, "0,1/2,0"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w129[] = {
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  { 8, "1/4,y,z"},
  { 8, "1/2*x-1/2*y,-1/2*x+1/2*y,1/2"},
  { 8, "1/2*x-1/2*y,-1/2*x+1/2*y,0"},
  { 4, "-1/4,1/4,z"},
  { 4, "0,0,1/2"},
  { 4, "0,0,0"},
  { 2, "1/4,1/4,z"},
  { 2, "-1/4,1/4,1/2"},
  { 2, "-1/4,1/4,0"}
  };
  static const raw_position w130[] = {
  { 8, "1/2*x-1/2*y,-1/2*x+1/2*y,1/4"},
  { 8, "-1/4,1/4,z"},
  { 8, "0,0,0"},
  { 4, "1/4,1/4,z"},
  { 4, "-1/4,1/4,0"},
  { 4, "-1/4,1/4,1/4"}
  };
  static const raw_position w131[] = {
  { 8, "x,y,0"},
  { 8, "1/2,y,z"},
  { 8, "0,y,z"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,1/4"},
  { 4, "x,1/2,0"},
  { 4, "x,0,1/2"},
  { 4, "x,1/2,1/2"},
  { 4, "x,0,0"},
  { 4, "0,1/2,z"},
  { 4, "1/2,1/2,z"},
  { 4, "0,0,z"},
  { 2, "1/2,1/2,1/4"},
  { 2, "0,0,1/4"},
  { 2, "0,1/2,1/2"},
  { 2, "0,1/2,0"},
  { 2, "1/2,1/2,0"},
  { 2, "0,0,0"}
  };
  static const raw_position w132[] = {
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  { 8, "x,y,0"},
  { 8, "x,1/2,1/4"},
  { 8, "x,0,1/4"},
  { 8, "0,1/2,z"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,1/2"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 4, "1/2,1/2,z"},
  { 4, "0,0,z"},
  { 4, "0,1/2,0"},
  { 4, "0,1/2,1/4"},
  { 2, "1/2,1/2,1/4"},
  { 2, "1/2,1/2,0"},
  { 2, "0,0,1/4"},
  { 2, "0,0,0"}
  };
  static const raw_position w133[] = {
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,1/4"},
  { 8, "x,1/4,1/2"},
  { 8, "x,1/4,0"},
  { 8, "-1/4,1/4,z"},
  { 8, "1/4,1/4,z"},
  { 8, "0,0,0"},
  { 4, "-1/4,1/4,-1/4"},
  { 4, "1/4,1/4,1/4"},
  { 4, "-1/4,1/4,0"},
  { 4, "1/4,1/4,0"}
  };
  static const raw_position w134[] = {
  { 8, "1/2*x-1/2*y,-1/2*x+1/2*y,z"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,1/2"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 8, "x,1/4,1/4"},
  { 8, "x,1/4,-1/4"},
  { 8, "1/4,1/4,z"},
  { 4, "-1/4,1/4,z"},
  { 4, "0,0,0"},
  { 4, "0,0,1/2"},
  { 4, "1/4,1/4,0"},
  { 4, "1/4,1/4,1/4"},
  { 2, "-1/4,1/4,1/4"},
  { 2, "1/4,-1/4,1/4"}
  };
  static const raw_position w135[] = {
  { 8, "x,y,0"},
  { 8, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,1/4"},
  { 8, "0,1/2,z"},
  { 8, "0,0,z"},
  { 4, "0,1/2,1/4"},
  { 4, "0,1/2,0"},
  { 4, "0,0,1/4"},
  { 4, "0,0,0"}
  };
  static const raw_position w136[] = {
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  { 8, "x,y,0"},
  { 8, "0,1/2,z"},
  { 4, "1/2*x-1/2*y,-1/2*x+1/2*y,0"},
  { 4, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 4, "0,0,z"},
  { 4, "0,1/2,1/4"},
  { 4, "0,1/2,0"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w137[] = {
  { 8, "1/4,y,z"},
  { 8, "1/2*x-1/2*y,-1/2*x+1/2*y,1/4"},
  { 8, "0,0,0"},
  { 4, "1/4,1/4,z"},
  { 4, "-1/4,1/4,z"},
  { 2, "-1/4,1/4,1/4"},
  { 2, "-1/4,1/4,-1/4"}
  };
  static const raw_position w138[] = {
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  { 8, "1/2*x-1/2*y,-1/2*x+1/2*y,0"},
  { 8, "1/2*x-1/2*y,-1/2*x+1/2*y,1/2"},
  { 8, "-1/4,1/4,z"},
  { 4, "1/4,1/4,z"},
  { 4, "0,0,0"},
  { 4, "0,0,1/2"},
  { 4, "-1/4,1/4,-1/4"},
  { 4, "-1/4,1/4,0"}
  };
  static const raw_position w139[] = {
  {16, "0,y,z"},
  {16, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  {16, "x,y,0"},
  {16, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,1/4"},
  { 8, "x,1/2,0"},
  { 8, "x,0,0"},
  { 8, "1/2*x+1/2*y,1/2*x+1/2*y,0"},
  { 8, "0,1/2,z"},
  { 8, "1/4,1/4,1/4"},
  { 4, "0,0,z"},
  { 4, "0,1/2,1/4"},
  { 4, "0,1/2,0"},
  { 2, "0,0,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w140[] = {
  {16, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,z"},
  {16, "x,y,0"},
  {16, "x,0,1/4"},
  {16, "1/2*x+1/2*y,1/2*x+1/2*y,1/4"},
  { 8, "1/2*x+1/2*y-1/4,1/2*x+1/2*y+1/4,0"},
  { 8, "0,1/2,z"},
  { 8, "0,0,z"},
  { 8, "1/4,1/4,1/4"},
  { 4, "0,1/2,0"},
  { 4, "0,0,0"},
  { 4, "0,1/2,1/4"},
  { 4, "0,0,1/4"}
  };
  static const raw_position w141[] = {
  {16, "0,y,z"},
  {16, "1/2*x+1/2*y-1/8,1/2*x+1/2*y+1/8,-1/8"},
  {16, "x,0,0"},
  { 8, "0,1/4,z"},
  { 8, "0,0,1/2"},
  { 8, "0,0,0"},
  { 4, "0,1/4,3/8"},
  { 4, "0,-1/4,1/8"}
  };
  static const raw_position w142[] = {
  {16, "1/2*x+1/2*y-1/8,1/2*x+1/2*y+1/8,1/8"},
  {16, "x,0,1/4"},
  {16, "0,1/4,z"},
  {16, "0,0,0"},
  { 8, "0,1/4,1/8"},
  { 8, "0,1/4,3/8"}
  };
  static const raw_position w143[] = {
  { 1, "-1/3,1/3,z"},
  { 1, "1/3,-1/3,z"},
  { 1, "0,0,z"}
  };
  static const raw_position w146[] = {
  { 3, "0,0,z"}
  };
  static const raw_position w147[] = {
  { 3, "1/2,0,1/2"},
  { 3, "1/2,0,0"},
  { 2, "1/3,-1/3,z"},
  { 2, "0,0,z"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w148[] = {
  { 9, "1/2,0,0"},
  { 9, "1/2,0,1/2"},
  { 6, "0,0,z"},
  { 3, "0,0,1/2"},
  { 3, "0,0,0"}
  };
  static const raw_position w149[] = {
  { 3, "1/2*x-1/2*y,-1/2*x+1/2*y,1/2"},
  { 3, "1/2*x-1/2*y,-1/2*x+1/2*y,0"},
  { 2, "-1/3,1/3,z"},
  { 2, "1/3,-1/3,z"},
  { 2, "0,0,z"},
  { 1, "-1/3,1/3,1/2"},
  { 1, "-1/3,1/3,0"},
  { 1, "1/3,-1/3,1/2"},
  { 1, "1/3,-1/3,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w150[] = {
  { 3, "x-1/2*y,0,1/2"},
  { 3, "x-1/2*y,0,0"},
  { 2, "1/3,-1/3,z"},
  { 2, "0,0,z"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w151[] = {
  { 3, "1/2*x-1/2*y,-1/2*x+1/2*y,-1/6"},
  { 3, "1/2*x-1/2*y,-1/2*x+1/2*y,1/3"}
  };
  static const raw_position w152[] = {
  { 3, "x-1/2*y,0,-1/6"},
  { 3, "x-1/2*y,0,1/3"}
  };
  static const raw_position w153[] = {
  { 3, "1/2*x-1/2*y,-1/2*x+1/2*y,1/6"},
  { 3, "1/2*x-1/2*y,-1/2*x+1/2*y,-1/3"}
  };
  static const raw_position w154[] = {
  { 3, "x-1/2*y,0,1/6"},
  { 3, "x-1/2*y,0,-1/3"}
  };
  static const raw_position w155[] = {
  { 9, "x-1/2*y,0,1/2"},
  { 9, "x-1/2*y,0,0"},
  { 6, "0,0,z"},
  { 3, "0,0,1/2"},
  { 3, "0,0,0"}
  };
  static const raw_position w156[] = {
  { 3, "1/2*x-1/2*y,-1/2*x+1/2*y,z"},
  { 1, "-1/3,1/3,z"},
  { 1, "1/3,-1/3,z"},
  { 1, "0,0,z"}
  };
  static const raw_position w157[] = {
  { 3, "x-1/2*y,0,z"},
  { 2, "1/3,-1/3,z"},
  { 1, "0,0,z"}
  };
  static const raw_position w158[] = {
  { 2, "-1/3,1/3,z"},
  { 2, "1/3,-1/3,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w159[] = {
  { 2, "1/3,-1/3,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w160[] = {
  { 9, "1/2*x-1/2*y,-1/2*x+1/2*y,z"},
  { 3, "0,0,z"}
  };
  static const raw_position w161[] = {
  { 6, "0,0,z"}
  };
  static const raw_position w162[] = {
  { 6, "x-1/2*y,0,z"},
  { 6, "1/2*x-1/2*y,-1/2*x+1/2*y,1/2"},
  { 6, "1/2*x-1/2*y,-1/2*x+1/2*y,0"},
  { 4, "1/3,-1/3,z"},
  { 3, "1/2,0,1/2"},
  { 3, "1/2,0,0"},
  { 2, "0,0,z"},
  { 2, "1/3,-1/3,1/2"},
  { 2, "1/3,-1/3,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w163[] = {
  { 6, "1/2*x-1/2*y,-1/2*x+1/2*y,1/4"},
  { 6, "1/2,0,0"},
  { 4, "1/3,-1/3,z"},
  { 4, "0,0,z"},
  { 2, "-1/3,1/3,1/4"},
  { 2, "1/3,-1/3,1/4"},
  { 2, "0,0,0"},
  { 2, "0,0,1/4"}
  };
  static const raw_position w164[] = {
  { 6, "1/2*x-1/2*y,-1/2*x+1/2*y,z"},
  { 6, "x-1/2*y,0,1/2"},
  { 6, "x-1/2*y,0,0"},
  { 3, "1/2,0,1/2"},
  { 3, "1/2,0,0"},
  { 2, "1/3,-1/3,z"},
  { 2, "0,0,z"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w165[] = {
  { 6, "x-1/2*y,0,1/4"},
  { 6, "1/2,0,0"},
  { 4, "1/3,-1/3,z"},
  { 4, "0,0,z"},
  { 2, "0,0,0"},
  { 2, "0,0,1/4"}
  };
  static const raw_position w166[] = {
  {18, "1/2*x-1/2*y,-1/2*x+1/2*y,z"},
  {18, "x-1/2*y,0,1/2"},
  {18, "x-1/2*y,0,0"},
  { 9, "1/2,0,0"},
  { 9, "1/2,0,1/2"},
  { 6, "0,0,z"},
  { 3, "0,0,1/2"},
  { 3, "0,0,0"}
  };
  static const raw_position w167[] = {
  {18, "x-1/2*y,0,1/4"},
  {18, "1/2,0,0"},
  {12, "0,0,z"},
  { 6, "0,0,0"},
  { 6, "0,0,1/4"}
  };
  static const raw_position w168[] = {
  { 3, "1/2,0,z"},
  { 2, "1/3,-1/3,z"},
  { 1, "0,0,z"}
  };
  static const raw_position w171[] = {
  { 3, "1/2,1/2,z"},
  { 3, "0,0,z"}
  };
  static const raw_position w174[] = {
  { 3, "x,y,1/2"},
  { 3, "x,y,0"},
  { 2, "-1/3,1/3,z"},
  { 2, "1/3,-1/3,z"},
  { 2, "0,0,z"},
  { 1, "-1/3,1/3,1/2"},
  { 1, "-1/3,1/3,0"},
  { 1, "1/3,-1/3,1/2"},
  { 1, "1/3,-1/3,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w175[] = {
  { 6, "x,y,1/2"},
  { 6, "x,y,0"},
  { 6, "1/2,0,z"},
  { 4, "1/3,-1/3,z"},
  { 3, "1/2,0,1/2"},
  { 3, "1/2,0,0"},
  { 2, "0,0,z"},
  { 2, "1/3,-1/3,1/2"},
  { 2, "1/3,-1/3,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w176[] = {
  { 6, "x,y,1/4"},
  { 6, "1/2,0,0"},
  { 4, "1/3,-1/3,z"},
  { 4, "0,0,z"},
  { 2, "-1/3,1/3,1/4"},
  { 2, "1/3,-1/3,1/4"},
  { 2, "0,0,0"},
  { 2, "0,0,1/4"}
  };
  static const raw_position w177[] = {
  { 6, "1/2*x-1/2*y,-1/2*x+1/2*y,1/2"},
  { 6, "1/2*x-1/2*y,-1/2*x+1/2*y,0"},
  { 6, "x-1/2*y,0,1/2"},
  { 6, "x-1/2*y,0,0"},
  { 6, "1/2,0,z"},
  { 4, "1/3,-1/3,z"},
  { 3, "1/2,0,1/2"},
  { 3, "1/2,0,0"},
  { 2, "0,0,z"},
  { 2, "1/3,-1/3,1/2"},
  { 2, "1/3,-1/3,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w178[] = {
  { 6, "1/2*y,y,1/4"},
  { 6, "x-1/2*y,0,0"}
  };
  static const raw_position w179[] = {
  { 6, "1/2*y,y,-1/4"},
  { 6, "x-1/2*y,0,0"}
  };
  static const raw_position w180[] = {
  { 6, "1/2*y,y,1/2"},
  { 6, "1/2*y,y,0"},
  { 6, "x-1/2*y,0,1/2"},
  { 6, "x-1/2*y,0,0"},
  { 6, "1/2,0,z"},
  { 6, "0,0,z"},
  { 3, "1/2,0,1/2"},
  { 3, "1/2,0,0"},
  { 3, "0,0,1/2"},
  { 3, "0,0,0"}
  };
  static const raw_position w182[] = {
  { 6, "1/2*y,y,1/4"},
  { 6, "x-1/2*y,0,0"},
  { 4, "1/3,-1/3,z"},
  { 4, "0,0,z"},
  { 2, "1/3,-1/3,-1/4"},
  { 2, "1/3,-1/3,1/4"},
  { 2, "0,0,1/4"},
  { 2, "0,0,0"}
  };
  static const raw_position w183[] = {
  { 6, "1/2*x-1/2*y,-1/2*x+1/2*y,z"},
  { 6, "x-1/2*y,0,z"},
  { 3, "1/2,0,z"},
  { 2, "1/3,-1/3,z"},
  { 1, "0,0,z"}
  };
  static const raw_position w184[] = {
  { 6, "1/2,0,z"},
  { 4, "1/3,-1/3,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w185[] = {
  { 6, "x-1/2*y,0,z"},
  { 4, "1/3,-1/3,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w186[] = {
  { 6, "1/2*x-1/2*y,-1/2*x+1/2*y,z"},
  { 2, "1/3,-1/3,z"},
  { 2, "0,0,z"}
  };
  static const raw_position w187[] = {
  { 6, "1/2*x-1/2*y,-1/2*x+1/2*y,z"},
  { 6, "x,y,1/2"},
  { 6, "x,y,0"},
  { 3, "1/2*x-1/2*y,-1/2*x+1/2*y,1/2"},
  { 3, "1/2*x-1/2*y,-1/2*x+1/2*y,0"},
  { 2, "-1/3,1/3,z"},
  { 2, "1/3,-1/3,z"},
  { 2, "0,0,z"},
  { 1, "-1/3,1/3,1/2"},
  { 1, "-1/3,1/3,0"},
  { 1, "1/3,-1/3,1/2"},
  { 1, "1/3,-1/3,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w188[] = {
  { 6, "x,y,1/4"},
  { 6, "1/2*x-1/2*y,-1/2*x+1/2*y,0"},
  { 4, "-1/3,1/3,z"},
  { 4, "1/3,-1/3,z"},
  { 4, "0,0,z"},
  { 2, "-1/3,1/3,1/4"},
  { 2, "-1/3,1/3,0"},
  { 2, "1/3,-1/3,1/4"},
  { 2, "1/3,-1/3,0"},
  { 2, "0,0,1/4"},
  { 2, "0,0,0"}
  };
  static const raw_position w189[] = {
  { 6, "x,y,1/2"},
  { 6, "x,y,0"},
  { 6, "x-1/2*y,0,z"},
  { 4, "1/3,-1/3,z"},
  { 3, "x-1/2*y,0,1/2"},
  { 3, "x-1/2*y,0,0"},
  { 2, "0,0,z"},
  { 2, "1/3,-1/3,1/2"},
  { 2, "1/3,-1/3,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w190[] = {
  { 6, "x,y,1/4"},
  { 6, "x-1/2*y,0,0"},
  { 4, "1/3,-1/3,z"},
  { 4, "0,0,z"},
  { 2, "-1/3,1/3,1/4"},
  { 2, "1/3,-1/3,1/4"},
  { 2, "0,0,1/4"},
  { 2, "0,0,0"}
  };
  static const raw_position w191[] = {
  {12, "x,y,1/2"},
  {12, "x,y,0"},
  {12, "1/2*y,y,z"},
  {12, "x-1/2*y,0,z"},
  { 6, "1/2*y,y,1/2"},
  { 6, "1/2*y,y,0"},
  { 6, "x-1/2*y,0,1/2"},
  { 6, "x-1/2*y,0,0"},
  { 6, "1/2,0,z"},
  { 4, "1/3,-1/3,z"},
  { 3, "1/2,0,1/2"},
  { 3, "1/2,0,0"},
  { 2, "0,0,z"},
  { 2, "1/3,-1/3,1/2"},
  { 2, "1/3,-1/3,0"},
  { 1, "0,0,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w192[] = {
  {12, "x,y,0"},
  {12, "1/2*y,y,1/4"},
  {12, "x-1/2*y,0,1/4"},
  {12, "1/2,0,z"},
  { 8, "1/3,-1/3,z"},
  { 6, "1/2,0,0"},
  { 6, "1/2,0,1/4"},
  { 4, "0,0,z"},
  { 4, "1/3,-1/3,0"},
  { 4, "1/3,-1/3,1/4"},
  { 2, "0,0,0"},
  { 2, "0,0,1/4"}
  };
  static const raw_position w193[] = {
  {12, "x-1/2*y,0,z"},
  {12, "x,y,1/4"},
  {12, "1/2*y,y,0"},
  { 8, "1/3,-1/3,z"},
  { 6, "x-1/2*y,0,1/4"},
  { 6, "1/2,0,0"},
  { 4, "0,0,z"},
  { 4, "1/3,-1/3,0"},
  { 4, "1/3,-1/3,1/4"},
  { 2, "0,0,0"},
  { 2, "0,0,1/4"}
  };
  static const raw_position w194[] = {
  {12, "1/2*y,y,z"},
  {12, "x,y,1/4"},
  {12, "x-1/2*y,0,0"},
  { 6, "1/2*y,y,1/4"},
  { 6, "1/2,0,0"},
  { 4, "1/3,-1/3,z"},
  { 4, "0,0,z"},
  { 2, "1/3,-1/3,-1/4"},
  { 2, "1/3,-1/3,1/4"},
  { 2, "0,0,1/4"},
  { 2, "0,0,0"}
  };
  static const raw_position w195[] = {
  { 6, "x,1/2,1/2"},
  { 6, "x,1/2,0"},
  { 6, "x,0,1/2"},
  { 6, "x,0,0"},
  { 4, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 3, "1/2,0,0"},
  { 3, "0,1/2,1/2"},
  { 1, "1/2,1/2,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w196[] = {
  {24, "x,1/4,1/4"},
  {24, "x,0,0"},
  {16, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 4, "-1/4,-1/4,-1/4"},
  { 4, "1/4,1/4,1/4"},
  { 4, "1/2,1/2,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w197[] = {
  {12, "x,1/2,0"},
  {12, "x,0,0"},
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 6, "0,1/2,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w198[] = {
  { 4, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"}
  };
  static const raw_position w199[] = {
  {12, "x,0,1/4"},
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"}
  };
  static const raw_position w200[] = {
  {12, "1/2,y,z"},
  {12, "0,y,z"},
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 6, "x,1/2,1/2"},
  { 6, "x,1/2,0"},
  { 6, "x,0,1/2"},
  { 6, "x,0,0"},
  { 3, "1/2,0,0"},
  { 3, "0,1/2,1/2"},
  { 1, "1/2,1/2,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w201[] = {
  {12, "x,-1/4,1/4"},
  {12, "x,1/4,1/4"},
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 6, "1/4,-1/4,-1/4"},
  { 4, "1/2,1/2,1/2"},
  { 4, "0,0,0"},
  { 2, "1/4,1/4,1/4"}
  };
  static const raw_position w202[] = {
  {48, "0,y,z"},
  {48, "x,1/4,1/4"},
  {32, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {24, "x,0,0"},
  {24, "0,1/4,1/4"},
  { 8, "1/4,1/4,1/4"},
  { 4, "1/2,1/2,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w203[] = {
  {48, "x,1/8,1/8"},
  {32, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {16, "1/2,1/2,1/2"},
  {16, "0,0,0"},
  { 8, "-3/8,-3/8,-3/8"},
  { 8, "1/8,1/8,1/8"}
  };
  static const raw_position w204[] = {
  {24, "0,y,z"},
  {16, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {12, "x,0,1/2"},
  {12, "x,0,0"},
  { 8, "1/4,1/4,1/4"},
  { 6, "0,1/2,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w205[] = {
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 4, "1/2,1/2,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w206[] = {
  {24, "x,0,1/4"},
  {16, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 8, "1/4,1/4,1/4"},
  { 8, "0,0,0"}
  };
  static const raw_position w207[] = {
  {12, "1/2,1/2*y+1/2*z,1/2*y+1/2*z"},
  {12, "0,1/2*y+1/2*z,1/2*y+1/2*z"},
  {12, "x,1/2,0"},
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 6, "x,1/2,1/2"},
  { 6, "x,0,0"},
  { 3, "1/2,0,0"},
  { 3, "0,1/2,1/2"},
  { 1, "1/2,1/2,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w208[] = {
  {12, "1/4,1/2*y+1/2*z-1/4,1/2*y+1/2*z+1/4"},
  {12, "1/4,1/2*y-1/2*z+1/4,-1/2*y+1/2*z+1/4"},
  {12, "x,1/2,0"},
  {12, "x,0,1/2"},
  {12, "x,0,0"},
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 6, "1/4,1/2,0"},
  { 6, "1/4,0,1/2"},
  { 6, "0,1/2,1/2"},
  { 4, "-1/4,-1/4,-1/4"},
  { 4, "1/4,1/4,1/4"},
  { 2, "0,0,0"}
  };
  static const raw_position w209[] = {
  {48, "x,1/4,1/4"},
  {48, "1/2,1/2*y+1/2*z,1/2*y+1/2*z"},
  {48, "0,1/2*y+1/2*z,1/2*y+1/2*z"},
  {32, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {24, "x,0,0"},
  {24, "0,1/4,1/4"},
  { 8, "1/4,1/4,1/4"},
  { 4, "1/2,1/2,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w210[] = {
  {48, "1/8,1/2*y-1/2*z+1/8,-1/2*y+1/2*z+1/8"},
  {48, "x,0,0"},
  {32, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {16, "-3/8,-3/8,-3/8"},
  {16, "1/8,1/8,1/8"},
  { 8, "1/2,1/2,1/2"},
  { 8, "0,0,0"}
  };
  static const raw_position w211[] = {
  {24, "1/4,1/2*y-1/2*z+1/4,-1/2*y+1/2*z+1/4"},
  {24, "0,1/2*y+1/2*z,1/2*y+1/2*z"},
  {24, "x,1/2,0"},
  {16, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {12, "x,0,0"},
  {12, "1/4,1/2,0"},
  { 8, "1/4,1/4,1/4"},
  { 6, "0,1/2,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w212[] = {
  {12, "1/8,1/2*y-1/2*z+1/8,-1/2*y+1/2*z+1/8"},
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 4, "-3/8,-3/8,-3/8"},
  { 4, "1/8,1/8,1/8"}
  };
  static const raw_position w213[] = {
  {12, "1/8,1/2*y+1/2*z-1/8,1/2*y+1/2*z+1/8"},
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 4, "-1/8,-1/8,-1/8"},
  { 4, "3/8,3/8,3/8"}
  };
  static const raw_position w214[] = {
  {24, "1/8,1/2*y-1/2*z+1/8,-1/2*y+1/2*z+1/8"},
  {24, "1/8,1/2*y+1/2*z-1/8,1/2*y+1/2*z+1/8"},
  {24, "x,0,1/4"},
  {16, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {12, "-3/8,0,1/4"},
  {12, "1/8,0,1/4"},
  { 8, "-1/8,-1/8,-1/8"},
  { 8, "1/8,1/8,1/8"}
  };
  static const raw_position w215[] = {
  {12, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  {12, "x,1/2,0"},
  { 6, "x,1/2,1/2"},
  { 6, "x,0,0"},
  { 4, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 3, "1/2,0,0"},
  { 3, "0,1/2,1/2"},
  { 1, "1/2,1/2,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w216[] = {
  {48, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  {24, "x,1/4,1/4"},
  {24, "x,0,0"},
  {16, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 4, "-1/4,-1/4,-1/4"},
  { 4, "1/4,1/4,1/4"},
  { 4, "1/2,1/2,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w217[] = {
  {24, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  {24, "x,1/2,0"},
  {12, "x,0,0"},
  {12, "1/4,1/2,0"},
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 6, "0,1/2,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w218[] = {
  {12, "x,0,1/2"},
  {12, "x,1/2,0"},
  {12, "x,0,0"},
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 6, "1/4,0,1/2"},
  { 6, "1/4,1/2,0"},
  { 6, "0,1/2,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w219[] = {
  {48, "x,1/4,1/4"},
  {48, "x,0,0"},
  {32, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {24, "1/4,0,0"},
  {24, "0,1/4,1/4"},
  { 8, "1/4,1/4,1/4"},
  { 8, "0,0,0"}
  };
  static const raw_position w220[] = {
  {24, "x,0,1/4"},
  {16, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {12, "-1/8,0,1/4"},
  {12, "3/8,0,1/4"}
  };
  static const raw_position w221[] = {
  {24, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  {24, "1/2,y,z"},
  {24, "0,y,z"},
  {12, "1/2,1/2*y+1/2*z,1/2*y+1/2*z"},
  {12, "0,1/2*y+1/2*z,1/2*y+1/2*z"},
  {12, "x,1/2,0"},
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 6, "x,1/2,1/2"},
  { 6, "x,0,0"},
  { 3, "1/2,0,0"},
  { 3, "0,1/2,1/2"},
  { 1, "1/2,1/2,1/2"},
  { 1, "0,0,0"}
  };
  static const raw_position w222[] = {
  {24, "1/4,1/2*y+1/2*z,1/2*y+1/2*z"},
  {24, "x,-1/4,1/4"},
  {16, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {12, "x,1/4,1/4"},
  {12, "0,-1/4,1/4"},
  { 8, "0,0,0"},
  { 6, "-1/4,1/4,1/4"},
  { 2, "1/4,1/4,1/4"}
  };
  static const raw_position w223[] = {
  {24, "0,y,z"},
  {24, "1/4,1/2*y+1/2*z-1/4,1/2*y+1/2*z+1/4"},
  {16, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {12, "x,1/2,0"},
  {12, "x,0,1/2"},
  {12, "x,0,0"},
  { 8, "1/4,1/4,1/4"},
  { 6, "1/4,1/2,0"},
  { 6, "1/4,0,1/2"},
  { 6, "0,1/2,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w224[] = {
  {24, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  {24, "1/2,1/2*y+1/2*z-1/4,1/2*y+1/2*z+1/4"},
  {24, "1/2,1/2*y-1/2*z,-1/2*y+1/2*z"},
  {24, "x,1/4,-1/4"},
  {12, "x,1/4,1/4"},
  {12, "1/2,1/4,-1/4"},
  { 8, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  { 6, "1/4,-1/4,-1/4"},
  { 4, "1/2,1/2,1/2"},
  { 4, "0,0,0"},
  { 2, "1/4,1/4,1/4"}
  };
  static const raw_position w225[] = {
  {96, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  {96, "0,y,z"},
  {48, "1/2,1/2*y+1/2*z,1/2*y+1/2*z"},
  {48, "0,1/2*y+1/2*z,1/2*y+1/2*z"},
  {48, "x,1/4,1/4"},
  {32, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {24, "x,0,0"},
  {24, "0,1/4,1/4"},
  { 8, "1/4,1/4,1/4"},
  { 4, "1/2,1/2,1/2"},
  { 4, "0,0,0"}
  };
  static const raw_position w226[] = {
  {96, "0,y,z"},
  {96, "1/4,1/2*y+1/2*z,1/2*y+1/2*z"},
  {64, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {48, "x,1/4,1/4"},
  {48, "x,0,0"},
  {24, "0,1/4,1/4"},
  {24, "1/4,0,0"},
  { 8, "0,0,0"},
  { 8, "1/4,1/4,1/4"}
  };
  static const raw_position w227[] = {
  {96, "0,1/2*y-1/2*z,-1/2*y+1/2*z"},
  {96, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  {48, "x,1/8,1/8"},
  {32, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {16, "1/2,1/2,1/2"},
  {16, "0,0,0"},
  { 8, "3/8,3/8,3/8"},
  { 8, "1/8,1/8,1/8"}
  };
  static const raw_position w228[] = {
  {96, "1/4,1/2*y-1/2*z,-1/2*y+1/2*z"},
  {96, "x,1/8,1/8"},
  {64, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {48, "-1/8,1/8,1/8"},
  {32, "0,0,0"},
  {32, "1/4,1/4,1/4"},
  {16, "1/8,1/8,1/8"}
  };
  static const raw_position w229[] = {
  {48, "1/2*x+1/2*y,1/2*x+1/2*y,z"},
  {48, "0,y,z"},
  {48, "1/4,1/2*y-1/2*z+1/4,-1/2*y+1/2*z+1/4"},
  {24, "0,1/2*y+1/2*z,1/2*y+1/2*z"},
  {24, "x,0,1/2"},
  {16, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {12, "x,0,0"},
  {12, "1/4,0,1/2"},
  { 8, "1/4,1/4,1/4"},
  { 6, "0,1/2,1/2"},
  { 2, "0,0,0"}
  };
  static const raw_position w230[] = {
  {48, "1/8,1/2*y-1/2*z+1/8,-1/2*y+1/2*z+1/8"},
  {48, "x,0,1/4"},
  {32, "1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z,1/3*x+1/3*y+1/3*z"},
  {24, "3/8,0,1/4"},
  {24, "1/8,0,1/4"},
  {16, "1/8,1/8,1/8"},
  {16, "0,0,0"}
  };
// END_COMPILED_IN_REFERENCE_DATA

} // namespace <anonymous>

  const raw_table&
  raw_tables(std::size_t i)
  {
    static const raw_table tables[] = {
    {  0, 0    },
    {  0, 0    }, //   1  P 1
    {  8, w2   }, //   2  P -1
    {  4, w3   }, //   3  P 1 2 1
    {  0, 0    }, //   4  P 1 21 1
    {  2, w5   }, //   5  C 1 2 1
    {  2, w6   }, //   6  P 1 m 1
    {  0, 0    }, //   7  P 1 c 1
    {  1, w8   }, //   8  C 1 m 1
    {  0, 0    }, //   9  C 1 c 1
    { 14, w10  }, //  10  P 1 2/m 1
    {  5, w11  }, //  11  P 1 21/m 1
    {  9, w12  }, //  12  C 1 2/m 1
    {  6, w13  }, //  13  P 1 2/c 1
    {  4, w14  }, //  14  P 1 21/c 1
    {  5, w15  }, //  15  C 1 2/c 1
    { 20, w16  }, //  16  P 2 2 2
    {  4, w17  }, //  17  P 2 2 21
    {  2, w18  }, //  18  P 21 21 2
    {  0, 0    }, //  19  P 21 21 21
    {  2, w20  }, //  20  C 2 2 21
    { 11, w21  }, //  21  C 2 2 2
    { 10, w22  }, //  22  F 2 2 2
    { 10, w23  }, //  23  I 2 2 2
    {  3, w24  }, //  24  I 21 21 21
    {  8, w25  }, //  25  P m m 2
    {  2, w26  }, //  26  P m c 21
    {  4, w27  }, //  27  P c c 2
    {  3, w28  }, //  28  P m a 2
    {  0, 0    }, //  29  P c a 21
    {  2, w30  }, //  30  P n c 2
    {  1, w31  }, //  31  P m n 21
    {  2, w18  }, //  32  P b a 2
    {  0, 0    }, //  33  P n a 21
    {  2, w18  }, //  34  P n n 2
    {  5, w35  }, //  35  C m m 2
    {  1, w36  }, //  36  C m c 21
    {  3, w37  }, //  37  C c c 2
    {  5, w38  }, //  38  A m m 2
    {  3, w39  }, //  39  A b m 2
    {  2, w40  }, //  40  A m a 2
    {  1, w41  }, //  41  A b a 2
    {  4, w42  }, //  42  F m m 2
    {  1, w43  }, //  43  F d d 2
    {  4, w44  }, //  44  I m m 2
    {  2, w45  }, //  45  I b a 2
    {  2, w40  }, //  46  I m a 2
    { 26, w47  }, //  47  P m m m
    { 12, w48  }, //  48  P n n n
    { 17, w49  }, //  49  P c c m
    { 12, w50  }, //  50  P b a n
    { 11, w51  }, //  51  P m m a
    {  4, w52  }, //  52  P n n a
    {  8, w53  }, //  53  P m n a
    {  5, w54  }, //  54  P c c a
    {  8, w55  }, //  55  P b a m
    {  4, w56  }, //  56  P c c n
    {  4, w57  }, //  57  P b c m
    {  7, w58  }, //  58  P n n m
    {  6, w59  }, //  59  P m m n
    {  3, w60  }, //  60  P b c n
    {  2, w61  }, //  61  P b c a
    {  3, w62  }, //  62  P n m a
    {  7, w63  }, //  63  C m c m
    {  6, w64  }, //  64  C m c a
    { 17, w65  }, //  65  C m m m
    { 12, w66  }, //  66  C c c m
    { 14, w67  }, //  67  C m m a
    {  8, w68  }, //  68  C c c a
    { 15, w69  }, //  69  F m m m
    {  7, w70  }, //  70  F d d d
    { 14, w71  }, //  71  I m m m
    { 10, w72  }, //  72  I b a m
    {  5, w73  }, //  73  I b c a
    {  9, w74  }, //  74  I m m a
    {  3, w75  }, //  75  P 4
    {  0, 0    }, //  76  P 41
    {  3, w77  }, //  77  P 42
    {  0, 0    }, //  78  P 43
    {  2, w79  }, //  79  I 4
    {  1, w41  }, //  80  I 41
    {  7, w81  }, //  81  P -4
    {  6, w82  }, //  82  I -4
    { 11, w83  }, //  83  P 4/m
    { 10, w84  }, //  84  P 42/m
    {  6, w85  }, //  85  P 4/n
    {  6, w86  }, //  86  P 42/n
    {  8, w87  }, //  87  I 4/m
    {  5, w88  }, //  88  I 41/a
    { 15, w89  }, //  89  P 4 2 2
    {  6, w90  }, //  90  P 4 21 2
    {  3, w91  }, //  91  P 41 2 2
    {  1, w92  }, //  92  P 41 21 2
    { 15, w93  }, //  93  P 42 2 2
    {  6, w94  }, //  94  P 42 21 2
    {  3, w95  }, //  95  P 43 2 2
    {  1, w92  }, //  96  P 43 21 2
    { 10, w97  }, //  97  I 4 2 2
    {  6, w98  }, //  98  I 41 2 2
    {  6, w99  }, //  99  P 4 m m
    {  3, w100 }, // 100  P 4 b m
    {  4, w101 }, // 101  P 42 c m
    {  3, w102 }, // 102  P 42 n m
    {  3, w103 }, // 103  P 4 c c
    {  2, w79  }, // 104  P 4 n c
    {  5, w105 }, // 105  P 42 m c
    {  2, w45  }, // 106  P 42 b c
    {  4, w107 }, // 107  I 4 m m
    {  3, w108 }, // 108  I 4 c m
    {  2, w109 }, // 109  I 41 m d
    {  1, w43  }, // 110  I 41 c d
    { 14, w111 }, // 111  P -4 2 m
    { 13, w112 }, // 112  P -4 2 c
    {  5, w113 }, // 113  P -4 21 m
    {  4, w114 }, // 114  P -4 21 c
    { 11, w115 }, // 115  P -4 m 2
    {  9, w116 }, // 116  P -4 c 2
    {  8, w117 }, // 117  P -4 b 2
    {  8, w118 }, // 118  P -4 n 2
    {  9, w119 }, // 119  I -4 m 2
    {  8, w120 }, // 120  I -4 c 2
    {  9, w121 }, // 121  I -4 2 m
    {  4, w122 }, // 122  I -4 2 d
    { 20, w123 }, // 123  P 4/m m m
    { 13, w124 }, // 124  P 4/m c c
    { 13, w125 }, // 125  P 4/n b m
    { 10, w126 }, // 126  P 4/n n c
    { 11, w127 }, // 127  P 4/m b m
    {  8, w128 }, // 128  P 4/m n c
    { 10, w129 }, // 129  P 4/n m m
    {  6, w130 }, // 130  P 4/n c c
    { 17, w131 }, // 131  P 42/m m c
    { 15, w132 }, // 132  P 42/m c m
    { 10, w133 }, // 133  P 42/n b c
    { 13, w134 }, // 134  P 42/n n m
    {  8, w135 }, // 135  P 42/m b c
    { 10, w136 }, // 136  P 42/m n m
    {  7, w137 }, // 137  P 42/n m c
    {  9, w138 }, // 138  P 42/n c m
    { 14, w139 }, // 139  I 4/m m m
    { 12, w140 }, // 140  I 4/m c m
    {  8, w141 }, // 141  I 41/a m d
    {  6, w142 }, // 142  I 41/a c d
    {  3, w143 }, // 143  P 3
    {  0, 0    }, // 144  P 31
    {  0, 0    }, // 145  P 32
    {  1, w146 }, // 146  R 3
    {  6, w147 }, // 147  P -3
    {  5, w148 }, // 148  R -3
    { 11, w149 }, // 149  P 3 1 2
    {  6, w150 }, // 150  P 3 2 1
    {  2, w151 }, // 151  P 31 1 2
    {  2, w152 }, // 152  P 31 2 1
    {  2, w153 }, // 153  P 32 1 2
    {  2, w154 }, // 154  P 32 2 1
    {  5, w155 }, // 155  R 3 2
    {  4, w156 }, // 156  P 3 m 1
    {  3, w157 }, // 157  P 3 1 m
    {  3, w158 }, // 158  P 3 c 1
    {  2, w159 }, // 159  P 3 1 c
    {  2, w160 }, // 160  R 3 m
    {  1, w161 }, // 161  R 3 c
    { 11, w162 }, // 162  P -3 1 m
    {  8, w163 }, // 163  P -3 1 c
    {  9, w164 }, // 164  P -3 m 1
    {  6, w165 }, // 165  P -3 c 1
    {  8, w166 }, // 166  R -3 m
    {  5, w167 }, // 167  R -3 c
    {  3, w168 }, // 168  P 6
    {  0, 0    }, // 169  P 61
    {  0, 0    }, // 170  P 65
    {  2, w171 }, // 171  P 62
    {  2, w171 }, // 172  P 64
    {  2, w159 }, // 173  P 63
    { 11, w174 }, // 174  P -6
    { 11, w175 }, // 175  P 6/m
    {  8, w176 }, // 176  P 63/m
    { 13, w177 }, // 177  P 6 2 2
    {  2, w178 }, // 178  P 61 2 2
    {  2, w179 }, // 179  P 65 2 2
    { 10, w180 }, // 180  P 62 2 2
    { 10, w180 }, // 181  P 64 2 2
    {  8, w182 }, // 182  P 63 2 2
    {  5, w183 }, // 183  P 6 m m
    {  3, w184 }, // 184  P 6 c c
    {  3, w185 }, // 185  P 63 c m
    {  3, w186 }, // 186  P 63 m c
    { 14, w187 }, // 187  P -6 m 2
    { 11, w188 }, // 188  P -6 c 2
    { 11, w189 }, // 189  P -6 2 m
    {  8, w190 }, // 190  P -6 2 c
    { 17, w191 }, // 191  P 6/m m m
    { 12, w192 }, // 192  P 6/m c c
    { 11, w193 }, // 193  P 63/m c m
    { 11, w194 }, // 194  P 63/m m c
    {  9, w195 }, // 195  P 2 3
    {  7, w196 }, // 196  F 2 3
    {  5, w197 }, // 197  I 2 3
    {  1, w198 }, // 198  P 21 3
    {  2, w199 }, // 199  I 21 3
    { 11, w200 }, // 200  P m -3
    {  7, w201 }, // 201  P n -3
    {  8, w202 }, // 202  F m -3
    {  6, w203 }, // 203  F d -3
    {  7, w204 }, // 204  I m -3
    {  3, w205 }, // 205  P a -3
    {  4, w206 }, // 206  I a -3
    { 10, w207 }, // 207  P 4 3 2
    { 12, w208 }, // 208  P 42 3 2
    {  9, w209 }, // 209  F 4 3 2
    {  7, w210 }, // 210  F 41 3 2
    {  9, w211 }, // 211  I 4 3 2
    {  4, w212 }, // 212  P 43 3 2
    {  4, w213 }, // 213  P 41 3 2
    {  8, w214 }, // 214  I 41 3 2
    {  9, w215 }, // 215  P -4 3 m
    {  8, w216 }, // 216  F -4 3 m
    {  7, w217 }, // 217  I -4 3 m
    {  8, w218 }, // 218  P -4 3 n
    {  7, w219 }, // 219  F -4 3 c
    {  4, w220 }, // 220  I -4 3 d
    { 13, w221 }, // 221  P m -3 m
    {  8, w222 }, // 222  P n -3 n
    { 11, w223 }, // 223  P m -3 n
    { 11, w224 }, // 224  P n -3 m
    { 11, w225 }, // 225  F m -3 m
    {  9, w226 }, // 226  F m -3 c
    {  8, w227 }, // 227  F d -3 m
    {  7, w228 }, // 228  F d -3 c
    { 11, w229 }, // 229  I m -3 m
    {  7, w230 }  // 230  I a -3 d
    };
    return tables[i];
  }

  int
  general_position_multiplicities(std::size_t i)
  {
    static const int table[] = {
      0,
      1, 2, 2, 2, 4, 2, 2, 4, 4, 4, 4, 8, 4, 4, 8, 4, 4, 4, 4, 8, 8,
      16, 8, 8, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 8, 8, 8, 8, 8, 8, 16,
      16, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 16,
      16, 16, 16, 16, 16, 32, 32, 16, 16, 16, 16, 4, 4, 4, 4, 8, 8, 4,
      8, 8, 8, 8, 8, 16, 16, 8, 8, 8, 8, 8, 8, 8, 8, 16, 16, 8, 8, 8,
      8, 8, 8, 8, 8, 16, 16, 16, 16, 8, 8, 8, 8, 8, 8, 8, 8, 16, 16,
      16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16,
      16, 16, 32, 32, 32, 32, 3, 3, 3, 9, 6, 18, 6, 6, 6, 6, 6, 6, 18,
      6, 6, 6, 6, 18, 18, 12, 12, 12, 12, 36, 36, 6, 6, 6, 6, 6, 6, 6,
      12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12,
      24, 24, 24, 24, 12, 48, 24, 12, 24, 24, 24, 96, 96, 48, 24, 48,
      24, 24, 96, 96, 48, 24, 24, 48, 24, 96, 48, 24, 96, 48, 48, 48,
      48, 48, 192, 192, 192, 192, 96, 96
    };
    return table[i];
  }

} // namespace wyckoff

}}} // namespace cctbx::sgtbx::reference_settings
