/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "log_bindings.h"
#include "qt_bindings.h"

#include <InterfaceLogger.h>
#include <Log.h>

namespace camitk {

void log(QString msg, const InterfaceLogger::LogLevel level) {
    // see https://stackoverflow.com/a/77641392
    py::module_ sys_mod = py::module::import("sys");
    py::object calling_frame = sys_mod.attr("_getframe")(0);
    py::str filename_py = calling_frame.attr("f_code").attr("co_filename");
    py::str function_py = calling_frame.attr("f_code").attr("co_name");
    py::int_ line_no_py = calling_frame.attr("f_lineno");

    Log::getLogger()->log(msg, level,
                          filename_py.cast<std::string>().c_str(),
                          function_py.cast<std::string>().c_str(),
                          line_no_py.cast<uint32_t>());

}

void trace(QString msg) {
    log(msg, InterfaceLogger::TRACE);
}

void info(QString msg) {
    log(msg, InterfaceLogger::INFO);
}

void warning(QString msg) {
    log(msg, InterfaceLogger::WARNING);
}

void error(QString msg) {
    log(msg, InterfaceLogger::ERROR);
}

} // namespace camitk

void add_log_bindings(py::module_ &m) {
    m.def("trace", &camitk::trace,
    R"doc(Logs a trace message.)doc");

    m.def("info", &camitk::info,
    R"doc(Logs an info message.)doc");

    m.def("warning", &camitk::warning,
    R"doc(Logs a warning message.)doc");

    m.def("error", &camitk::error,
    R"doc(Logs an error message.)doc");
}
