/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2025 Univ. Grenoble Alpes, CNRS, Grenoble INP - UGA, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include <pybind11/pybind11.h>

#include "action_bindings.h"
#include "component_bindings.h"
#include "console_bindings.h"
#include "core_bindings.h"
#include "application_bindings.h"
#include "transformation_manager_bindings.h"
#include "extensionmanager_bindings.h"
#include "log_bindings.h"

PYBIND11_MODULE(camitk, m) {
    add_core_bindings(m);
    add_console_bindings(m);
    add_component_bindings(m);
    add_action_bindings(m);
    add_extensionmanager_bindings(m);
    add_transformation_manager_bindings(m);
    add_application_bindings(m);
    add_log_bindings(m);
}
