;; NOTE: Assertions have been generated by update_lit_checks.py and should not be edited.
;; RUN: wasm-opt %s --coalesce-locals -all -S -o - | filecheck %s

(module
  ;; CHECK:      (tag $e)
  (tag $e)

  ;; CHECK:      (tag $any (param (ref any)))
  (tag $any (param (ref any)))

  ;; CHECK:      (func $bar (type $2) (result i32)
  ;; CHECK-NEXT:  (i32.const 1984)
  ;; CHECK-NEXT: )
  (func $bar (result i32)
    (i32.const 1984)
  )

  ;; CHECK:      (func $bug-cfg-traversal (type $3) (param $0 i32) (result i32)
  ;; CHECK-NEXT:  (block $tryend
  ;; CHECK-NEXT:   (block $catch
  ;; CHECK-NEXT:    (try_table (catch_all $catch)
  ;; CHECK-NEXT:     (local.set $0
  ;; CHECK-NEXT:      (call $bar)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:    (br $tryend)
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:   (unreachable)
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT:  (local.get $0)
  ;; CHECK-NEXT: )
  (func $bug-cfg-traversal (param $0 i32) (result i32)
    (local $x i32)
    ;; This is a regression test case for a bug in cfg-traversal for EH.
    ;; See https://github.com/WebAssembly/binaryen/pull/3594
    (block $tryend
      (block $catch
        (try_table (catch_all $catch)
          (local.set $x
            ;; the call may or may not throw, so we may reach the get of $x
            (call $bar)
          )
        )
        (br $tryend)
      )
      (unreachable)
    )
    (local.get $x)
  )

  ;; CHECK:      (func $0 (type $0)
  ;; CHECK-NEXT:  (local $0 anyref)
  ;; CHECK-NEXT:  (block $tryend
  ;; CHECK-NEXT:   (drop
  ;; CHECK-NEXT:    (block (result anyref)
  ;; CHECK-NEXT:     (block $catch (result (ref any))
  ;; CHECK-NEXT:      (try_table (catch $any $catch)
  ;; CHECK-NEXT:       (nop)
  ;; CHECK-NEXT:      )
  ;; CHECK-NEXT:      (br $tryend)
  ;; CHECK-NEXT:     )
  ;; CHECK-NEXT:    )
  ;; CHECK-NEXT:   )
  ;; CHECK-NEXT:  )
  ;; CHECK-NEXT: )
  (func $0
    (local $0 (ref null any))
    (block $tryend
      (drop
        ;; There is a difference between the type of the value here and the type
        ;; of the local, due to the local being nullable. We should not error on
        ;; that as we replace the tee with a drop (as it has no gets).
        (local.tee $0
          (block $catch (result (ref any))
            (try_table (catch $any $catch)
              (nop)
            )
            (br $tryend)
          )
        )
      )
    )
  )
)
