#if defined(__linux__) && !defined(__ANDROID__)

  #include <limits.h>
  #include <stdio.h>

  #include "seccomp.h"
  #include "util.h"

typedef struct {

  int  id;
  char name[PATH_MAX];

} syscall_entry_t;

static syscall_entry_t seccomp_syscall_table[] = {

    {SYS_READ, "SYS_READ"},
    {SYS_WRITE, "SYS_WRITE"},
    {SYS_OPEN, "SYS_OPEN"},
    {SYS_CLOSE, "SYS_CLOSE"},
    {SYS_STAT, "SYS_STAT"},
    {SYS_FSTAT, "SYS_FSTAT"},
    {SYS_LSTAT, "SYS_LSTAT"},
    {SYS_POLL, "SYS_POLL"},
    {SYS_LSEEK, "SYS_LSEEK"},
    {SYS_MMAP, "SYS_MMAP"},
    {SYS_MPROTECT, "SYS_MPROTECT"},
    {SYS_MUNMAP, "SYS_MUNMAP"},
    {SYS_BRK, "SYS_BRK"},
    {SYS_RT_SIGACTION, "SYS_RT_SIGACTION"},
    {SYS_RT_SIGPROCMASK, "SYS_RT_SIGPROCMASK"},
    {SYS_RT_SIGRETURN, "SYS_RT_SIGRETURN"},
    {SYS_IOCTL, "SYS_IOCTL"},
    {SYS_PREAD64, "SYS_PREAD64"},
    {SYS_PWRITE64, "SYS_PWRITE64"},
    {SYS_READV, "SYS_READV"},
    {SYS_WRITEV, "SYS_WRITEV"},
    {SYS_ACCESS, "SYS_ACCESS"},
    {SYS_PIPE, "SYS_PIPE"},
    {SYS_SELECT, "SYS_SELECT"},
    {SYS_SCHED_YIELD, "SYS_SCHED_YIELD"},
    {SYS_MREMAP, "SYS_MREMAP"},
    {SYS_MSYNC, "SYS_MSYNC"},
    {SYS_MINCORE, "SYS_MINCORE"},
    {SYS_MADVISE, "SYS_MADVISE"},
    {SYS_SHMGET, "SYS_SHMGET"},
    {SYS_SHMAT, "SYS_SHMAT"},
    {SYS_SHMCTL, "SYS_SHMCTL"},
    {SYS_DUP, "SYS_DUP"},
    {SYS_DUP2, "SYS_DUP2"},
    {SYS_PAUSE, "SYS_PAUSE"},
    {SYS_NANOSLEEP, "SYS_NANOSLEEP"},
    {SYS_GETITIMER, "SYS_GETITIMER"},
    {SYS_ALARM, "SYS_ALARM"},
    {SYS_SETITIMER, "SYS_SETITIMER"},
    {SYS_GETPID, "SYS_GETPID"},
    {SYS_SENDFILE, "SYS_SENDFILE"},
    {SYS_SOCKET, "SYS_SOCKET"},
    {SYS_CONNECT, "SYS_CONNECT"},
    {SYS_ACCEPT, "SYS_ACCEPT"},
    {SYS_SENDTO, "SYS_SENDTO"},
    {SYS_RECVFROM, "SYS_RECVFROM"},
    {SYS_SENDMSG, "SYS_SENDMSG"},
    {SYS_RECVMSG, "SYS_RECVMSG"},
    {SYS_SHUTDOWN, "SYS_SHUTDOWN"},
    {SYS_BIND, "SYS_BIND"},
    {SYS_LISTEN, "SYS_LISTEN"},
    {SYS_GETSOCKNAME, "SYS_GETSOCKNAME"},
    {SYS_GETPEERNAME, "SYS_GETPEERNAME"},
    {SYS_SOCKETPAIR, "SYS_SOCKETPAIR"},
    {SYS_SETSOCKOPT, "SYS_SETSOCKOPT"},
    {SYS_GETSOCKOPT, "SYS_GETSOCKOPT"},
    {SYS_CLONE, "SYS_CLONE"},
    {SYS_FORK, "SYS_FORK"},
    {SYS_VFORK, "SYS_VFORK"},
    {SYS_EXECVE, "SYS_EXECVE"},
    {SYS_EXIT, "SYS_EXIT"},
    {SYS_WAIT4, "SYS_WAIT4"},
    {SYS_KILL, "SYS_KILL"},
    {SYS_UNAME, "SYS_UNAME"},
    {SYS_SEMGET, "SYS_SEMGET"},
    {SYS_SEMOP, "SYS_SEMOP"},
    {SYS_SEMCTL, "SYS_SEMCTL"},
    {SYS_SHMDT, "SYS_SHMDT"},
    {SYS_MSGGET, "SYS_MSGGET"},
    {SYS_MSGSND, "SYS_MSGSND"},
    {SYS_MSGRCV, "SYS_MSGRCV"},
    {SYS_MSGCTL, "SYS_MSGCTL"},
    {SYS_FCNTL, "SYS_FCNTL"},
    {SYS_FLOCK, "SYS_FLOCK"},
    {SYS_FSYNC, "SYS_FSYNC"},
    {SYS_FDATASYNC, "SYS_FDATASYNC"},
    {SYS_TRUNCATE, "SYS_TRUNCATE"},
    {SYS_FTRUNCATE, "SYS_FTRUNCATE"},
    {SYS_GETDENTS, "SYS_GETDENTS"},
    {SYS_GETCWD, "SYS_GETCWD"},
    {SYS_CHDIR, "SYS_CHDIR"},
    {SYS_FCHDIR, "SYS_FCHDIR"},
    {SYS_RENAME, "SYS_RENAME"},
    {SYS_MKDIR, "SYS_MKDIR"},
    {SYS_RMDIR, "SYS_RMDIR"},
    {SYS_CREAT, "SYS_CREAT"},
    {SYS_LINK, "SYS_LINK"},
    {SYS_UNLINK, "SYS_UNLINK"},
    {SYS_SYMLINK, "SYS_SYMLINK"},
    {SYS_READLINK, "SYS_READLINK"},
    {SYS_CHMOD, "SYS_CHMOD"},
    {SYS_FCHMOD, "SYS_FCHMOD"},
    {SYS_CHOWN, "SYS_CHOWN"},
    {SYS_FCHOWN, "SYS_FCHOWN"},
    {SYS_LCHOWN, "SYS_LCHOWN"},
    {SYS_UMASK, "SYS_UMASK"},
    {SYS_GETTIMEOFDAY, "SYS_GETTIMEOFDAY"},
    {SYS_GETRLIMIT, "SYS_GETRLIMIT"},
    {SYS_GETRUSAGE, "SYS_GETRUSAGE"},
    {SYS_SYSINFO, "SYS_SYSINFO"},
    {SYS_TIMES, "SYS_TIMES"},
    {SYS_PTRACE, "SYS_PTRACE"},
    {SYS_GETUID, "SYS_GETUID"},
    {SYS_SYSLOG, "SYS_SYSLOG"},
    {SYS_GETGID, "SYS_GETGID"},
    {SYS_SETUID, "SYS_SETUID"},
    {SYS_SETGID, "SYS_SETGID"},
    {SYS_GETEUID, "SYS_GETEUID"},
    {SYS_GETEGID, "SYS_GETEGID"},
    {SYS_SETPGID, "SYS_SETPGID"},
    {SYS_GETPPID, "SYS_GETPPID"},
    {SYS_GETPGRP, "SYS_GETPGRP"},
    {SYS_SETSID, "SYS_SETSID"},
    {SYS_SETREUID, "SYS_SETREUID"},
    {SYS_SETREGID, "SYS_SETREGID"},
    {SYS_GETGROUPS, "SYS_GETGROUPS"},
    {SYS_SETGROUPS, "SYS_SETGROUPS"},
    {SYS_SETRESUID, "SYS_SETRESUID"},
    {SYS_GETRESUID, "SYS_GETRESUID"},
    {SYS_SETRESGID, "SYS_SETRESGID"},
    {SYS_GETRESGID, "SYS_GETRESGID"},
    {SYS_GETPGID, "SYS_GETPGID"},
    {SYS_SETFSUID, "SYS_SETFSUID"},
    {SYS_SETFSGID, "SYS_SETFSGID"},
    {SYS_GETSID, "SYS_GETSID"},
    {SYS_CAPGET, "SYS_CAPGET"},
    {SYS_CAPSET, "SYS_CAPSET"},
    {SYS_RT_SIGPENDING, "SYS_RT_SIGPENDING"},
    {SYS_RT_SIGTIMEDWAIT, "SYS_RT_SIGTIMEDWAIT"},
    {SYS_RT_SIGQUEUEINFO, "SYS_RT_SIGQUEUEINFO"},
    {SYS_RT_SIGSUSPEND, "SYS_RT_SIGSUSPEND"},
    {SYS_SIGALTSTACK, "SYS_SIGALTSTACK"},
    {SYS_UTIME, "SYS_UTIME"},
    {SYS_MKNOD, "SYS_MKNOD"},
    {SYS_USELIB, "SYS_USELIB"},
    {SYS_PERSONALITY, "SYS_PERSONALITY"},
    {SYS_USTAT, "SYS_USTAT"},
    {SYS_STATFS, "SYS_STATFS"},
    {SYS_FSTATFS, "SYS_FSTATFS"},
    {SYS_SYSFS, "SYS_SYSFS"},
    {SYS_GETPRIORITY, "SYS_GETPRIORITY"},
    {SYS_SETPRIORITY, "SYS_SETPRIORITY"},
    {SYS_SCHED_SETPARAM, "SYS_SCHED_SETPARAM"},
    {SYS_SCHED_GETPARAM, "SYS_SCHED_GETPARAM"},
    {SYS_SCHED_SETSCHEDULER, "SYS_SCHED_SETSCHEDULER"},
    {SYS_SCHED_GETSCHEDULER, "SYS_SCHED_GETSCHEDULER"},
    {SYS_SCHED_GET_PRIORITY_MAX, "SYS_SCHED_GET_PRIORITY_MAX"},
    {SYS_SCHED_GET_PRIORITY_MIN, "SYS_SCHED_GET_PRIORITY_MIN"},
    {SYS_SCHED_RR_GET_INTERVAL, "SYS_SCHED_RR_GET_INTERVAL"},
    {SYS_MLOCK, "SYS_MLOCK"},
    {SYS_MUNLOCK, "SYS_MUNLOCK"},
    {SYS_MLOCKALL, "SYS_MLOCKALL"},
    {SYS_MUNLOCKALL, "SYS_MUNLOCKALL"},
    {SYS_VHANGUP, "SYS_VHANGUP"},
    {SYS_MODIFY_LDT, "SYS_MODIFY_LDT"},
    {SYS_PIVOT_ROOT, "SYS_PIVOT_ROOT"},
    {SYS__SYSCTL, "SYS__SYSCTL"},
    {SYS_PRCTL, "SYS_PRCTL"},
    {SYS_ARCH_PRCTL, "SYS_ARCH_PRCTL"},
    {SYS_ADJTIMEX, "SYS_ADJTIMEX"},
    {SYS_SETRLIMIT, "SYS_SETRLIMIT"},
    {SYS_CHROOT, "SYS_CHROOT"},
    {SYS_SYNC, "SYS_SYNC"},
    {SYS_ACCT, "SYS_ACCT"},
    {SYS_SETTIMEOFDAY, "SYS_SETTIMEOFDAY"},
    {SYS_MOUNT, "SYS_MOUNT"},
    {SYS_UMOUNT2, "SYS_UMOUNT2"},
    {SYS_SWAPON, "SYS_SWAPON"},
    {SYS_SWAPOFF, "SYS_SWAPOFF"},
    {SYS_REBOOT, "SYS_REBOOT"},
    {SYS_SETHOSTNAME, "SYS_SETHOSTNAME"},
    {SYS_SETDOMAINNAME, "SYS_SETDOMAINNAME"},
    {SYS_IOPL, "SYS_IOPL"},
    {SYS_IOPERM, "SYS_IOPERM"},
    {SYS_CREATE_MODULE, "SYS_CREATE_MODULE"},
    {SYS_INIT_MODULE, "SYS_INIT_MODULE"},
    {SYS_DELETE_MODULE, "SYS_DELETE_MODULE"},
    {SYS_GET_KERNEL_SYMS, "SYS_GET_KERNEL_SYMS"},
    {SYS_QUERY_MODULE, "SYS_QUERY_MODULE"},
    {SYS_QUOTACTL, "SYS_QUOTACTL"},
    {SYS_NFSSERVCTL, "SYS_NFSSERVCTL"},
    {SYS_GETPMSG, "SYS_GETPMSG"},
    {SYS_PUTPMSG, "SYS_PUTPMSG"},
    {SYS_AFS_SYSCALL, "SYS_AFS_SYSCALL"},
    {SYS_TUXCALL, "SYS_TUXCALL"},
    {SYS_SECURITY, "SYS_SECURITY"},
    {SYS_GETTID, "SYS_GETTID"},
    {SYS_READAHEAD, "SYS_READAHEAD"},
    {SYS_SETXATTR, "SYS_SETXATTR"},
    {SYS_LSETXATTR, "SYS_LSETXATTR"},
    {SYS_FSETXATTR, "SYS_FSETXATTR"},
    {SYS_GETXATTR, "SYS_GETXATTR"},
    {SYS_LGETXATTR, "SYS_LGETXATTR"},
    {SYS_FGETXATTR, "SYS_FGETXATTR"},
    {SYS_LISTXATTR, "SYS_LISTXATTR"},
    {SYS_LLISTXATTR, "SYS_LLISTXATTR"},
    {SYS_FLISTXATTR, "SYS_FLISTXATTR"},
    {SYS_REMOVEXATTR, "SYS_REMOVEXATTR"},
    {SYS_LREMOVEXATTR, "SYS_LREMOVEXATTR"},
    {SYS_FREMOVEXATTR, "SYS_FREMOVEXATTR"},
    {SYS_TKILL, "SYS_TKILL"},
    {SYS_TIME, "SYS_TIME"},
    {SYS_FUTEX, "SYS_FUTEX"},
    {SYS_SCHED_SETAFFINITY, "SYS_SCHED_SETAFFINITY"},
    {SYS_SCHED_GETAFFINITY, "SYS_SCHED_GETAFFINITY"},
    {SYS_SET_THREAD_AREA, "SYS_SET_THREAD_AREA"},
    {SYS_IO_SETUP, "SYS_IO_SETUP"},
    {SYS_IO_DESTROY, "SYS_IO_DESTROY"},
    {SYS_IO_GETEVENTS, "SYS_IO_GETEVENTS"},
    {SYS_IO_SUBMIT, "SYS_IO_SUBMIT"},
    {SYS_IO_CANCEL, "SYS_IO_CANCEL"},
    {SYS_GET_THREAD_AREA, "SYS_GET_THREAD_AREA"},
    {SYS_LOOKUP_DCOOKIE, "SYS_LOOKUP_DCOOKIE"},
    {SYS_EPOLL_CREATE, "SYS_EPOLL_CREATE"},
    {SYS_EPOLL_CTL_OLD, "SYS_EPOLL_CTL_OLD"},
    {SYS_EPOLL_WAIT_OLD, "SYS_EPOLL_WAIT_OLD"},
    {SYS_REMAP_FILE_PAGES, "SYS_REMAP_FILE_PAGES"},
    {SYS_GETDENTS64, "SYS_GETDENTS64"},
    {SYS_SET_TID_ADDRESS, "SYS_SET_TID_ADDRESS"},
    {SYS_RESTART_SYSCALL, "SYS_RESTART_SYSCALL"},
    {SYS_SEMTIMEDOP, "SYS_SEMTIMEDOP"},
    {SYS_FADVISE64, "SYS_FADVISE64"},
    {SYS_TIMER_CREATE, "SYS_TIMER_CREATE"},
    {SYS_TIMER_SETTIME, "SYS_TIMER_SETTIME"},
    {SYS_TIMER_GETTIME, "SYS_TIMER_GETTIME"},
    {SYS_TIMER_GETOVERRUN, "SYS_TIMER_GETOVERRUN"},
    {SYS_TIMER_DELETE, "SYS_TIMER_DELETE"},
    {SYS_CLOCK_SETTIME, "SYS_CLOCK_SETTIME"},
    {SYS_CLOCK_GETTIME, "SYS_CLOCK_GETTIME"},
    {SYS_CLOCK_GETRES, "SYS_CLOCK_GETRES"},
    {SYS_CLOCK_NANOSLEEP, "SYS_CLOCK_NANOSLEEP"},
    {SYS_EXIT_GROUP, "SYS_EXIT_GROUP"},
    {SYS_EPOLL_WAIT, "SYS_EPOLL_WAIT"},
    {SYS_EPOLL_CTL, "SYS_EPOLL_CTL"},
    {SYS_TGKILL, "SYS_TGKILL"},
    {SYS_UTIMES, "SYS_UTIMES"},
    {SYS_VSERVER, "SYS_VSERVER"},
    {SYS_MBIND, "SYS_MBIND"},
    {SYS_SET_MEMPOLICY, "SYS_SET_MEMPOLICY"},
    {SYS_GET_MEMPOLICY, "SYS_GET_MEMPOLICY"},
    {SYS_MQ_OPEN, "SYS_MQ_OPEN"},
    {SYS_MQ_UNLINK, "SYS_MQ_UNLINK"},
    {SYS_MQ_TIMEDSEND, "SYS_MQ_TIMEDSEND"},
    {SYS_MQ_TIMEDRECEIVE, "SYS_MQ_TIMEDRECEIVE"},
    {SYS_MQ_NOTIFY, "SYS_MQ_NOTIFY"},
    {SYS_MQ_GETSETATTR, "SYS_MQ_GETSETATTR"},
    {SYS_KEXEC_LOAD, "SYS_KEXEC_LOAD"},
    {SYS_WAITID, "SYS_WAITID"},
    {SYS_ADD_KEY, "SYS_ADD_KEY"},
    {SYS_REQUEST_KEY, "SYS_REQUEST_KEY"},
    {SYS_KEYCTL, "SYS_KEYCTL"},
    {SYS_IOPRIO_SET, "SYS_IOPRIO_SET"},
    {SYS_IOPRIO_GET, "SYS_IOPRIO_GET"},
    {SYS_INOTIFY_INIT, "SYS_INOTIFY_INIT"},
    {SYS_INOTIFY_ADD_WATCH, "SYS_INOTIFY_ADD_WATCH"},
    {SYS_INOTIFY_RM_WATCH, "SYS_INOTIFY_RM_WATCH"},
    {SYS_MIGRATE_PAGES, "SYS_MIGRATE_PAGES"},
    {SYS_OPENAT, "SYS_OPENAT"},
    {SYS_MKDIRAT, "SYS_MKDIRAT"},
    {SYS_MKNODAT, "SYS_MKNODAT"},
    {SYS_FCHOWNAT, "SYS_FCHOWNAT"},
    {SYS_FUTIMESAT, "SYS_FUTIMESAT"},
    {SYS_NEWFSTATAT, "SYS_NEWFSTATAT"},
    {SYS_UNLINKAT, "SYS_UNLINKAT"},
    {SYS_RENAMEAT, "SYS_RENAMEAT"},
    {SYS_LINKAT, "SYS_LINKAT"},
    {SYS_SYMLINKAT, "SYS_SYMLINKAT"},
    {SYS_READLINKAT, "SYS_READLINKAT"},
    {SYS_FCHMODAT, "SYS_FCHMODAT"},
    {SYS_FACCESSAT, "SYS_FACCESSAT"},
    {SYS_PSELECT6, "SYS_PSELECT6"},
    {SYS_PPOLL, "SYS_PPOLL"},
    {SYS_UNSHARE, "SYS_UNSHARE"},
    {SYS_SET_ROBUST_LIST, "SYS_SET_ROBUST_LIST"},
    {SYS_GET_ROBUST_LIST, "SYS_GET_ROBUST_LIST"},
    {SYS_SPLICE, "SYS_SPLICE"},
    {SYS_TEE, "SYS_TEE"},
    {SYS_SYNC_FILE_RANGE, "SYS_SYNC_FILE_RANGE"},
    {SYS_VMSPLICE, "SYS_VMSPLICE"},
    {SYS_MOVE_PAGES, "SYS_MOVE_PAGES"},
    {SYS_UTIMENSAT, "SYS_UTIMENSAT"},
    {SYS_EPOLL_PWAIT, "SYS_EPOLL_PWAIT"},
    {SYS_SIGNALFD, "SYS_SIGNALFD"},
    {SYS_TIMERFD_CREATE, "SYS_TIMERFD_CREATE"},
    {SYS_EVENTFD, "SYS_EVENTFD"},
    {SYS_FALLOCATE, "SYS_FALLOCATE"},
    {SYS_TIMERFD_SETTIME, "SYS_TIMERFD_SETTIME"},
    {SYS_TIMERFD_GETTIME, "SYS_TIMERFD_GETTIME"},
    {SYS_ACCEPT4, "SYS_ACCEPT4"},
    {SYS_SIGNALFD4, "SYS_SIGNALFD4"},
    {SYS_EVENTFD2, "SYS_EVENTFD2"},
    {SYS_EPOLL_CREATE1, "SYS_EPOLL_CREATE1"},
    {SYS_DUP3, "SYS_DUP3"},
    {SYS_PIPE2, "SYS_PIPE2"},
    {SYS_INOTIFY_INIT1, "SYS_INOTIFY_INIT1"},
    {SYS_PREADV, "SYS_PREADV"},
    {SYS_PWRITEV, "SYS_PWRITEV"},
    {SYS_RT_TGSIGQUEUEINFO, "SYS_RT_TGSIGQUEUEINFO"},
    {SYS_PERF_EVENT_OPEN, "SYS_PERF_EVENT_OPEN"},
    {SYS_RECVMMSG, "SYS_RECVMMSG"},
    {SYS_FANOTIFY_INIT, "SYS_FANOTIFY_INIT"},
    {SYS_FANOTIFY_MARK, "SYS_FANOTIFY_MARK"},
    {SYS_PRLIMIT64, "SYS_PRLIMIT64"},

};

char *seccomp_syscall_lookup(int id) {

  if (id < 0) { FFATAL("Invalid id: %d", id); }
  if ((uint32_t)id >= sizeof(seccomp_syscall_table) / sizeof(syscall_entry_t)) {

    FFATAL("Invalid id: %d", id);

  }

  return seccomp_syscall_table[id].name;

}

#endif

