import apport.hookutils

def add_info(report):
    """Add a list of installed packages matching 'virtualbox' or 'linux-headers'"""
    report['VirtualBox.DpkgList'] = apport.hookutils.command_output(["sh", "-c", "dpkg -l | grep -e virtualbox -e linux-headers"])

    """Add information about installed VirtualBox kernel modules"""
    report['VirtualBox.ModInfo'] = apport.hookutils.command_output(["sh", "-c",
        "find /lib/modules/`uname -r` -name \"vbox*\" | xargs -r modinfo"])

    report['LsMod'] = apport.hookutils.command_output(["lsmod"])
    report['DkmsLog'] = apport.hookutils.command_output(["sh", "-c", "cat /var/lib/dkms/virtualbox/$(dpkg-query -f '${source:Upstream-Version}\n' -W 'virtualbox' |cut -f 1 -d '-')/build/make.log"])
    # the following contains a different parsing way, based on "Package" field, constructed in this way:
    # ['virtualbox', '7.2.0-dfsg-3'], so getting the field number 1, splitting the "-" and getting the first field works in the same way as the dpkg-query call above
    #report['DkmsLog'] = apport.hookutils.command_output(["sh", "-c", "cat /var/lib/dkms/virtualbox/" + report['Package'].split()[1].split("-")[0] + "/build/make.log"])
