/* SPDX-License-Identifier: GPL-2.0-or-later */

#define NV_ERROR_SUCCESS		0x0
#define NV_ERROR_UNSPECIFIED		0x80000001
#define NV_ERROR_UNSUPPORTED		0x80000002

#define PCI_OWNER_SBIOS			0x0
#define PCI_OWNER_DRIVER		0x1

#define OPTIMUS_POWER_CONTROL_DISABLE	0x2
#define OPTIMUS_POWER_CONTROL_ENABLE	0x3

#define OPTIMUS_CONTROL_NO_RUN_PS0	0x0
#define OPTIMUS_CONTROL_RUN_PS0		0x1

#define GC6_STATE_EXITED		0x0
#define GC6_STATE_ENTERED		0x1
#define GC6_STATE_TRANSITION		0x2

#define GC6_DEFER_DISABLE		0x0
#define GC6_DEFER_ENABLE		0x1

#define NOTIFY_GPS_EVENT_STATUS_CHANGE	0xc0
#define NOTIFY_GPS_NVPCF_STATUS_CHANGE	0xc5
#define NOTIFY_GPS_EVENT_LIMIT_POWER_0	0xd1
#define NOTIFY_GPS_EVENT_LIMIT_POWER_1	0xd2
#define NOTIFY_GPS_EVENT_LIMIT_POWER_2	0xd3
#define NOTIFY_GPS_EVENT_LIMIT_POWER_3	0xd4
#define NOTIFY_GPS_EVENT_LIMIT_POWER_4	0xd5

/* Defines for NVJT subfunction */
#define NVJT_GPC_GSS		0
#define NVJT_GPC_EGNS		1
#define NVJT_GPC_EGIS		2
#define NVJT_GPS_XGXS		3
#define NVJT_GPS_XGIS		4

#define UUID_NVOP		"a486d8f8-0bda-471b-a72b-6042a6b5bee0"
#define UUID_NVJT		"cbeca351-067b-4924-9cbd-b46b00b86f34"
#define UUID_NBCI		"d4a50b75-65c7-46f7-bfb7-41514cea0244"
#define UUID_NVPCF		"36b49710-2483-11e7-9598-0800200c9a66"
#define UUID_GPS		"a3132d01-8cda-49ba-a52e-bc9d46df6b81"

#define REVISION_MIN_NVOP	0x100
#define REVISION_MIN_NVJT	0x100
#define REVISION_MIN_NBCI	0x102
#define REVISION_MIN_NVPCF	0x200
#define REVISION_MIN_GPS	0x200

#define D1_EC	0
#define D2_EC	1
#define D3_EC	2
#define D4_EC	3
#define D5_EC	4

#define D1_GPU	0xD1
#define D2_GPU	0xD2
#define D3_GPU	0xD3
#define D4_GPU	0xD4
#define D5_GPU	0xD5
