/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class UriOrFile {
    private UriOrFile() {
    }

    public static String toUri(String string) {
        String string2 = UriOrFile.getScheme(string);
        return string2 != null && string2.length() > 1 ? string : UriOrFile.fileToUri(string);
    }

    private static String getScheme(String string) {
        int n = string.length();
        if (n == 0) {
            return null;
        }
        if (!UriOrFile.isAlpha(string.charAt(0))) {
            return null;
        }
        block4: for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ':': {
                    return string.substring(0, i);
                }
                case '+': 
                case '-': {
                    continue block4;
                }
                default: {
                    if (UriOrFile.isAlnum(c)) continue block4;
                    return null;
                }
            }
        }
        return null;
    }

    private static boolean isAlpha(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isAlnum(char c) {
        return UriOrFile.isAlpha(c) || '0' <= c && c <= '9';
    }

    public static String fileToUri(String string) {
        return UriOrFile.fileToUri(new File(string));
    }

    public static String fileToUri(File file) {
        return file.toURI().toString();
    }

    public static String uriToUriOrFile(String string) {
        if ("file".equalsIgnoreCase(UriOrFile.getScheme(string))) {
            try {
                return new File(new URI(string)).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return string;
    }
}

